/*
 * Decompiled with CFR 0.152.
 */
package lac.cnclib.stress;

import java.net.SocketAddress;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import lac.cnclib.net.NodeConnection;
import lac.cnclib.net.NodeConnectionListener;
import lac.cnclib.net.NodeConnectionServerListener;
import lac.cnclib.net.mrudp.MrUdpNodeConnectionServer;
import lac.cnclib.sddl.message.Message;

public class ClientlibStressServer
implements NodeConnectionServerListener,
NodeConnectionListener {
    public MrUdpNodeConnectionServer server;
    private static final int port = 5500;
    private static final Logger LOGGER = Logger.getLogger(ClientlibStressServer.class.getCanonicalName());
    private long initialTime = 0L;
    private int count;

    public static void main(String[] args) {
        Logger.getLogger("").setLevel(Level.ALL);
        new ClientlibStressServer(5500);
    }

    public ClientlibStressServer(int port) {
        try {
            this.count = 1;
            this.initialTime = 0L;
            this.server = new MrUdpNodeConnectionServer(port);
            this.server.addListener(this);
            this.server.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void newNodeConnection(NodeConnection remoteCon) {
        if (this.initialTime == 0L) {
            this.initialTime = System.currentTimeMillis();
        }
        remoteCon.addNodeConnectionListener(this);
    }

    @Override
    public void newMessageReceived(NodeConnection remoteCon, Message message) {
        ++this.count;
        if (System.currentTimeMillis() - this.initialTime > 10000L) {
            double msgPerSecond = this.count / 10;
            System.out.println("MSG PER SECOND: " + msgPerSecond);
            this.initialTime = System.currentTimeMillis();
            this.count = 0;
        }
    }

    @Override
    public void connected(NodeConnection remoteCon) {
        LOGGER.fine("We connected");
    }

    @Override
    public void reconnected(NodeConnection remoteCon, SocketAddress endPoint, boolean wasHandover, boolean wasMandatory) {
        System.out.println("CONNECTED");
    }

    @Override
    public void disconnected(NodeConnection remoteCon) {
        System.out.println("DISCONNECTED FROM " + remoteCon.getUuid());
    }

    @Override
    public void unsentMessages(NodeConnection remoteCon, List<Message> unsentMessages) {
        System.out.println("UNSENT MESSAGES " + remoteCon.getUuid());
        for (Message m : unsentMessages) {
            System.out.println(m);
        }
    }

    @Override
    public void internalException(NodeConnection remoteCon, Exception e) {
    }
}

