/*
 * Decompiled with CFR 0.152.
 */
package net.rudp;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import net.rudp.ReliableSocket;
import net.rudp.impl.Segment;

public class AsyncScheduler
implements Runnable {
    private static AsyncScheduler scheduler = new AsyncScheduler();
    private volatile Selector selector;
    private ReentrantLock selectorLock;
    private ByteBuffer recvBuffer;
    private ExecutorService recvThreadPool;
    private Semaphore sendSemaphore;
    public static final Logger LOGGER = Logger.getLogger(AsyncScheduler.class.getCanonicalName());

    private AsyncScheduler() {
        try {
            this.selector = Selector.open();
            this.selectorLock = new ReentrantLock();
            this.recvBuffer = ByteBuffer.allocate(65535);
            this.recvThreadPool = new ThreadPoolExecutor(16, 16, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ScheduleFactory("Receive-Scheduler"));
            this.sendSemaphore = new Semaphore(16, true);
            new Thread((Runnable)this, "AsyncScheduler").start();
        }
        catch (IOException e) {
            System.err.println("Could not create Scheduler.");
            System.exit(-1);
        }
    }

    public static AsyncScheduler getAsyncScheduler() {
        return scheduler;
    }

    public SelectionKey register(DatagramChannel channel, ReliableSocket socket) {
        SelectionKey key = null;
        this.selectorLock.lock();
        try {
            try {
                channel.configureBlocking(false);
                this.selector.wakeup();
                key = channel.register(this.selector, 1);
                key.attach(socket);
            }
            catch (Exception e) {
                LOGGER.severe("COULD NOT REGISTER CHANNEL");
                this.selectorLock.unlock();
            }
        }
        finally {
            this.selectorLock.unlock();
        }
        return key;
    }

    @Override
    public void run() {
        while (true) {
            try {
                block7: while (true) {
                    this.selector.select();
                    Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
                    this.selectorLock.lock();
                    this.selectorLock.unlock();
                    Iterator<SelectionKey> keyIterator = selectedKeys.iterator();
                    while (true) {
                        block10: {
                            if (!keyIterator.hasNext()) continue block7;
                            SelectionKey key = keyIterator.next();
                            ((DatagramChannel)key.channel()).receive(this.recvBuffer);
                            this.recvBuffer.flip();
                            try {
                                try {
                                    Segment segment = Segment.parse(this.recvBuffer.array(), 0, this.recvBuffer.limit());
                                    this.recvThreadPool.submit(new ReceiveTask((ReliableSocket)key.attachment(), segment));
                                }
                                catch (Exception ex) {
                                    LOGGER.severe("Problem at parsing Segment received. Pkg received is corrupted.");
                                    this.recvBuffer.clear();
                                    break block10;
                                }
                            }
                            catch (Throwable throwable) {
                                this.recvBuffer.clear();
                                throw throwable;
                            }
                            this.recvBuffer.clear();
                        }
                        keyIterator.remove();
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void submit(DatagramChannel channel, SocketAddress endpoint, Segment segment) {
        try {
            try {
                this.sendSemaphore.acquire();
                channel.send(ByteBuffer.wrap(segment.getBytes()), endpoint);
            }
            catch (Exception ex) {
                LOGGER.severe("Error at submitting Segment");
                ex.printStackTrace();
                this.sendSemaphore.release();
            }
        }
        finally {
            this.sendSemaphore.release();
        }
    }

    private class ReceiveTask
    implements Runnable {
        private ReliableSocket socket;
        private Segment segment;

        public ReceiveTask(ReliableSocket sock, Segment segment) {
            this.socket = sock;
            this.segment = segment;
        }

        @Override
        public void run() {
            this.socket.scheduleReceive(this.segment);
        }
    }

    public static class ScheduleFactory
    implements ThreadFactory {
        private String name;
        private int counter = 1;

        public ScheduleFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, String.valueOf(this.name) + "-" + this.counter++);
        }
    }
}

