/*
 * Decompiled with CFR 0.152.
 */
package net.rudp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import net.rudp.AsyncScheduler;
import net.rudp.ReliableSocketInputStream;
import net.rudp.ReliableSocketListener;
import net.rudp.ReliableSocketOutputStream;
import net.rudp.ReliableSocketProfile;
import net.rudp.ReliableSocketStateListener;
import net.rudp.impl.ACKSegment;
import net.rudp.impl.DATSegment;
import net.rudp.impl.EAKSegment;
import net.rudp.impl.FINSegment;
import net.rudp.impl.NULSegment;
import net.rudp.impl.RSTSegment;
import net.rudp.impl.SYNSegment;
import net.rudp.impl.Segment;
import net.rudp.impl.Timer;
import net.rudp.impl.UIDSegment;

public class ReliableSocket
extends Socket {
    protected UUID _uuid;
    protected DatagramChannel _channel;
    protected SelectionKey _key;
    protected SocketAddress _endpoint;
    protected AsyncScheduler _scheduler;
    protected ReliableSocketInputStream _in;
    protected ReliableSocketOutputStream _out;
    private volatile boolean _closed = false;
    private volatile boolean _wasConnected = false;
    private volatile boolean _connected = false;
    private volatile boolean _reset = false;
    private volatile boolean _keepAlive = true;
    private volatile int _state = 0;
    private volatile int _timeout = 0;
    private volatile boolean _shutIn = false;
    private volatile boolean _shutOut = false;
    private final Object _closeLock = new Object();
    private final Object _resetLock = new Object();
    private final ArrayList _listeners = new ArrayList();
    private final ArrayList _stateListeners = new ArrayList();
    private ShutdownHook _shutdownHook;
    private ReliableSocketProfile _profile = new ReliableSocketProfile();
    private volatile List<Segment> _unackedBufferSentQueue = Collections.synchronizedList(new ArrayList());
    private volatile List<Segment> _unackedSentQueue = Collections.synchronizedList(new ArrayList());
    private volatile List<Segment> _outSeqRecvQueue = Collections.synchronizedList(new ArrayList());
    private volatile List<Segment> _inSeqRecvQueue = Collections.synchronizedList(new ArrayList());
    private final Object _recvQueueLock = new Object();
    private final Counters _counters = new Counters();
    private int _sendQueueSize;
    private int _recvQueueSize;
    private int _sendBufferSize;
    private int _recvBufferSize;
    protected static ScheduledThreadPoolExecutor _threadPool = new ScheduledThreadPoolExecutor(5, new AsyncScheduler.ScheduleFactory("Utils"));
    protected static int nSockets = 0;
    private final Timer _nullSegmentTimer = new Timer("ReliableSocket-NullSegmentTimer", new NullSegmentTimerTask(), _threadPool);
    private final Timer _uidSegmentTimer = new Timer("ReliableSocket-UUIDSegmentTimer", new UIDSegmentTimerTask(), _threadPool);
    private final Timer _retransmissionTimer = new Timer("ReliableSocket-RetransmissionTimer", new RetransmissionTimerTask(), _threadPool);
    private final Timer _cumulativeAckTimer = new Timer("ReliableSocket-CumulativeAckTimer", new CumulativeAckTimerTask(), _threadPool);
    private final Timer _keepAliveTimer = new Timer("ReliableSocket-KeepAliveTimer", new KeepAliveTimerTask(), _threadPool);
    private static final int MAX_SEQUENCE_NUMBER = 255;
    public static final int CLOSED = 0;
    public static final int SYN_RCVD = 1;
    public static final int SYN_SENT = 2;
    public static final int ESTABLISHED = 3;
    public static final int CLOSE_WAIT = 4;
    public static final Logger LOGGER = Logger.getLogger(ReliableSocket.class.getCanonicalName());

    public ReliableSocket() throws IOException {
        this(new ReliableSocketProfile());
    }

    public ReliableSocket(ReliableSocketProfile profile) throws IOException {
        this(DatagramChannel.open(), profile);
    }

    public ReliableSocket(String host, int port) throws UnknownHostException, IOException {
        this(new InetSocketAddress(host, port), null);
    }

    public ReliableSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        this(new InetSocketAddress(address, port), new InetSocketAddress(localAddr, localPort));
    }

    public ReliableSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        this(new InetSocketAddress(host, port), new InetSocketAddress(localAddr, localPort));
    }

    protected ReliableSocket(InetSocketAddress inetAddr, InetSocketAddress localAddr) throws IOException {
        this(DatagramChannel.open(), new ReliableSocketProfile());
        this.connect(inetAddr);
    }

    protected ReliableSocket(DatagramChannel channel) {
        this(channel, new ReliableSocketProfile());
    }

    protected ReliableSocket(DatagramChannel channel, ReliableSocketProfile profile) {
        this.init(channel, profile);
        int actualSize = _threadPool.getCorePoolSize();
        int poolSize = (++nSockets / 1000 + 1) * 3;
        _threadPool.setCorePoolSize(poolSize);
        if (actualSize != poolSize) {
            System.out.println("ReliableSocket: new utils pool size = " + poolSize);
        }
    }

    protected void init(DatagramChannel channel, ReliableSocketProfile profile) {
        this._profile = profile;
        this._channel = channel;
        this._recvQueueSize = profile.maxRecvQueueSize();
        this._sendQueueSize = profile.maxSendQueueSize();
        this._scheduler = AsyncScheduler.getAsyncScheduler();
        this._sendBufferSize = (this._profile.maxSegmentSize() - 6) * this._recvQueueSize;
        this._recvBufferSize = (this._profile.maxSegmentSize() - 6) * this._sendQueueSize;
        this._shutdownHook = new ShutdownHook();
        try {
            if (!this._channel.socket().isBound()) {
                this._channel.socket().bind(null);
            }
            Runtime.getRuntime().addShutdownHook(this._shutdownHook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        this._channel.socket().bind(bindpoint);
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (timeout < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (this.isClosed() && !this._closed) {
            throw new SocketException("Socket is closed");
        }
        if (this.isConnected() && !this._closed) {
            throw new SocketException("Already connected");
        }
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        this._endpoint = endpoint;
        this._key = this._scheduler.register(this._channel, this);
        this._state = 2;
        Random rand = new Random(System.currentTimeMillis());
        SYNSegment syn = new SYNSegment(this._counters.setSequenceNumber(rand.nextInt(255)), this._profile.maxOutstandingSegs(), this._profile.maxSegmentSize(), this._profile.retransmissionTimeout(), this._profile.cumulativeAckTimeout(), this._profile.nullSegmentTimeout(), this._profile.maxRetrans(), this._profile.maxCumulativeAcks(), this._profile.maxOutOfSequence(), this._profile.maxAutoReset());
        this.sendAndQueueSegment(syn);
        boolean timedout = false;
        Object object = this;
        synchronized (object) {
            if (!this.isConnected()) {
                try {
                    if (timeout == 0) {
                        this.wait();
                    } else {
                        long startTime = System.currentTimeMillis();
                        this.wait(timeout);
                        if (System.currentTimeMillis() - startTime >= (long)timeout) {
                            timedout = true;
                        }
                    }
                }
                catch (InterruptedException xcp) {
                    xcp.printStackTrace();
                }
            }
        }
        if (this._state == 3) {
            return;
        }
        object = this._unackedSentQueue;
        synchronized (object) {
            this._unackedSentQueue.clear();
            this._unackedSentQueue.notifyAll();
        }
        this._counters.reset();
        this._retransmissionTimer.cancel();
        switch (this._state) {
            case 2: {
                this.connectionRefused();
                this._state = 0;
                if (timedout) {
                    throw new SocketTimeoutException();
                }
                throw new SocketException("Connection refused");
            }
            case 0: 
            case 4: {
                this._state = 0;
                throw new SocketException("Socket closed");
            }
        }
    }

    @Override
    public SocketChannel getChannel() {
        return null;
    }

    @Override
    public InetAddress getInetAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return ((InetSocketAddress)this._endpoint).getAddress();
    }

    @Override
    public int getPort() {
        if (!this.isConnected()) {
            return 0;
        }
        return ((InetSocketAddress)this._endpoint).getPort();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    @Override
    public InetAddress getLocalAddress() {
        return this._channel.socket().getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this._channel.socket().getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this._channel.socket().getLocalSocketAddress();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is shutdown");
        }
        return this._in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        return this._out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        Object object = this._closeLock;
        synchronized (object) {
            List<Segment> list;
            if (this.isClosed()) {
                return;
            }
            try {
                Runtime.getRuntime().removeShutdownHook(this._shutdownHook);
            }
            catch (IllegalStateException xcp) {
                LOGGER.severe("CANNOT INITIATE SHUTDOWN HOOK");
            }
            switch (this._state) {
                case 2: {
                    list = this;
                    synchronized (list) {
                        this.notify();
                        break;
                    }
                }
                case 1: 
                case 3: 
                case 4: {
                    this.sendSegment(new FINSegment(this._counters.nextSequenceNumber()));
                    this.closeImpl();
                    break;
                }
                case 0: {
                    this._retransmissionTimer.destroy();
                    this._cumulativeAckTimer.destroy();
                    this._keepAliveTimer.destroy();
                    this._nullSegmentTimer.destroy();
                    this._channel.close();
                }
            }
            this.log("closing-close");
            this._closed = true;
            this._state = 0;
            list = this._unackedSentQueue;
            synchronized (list) {
                this._unackedSentQueue.notify();
            }
            list = this._inSeqRecvQueue;
            synchronized (list) {
                this._inSeqRecvQueue.notify();
            }
        }
    }

    @Override
    public boolean isBound() {
        return this._channel.socket().isBound();
    }

    @Override
    public boolean isConnected() {
        return this._connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object = this._closeLock;
        synchronized (object) {
            return this._closed;
        }
    }

    public void setUUID(UUID uuid) {
        this._uuid = uuid;
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout < 0");
        }
        this._timeout = timeout;
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("negative receive size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isConnected()) {
            return;
        }
        this._sendBufferSize = size;
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this._sendBufferSize;
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("negative send size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isConnected()) {
            return;
        }
        this._recvBufferSize = size;
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this._recvBufferSize;
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        throw new SocketException("Socket option not supported");
    }

    @Override
    public boolean getTcpNoDelay() {
        return false;
    }

    @Override
    public synchronized void setKeepAlive(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!(this._keepAlive ^ on)) {
            return;
        }
        this._keepAlive = on;
        if (this.isConnected()) {
            if (this._keepAlive) {
                this._keepAliveTimer.schedule(this._profile.nullSegmentTimeout() * 10, this._profile.nullSegmentTimeout() * 10);
            } else {
                this._keepAliveTimer.cancel();
            }
        }
    }

    @Override
    public synchronized boolean getKeepAlive() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this._keepAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownInput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is already shutdown");
        }
        this._shutIn = true;
        Object object = this._recvQueueLock;
        synchronized (object) {
            this._recvQueueLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownOutput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is already shutdown");
        }
        this._shutOut = true;
        List<Segment> list = this._unackedSentQueue;
        synchronized (list) {
            this._unackedSentQueue.notifyAll();
        }
    }

    @Override
    public boolean isInputShutdown() {
        return this._shutIn;
    }

    @Override
    public boolean isOutputShutdown() {
        return this._shutOut;
    }

    public void reset() throws IOException {
        this.reset(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset(ReliableSocketProfile profile) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        Object object = this._resetLock;
        synchronized (object) {
            this._reset = true;
            this.sendAndQueueSegment(new RSTSegment(this._counters.nextSequenceNumber()));
            List<Segment> list = this._unackedSentQueue;
            synchronized (list) {
                while (!this._unackedSentQueue.isEmpty()) {
                    try {
                        this._unackedSentQueue.wait();
                    }
                    catch (InterruptedException xcp) {
                        xcp.printStackTrace();
                    }
                }
            }
        }
        this.connectionReset();
        if (profile != null) {
            this._profile = profile;
        }
        this._state = 2;
        Random rand = new Random(System.currentTimeMillis());
        SYNSegment syn = new SYNSegment(this._counters.setSequenceNumber(rand.nextInt(255)), this._profile.maxOutstandingSegs(), this._profile.maxSegmentSize(), this._profile.retransmissionTimeout(), this._profile.cumulativeAckTimeout(), this._profile.nullSegmentTimeout(), this._profile.maxRetrans(), this._profile.maxCumulativeAcks(), this._profile.maxOutOfSequence(), this._profile.maxAutoReset());
        this.sendAndQueueSegment(syn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int write(byte[] b, int off, int len) throws IOException {
        int writeBytes;
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isOutputShutdown()) {
            throw new IOException("Socket output is shutdown");
        }
        if (!this.isConnected()) {
            throw new SocketException("Connection reset");
        }
        int lastSeq = -1;
        block5: for (int totalBytes = 0; totalBytes < len; totalBytes += writeBytes) {
            Object object = this._resetLock;
            synchronized (object) {
                while (true) {
                    while (true) {
                        if (!this._reset) {
                            writeBytes = Math.min(this._profile.maxSegmentSize() - 6, len - totalBytes);
                            lastSeq = this._counters.nextSequenceNumber();
                            this.sendAndQueueSegment(new DATSegment(lastSeq, this._counters.getLastInSequence(), b, off + totalBytes, writeBytes));
                            continue block5;
                        }
                        try {
                            this._resetLock.wait();
                        }
                        catch (InterruptedException xcp) {
                            xcp.printStackTrace();
                        }
                    }
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        return lastSeq;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int read(byte[] b, int off, int len) throws IOException {
        totalBytes = 0;
        var5_5 = this._recvQueueLock;
        synchronized (var5_5) {
            while (true) lbl-1000:
            // 4 sources

            {
                block14: {
                    if (this._inSeqRecvQueue.isEmpty()) break block14;
                    it = this._inSeqRecvQueue.iterator();
                    if (true) ** GOTO lbl45
                }
                if (this.isClosed()) {
                    throw new SocketException("Socket is closed");
                }
                if (this.isInputShutdown()) {
                    throw new EOFException();
                }
                if (!this.isConnected()) {
                    throw new SocketException("Connection reset");
                }
                try {
                    if (this._timeout == 0) {
                        this._recvQueueLock.wait();
                    }
                    startTime = System.currentTimeMillis();
                    this._recvQueueLock.wait(this._timeout);
                    if (System.currentTimeMillis() - startTime < (long)this._timeout) ** GOTO lbl-1000
                    throw new SocketTimeoutException();
                }
                catch (InterruptedException xcp) {
                    xcp.printStackTrace();
                }
                break;
            }
            do {
                if ((s = it.next()) instanceof RSTSegment) {
                    it.remove();
                    break;
                }
                if (s instanceof FINSegment) {
                    if (totalBytes > 0) break;
                    it.remove();
                    return -1;
                }
                if (!(s instanceof DATSegment)) continue;
                data = ((DATSegment)s).getData();
                if (data.length + totalBytes > len) {
                    if (totalBytes > 0) break;
                    throw new IOException("insufficient buffer space");
                }
                System.arraycopy(data, 0, b, off + totalBytes, data.length);
                totalBytes += data.length;
                it.remove();
lbl45:
                // 3 sources

            } while (it.hasNext());
            if (totalBytes > 0) ** break;
            ** continue;
            return totalBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ReliableSocketListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        ArrayList arrayList = this._listeners;
        synchronized (arrayList) {
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ReliableSocketListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        ArrayList arrayList = this._listeners;
        synchronized (arrayList) {
            this._listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateListener(ReliableSocketStateListener stateListener) {
        if (stateListener == null) {
            throw new NullPointerException("stateListener");
        }
        ArrayList arrayList = this._stateListeners;
        synchronized (arrayList) {
            if (!this._stateListeners.contains(stateListener)) {
                this._stateListeners.add(stateListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateListener(ReliableSocketStateListener stateListener) {
        if (stateListener == null) {
            throw new NullPointerException("stateListener");
        }
        ArrayList arrayList = this._stateListeners;
        synchronized (arrayList) {
            this._stateListeners.remove(stateListener);
        }
    }

    private void sendSegment(Segment s) throws IOException {
        if (s instanceof DATSegment || s instanceof RSTSegment || s instanceof FINSegment || s instanceof NULSegment) {
            this.checkAndSetAck(s);
        }
        if (s instanceof DATSegment || s instanceof RSTSegment || s instanceof FINSegment || s instanceof UIDSegment) {
            this._nullSegmentTimer.reset();
        }
        this.log("-------> sent \t" + s);
        this.sendSegmentImpl(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendAndQueueSegment(Segment segment) throws IOException {
        Object object = this._unackedSentQueue;
        synchronized (object) {
            while (true) {
                if (this._unackedSentQueue.isEmpty() || this._unackedSentQueue.size() < this._sendQueueSize && this._counters.getOutstandingSegsCounter() <= this._profile.maxOutstandingSegs() || !this._connected || this._closed) {
                    this._unackedBufferSentQueue.add(segment);
                    this._counters.incOutstandingSegsCounter();
                    break;
                }
                try {
                    this._unackedSentQueue.wait(this._profile.retransmissionTimeout());
                }
                catch (InterruptedException xcp) {
                    xcp.printStackTrace();
                }
            }
        }
        if (this._closed && !this._wasConnected) {
            LOGGER.severe("Socket is closed.");
            throw new SocketException("Socket is closed");
        }
        this.sendSegment(segment);
        if (!(segment instanceof EAKSegment) && !(segment instanceof ACKSegment)) {
            object = this._retransmissionTimer;
            synchronized (object) {
                if (this._retransmissionTimer.isIdle()) {
                    this._retransmissionTimer.schedule(this._profile.retransmissionTimeout(), this._profile.retransmissionTimeout());
                }
            }
        }
        if (!(segment instanceof DATSegment)) return;
        object = this._listeners;
        synchronized (object) {
            Iterator it = this._listeners.iterator();
            while (true) {
                if (!it.hasNext()) {
                    return;
                }
                ReliableSocketListener l = (ReliableSocketListener)it.next();
                l.packetSent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retransmitSegment(Segment segment) throws IOException {
        if (segment.isRetransmitting()) {
            return;
        }
        segment.setRetransmitting(true);
        if (this._profile.maxRetrans() > 0) {
            segment.setRetxCounter(segment.getRetxCounter() + 1);
        }
        if (this._profile.maxRetrans() != 0 && segment.getRetxCounter() > this._profile.maxRetrans()) {
            this.connectionFailure();
            return;
        }
        this.sendSegment(segment);
        if (segment instanceof DATSegment) {
            ArrayList arrayList = this._listeners;
            synchronized (arrayList) {
                for (ReliableSocketListener l : this._listeners) {
                    l.packetRetransmitted();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionOpened() {
        if (this.isConnected()) {
            this._nullSegmentTimer.cancel();
            this._uidSegmentTimer.cancel();
            if (this._keepAlive) {
                this._keepAliveTimer.cancel();
            }
            Object object = this._resetLock;
            synchronized (object) {
                this._reset = false;
                this._resetLock.notify();
            }
        }
        ReliableSocket reliableSocket = this;
        synchronized (reliableSocket) {
            try {
                this._in = new ReliableSocketInputStream(this);
                this._out = new ReliableSocketOutputStream(this);
                this._connected = true;
                this._state = 3;
            }
            catch (IOException xcp) {
                xcp.printStackTrace();
            }
            this.notify();
        }
        for (ReliableSocketStateListener l : this._stateListeners) {
            l.connectionOpened(this);
        }
        this._nullSegmentTimer.schedule(0L, this._profile.nullSegmentTimeout());
        this._uidSegmentTimer.schedule(0L, this._profile.nullSegmentTimeout());
        if (this._keepAlive) {
            this._keepAliveTimer.schedule(this._profile.nullSegmentTimeout() * 10, this._profile.nullSegmentTimeout() * 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionRefused() {
        ArrayList arrayList = this._stateListeners;
        synchronized (arrayList) {
            for (ReliableSocketStateListener l : this._stateListeners) {
                l.connectionRefused(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionClosed() {
        ArrayList arrayList = this._stateListeners;
        synchronized (arrayList) {
            for (ReliableSocketStateListener l : this._stateListeners) {
                l.connectionClosed(this);
            }
        }
        this._connected = false;
        this._wasConnected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionFailure() {
        Object object = this._closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            switch (this._state) {
                case 2: {
                    Object object2 = this;
                    synchronized (object2) {
                        this.notify();
                        break;
                    }
                }
                case 1: 
                case 3: 
                case 4: {
                    this._connected = false;
                    Object object2 = this._unackedSentQueue;
                    synchronized (object2) {
                        this._unackedSentQueue.notifyAll();
                    }
                    object2 = this._recvQueueLock;
                    synchronized (object2) {
                        this._recvQueueLock.notify();
                    }
                    this.closeImpl();
                }
            }
            this.log("closing-connection failure");
            this._state = 0;
            this._closed = true;
        }
        object = this._stateListeners;
        synchronized (object) {
            for (ReliableSocketStateListener l : this._stateListeners) {
                l.connectionFailure(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionReset() {
        ArrayList arrayList = this._stateListeners;
        synchronized (arrayList) {
            for (ReliableSocketStateListener l : this._stateListeners) {
                l.connectionReset(this);
            }
        }
    }

    protected void handleSYNSegment(SYNSegment segment) {
        try {
            switch (this._state) {
                case 0: {
                    this._counters.setLastInSequence(segment.seq());
                    this._state = 1;
                    Random rand = new Random(System.currentTimeMillis());
                    this._profile = new ReliableSocketProfile(this._sendQueueSize, this._recvQueueSize, segment.getMaxSegmentSize(), segment.getMaxOutstandingSegments(), segment.getMaxRetransmissions(), segment.getMaxCumulativeAcks(), segment.getMaxOutOfSequence(), segment.getMaxAutoReset(), segment.getNulSegmentTimeout(), segment.getRetransmissionTimeout(), segment.getCummulativeAckTimeout());
                    SYNSegment syn = new SYNSegment(this._counters.setSequenceNumber(rand.nextInt(255)), this._profile.maxOutstandingSegs(), this._profile.maxSegmentSize(), this._profile.retransmissionTimeout(), this._profile.cumulativeAckTimeout(), this._profile.nullSegmentTimeout(), this._profile.maxRetrans(), this._profile.maxCumulativeAcks(), this._profile.maxOutOfSequence(), this._profile.maxAutoReset());
                    syn.setAck(segment.seq());
                    this.sendAndQueueSegment(syn);
                    break;
                }
                case 2: {
                    this._counters.setLastInSequence(segment.seq());
                    this._state = 3;
                    this.sendAck();
                    this.connectionOpened();
                }
            }
        }
        catch (IOException xcp) {
            xcp.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEAKSegment(EAKSegment segment) {
        int[] acks = segment.getACKs();
        int lastInSequence = segment.getAck();
        int lastOutSequence = acks[acks.length - 1];
        List<Segment> list = this._unackedSentQueue;
        synchronized (list) {
            Iterator<Segment> it = this._unackedSentQueue.iterator();
            block5: while (it.hasNext()) {
                Segment s = it.next();
                if (s == null) {
                    LOGGER.severe("[EAK Task] This should not happen. While iterating in the list someone (who?) removed a package from it!.");
                    it.remove();
                    continue;
                }
                if (this.compareSequenceNumbers(s.seq(), lastInSequence) <= 0) {
                    it.remove();
                    continue;
                }
                int i = 0;
                while (i < acks.length) {
                    if (this.compareSequenceNumbers(s.seq(), acks[i]) == 0) {
                        it.remove();
                        continue block5;
                    }
                    ++i;
                }
            }
            for (Segment s : this._unackedSentQueue) {
                if (this.compareSequenceNumbers(lastInSequence, s.seq()) >= 0 || this.compareSequenceNumbers(lastOutSequence, s.seq()) <= 0) continue;
                try {
                    this.retransmitSegment(s);
                }
                catch (IOException xcp) {
                    xcp.printStackTrace();
                }
            }
            this._unackedSentQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSegment(Segment segment) {
        Object object;
        if (segment instanceof RSTSegment) {
            object = this._resetLock;
            synchronized (object) {
                this._reset = true;
            }
            this.connectionReset();
        }
        if (segment instanceof FINSegment) {
            switch (this._state) {
                case 2: {
                    object = this;
                    synchronized (object) {
                        this.notify();
                        break;
                    }
                }
                case 0: {
                    break;
                }
                default: {
                    this._state = 4;
                    try {
                        this.close();
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        boolean inSequence = false;
        Object object2 = this._recvQueueLock;
        synchronized (object2) {
            if (this.compareSequenceNumbers(segment.seq(), this._counters.getLastInSequence()) > 0) {
                if (this.compareSequenceNumbers(segment.seq(), ReliableSocket.nextSequenceNumber(this._counters.getLastInSequence())) == 0) {
                    inSequence = true;
                    if (this._inSeqRecvQueue.size() == 0 || this._inSeqRecvQueue.size() + this._outSeqRecvQueue.size() < this._recvQueueSize) {
                        this._counters.setLastInSequence(segment.seq());
                        if (segment instanceof DATSegment || segment instanceof RSTSegment || segment instanceof FINSegment) {
                            this._inSeqRecvQueue.add(segment);
                        }
                        this.checkRecvQueues();
                        boolean hasDAT = segment instanceof DATSegment;
                        if (!hasDAT) {
                            int i = 0;
                            while (i < this._inSeqRecvQueue.size()) {
                                if (this._inSeqRecvQueue.get(i) instanceof DATSegment) {
                                    hasDAT = true;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (hasDAT) {
                            ArrayList i = this._listeners;
                            synchronized (i) {
                                for (ReliableSocketListener l : this._listeners) {
                                    l.packetReceivedInOrder();
                                }
                            }
                        }
                    }
                } else if (this._inSeqRecvQueue.size() + this._outSeqRecvQueue.size() < this._recvQueueSize) {
                    boolean added = false;
                    int i = 0;
                    while (i < this._outSeqRecvQueue.size() && !added) {
                        Segment s = this._outSeqRecvQueue.get(i);
                        int cmp = this.compareSequenceNumbers(segment.seq(), s.seq());
                        if (cmp == 0) {
                            added = true;
                        } else if (cmp < 0) {
                            this._outSeqRecvQueue.add(i, segment);
                            added = true;
                        }
                        ++i;
                    }
                    if (!added) {
                        this._outSeqRecvQueue.add(segment);
                    }
                    this._counters.incOutOfSequenceCounter();
                    if (segment instanceof DATSegment) {
                        ArrayList arrayList = this._listeners;
                        synchronized (arrayList) {
                            for (ReliableSocketListener l : this._listeners) {
                                l.packetReceivedOutOfOrder();
                            }
                        }
                    }
                }
            }
            if (inSequence && (segment instanceof RSTSegment || segment instanceof NULSegment || segment instanceof FINSegment || segment instanceof UIDSegment)) {
                this.sendAck();
            } else if (this._counters.getOutOfSequenceCounter() > 0 && (this._profile.maxOutOfSequence() == 0 || this._counters.getOutOfSequenceCounter() > this._profile.maxOutOfSequence())) {
                this.sendExtendedAck();
            } else if (this._counters.getCumulativeAckCounter() > 0 && (this._profile.maxCumulativeAcks() == 0 || this._counters.getCumulativeAckCounter() > this._profile.maxCumulativeAcks())) {
                this.sendSingleAck();
            } else {
                Timer timer = this._cumulativeAckTimer;
                synchronized (timer) {
                    if (this._cumulativeAckTimer.isIdle()) {
                        this._cumulativeAckTimer.schedule(this._profile.cumulativeAckTimeout());
                    }
                }
            }
        }
    }

    public int getState() {
        return this._state;
    }

    public boolean wasPreviouslyConnected() {
        return this._wasConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAck() {
        Object object = this._recvQueueLock;
        synchronized (object) {
            if (!this._outSeqRecvQueue.isEmpty()) {
                this.sendExtendedAck();
                return;
            }
            this.sendSingleAck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendExtendedAck() {
        Object object = this._recvQueueLock;
        synchronized (object) {
            if (this._outSeqRecvQueue.isEmpty()) {
                return;
            }
            this._counters.getAndResetCumulativeAckCounter();
            this._counters.getAndResetOutOfSequenceCounter();
            int[] acks = new int[this._outSeqRecvQueue.size()];
            int i = 0;
            while (i < acks.length) {
                Segment s = this._outSeqRecvQueue.get(i);
                acks[i] = s.seq();
                ++i;
            }
            try {
                int lastInSequence = this._counters.getLastInSequence();
                this.sendSegment(new EAKSegment(ReliableSocket.nextSequenceNumber(lastInSequence), lastInSequence, acks));
            }
            catch (IOException xcp) {
                xcp.printStackTrace();
            }
        }
    }

    private void sendSingleAck() {
        if (this._counters.getAndResetCumulativeAckCounter() == 0) {
            return;
        }
        try {
            int lastInSequence = this._counters.getLastInSequence();
            this.sendSegment(new ACKSegment(ReliableSocket.nextSequenceNumber(lastInSequence), lastInSequence));
        }
        catch (IOException xcp) {
            xcp.printStackTrace();
        }
    }

    private void checkAndSetAck(Segment s) {
        if (this._counters.getAndResetCumulativeAckCounter() == 0) {
            return;
        }
        s.setAck(this._counters.getLastInSequence());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAndGetAck(Segment segment) {
        int ackn = segment.getAck();
        if (ackn < 0) {
            return;
        }
        this._counters.getAndResetOutstandingSegsCounter();
        if (this._state == 1) {
            this._state = 3;
            this.connectionOpened();
        }
        List<Segment> list = this._unackedSentQueue;
        synchronized (list) {
            Iterator<Segment> it = this._unackedSentQueue.iterator();
            while (it.hasNext()) {
                Segment s = it.next();
                if (s == null) {
                    LOGGER.severe("[CHECK AND GET Task] This should not happen. While iterating in the list someone (who?) removed a package from it!.");
                    it.remove();
                    continue;
                }
                if (this.compareSequenceNumbers(s.seq(), ackn) > 0) continue;
                it.remove();
            }
            if (this._unackedSentQueue.isEmpty()) {
                this._retransmissionTimer.cancel();
                ArrayList arrayList = this._listeners;
                synchronized (arrayList) {
                    for (ReliableSocketListener l : this._listeners) {
                        l.ackReceived(ackn);
                    }
                }
            }
            this._unackedSentQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRecvQueues() {
        Object object = this._recvQueueLock;
        synchronized (object) {
            Iterator<Segment> it = this._outSeqRecvQueue.iterator();
            while (it.hasNext()) {
                Segment s = it.next();
                if (this.compareSequenceNumbers(s.seq(), ReliableSocket.nextSequenceNumber(this._counters.getLastInSequence())) != 0) continue;
                this._counters.setLastInSequence(s.seq());
                if (s instanceof DATSegment || s instanceof RSTSegment || s instanceof FINSegment) {
                    this._inSeqRecvQueue.add(s);
                }
                it.remove();
            }
            this._recvQueueLock.notify();
        }
    }

    protected void sendSegmentImpl(Segment segment) throws IOException {
        this._scheduler.submit(this._channel, this._endpoint, segment);
        if (this._unackedBufferSentQueue.contains(segment)) {
            this._unackedSentQueue.add(segment);
            this._unackedBufferSentQueue.remove(segment);
        }
        if (segment.isRetransmitting()) {
            segment.setRetransmitting(false);
        }
    }

    protected void closeSocket() {
        this._channel.socket().close();
        if (this._key != null) {
            this._key.cancel();
        }
    }

    protected void closeImpl() {
        this._nullSegmentTimer.cancel();
        this._keepAliveTimer.cancel();
        this._state = 4;
        Thread t = new Thread(){

            @Override
            public void run() {
                ReliableSocket.this._keepAliveTimer.destroy();
                ReliableSocket.this._nullSegmentTimer.destroy();
                ReliableSocket.this._uidSegmentTimer.destroy();
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException xcp) {
                    xcp.printStackTrace();
                }
                ReliableSocket.this._retransmissionTimer.destroy();
                ReliableSocket.this._cumulativeAckTimer.destroy();
                ReliableSocket.this.closeSocket();
                ReliableSocket.this.connectionClosed();
            }
        };
        t.setName("ReliableSocket-Closing");
        t.setDaemon(true);
        t.start();
    }

    protected void log(String msg) {
        LOGGER.fine(String.valueOf(this.getLocalPort()) + ": " + msg);
    }

    private static int nextSequenceNumber(int seqn) {
        return (seqn + 1) % 255;
    }

    private int compareSequenceNumbers(int seqn, int aseqn) {
        if (seqn == aseqn) {
            return 0;
        }
        if (seqn < aseqn && aseqn - seqn > 127 || seqn > aseqn && seqn - aseqn < 127) {
            return 1;
        }
        return -1;
    }

    public static ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return _threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleReceive(Segment segment) {
        Object object = this._recvQueueLock;
        synchronized (object) {
            this.log("<------- recv \t" + segment);
            if (segment instanceof DATSegment || segment instanceof NULSegment || segment instanceof RSTSegment || segment instanceof FINSegment || segment instanceof SYNSegment) {
                this._counters.incCumulativeAckCounter();
            }
            if (this._keepAlive) {
                this._keepAliveTimer.reset();
            }
            if (segment instanceof SYNSegment) {
                this.handleSYNSegment((SYNSegment)segment);
            } else if (segment instanceof EAKSegment) {
                this.handleEAKSegment((EAKSegment)segment);
            } else if (!(segment instanceof ACKSegment) && !(segment instanceof UIDSegment)) {
                this.handleSegment(segment);
            }
            this.checkAndGetAck(segment);
        }
    }

    private class Counters {
        private volatile int _seqn;
        private volatile int _lastInSequence;
        private volatile int _cumAckCounter;
        private volatile int _outOfSeqCounter;
        private volatile int _outSegsCounter;

        public synchronized void setOutstandingSegsCounter(int remainder) {
            this._outSegsCounter = remainder > 0 ? remainder : 0;
        }

        public synchronized int nextSequenceNumber() {
            this._seqn = ReliableSocket.nextSequenceNumber(this._seqn);
            return this._seqn;
        }

        public synchronized int setSequenceNumber(int n) {
            this._seqn = n;
            return this._seqn;
        }

        public synchronized int getSequenceNumber() {
            return this._seqn;
        }

        public synchronized int setLastInSequence(int n) {
            this._lastInSequence = n;
            return this._lastInSequence;
        }

        public synchronized int getLastInSequence() {
            return this._lastInSequence;
        }

        public synchronized void incCumulativeAckCounter() {
            ++this._cumAckCounter;
        }

        public synchronized int getCumulativeAckCounter() {
            return this._cumAckCounter;
        }

        public synchronized int getAndResetCumulativeAckCounter() {
            int tmp = this._cumAckCounter;
            this._cumAckCounter = 0;
            return tmp;
        }

        public synchronized void incOutOfSequenceCounter() {
            ++this._outOfSeqCounter;
        }

        public synchronized int getOutOfSequenceCounter() {
            return this._outOfSeqCounter;
        }

        public synchronized int getAndResetOutOfSequenceCounter() {
            int tmp = this._outOfSeqCounter;
            this._outOfSeqCounter = 0;
            return tmp;
        }

        public synchronized void incOutstandingSegsCounter() {
            ++this._outSegsCounter;
        }

        public synchronized int getOutstandingSegsCounter() {
            return this._outSegsCounter;
        }

        public synchronized int getAndResetOutstandingSegsCounter() {
            int tmp = this._outSegsCounter;
            this._outSegsCounter = 0;
            return tmp;
        }

        public synchronized void reset() {
            this._outOfSeqCounter = 0;
            this._outSegsCounter = 0;
            this._cumAckCounter = 0;
        }
    }

    private class CumulativeAckTimerTask
    extends RecurringTask {
        private CumulativeAckTimerTask() {
        }

        @Override
        public void run() {
            this.runningLock.lock();
            ReliableSocket.this.sendAck();
            this.runningLock.unlock();
        }
    }

    private class KeepAliveTimerTask
    extends RecurringTask {
        private KeepAliveTimerTask() {
        }

        @Override
        public void run() {
            this.runningLock.lock();
            ReliableSocket.this.connectionFailure();
            this.runningLock.unlock();
        }
    }

    private class NullSegmentTimerTask
    extends RecurringTask {
        private NullSegmentTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.runningLock.lock();
            List list = ReliableSocket.this._unackedSentQueue;
            synchronized (list) {
                if (ReliableSocket.this._unackedSentQueue.isEmpty()) {
                    try {
                        ReliableSocket.this.sendAndQueueSegment(new NULSegment(ReliableSocket.this._counters.nextSequenceNumber()));
                    }
                    catch (IOException xcp) {
                        LOGGER.severe("NULL SEGMENT TIMER FAILED");
                    }
                }
            }
            this.runningLock.unlock();
        }
    }

    public abstract class RecurringTask
    implements Runnable {
        protected ReentrantLock runningLock = new ReentrantLock();
        protected volatile boolean canceled;

        public boolean isRunning() {
            return this.runningLock.isLocked();
        }

        public void resume() {
            this.canceled = false;
        }

        public void cancel() {
            this.canceled = true;
        }

        public boolean isCanceled() {
            return this.canceled;
        }
    }

    private class RetransmissionTimerTask
    extends RecurringTask {
        private RetransmissionTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.runningLock.lock();
            List list = ReliableSocket.this._unackedSentQueue;
            synchronized (list) {
                Iterator it = ReliableSocket.this._unackedSentQueue.iterator();
                while (it.hasNext()) {
                    if (this.isCanceled()) break;
                    Segment s = (Segment)it.next();
                    if (s == null) {
                        LOGGER.severe("[Retransmission Task] This should not happen. While iterating in the list someone (who?) removed a package from it!.");
                        it.remove();
                        continue;
                    }
                    try {
                        ReliableSocket.this.log("=======> retrans " + s);
                        ReliableSocket.this.retransmitSegment(s);
                    }
                    catch (IOException xcp) {
                        LOGGER.severe("RETRANSMISSION TIMER FAILED");
                    }
                }
                ReliableSocket.this._retransmissionTimer.setPeriod(ReliableSocket.this._profile.retransmissionTimeout());
            }
            this.runningLock.unlock();
        }
    }

    private class ShutdownHook
    extends Thread {
        public ShutdownHook() {
            super("ReliableSocket-ShutdownHook");
        }

        @Override
        public void run() {
            try {
                switch (ReliableSocket.this._state) {
                    case 0: {
                        return;
                    }
                }
                ReliableSocket.this.sendSegment(new FINSegment(ReliableSocket.this._counters.nextSequenceNumber()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class UIDSegmentTimerTask
    extends RecurringTask {
        private UIDSegmentTimerTask() {
        }

        @Override
        public void run() {
            this.runningLock.lock();
            if (ReliableSocket.this._uuid != null) {
                try {
                    ReliableSocket.this.sendSegment(new UIDSegment(-1, ReliableSocket.this._uuid));
                }
                catch (IOException e) {
                    LOGGER.severe("UID TIMER FAILED");
                }
            }
            this.runningLock.unlock();
        }
    }
}

