/*
 * Decompiled with CFR 0.152.
 */
package net.rudp.impl;

import net.rudp.impl.Segment;

public class SYNSegment
extends Segment {
    private int _version;
    private int _maxseg;
    private int _optflags;
    private int _maxsegsize;
    private int _rettoval;
    private int _cumacktoval;
    private int _niltoval;
    private int _maxret;
    private int _maxcumack;
    private int _maxoutseq;
    private int _maxautorst;
    private static final int SYN_HEADER_LEN = 22;

    protected SYNSegment() {
    }

    public SYNSegment(int seqn, int maxseg, int maxsegsize, int rettoval, int cumacktoval, int niltoval, int maxret, int maxcumack, int maxoutseq, int maxautorst) {
        this.init(-128, seqn, 22);
        this._version = 1;
        this._maxseg = maxseg;
        this._optflags = 1;
        this._maxsegsize = maxsegsize;
        this._rettoval = rettoval;
        this._cumacktoval = cumacktoval;
        this._niltoval = niltoval;
        this._maxret = maxret;
        this._maxcumack = maxcumack;
        this._maxoutseq = maxoutseq;
        this._maxautorst = maxautorst;
    }

    @Override
    public String type() {
        return "SYN";
    }

    public int getVersion() {
        return this._version;
    }

    public int getMaxOutstandingSegments() {
        return this._maxseg;
    }

    public int getOptionFlags() {
        return this._optflags;
    }

    public int getMaxSegmentSize() {
        return this._maxsegsize;
    }

    public int getRetransmissionTimeout() {
        return this._rettoval;
    }

    public int getCummulativeAckTimeout() {
        return this._cumacktoval;
    }

    public int getNulSegmentTimeout() {
        return this._niltoval;
    }

    public int getMaxRetransmissions() {
        return this._maxret;
    }

    public int getMaxCumulativeAcks() {
        return this._maxcumack;
    }

    public int getMaxOutOfSequence() {
        return this._maxoutseq;
    }

    public int getMaxAutoReset() {
        return this._maxautorst;
    }

    @Override
    public byte[] getBytes() {
        byte[] buffer = super.getBytes();
        buffer[4] = (byte)(this._version << 4 & 0xFF);
        buffer[5] = (byte)(this._maxseg & 0xFF);
        buffer[6] = (byte)(this._optflags & 0xFF);
        buffer[7] = 0;
        buffer[8] = (byte)(this._maxsegsize >>> 8 & 0xFF);
        buffer[9] = (byte)(this._maxsegsize >>> 0 & 0xFF);
        buffer[10] = (byte)(this._rettoval >>> 8 & 0xFF);
        buffer[11] = (byte)(this._rettoval >>> 0 & 0xFF);
        buffer[12] = (byte)(this._cumacktoval >>> 8 & 0xFF);
        buffer[13] = (byte)(this._cumacktoval >>> 0 & 0xFF);
        buffer[14] = (byte)(this._niltoval >>> 8 & 0xFF);
        buffer[15] = (byte)(this._niltoval >>> 0 & 0xFF);
        buffer[16] = (byte)(this._maxret & 0xFF);
        buffer[17] = (byte)(this._maxcumack & 0xFF);
        buffer[18] = (byte)(this._maxoutseq & 0xFF);
        buffer[19] = (byte)(this._maxautorst & 0xFF);
        return buffer;
    }

    @Override
    protected void parseBytes(byte[] buffer, int off, int len) {
        super.parseBytes(buffer, off, len);
        if (len < 22) {
            throw new IllegalArgumentException("Invalid SYN segment");
        }
        this._version = (buffer[off + 4] & 0xFF) >>> 4;
        if (this._version != 1) {
            throw new IllegalArgumentException("Invalid RUDP version");
        }
        this._maxseg = buffer[off + 5] & 0xFF;
        this._optflags = buffer[off + 6] & 0xFF;
        this._maxsegsize = (buffer[off + 8] & 0xFF) << 8 | (buffer[off + 9] & 0xFF) << 0;
        this._rettoval = (buffer[off + 10] & 0xFF) << 8 | (buffer[off + 11] & 0xFF) << 0;
        this._cumacktoval = (buffer[off + 12] & 0xFF) << 8 | (buffer[off + 13] & 0xFF) << 0;
        this._niltoval = (buffer[off + 14] & 0xFF) << 8 | (buffer[off + 15] & 0xFF) << 0;
        this._maxret = buffer[off + 16] & 0xFF;
        this._maxcumack = buffer[off + 17] & 0xFF;
        this._maxoutseq = buffer[off + 18] & 0xFF;
        this._maxautorst = buffer[off + 19] & 0xFF;
    }

    public int get_version() {
        return this._version;
    }

    public void set_version(int _version) {
        this._version = _version;
    }

    public int get_maxseg() {
        return this._maxseg;
    }

    public void set_maxseg(int _maxseg) {
        this._maxseg = _maxseg;
    }

    public int get_optflags() {
        return this._optflags;
    }

    public void set_optflags(int _optflags) {
        this._optflags = _optflags;
    }

    public int get_maxsegsize() {
        return this._maxsegsize;
    }

    public void set_maxsegsize(int _maxsegsize) {
        this._maxsegsize = _maxsegsize;
    }

    public int get_rettoval() {
        return this._rettoval;
    }

    public void set_rettoval(int _rettoval) {
        this._rettoval = _rettoval;
    }

    public int get_cumacktoval() {
        return this._cumacktoval;
    }

    public void set_cumacktoval(int _cumacktoval) {
        this._cumacktoval = _cumacktoval;
    }

    public int get_niltoval() {
        return this._niltoval;
    }

    public void set_niltoval(int _niltoval) {
        this._niltoval = _niltoval;
    }

    public int get_maxret() {
        return this._maxret;
    }

    public void set_maxret(int _maxret) {
        this._maxret = _maxret;
    }

    public int get_maxcumack() {
        return this._maxcumack;
    }

    public void set_maxcumack(int _maxcumack) {
        this._maxcumack = _maxcumack;
    }

    public int get_maxoutseq() {
        return this._maxoutseq;
    }

    public void set_maxoutseq(int _maxoutseq) {
        this._maxoutseq = _maxoutseq;
    }

    public int get_maxautorst() {
        return this._maxautorst;
    }

    public void set_maxautorst(int _maxautorst) {
        this._maxautorst = _maxautorst;
    }
}

