/*
 * Decompiled with CFR 0.152.
 */
package net.rudp.impl;

import java.io.Serializable;
import net.rudp.impl.ACKSegment;
import net.rudp.impl.DATSegment;
import net.rudp.impl.EAKSegment;
import net.rudp.impl.FINSegment;
import net.rudp.impl.NULSegment;
import net.rudp.impl.RSTSegment;
import net.rudp.impl.SYNSegment;
import net.rudp.impl.UIDSegment;

public abstract class Segment
implements Serializable {
    public static final int RUDP_VERSION = 1;
    public static final int RUDP_HEADER_LEN = 6;
    public static final byte SYN_FLAG = -128;
    public static final byte ACK_FLAG = 64;
    public static final byte EAK_FLAG = 32;
    public static final byte RST_FLAG = 16;
    public static final byte NUL_FLAG = 8;
    public static final byte CHK_FLAG = 4;
    public static final byte FIN_FLAG = 2;
    public transient boolean retransmitting = false;
    private int _flags;
    private int _hlen;
    private int _seqn;
    private int _ackn = -1;
    private int _nretx = 0;

    public abstract String type();

    public int flags() {
        return this._flags;
    }

    public int seq() {
        return this._seqn;
    }

    public int length() {
        return this._hlen;
    }

    public void setAck(int ackn) {
        this._flags |= 0x40;
        this._ackn = ackn;
    }

    public int getAck() {
        if ((this._flags & 0x40) == 64) {
            return this._ackn;
        }
        return -1;
    }

    public int getRetxCounter() {
        return this._nretx;
    }

    public void setRetxCounter(int n) {
        this._nretx = n;
    }

    public byte[] getBytes() {
        byte[] buffer = new byte[this.length()];
        buffer[0] = (byte)(this._flags & 0xFF);
        buffer[1] = (byte)(this._hlen & 0xFF);
        buffer[2] = (byte)(this._seqn & 0xFF);
        buffer[3] = (byte)(this._ackn & 0xFF);
        return buffer;
    }

    public String toString() {
        return String.valueOf(this.type()) + " [" + " SEQ = " + this.seq() + ", ACK = " + (this.getAck() >= 0 ? "" + this.getAck() : "N/A") + ", LEN = " + this.length() + " ]";
    }

    public static Segment parse(byte[] bytes) {
        return Segment.parse(bytes, 0, bytes.length);
    }

    public static Segment parse(byte[] bytes, int off, int len) {
        Segment segment = null;
        if (len < 6) {
            throw new IllegalArgumentException("Invalid segment");
        }
        byte flags = bytes[off];
        if ((flags & 0xFFFFFF80) != 0) {
            segment = new SYNSegment();
        } else if ((flags & 8) != 0) {
            segment = len == 6 ? new NULSegment() : new UIDSegment();
        } else if ((flags & 0x20) != 0) {
            segment = new EAKSegment();
        } else if ((flags & 0x10) != 0) {
            segment = new RSTSegment();
        } else if ((flags & 2) != 0) {
            segment = new FINSegment();
        } else if ((flags & 0x40) != 0) {
            segment = len == 6 ? new ACKSegment() : new DATSegment();
        }
        if (segment == null) {
            throw new IllegalArgumentException("Invalid segment");
        }
        ((Segment)segment).parseBytes(bytes, off, len);
        return segment;
    }

    protected void init(int flags, int seqn, int len) {
        this._flags = flags;
        this._seqn = seqn;
        this._hlen = len;
    }

    protected void parseBytes(byte[] buffer, int off, int len) {
        this._flags = buffer[off] & 0xFF;
        this._hlen = buffer[off + 1] & 0xFF;
        this._seqn = buffer[off + 2] & 0xFF;
        this._ackn = buffer[off + 3] & 0xFF;
    }

    public int get_flags() {
        return this._flags;
    }

    public void set_flags(int _flags) {
        this._flags = _flags;
    }

    public int get_hlen() {
        return this._hlen;
    }

    public void set_hlen(int _hlen) {
        this._hlen = _hlen;
    }

    public int get_seqn() {
        return this._seqn;
    }

    public void set_seqn(int _seqn) {
        this._seqn = _seqn;
    }

    public int get_ackn() {
        return this._ackn;
    }

    public void set_ackn(int _ackn) {
        this._ackn = _ackn;
    }

    public int get_nretx() {
        return this._nretx;
    }

    public void set_nretx(int _nretx) {
        this._nretx = _nretx;
    }

    public synchronized boolean isRetransmitting() {
        return this.retransmitting;
    }

    public synchronized void setRetransmitting(boolean retransmitting) {
        this.retransmitting = retransmitting;
    }
}

