/*
 * Decompiled with CFR 0.152.
 */
package net.rudp.impl;

import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.rudp.ReliableSocket;

public class Timer {
    public static final boolean DEBUG = Boolean.getBoolean("net.rudp.timer.debug");
    private ScheduledThreadPoolExecutor _executor;
    private String _name;
    private ReliableSocket.RecurringTask _task;
    private long _delay;
    private long _period;
    private boolean _canceled;
    private boolean _scheduled;
    private boolean _reset;
    private boolean _stopped;
    private Object _lock = new Object();
    private ScheduledFuture<?> _pooledTask;
    private ScheduledTask _scheduledTask;

    public Timer(String name, Runnable task, ScheduledThreadPoolExecutor executor) {
        this._name = name;
        this._task = (ReliableSocket.RecurringTask)task;
        this._executor = executor;
        this._delay = 0L;
        this._period = 0L;
        this._scheduled = false;
        if (DEBUG) {
            System.out.println("created task: " + this._name);
        }
    }

    public void schedule(long delay) {
        this.schedule(delay, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(long delay, long period) {
        if (DEBUG) {
            System.out.println("schedule task: " + this._name + " delay=" + delay + " period=" + period);
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._scheduled) {
                this.reset();
            }
            this._delay = delay;
            this._period = period;
            this._scheduled = true;
            this._reset = false;
            this._canceled = false;
            this._task.resume();
            this._scheduledTask = new ScheduledTask(this._task);
            this._pooledTask = this._executor.schedule(this._scheduledTask, this._delay, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScheduled() {
        Object object = this._lock;
        synchronized (object) {
            return this._scheduled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        Object object = this._lock;
        synchronized (object) {
            return !this.isScheduled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (DEBUG) {
            System.out.println("reset task: " + this._name);
        }
        Object object = this._lock;
        synchronized (object) {
            this._reset = true;
            if (this._scheduled) {
                this._scheduledTask._resetTime = System.currentTimeMillis();
                this._scheduledTask._canceled = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (DEBUG) {
            System.out.println("cancel task: " + this._name);
        }
        Object object = this._lock;
        synchronized (object) {
            this._scheduled = false;
            this._canceled = true;
            if (this._scheduledTask == null) {
                return;
            }
            this._scheduledTask._canceled = true;
            this._task.cancel();
            if (!this._task.isRunning()) {
                this._scheduledTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (DEBUG) {
            System.out.println("destroy task: " + this._name);
        }
        Object object = this._lock;
        synchronized (object) {
            this.cancel();
            this._stopped = true;
        }
    }

    public void setPeriod(long offsetPeriod) {
        this._period = offsetPeriod;
    }

    private class ScheduledTask
    extends FutureTask<Boolean> {
        private Runnable _task;
        public boolean _canceled;
        public long _resetTime;

        public ScheduledTask(Runnable task) {
            super(task, null);
            this._task = task;
            this._canceled = false;
            this._resetTime = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (DEBUG) {
                System.out.println("run task: " + Timer.this._name);
            }
            if (this._canceled) {
                if (DEBUG) {
                    System.out.println("run task: " + Timer.this._name + " - was cancelled");
                }
                this.set(false);
            } else {
                Timer.this._scheduled = false;
                long diff = 0L;
                if (this._resetTime != 0L) {
                    diff = System.currentTimeMillis() - this._resetTime;
                } else {
                    Runnable runnable = this._task;
                    synchronized (runnable) {
                        this._task.run();
                    }
                }
                if (Timer.this._period > 0L && !this._canceled) {
                    Timer.this.schedule(Timer.this._period + diff, Timer.this._period);
                }
                this.set(true);
            }
        }
    }
}

