#ifdef DDS_IDL
#define DDS_KEY __dds_key
#else
#define DDS_KEY
#endif

//Estrutura utilizada pelo GW para enviar os grupos para o domnio
struct GroupTopic
{
	long groupType;
	sequence<long> groupIDCollection;
};

struct GroupAdvertisementTopic
{
	long long leastSignificantBitsGatewayId;
	long long mostSignificantBitsGatewayId;
	DDS_KEY long long leastSignificantBitsVehicleId;
    DDS_KEY long long mostSignificantBitsVehicleId;
	long groupType;
	sequence<long> groupOperationCollection;
};

struct PrivateMessageTopic
{
	DDS_KEY long long leastSignificantBitsVehicleId;
	DDS_KEY long long mostSignificantBitsVehicleId;
	long long leastSignificantBitsGatewayId;
	long long mostSignificantBitsGatewayId;
	long groupId;
	long groupType;
	sequence<octet> message;
	//boolean toOutsideDomain; //Pode usar este tpico para enviar mensagens para os veculos e Domnio
};

//Utilizado como nested-structure no tpico UnsentMessageTopic
struct MessageStructureTopic
{
	sequence<octet> message;
};

struct UnsentMessageTopic
{
	DDS_KEY long long leastSignificantBitsVehicleId;
	DDS_KEY long long mostSignificantBitsVehicleId;
	long long leastSignificantBitsGatewayId;
	long long mostSignificantBitsGatewayId;
	sequence<MessageStructureTopic> unsentMessages;
};

struct PingTopic
{
	DDS_KEY octet pingId;
	long long leastSignificantBitsGatewayId;
	long long mostSignificantBitsGatewayId;
	long long leastSignificantBitsVehicleId;
	long long mostSignificantBitsVehicleId;
	long long timestamp; //ou outro tipo de tempo. Necessrio?
	boolean pingCore; //Informar se eh um pingCore
	boolean ping; //Assim  possvel usar o mesmo tempo para receber e enviar dados. Informa se  PING ou PONG
	long groupType;
	long groupId;
};

struct LoadReportTopic
{
	DDS_KEY long long leastSignificantBitsParticipantId;
	DDS_KEY long long mostSignificantBitsParticipantId;
	octet participantType; //GW, GroupDefiner, Monitor,... Podemos monitorar todos os elementos no domnio e saber seu tipo
	octet cpuUsage;
	long freeMemory;
	long numberOfConnectedVehicles;
	string participantIp; //til no caso do GW onde o PoM-Manager precisa saber o IP de cada GW para gerar a lista
};

struct ConnectionReportTopic
{
	DDS_KEY long long leastSignificantBitsVehicleId;
	DDS_KEY long long mostSignificantBitsVehicleId;
	long long leastSignificantBitsGatewayId;
	long long mostSignificantBitsGatewayId;
	boolean connected;
};

struct GroupMessageTopic
{
	DDS_KEY long long leastSignificantBitsGatewayId;
	DDS_KEY long long mostSignificantBitsGatewayId;
	long long localLogicalTime;
	sequence<octet> message;
};