/*
 * Decompiled with CFR 0.152.
 */
package lac.cnclib.group;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lac.cnclib.group.GroupNode;

public class GroupSender {
    private static InetSocketAddress address;
    private static int numClients;

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Call: java -jar stresstest.jar <ip> <port> <number of clients>");
        } else {
            address = new InetSocketAddress(args[0], Integer.parseInt(args[1]));
            numClients = Integer.parseInt(args[2]);
            try {
                new GroupSender().start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void start() throws IOException {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(50);
        int n = 0;
        while (n < numClients) {
            GroupNode client = new GroupNode(n, address, executor);
            executor.scheduleWithFixedDelay(client, 15000L, 500L, TimeUnit.MILLISECONDS);
            ++n;
        }
    }
}

