/*
 * Decompiled with CFR 0.152.
 */
package lac.cnclib.picture;

import java.awt.Font;
import java.io.Serializable;
import java.net.SocketAddress;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lac.cnclib.net.NodeConnection;
import lac.cnclib.net.NodeConnectionListener;
import lac.cnclib.net.NodeConnectionServerListener;
import lac.cnclib.net.mrudp.MrUdpNodeConnectionServer;
import lac.cnclib.picture.CustomData;
import lac.cnclib.picture.HelloWorldServerGUI;
import lac.cnclib.sddl.message.ApplicationMessage;
import lac.cnclib.sddl.message.Message;

public class HelloWorldServer
implements NodeConnectionServerListener,
NodeConnectionListener {
    public MrUdpNodeConnectionServer server;
    private static final int port = 5500;
    private JFrame gui;
    private String guiTitle;
    private JLabel guiLabel;
    private static int count = 1;

    public HelloWorldServer(int port) {
        try {
            this.server = new MrUdpNodeConnectionServer(port);
            this.server.addListener(this);
            this.server.start();
            this.gui = new HelloWorldServerGUI();
            this.gui.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Logger.getLogger("").setLevel(Level.ALL);
        new HelloWorldServer(5500);
    }

    @Override
    public void newNodeConnection(NodeConnection remoteCon) {
        System.out.println("ALGUEM SE CONECTOU");
        remoteCon.addNodeConnectionListener(this);
    }

    @Override
    public void newMessageReceived(NodeConnection remoteCon, Message message) {
        System.out.println("CHEGOU ALGO " + count++);
        ApplicationMessage msg = (ApplicationMessage)message;
        Serializable content = msg.getContentObject();
        if (content instanceof String) {
            this.guiTitle = (String)((Object)content);
            this.gui.setTitle(this.guiTitle);
        } else if (content instanceof CustomData && count < 5) {
            CustomData data = (CustomData)content;
            JPanel panel = ((HelloWorldServerGUI)this.gui).getPanel();
            this.guiLabel = new JLabel(new ImageIcon(data.getIcon().getImage()));
            this.guiLabel.setText(data.getCaption());
            this.guiLabel.setVerticalTextPosition(3);
            this.guiLabel.setHorizontalTextPosition(0);
            this.guiLabel.setFont(new Font("Tahoma", 0, 22));
            panel.add(this.guiLabel);
            SwingUtilities.updateComponentTreeUI(this.gui);
        }
    }

    @Override
    public void connected(NodeConnection remoteCon) {
    }

    @Override
    public void reconnected(NodeConnection remoteCon, SocketAddress endPoint, boolean wasHandover, boolean wasMandatory) {
    }

    @Override
    public void disconnected(NodeConnection remoteCon) {
    }

    @Override
    public void unsentMessages(NodeConnection remoteCon, List<Message> unsentMessages) {
    }

    @Override
    public void internalException(NodeConnection remoteCon, Exception e) {
    }
}

