/*
 * Decompiled with CFR 0.152.
 */
package lac.cnclib.ws;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Scanner;
import lac.cnclib.net.NodeConnection;
import lac.cnclib.net.NodeConnectionListener;
import lac.cnclib.net.mrudp.MrUdpNodeConnection;
import lac.cnclib.sddl.message.ApplicationMessage;
import lac.cnclib.sddl.message.ClientLibProtocol;
import lac.cnclib.sddl.message.Message;

public class WebSocketTest
implements NodeConnectionListener {
    private static String gatewayIP = "127.0.0.1";
    private static int gatewayPort = 5500;
    private MrUdpNodeConnection connection;
    private InetSocketAddress address = new InetSocketAddress(gatewayIP, gatewayPort);
    private Shell shell;

    public static void main(String[] args) {
        new WebSocketTest();
    }

    public WebSocketTest() {
        try {
            this.connection = new MrUdpNodeConnection();
            this.connection.connect(this.address);
            this.connection.addNodeConnectionListener(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void connected(NodeConnection remoteCon) {
        ApplicationMessage message = new ApplicationMessage();
        if (this.shell == null) {
            this.shell = new Shell(message, remoteCon);
            new Thread(this.shell).start();
        }
    }

    @Override
    public void newMessageReceived(NodeConnection remoteCon, Message message) {
        System.out.println("<---- RECEIVED MSG:");
        System.out.println(message.getContentObject());
    }

    @Override
    public void reconnected(NodeConnection remoteCon, SocketAddress endPoint, boolean wasHandover, boolean wasMandatory) {
        System.out.println("RECONNECTED");
    }

    @Override
    public void disconnected(NodeConnection remoteCon) {
        System.out.println("DISCONNECTED");
    }

    @Override
    public void unsentMessages(NodeConnection remoteCon, List<Message> unsentMessages) {
        System.out.println("UNSENT MESSAGES");
        for (Message m : unsentMessages) {
            System.out.println("MENSAGEM NAO ENVIADA: " + m);
        }
    }

    @Override
    public void internalException(NodeConnection remoteCon, Exception e) {
    }

    public class Shell
    implements Runnable {
        private NodeConnection nodeCon;

        public Shell(ApplicationMessage msg, NodeConnection conn) {
            this.nodeCon = conn;
        }

        @Override
        public void run() {
            try {
                System.out.println("COMMANDS: ");
                System.out.println("\t\t {JSON} -- WILL SEND THE JSON MSG");
                String serializableContent = "";
                Scanner scan = new Scanner(System.in);
                while (scan.hasNext()) {
                    ApplicationMessage msg = new ApplicationMessage();
                    serializableContent = scan.nextLine();
                    msg.setContentObject((Serializable)((Object)serializableContent));
                    msg.setPayloadType(ClientLibProtocol.PayloadSerialization.JSON);
                    System.out.println("----> SENDING:" + serializableContent);
                    this.nodeCon.sendMessage(msg);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

