/*
 * Decompiled with CFR 0.152.
 */
package lac.mrudp.stress;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import net.rudp.ReliableSocket;
import net.rudp.ReliableSocketOutputStream;

public class SimpleStressClient {
    private String host = "localhost";
    private int port = 5500;

    public static void main(String[] args) throws Exception {
        SimpleStressClient test = new SimpleStressClient();
        test.start();
    }

    public void start() throws UnknownHostException, IOException {
        new Thread(new StressTask(1, this.host, this.port)).start();
    }

    private class StressTask
    implements Runnable {
        private int id;
        private ReliableSocket client;

        public StressTask(int id, String host, int port) throws UnknownHostException, IOException {
            this.id = id;
            this.client = new ReliableSocket(host, port);
        }

        @Override
        public void run() {
            long oldTime;
            int count = 0;
            long currentTime = oldTime = System.currentTimeMillis();
            try {
                ReliableSocketOutputStream outputStream = (ReliableSocketOutputStream)this.client.getOutputStream();
                PrintWriter outputBuffer = new PrintWriter(outputStream);
                do {
                    outputBuffer.println("Task " + this.id);
                    currentTime = System.currentTimeMillis();
                    ++count;
                } while (currentTime - oldTime < 120000L);
                System.out.println("SENDED: " + (long)count / (1000L * (currentTime - oldTime)) + " msg / sec");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

