/*
 * Decompiled with CFR 0.152.
 */
package net.rudp;

import java.io.IOException;
import java.io.InputStream;
import net.rudp.ReliableSocket;

class ReliableSocketInputStream
extends InputStream {
    protected ReliableSocket _sock;
    protected byte[] _buf;
    protected int _pos;
    protected int _count;

    public ReliableSocketInputStream(ReliableSocket sock) throws IOException {
        if (sock == null) {
            throw new NullPointerException("sock");
        }
        this._sock = sock;
        this._buf = new byte[this._sock.getReceiveBufferSize()];
        this._count = 0;
        this._pos = 0;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.readImpl() < 0) {
            return -1;
        }
        return this._buf[this._pos++] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.readImpl() < 0) {
            return -1;
        }
        int readBytes = Math.min(this.available(), len);
        System.arraycopy(this._buf, this._pos, b, off, readBytes);
        this._pos += readBytes;
        return readBytes;
    }

    @Override
    public synchronized int available() {
        return this._count - this._pos;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this._sock.shutdownInput();
    }

    private int readImpl() throws IOException {
        if (this.available() == 0) {
            this._count = this._sock.read(this._buf, 0, this._buf.length);
            this._pos = 0;
        }
        return this._count;
    }
}

