/*
 * Decompiled with CFR 0.152.
 */
package net.rudp.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.UUID;
import net.rudp.impl.Segment;

public class UIDSegment
extends Segment {
    protected byte[] _data;

    protected UIDSegment() {
    }

    public UIDSegment(int seqn, UUID uuid) throws IOException {
        this.init(8, seqn, 6);
        this._data = UIDSegment.getUUIDObjectBytes(uuid);
    }

    private static byte[] getUUIDObjectBytes(UUID uuid) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(byteOut);
        objOut.writeObject(uuid);
        objOut.flush();
        return byteOut.toByteArray();
    }

    private static UUID getUUIDObjectFromBytes(byte[] uuidBytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(uuidBytes);
        ObjectInputStream objIn = new ObjectInputStream(byteIn);
        return (UUID)objIn.readObject();
    }

    @Override
    public int length() {
        return this._data.length + super.length();
    }

    @Override
    public String type() {
        return "UID";
    }

    public byte[] getData() {
        return this._data;
    }

    public UUID getUUID() {
        try {
            return UIDSegment.getUUIDObjectFromBytes(this._data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public byte[] getBytes() {
        byte[] buffer = super.getBytes();
        System.arraycopy(this._data, 0, buffer, 6, this._data.length);
        return buffer;
    }

    @Override
    public void parseBytes(byte[] buffer, int off, int len) {
        super.parseBytes(buffer, off, len);
        this._data = new byte[len - 6];
        System.arraycopy(buffer, off + 6, this._data, 0, this._data.length);
    }

    public byte[] get_data() {
        return this._data;
    }

    public void set_data(byte[] _data) {
        this._data = _data;
    }
}

