/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import lac.cnet.sddl.udi.core.SddlLayer;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;
import lac.cnet.sddl.udi.core.qos.BatchQosPolicy;
import lac.cnet.sddl.udi.core.qos.DataReaderQos;
import lac.cnet.sddl.udi.core.qos.DataWriterQos;
import lac.cnet.sddl.udi.core.qos.DestinationOrderQosPolicy;
import lac.cnet.sddl.udi.core.qos.DestinationOrderQosPolicyKind;
import lac.cnet.sddl.udi.core.qos.Duration;
import lac.cnet.sddl.udi.core.qos.HistoryQosPolicy;
import lac.cnet.sddl.udi.core.qos.HistoryQosPolicyKind;
import lac.cnet.sddl.udi.core.qos.LatencyBudgetQosPolicy;
import lac.cnet.sddl.udi.core.qos.QosProfile;
import lac.cnet.sddl.udi.core.qos.ReliabilityQosPolicy;
import lac.cnet.sddl.udi.core.qos.ReliabilityQosPolicyKind;
import lac.cnet.sddl.udi.core.qos.ResourceLimitsQosPolicy;

public class QosProfileBuilder {
    public static void main(String[] args) throws IOException {
        System.out.println("QosProfileBuilder started");
        new QosProfileBuilder();
        System.out.println("QosProfileBuilder finshed");
    }

    public QosProfileBuilder() throws IOException {
        SddlLayer sddl = UniversalDDSLayerFactory.getInstance();
        QosProfile qosProfile = this.instanciateQosProfile();
        sddl.writeQosProfileToJsonFile(qosProfile, "Blank_Qos.txt");
        qosProfile = this.generateHighThroughputQos();
        sddl.writeQosProfileToJsonFile(qosProfile, "High_Throughput_Qos.txt");
        qosProfile = this.generateLowLatencyQos();
        sddl.writeQosProfileToJsonFile(qosProfile, "Low_Latency_Qos.txt");
        qosProfile = this.generateDefaultSddlQos();
        sddl.writeQosProfileToJsonFile(qosProfile, "Default_SDDL_Qos.txt");
        qosProfile = this.generateNonReliableSddlQos();
        sddl.writeQosProfileToJsonFile(qosProfile, "Non_Reliable_SDDL_Qos.txt");
        qosProfile = this.generateNonOrderedSddlQos();
        sddl.writeQosProfileToJsonFile(qosProfile, "Non_Ordered_SDDL_Qos.txt");
        qosProfile = this.generateHighThroughputSddlQos();
        sddl.writeQosProfileToJsonFile(qosProfile, "High_Throughput_SDDL_Qos.txt");
    }

    private QosProfile instanciateQosProfile() {
        QosProfile qosProfile = new QosProfile();
        qosProfile.dataReaderQos = new DataReaderQos();
        qosProfile.dataWriterQos = new DataWriterQos();
        return qosProfile;
    }

    private QosProfile generateHighThroughputQos() {
        QosProfile qosProfile = this.instanciateQosProfile();
        qosProfile.dataReaderQos.reliability = new ReliabilityQosPolicy();
        qosProfile.dataReaderQos.reliability.kind = ReliabilityQosPolicyKind.RELIABLE_RELIABILITY_QOS;
        qosProfile.dataReaderQos.history = new HistoryQosPolicy();
        qosProfile.dataReaderQos.history.kind = HistoryQosPolicyKind.KEEP_ALL_HISTORY_QOS;
        qosProfile.dataWriterQos.reliability = qosProfile.dataReaderQos.reliability;
        qosProfile.dataWriterQos.history = qosProfile.dataReaderQos.history;
        qosProfile.dataWriterQos.resourceLimits = new ResourceLimitsQosPolicy();
        qosProfile.dataWriterQos.resourceLimits.maxSamples = 32;
        qosProfile.dataWriterQos.batch = new BatchQosPolicy();
        qosProfile.dataWriterQos.batch.enable = true;
        qosProfile.dataWriterQos.batch.maxDataBytes = 30720;
        qosProfile.dataWriterQos.resourceLimits.maxInstances = 32;
        qosProfile.dataWriterQos.latencyBudget = new LatencyBudgetQosPolicy(new Duration(0, 100000000));
        return qosProfile;
    }

    private QosProfile generateLowLatencyQos() {
        QosProfile qosProfile = this.instanciateQosProfile();
        qosProfile.dataReaderQos.reliability = new ReliabilityQosPolicy();
        qosProfile.dataReaderQos.reliability.kind = ReliabilityQosPolicyKind.RELIABLE_RELIABILITY_QOS;
        qosProfile.dataReaderQos.history = new HistoryQosPolicy();
        qosProfile.dataReaderQos.history.kind = HistoryQosPolicyKind.KEEP_ALL_HISTORY_QOS;
        qosProfile.dataReaderQos.resourceLimits = new ResourceLimitsQosPolicy();
        qosProfile.dataReaderQos.resourceLimits.maxSamples = 100;
        qosProfile.dataWriterQos.reliability = qosProfile.dataReaderQos.reliability;
        qosProfile.dataWriterQos.history = qosProfile.dataReaderQos.history;
        qosProfile.dataWriterQos.resourceLimits = new ResourceLimitsQosPolicy();
        qosProfile.dataWriterQos.resourceLimits.maxSamples = 32;
        qosProfile.dataWriterQos.batch = new BatchQosPolicy();
        qosProfile.dataWriterQos.batch.enable = false;
        qosProfile.dataWriterQos.latencyBudget = new LatencyBudgetQosPolicy(new Duration(0, 0));
        qosProfile.dataWriterQos.transportPriority = Integer.MAX_VALUE;
        return qosProfile;
    }

    private QosProfile generateDefaultSddlQos() {
        QosProfile qosProfile = this.instanciateQosProfile();
        qosProfile.dataReaderQos.destinationOrder = new DestinationOrderQosPolicy(DestinationOrderQosPolicyKind.BY_SOURCE_TIMESTAMP_DESTINATIONORDER_QOS);
        qosProfile.dataReaderQos.history = new HistoryQosPolicy(HistoryQosPolicyKind.KEEP_ALL_HISTORY_QOS);
        qosProfile.dataReaderQos.reliability = new ReliabilityQosPolicy(ReliabilityQosPolicyKind.RELIABLE_RELIABILITY_QOS);
        qosProfile.dataWriterQos.destinationOrder = qosProfile.dataReaderQos.destinationOrder;
        qosProfile.dataWriterQos.history = qosProfile.dataReaderQos.history;
        qosProfile.dataWriterQos.reliability = qosProfile.dataReaderQos.reliability;
        return qosProfile;
    }

    private QosProfile generateNonReliableSddlQos() {
        QosProfile qosProfile = this.generateDefaultSddlQos();
        qosProfile.dataReaderQos.reliability.kind = ReliabilityQosPolicyKind.BEST_EFFORT_RELIABILITY_QOS;
        return qosProfile;
    }

    private QosProfile generateNonOrderedSddlQos() {
        QosProfile qosProfile = this.generateDefaultSddlQos();
        qosProfile.dataReaderQos.destinationOrder.kind = DestinationOrderQosPolicyKind.BY_RECEPTION_TIMESTAMP_DESTINATIONORDER_QOS;
        return qosProfile;
    }

    private QosProfile generateHighThroughputSddlQos() {
        QosProfile qosProfile = this.generateDefaultSddlQos();
        qosProfile.dataWriterQos.batch = new BatchQosPolicy();
        qosProfile.dataWriterQos.batch.maxFlushDelay = new Duration(0, 300000000);
        qosProfile.dataWriterQos.batch.maxDataBytes = 30720;
        qosProfile.dataWriterQos.latencyBudget = qosProfile.dataReaderQos.latencyBudget = new LatencyBudgetQosPolicy(new Duration(0, 350000000));
        qosProfile.dataWriterQos.destinationOrder.kind = DestinationOrderQosPolicyKind.BY_RECEPTION_TIMESTAMP_DESTINATIONORDER_QOS;
        return qosProfile;
    }
}

