/*
 * Decompiled with CFR 0.152.
 */
package client;

import component.IComponent;
import data.ClassLoaderWrapper;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassLoaderManager {
    protected final Map<String, LinkedList<ClassLoaderWrapper>> classLoaderCollection = new HashMap<String, LinkedList<ClassLoaderWrapper>>();

    public ClassLoaderManager() {
        Logger.getGlobal().setLevel(Level.WARNING);
    }

    public void addClassLoader(String componentName, String componentClass, String version, ClassLoader classLoader, boolean enabled) {
        ClassLoaderWrapper classLoaderWrapper = new ClassLoaderWrapper(componentName, componentClass, version, classLoader, enabled);
        LinkedList<ClassLoaderWrapper> versionList = this.classLoaderCollection.get(componentName);
        if (versionList == null) {
            versionList = new LinkedList();
            versionList.add(classLoaderWrapper);
            this.classLoaderCollection.put(componentName, versionList);
        } else {
            versionList.add(classLoaderWrapper);
        }
    }

    private ClassLoaderWrapper getClassLoader(String componentName, String componentClass, boolean remove) {
        ClassLoaderWrapper classLoarder = new ClassLoaderWrapper(componentName, componentClass, null, null);
        LinkedList<ClassLoaderWrapper> versionList = this.classLoaderCollection.get(componentName);
        if (versionList != null) {
            int i = 0;
            while (i < versionList.size()) {
                ClassLoaderWrapper currentClassLoarder = versionList.get(i);
                if (currentClassLoarder.equals(classLoarder)) {
                    if (remove) {
                        versionList.remove(i);
                    }
                    return currentClassLoarder;
                }
                ++i;
            }
        }
        return null;
    }

    public ClassLoader removeClassLoader(String componentName, String componentClass) throws IOException {
        ClassLoaderWrapper classLoaderWrapper = this.getClassLoader(componentName, componentClass, true);
        if (classLoaderWrapper != null) {
            if (classLoaderWrapper.classLoader instanceof URLClassLoader) {
                ((URLClassLoader)classLoaderWrapper.classLoader).close();
            }
            return classLoaderWrapper.classLoader;
        }
        return null;
    }

    public ClassLoader getClassLoader(String componentName, String componentClass) {
        return this.getClassLoader((String)componentName, (String)componentClass, (boolean)false).classLoader;
    }

    private ClassLoaderWrapper getLastClassLoader(String componentName, boolean remove) {
        LinkedList<ClassLoaderWrapper> versionList = this.classLoaderCollection.get(componentName);
        if (versionList != null) {
            if (remove) {
                return versionList.removeLast();
            }
            return versionList.getLast();
        }
        return null;
    }

    public ClassLoaderWrapper getLastClassLoader(String componentName) {
        return this.getLastClassLoader(componentName, false);
    }

    public ClassLoaderWrapper removeLastClassLoader(String componentName) throws IOException {
        ClassLoaderWrapper classLoaderWrapper = this.getLastClassLoader(componentName, true);
        if (classLoaderWrapper != null && classLoaderWrapper.classLoader instanceof URLClassLoader) {
            ((URLClassLoader)classLoaderWrapper.classLoader).close();
        }
        return classLoaderWrapper;
    }

    public void removeFirstClassLoader(String componentName) throws IOException {
        ClassLoaderWrapper classLoaderWrapper;
        LinkedList<ClassLoaderWrapper> versionList = this.classLoaderCollection.get(componentName);
        if (versionList != null && (classLoaderWrapper = versionList.removeFirst()) != null && classLoaderWrapper.classLoader instanceof URLClassLoader) {
            ((URLClassLoader)classLoaderWrapper.classLoader).close();
        }
    }

    private ClassLoaderWrapper getLastEnabledClassLoader(String componentName) {
        LinkedList<ClassLoaderWrapper> versionList = this.classLoaderCollection.get(componentName);
        if (versionList != null) {
            Iterator<ClassLoaderWrapper> iterator = versionList.descendingIterator();
            while (iterator.hasNext()) {
                ClassLoaderWrapper classLoaderWrapper = iterator.next();
                if (!classLoaderWrapper.enabled) continue;
                return classLoaderWrapper;
            }
        }
        return null;
    }

    public Class<? extends IComponent<?, ?>> getClass(String componentName) throws ClassNotFoundException {
        ClassLoaderWrapper classLoaderWrapper = this.getLastEnabledClassLoader(componentName);
        try {
            return classLoaderWrapper.classLoader.loadClass(classLoaderWrapper.componentClass);
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.FINE, "ComponentNotFoundException: " + e.toString() + " " + componentName + " " + e.getStackTrace()[0].toString());
            throw new ClassNotFoundException("ComponentNotFoundException: " + componentName, e);
        }
    }

    public Class<? extends IComponent<?, ?>> getClass(String componentName, String componentClassName) throws ClassNotFoundException {
        ClassLoaderWrapper classLoaderWrapper = this.getClassLoader(componentName, componentClassName, false);
        try {
            return classLoaderWrapper.classLoader.loadClass(componentClassName);
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.FINE, "ComponentNotFoundException: " + e.toString() + " " + componentName + " " + e.getStackTrace()[0].toString());
            throw new ClassNotFoundException("ComponentNotFoundException: " + componentName, e);
        }
    }

    public void enableComponent(String componentName, String componentClass, boolean enable) throws ClassNotFoundException {
        try {
            if (componentClass == null) {
                this.enableComponent(componentName, enable);
            } else {
                this.getClassLoader((String)componentName, (String)componentClass, (boolean)false).enabled = enable;
            }
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "ComponentNotFoundException: " + e.toString() + " " + componentName + " " + e.getStackTrace()[0].toString());
            throw new ClassNotFoundException("ComponentNotFoundException: " + componentName, e);
        }
    }

    public void enableComponent(String componentName, boolean enable) throws ClassNotFoundException {
        try {
            LinkedList<ClassLoaderWrapper> versionList = this.classLoaderCollection.get(componentName);
            versionList.getLast().enabled = enable;
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "ComponentNotFoundException: " + e.toString() + " " + componentName + " " + e.getStackTrace()[0].toString());
            throw new ClassNotFoundException("ComponentNotFoundException: " + componentName, e);
        }
    }
}

