/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ClassLoaderManager;
import client.ComponentManager;
import client.IConnection;
import component.AbstractComponentWrapper;
import component.IComponent;
import data.ActionList;
import data.AdaptationAction;
import data.AdaptationResponse;
import data.CommandMessage;
import data.MessageCode;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;
import lac.cnclib.sddl.message.ApplicationMessage;
import lac.cnclib.sddl.message.Message;
import lac.cnclib.sddl.serialization.Serialization;
import utils.Utils;

public class ClientAdaptionService {
    protected static final Logger LOGGER = Logger.getLogger(ClientAdaptionService.class.getName());
    protected final IConnection connection;
    protected final ClassLoaderManager classLoaderManager;
    protected final ComponentManager componentManager;
    protected final UUID id;

    public ClientAdaptionService(IConnection connection, Map<String, Class<? extends AbstractComponentWrapper<? extends IComponent<?, ?>, ?, ?>>> wrapperMapper, UUID id) {
        LOGGER.setLevel(Level.FINEST);
        this.connection = connection;
        this.classLoaderManager = new ClassLoaderManager();
        this.componentManager = new ComponentManager(this.classLoaderManager, wrapperMapper);
        this.id = id;
    }

    public boolean receiveMessage(Message applicationMessage) {
        ActionList actionPlan = (ActionList)applicationMessage.getContentObject();
        for (AdaptationAction adaptationAction : actionPlan.adaptationActionList) {
            try {
                if (!(adaptationAction instanceof CommandMessage)) continue;
                CommandMessage commandMessage = (CommandMessage)adaptationAction;
                switch (commandMessage.commandCode) {
                    case InsertComponent: {
                        this.loadNewJar(commandMessage);
                        break;
                    }
                    case UpdateComponentInstances: {
                        this.updateComponent(commandMessage, actionPlan.transactionalAdaptation);
                        break;
                    }
                    case EnableComponent: {
                        this.classLoaderManager.enableComponent(commandMessage.componentName, commandMessage.componentClass, true);
                        break;
                    }
                    case CommitUpdateComponentInstances: {
                        this.commitUpdateComponent(commandMessage);
                        break;
                    }
                    case RemoveComponent: {
                        this.removeComponent(commandMessage);
                        break;
                    }
                    case DisableComponent: {
                        this.classLoaderManager.enableComponent(commandMessage.componentName, commandMessage.componentClass, false);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                this.sendResponse(actionPlan.adaptationId, e.toString(), MessageCode.AdaptionFailure);
                return false;
            }
        }
        this.sendResponse(actionPlan.adaptationId, "", MessageCode.AdaptationOk);
        return true;
    }

    protected void removeComponent(CommandMessage commandMessage) throws IOException {
        if (commandMessage.componentClass != null) {
            this.classLoaderManager.removeClassLoader(commandMessage.componentName, commandMessage.componentClass);
        } else {
            this.classLoaderManager.removeFirstClassLoader(commandMessage.componentName);
        }
    }

    protected void updateComponent(CommandMessage commandMessage, boolean transactionalUpdate) throws Exception {
        this.componentManager.updateComponentInstances(commandMessage.componentName, transactionalUpdate);
    }

    protected void commitUpdateComponent(CommandMessage commandMessage) {
        this.componentManager.commitUpdateComponentInstances(commandMessage.componentName);
    }

    protected void writeJarToFile(String fileName, byte[] jarBytes) throws IOException {
        byte[] array = jarBytes;
        FileOutputStream fileOutputStream = new FileOutputStream(fileName);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        bufferedOutputStream.write(array);
        bufferedOutputStream.close();
        fileOutputStream.close();
    }

    public void loadNewJar(String jarName, boolean enabledJar) throws Throwable {
        File file = new File(jarName);
        URL url = file.toURI().toURL();
        Attributes attribute = Utils.getManifest(file);
        String componentVersion = attribute.getValue("Component-Version");
        String componentName = attribute.getValue("Component-Name");
        String componentClass = attribute.getValue("Component-Class");
        if (componentClass == null || componentName == null || componentVersion == null) {
            throw new Exception("Manifest malformed!");
        }
        URLClassLoader classLoader = new URLClassLoader(new URL[]{url});
        this.classLoaderManager.addClassLoader(componentName, componentClass, componentVersion, classLoader, enabledJar);
    }

    protected void loadNewJar(CommandMessage loadJarMessage) throws Throwable {
        long time = System.nanoTime();
        this.writeJarToFile(String.valueOf(time) + loadJarMessage.jarPathname, loadJarMessage.jarBytes);
        this.loadNewJar(String.valueOf(time) + loadJarMessage.jarPathname, false);
    }

    protected void sendResponse(int adaptationId, String message, MessageCode messageCode) {
        ApplicationMessage applicationMessage = new ApplicationMessage();
        AdaptationResponse adaptationMessage = null;
        try {
            adaptationMessage = new AdaptationResponse(adaptationId, Serialization.toJavaByteStream((Serializable)((Object)message)), messageCode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        applicationMessage.setContentObject(adaptationMessage);
        applicationMessage.setSenderID(this.id);
        this.connection.sendMessage(applicationMessage);
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public ClassLoaderManager getClassLoaderManager() {
        return this.classLoaderManager;
    }
}

