/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ClientManager;
import client.IConnection;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import lac.cnclib.net.NodeConnection;
import lac.cnclib.net.NodeConnectionListener;
import lac.cnclib.sddl.message.ApplicationMessage;
import lac.cnclib.sddl.message.Message;

public class ClientLibConnection
implements IConnection,
NodeConnectionListener {
    protected final ClientManager clientManager;
    protected NodeConnection connection;

    public ClientLibConnection(NodeConnection nodeConnection, ClientManager clientManager) {
        this.connection = nodeConnection;
        this.clientManager = clientManager;
        this.connection.addNodeConnectionListener(this);
    }

    public boolean initialize(Object state) {
        return false;
    }

    public boolean loadState(Object state) {
        return false;
    }

    public Object getState() {
        return null;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public boolean sendMessage(ApplicationMessage message) {
        message.setTagList(new LinkedList<String>());
        message.addTag("@");
        try {
            this.connection.sendMessage(message);
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
        return false;
    }

    @Override
    public void connected(NodeConnection remoteCon) {
    }

    @Override
    public void reconnected(NodeConnection remoteCon, SocketAddress endPoint, boolean wasHandover, boolean wasMandatory) {
        if (wasHandover && wasMandatory) {
            this.sendMockMessage();
        }
    }

    @Override
    public void disconnected(NodeConnection remoteCon) {
    }

    @Override
    public void newMessageReceived(NodeConnection remoteCon, Message message) {
        if (message.getTagList().contains("@")) {
            this.clientManager.newMessageReceived(message);
        }
    }

    @Override
    public void unsentMessages(NodeConnection remoteCon, List<Message> unsentMessages) {
    }

    @Override
    public void internalException(NodeConnection remoteCon, Exception e) {
    }

    protected void sendMockMessage() {
        ApplicationMessage applicationMessage = new ApplicationMessage();
        applicationMessage.setSenderID(new UUID(1L, 2L));
        try {
            this.connection.sendMessage(applicationMessage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

