/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ClientAdaptionService;
import client.ClientLibConnection;
import client.IConnection;
import component.AbstractComponentWrapper;
import component.IComponent;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import lac.cnclib.net.NodeConnection;
import lac.cnclib.sddl.message.ApplicationMessage;
import lac.cnclib.sddl.message.Message;
import lac.cnclib.sddl.serialization.Serialization;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.objects.PrivateMessage;

public class ClientManager {
    protected final IConnection connection;
    protected ClientAdaptionService adaptationManager;

    public ClientManager(Map<String, Class<? extends AbstractComponentWrapper<? extends IComponent<?, ?>, ?, ?>>> wrapperMapper, NodeConnection connection, UUID id) {
        this.connection = new ClientLibConnection(connection, this);
        this.adaptationManager = new ClientAdaptionService(this.connection, wrapperMapper, id);
    }

    protected ClientManager(NodeConnection connection) {
        this.connection = new ClientLibConnection(connection, this);
    }

    void newMessageReceived(ApplicationObject object) {
        PrivateMessage message = (PrivateMessage)object;
        ApplicationMessage applicationMessage = (ApplicationMessage)Serialization.fromProtocolMessage(message.getMessage());
        this.newMessageReceived(applicationMessage);
    }

    void newMessageReceived(Message applicationMessage) {
        this.adaptationManager.receiveMessage(applicationMessage);
    }

    public ClientAdaptionService getAdaptationManager() {
        return this.adaptationManager;
    }

    public void loadNewJar(String jarName, boolean enabledJar) throws Throwable {
        this.adaptationManager.loadNewJar(jarName, enabledJar);
    }

    public <ComponentType extends IComponent<State, ConstructionParameters>, State, ConstructionParameters> ComponentType createComponentInstance(String componentName) throws Exception {
        return this.adaptationManager.getComponentManager().createComponentInstance(componentName);
    }

    public <ComponentType extends IComponent<State, ConstructionParameters>, State, ConstructionParameters> ComponentType createComponentInstance(String componentName, String componentClass) throws Exception {
        return this.adaptationManager.getComponentManager().createComponentInstance(componentName, componentClass);
    }

    public void updateComponentInstances(String componentName, boolean transactionalUpdate) throws Exception {
        this.adaptationManager.getComponentManager().updateComponentInstances(componentName, transactionalUpdate);
    }

    public void enableComponent(String componentName, String componentClass, boolean enable) throws ClassNotFoundException {
        this.adaptationManager.getClassLoaderManager().enableComponent(componentName, componentClass, enable);
    }

    public void enableComponent(String componentName, boolean enable) throws ClassNotFoundException {
        this.adaptationManager.getClassLoaderManager().enableComponent(componentName, enable);
    }

    public void removeComponent(String componentName, String componentClass) throws IOException {
        this.adaptationManager.getClassLoaderManager().removeClassLoader(componentName, componentClass);
    }

    public void removeComponent(String componentName) throws IOException {
        this.adaptationManager.getClassLoaderManager().removeFirstClassLoader(componentName);
    }
}

