/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.cdr;

import com.rti.dds.cdr.CdrBuffer;
import com.rti.dds.cdr.CdrEncapsulation;
import com.rti.dds.cdr.CdrMemberInfo;
import com.rti.dds.cdr.CdrObjectInput;
import com.rti.dds.cdr.CdrPrimitiveType;
import com.rti.dds.infrastructure.BooleanSeq;
import com.rti.dds.infrastructure.ByteSeq;
import com.rti.dds.infrastructure.CharSeq;
import com.rti.dds.infrastructure.DoubleSeq;
import com.rti.dds.infrastructure.FloatSeq;
import com.rti.dds.infrastructure.IntSeq;
import com.rti.dds.infrastructure.LongDoubleSeq;
import com.rti.dds.infrastructure.LongSeq;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.ShortSeq;
import com.rti.dds.infrastructure.StringSeq;
import com.rti.dds.infrastructure.WcharSeq;
import com.rti.dds.infrastructure.WstringSeq;
import com.rti.dds.topic.TypeSupportImpl;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.security.MessageDigest;

public final class CdrInputStream
extends InputStream
implements CdrObjectInput {
    private final CdrBuffer _buffer;
    private boolean _dirty = false;
    private CharsetDecoder _decoder = null;
    private boolean _swapByteOrder = false;
    private short _encapsulationKind = 0;
    private short _encapsulationOptions = 0;
    private int _minBufferSize;
    private boolean _dynamicStream;
    private boolean _trimToSize;
    private CdrMemberInfo _memberInfo_tmp;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CdrInputStream(int n) {
        this._buffer = new CdrBuffer(n);
        this._minBufferSize = n;
        this._trimToSize = false;
        this._dynamicStream = false;
        this._memberInfo_tmp = new CdrMemberInfo();
    }

    public CdrInputStream(TypeSupportImpl typeSupportImpl) {
        this(typeSupportImpl.get_serialized_sample_max_sizeI(null, true, CdrEncapsulation.CDR_ENCAPSULATION_ID_CDR_NATIVE, 0));
    }

    public CdrInputStream(byte[] byArray, boolean bl) {
        this(byArray, byArray.length, bl);
    }

    public CdrInputStream(byte[] byArray, int n, boolean bl) {
        this._buffer = new CdrBuffer(byArray, n);
        this._swapByteOrder = bl;
        this._encapsulationKind = this._swapByteOrder ? (short)1 : 0;
        this._encapsulationOptions = 0;
        this._minBufferSize = n;
        this._trimToSize = false;
        this._dynamicStream = false;
        this._memberInfo_tmp = new CdrMemberInfo();
    }

    public CdrInputStream(int n, boolean bl, boolean bl2) {
        this(n);
        this._minBufferSize = n;
        this._trimToSize = bl2;
        this._dynamicStream = bl;
        this._memberInfo_tmp = new CdrMemberInfo();
    }

    public CdrBuffer getBuffer() {
        return this._buffer;
    }

    public void setBuffer(byte[] byArray, int n) {
        this._buffer.setBuffer(byArray, n);
    }

    public void openFromNative(long l, int n, boolean bl, boolean bl2) {
        if (l == 0L) {
            throw new IllegalArgumentException("NULL native pointer");
        }
        if (this._dynamicStream) {
            if (this._trimToSize) {
                int n2;
                int n3 = n2 = n < this._minBufferSize ? this._minBufferSize : n;
                if (this._buffer.getSize() != n2) {
                    this._buffer.resize(n2);
                }
            } else if (n > this._buffer.getSize()) {
                this._buffer.resize(n);
            }
        }
        this._buffer.flushToJava(l, n);
        this._swapByteOrder = bl;
        this._encapsulationKind = this._swapByteOrder ? (short)1 : 0;
        this._encapsulationOptions = 0;
        this._dirty = bl2;
    }

    public int closeFromNative() {
        int n = this._buffer.currentPosition();
        this._buffer.resetToZero();
        return n;
    }

    public void skipEncapsulation() {
        this.skipInt();
    }

    public String readString() {
        int n = this.readInt();
        if (n == 0) {
            return null;
        }
        this._buffer.checkSize(n);
        if (n == 1) {
            this.skipByte();
            return "";
        }
        CharsetDecoder charsetDecoder = this.getDecoder();
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this._buffer.getBuffer(), this._buffer.currentPosition(), n - 1);
            long l = this._buffer.skip(n);
            if (!$assertionsDisabled && l != (long)n) {
                throw new AssertionError();
            }
            CharBuffer charBuffer = charsetDecoder.decode(byteBuffer);
            return charBuffer.toString();
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public String readString(int n) {
        int n2 = this.readInt();
        if (n2 == 0) {
            return null;
        }
        this._buffer.checkSize(n2);
        if (n != 0 && n2 > n + 1) {
            throw new IllegalArgumentException("string length (" + (n2 - 1) + ") " + "exceeds maximum (" + n + ")");
        }
        if (n2 == 1) {
            this.skipByte();
            return "";
        }
        CharsetDecoder charsetDecoder = this.getDecoder();
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this._buffer.getBuffer(), this._buffer.currentPosition(), n2 - 1);
            long l = this._buffer.skip(n2);
            if (!$assertionsDisabled && l != (long)n2) {
                throw new AssertionError();
            }
            CharBuffer charBuffer = charsetDecoder.decode(byteBuffer);
            return charBuffer.toString();
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public void skipString() {
        int n = this.readInt();
        this.skipBytes(n);
    }

    public void readStringArray(String[] stringArray, int n) {
        try {
            StringSeq.readStringArray(stringArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            throw illegalStateException;
        }
    }

    public void skipStringArray(int n) {
        for (int i = 0; i < n; ++i) {
            this.skipString();
        }
    }

    public void readStringSequence(StringSeq stringSeq, int n) {
        this.readSequence(stringSeq, n);
    }

    public void skipStringSequence() {
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            this.skipString();
        }
    }

    public String readWstring() {
        int n = this.readInt();
        if (n == 1) {
            this.skipInt();
            return "";
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)this.readInt();
        }
        return new String(cArray, 0, n - 1);
    }

    public String readWstring(int n) {
        int n2 = this.readInt();
        if (n != 0 && n2 > n + 1) {
            throw new IllegalArgumentException("wstring length (" + (n2 - 1) + ") " + "exceeds maximum (" + n + ")");
        }
        if (n2 == 1) {
            this.skipInt();
            return "";
        }
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = (char)this.readInt();
        }
        return new String(cArray, 0, n2 - 1);
    }

    public void skipWstring() {
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            this.skipInt();
        }
    }

    public void readWstringArray(String[] stringArray, int n) {
        try {
            WstringSeq.readWstringArray(stringArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            throw illegalStateException;
        }
    }

    public void skipWstringArray(int n) {
        for (int i = 0; i < n; ++i) {
            this.skipWstring();
        }
    }

    public void readWstringSequence(StringSeq stringSeq, int n) {
        this.readSequence(stringSeq, n);
    }

    public void skipWstringSequence() {
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            this.skipWstring();
        }
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        throw new UnsupportedOperationException();
    }

    public int read() throws IOException {
        return this.readUnsignedByte();
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) {
        return this._buffer.get(byArray, n, n2);
    }

    public void close() {
        this._buffer.resetToZero();
    }

    public int available() {
        return this._buffer.available();
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        this._buffer.mark();
    }

    public void reset() {
        this._buffer.resetToZero();
    }

    public void resetAndSetDirtyBit(boolean bl) {
        this.reset();
        this._dirty = bl;
    }

    public int skipBytes(int n) {
        return (int)this._buffer.skip(n);
    }

    public long skipBytes(long l) {
        return this._buffer.skip(l);
    }

    public long skip(long l) throws IOException {
        if (l <= Integer.MAX_VALUE) {
            return this.skipBytes((int)l);
        }
        return super.skip(l);
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public void skipBoolean() {
        this.skipBytes(CdrPrimitiveType.BOOLEAN.size);
    }

    public byte readByte() {
        this._buffer.checkSize(CdrPrimitiveType.BYTE.size);
        return this._buffer.get();
    }

    public void skipByte() {
        this.skipBytes(CdrPrimitiveType.BYTE.size);
    }

    public char readChar() {
        return (char)this.readByte();
    }

    public void skipChar() {
        this.skipBytes(CdrPrimitiveType.BYTE.size);
    }

    public int readUnsignedByte() {
        int n = this.readByte();
        if (n < 0) {
            n += 128;
        }
        return n;
    }

    public void skipUnsignedByte() {
        this.skipBytes(CdrPrimitiveType.BYTE.size);
    }

    public void readFully(byte[] byArray) {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) {
        this.read(byArray, n, n2);
    }

    public short readShort() {
        this._buffer.align(CdrPrimitiveType.SHORT.alignment);
        this._buffer.checkSize(CdrPrimitiveType.SHORT.size);
        int n = this._buffer.get() & 0xFF;
        int n2 = this._buffer.get() & 0xFF;
        int n3 = this._swapByteOrder ? n | n2 << 8 : n << 8 | n2;
        return (short)n3;
    }

    public void skipShort() {
        this._buffer.align(CdrPrimitiveType.SHORT.alignment);
        this.skipBytes(CdrPrimitiveType.SHORT.size);
    }

    public short readShortFromBigEndian() {
        this._buffer.checkSize(CdrPrimitiveType.SHORT.size);
        int n = this._buffer.get() & 0xFF;
        int n2 = this._buffer.get() & 0xFF;
        int n3 = n << 8 | n2;
        return (short)n3;
    }

    public int readUnsignedShort() {
        int n = this.readShort();
        if (n < 0) {
            n += 32768;
        }
        return n;
    }

    public void skipUnsignedShort() {
        this.skipShort();
    }

    public char readWchar() {
        return (char)this.readInt();
    }

    public void skipWchar() {
        this.skipInt();
    }

    public int readInt() {
        this._buffer.align(CdrPrimitiveType.INT.alignment);
        this._buffer.checkSize(CdrPrimitiveType.INT.size);
        int n = this._buffer.get() & 0xFF;
        int n2 = this._buffer.get() & 0xFF;
        int n3 = this._buffer.get() & 0xFF;
        int n4 = this._buffer.get() & 0xFF;
        int n5 = this._swapByteOrder ? n | n2 << 8 | n3 << 16 | n4 << 24 : n << 24 | n2 << 16 | n3 << 8 | n4;
        return n5;
    }

    public void skipInt() {
        this._buffer.align(CdrPrimitiveType.INT.alignment);
        this.skipBytes(CdrPrimitiveType.INT.size);
    }

    public long readUnsignedInt() {
        long l = this.readInt();
        if (l < 0L) {
            l -= Integer.MIN_VALUE;
        }
        return l;
    }

    public void skipUnsignedInt() {
        this.skipInt();
    }

    public long readLong() {
        this._buffer.align(CdrPrimitiveType.LONG.alignment);
        this._buffer.checkSize(CdrPrimitiveType.LONG.size);
        long l = (long)this._buffer.get() & 0xFFL;
        long l2 = (long)this._buffer.get() & 0xFFL;
        long l3 = (long)this._buffer.get() & 0xFFL;
        long l4 = (long)this._buffer.get() & 0xFFL;
        long l5 = (long)this._buffer.get() & 0xFFL;
        long l6 = (long)this._buffer.get() & 0xFFL;
        long l7 = (long)this._buffer.get() & 0xFFL;
        long l8 = (long)this._buffer.get() & 0xFFL;
        long l9 = this._swapByteOrder ? l | l2 << 8 | l3 << 16 | l4 << 24 | l5 << 32 | l6 << 40 | l7 << 48 | l8 << 56 : l << 56 | l2 << 48 | l3 << 40 | l4 << 32 | l5 << 24 | l6 << 16 | l7 << 8 | l8;
        return l9;
    }

    public void skipLong() {
        this._buffer.align(CdrPrimitiveType.LONG.alignment);
        this.skipBytes(CdrPrimitiveType.LONG.size);
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public void skipFloat() {
        this._buffer.align(CdrPrimitiveType.FLOAT.alignment);
        this.skipBytes(CdrPrimitiveType.FLOAT.size);
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public int skipDouble() {
        this._buffer.align(CdrPrimitiveType.DOUBLE.alignment);
        return this.skipBytes(CdrPrimitiveType.DOUBLE.size);
    }

    public double readLongDouble() {
        long l;
        long l2;
        if (this._swapByteOrder) {
            l2 = this.readLong();
            l = this.readLong();
        } else {
            l = this.readLong();
            l2 = this.readLong();
        }
        long l3 = l << 16 >>> 12;
        long l4 = l >>> 63;
        long l5 = l << 1 >>> 49;
        long l6 = l4 << 63 | (l5 -= 15360L) << 53 >>> 1 | (l3 |= l2 >>> 60);
        return Double.longBitsToDouble(l6);
    }

    public void skipLongDouble() {
        this._buffer.align(CdrPrimitiveType.LONG_DOUBLE.alignment);
        this.skipBytes(CdrPrimitiveType.LONG_DOUBLE.size);
    }

    public String readLine() {
        throw new UnsupportedOperationException();
    }

    public String readUTF() {
        throw new UnsupportedOperationException();
    }

    public void readBooleanArray(boolean[] blArray, int n) {
        try {
            BooleanSeq.readBooleanArray(blArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            throw illegalStateException;
        }
    }

    public void skipBooleanArray(int n) {
        for (int i = 0; i < n; ++i) {
            this.skipBoolean();
        }
    }

    public void readByteArray(byte[] byArray, int n) {
        try {
            ByteSeq.readByteArray(byArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            throw illegalStateException;
        }
    }

    public void skipByteArray(int n) {
        this.skipBytes(n);
    }

    public void readCharArray(char[] cArray, int n) {
        try {
            CharSeq.readCharArray(cArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            throw illegalStateException;
        }
    }

    public void skipCharArray(int n) {
        this.skipBytes(n);
    }

    public void readShortArray(short[] sArray, int n) {
        try {
            ShortSeq.readShortArray(sArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            throw illegalStateException;
        }
    }

    public void skipShortArray(int n) {
        for (int i = 0; i < n; ++i) {
            this.skipShort();
        }
    }

    public void readWcharArray(char[] cArray, int n) {
        try {
            WcharSeq.readWcharArray(cArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            throw illegalStateException;
        }
    }

    public void skipWcharArray(int n) {
        for (int i = 0; i < n; ++i) {
            this.skipWchar();
        }
    }

    public void readIntArray(int[] nArray, int n) {
        try {
            IntSeq.readIntArray(nArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            throw illegalStateException;
        }
    }

    public void skipIntArray(int n) {
        for (int i = 0; i < n; ++i) {
            this.skipInt();
        }
    }

    public void readLongArray(long[] lArray, int n) {
        try {
            LongSeq.readLongArray(lArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            throw illegalStateException;
        }
    }

    public void skipLongArray(int n) {
        for (int i = 0; i < n; ++i) {
            this.skipLong();
        }
    }

    public void readFloatArray(float[] fArray, int n) {
        try {
            FloatSeq.readFloatArray(fArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            throw illegalStateException;
        }
    }

    public void skipFloatArray(int n) {
        for (int i = 0; i < n; ++i) {
            this.skipFloat();
        }
    }

    public void readDoubleArray(double[] dArray, int n) {
        try {
            DoubleSeq.readDoubleArray(dArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            throw illegalStateException;
        }
    }

    public void skipDoubleArray(int n) {
        for (int i = 0; i < n; ++i) {
            this.skipDouble();
        }
    }

    public void readLongDoubleArray(double[] dArray, int n) {
        try {
            LongDoubleSeq.readLongDoubleArray(dArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            throw illegalStateException;
        }
    }

    public void skipLongDoubleArray(int n) {
        for (int i = 0; i < n; ++i) {
            this.skipLongDouble();
        }
    }

    public void readBooleanSequence(BooleanSeq booleanSeq, int n) {
        this.readSequence(booleanSeq, n);
    }

    public void skipBooleanSequence() {
        int n = this.readInt();
        this.skipBooleanArray(n);
    }

    public void readByteSequence(ByteSeq byteSeq, int n) {
        this.readSequence(byteSeq, n);
    }

    public void skipByteSequence() {
        int n = this.readInt();
        this.skipByteArray(n);
    }

    public void readCharSequence(CharSeq charSeq, int n) {
        this.readSequence(charSeq, n);
    }

    public void skipCharSequence() {
        int n = this.readInt();
        this.skipCharArray(n);
    }

    public void readShortSequence(ShortSeq shortSeq, int n) {
        this.readSequence(shortSeq, n);
    }

    public void skipShortSequence() {
        int n = this.readInt();
        this.skipShortArray(n);
    }

    public void readWcharSequence(CharSeq charSeq, int n) {
        this.readSequence(charSeq, n);
    }

    public void skipWcharSequence() {
        int n = this.readInt();
        this.skipWcharArray(n);
    }

    public void readIntSequence(IntSeq intSeq, int n) {
        this.readSequence(intSeq, n);
    }

    public void skipIntSequence() {
        int n = this.readInt();
        this.skipIntArray(n);
    }

    public void readLongSequence(LongSeq longSeq, int n) {
        this.readSequence(longSeq, n);
    }

    public void skipLongSequence() {
        int n = this.readInt();
        this.skipLongArray(n);
    }

    public void readFloatSequence(FloatSeq floatSeq, int n) {
        this.readSequence(floatSeq, n);
    }

    public void skipFloatSequence() {
        int n = this.readInt();
        this.skipFloatArray(n);
    }

    public void readDoubleSequence(DoubleSeq doubleSeq, int n) {
        this.readSequence(doubleSeq, n);
    }

    public void skipDoubleSequence() {
        int n = this.readInt();
        this.skipDoubleArray(n);
    }

    public void readLongDoubleSequence(DoubleSeq doubleSeq, int n) {
        this.readSequence(doubleSeq, n);
    }

    public void skipLongDoubleSequence() {
        int n = this.readInt();
        this.skipLongDoubleArray(n);
    }

    public void deserializeCdrEncapsulationAndSetDefault() {
        boolean bl;
        this._encapsulationKind = this.readShortFromBigEndian();
        this._encapsulationOptions = this.readShortFromBigEndian();
        boolean bl2 = bl = this._encapsulationKind == 0 || this._encapsulationKind == 1 || this._encapsulationKind == 2 || this._encapsulationKind == 3;
        if (!bl) {
            throw new RETCODE_ERROR("Unsupported encapsulation " + this._encapsulationKind);
        }
        this._swapByteOrder = this._encapsulationKind == 1 || this._encapsulationKind == 3;
    }

    public void deserializeAndSetCdrEncapsulation() {
        boolean bl;
        this._encapsulationKind = this.readShortFromBigEndian();
        this._encapsulationOptions = this.readShortFromBigEndian();
        boolean bl2 = bl = this._encapsulationKind == 0 || this._encapsulationKind == 1 || this._encapsulationKind == 2 || this._encapsulationKind == 3;
        if (!bl) {
            throw new RETCODE_ERROR("Unsupported encapsulation " + this._encapsulationKind);
        }
        this._swapByteOrder = this._encapsulationKind == 1 || this._encapsulationKind == 3;
    }

    public CdrEncapsulation deserializeCdrEncapsulation() {
        short s = this.readShortFromBigEndian();
        short s2 = this.readShortFromBigEndian();
        return new CdrEncapsulation(s, s2);
    }

    public short getEncapsulationKind() {
        return this._encapsulationKind;
    }

    public short getEncapsulationOptions() {
        return this._encapsulationOptions;
    }

    public void setEncapsulationKind(short s) {
        boolean bl = s == 0 || s == 1 || s == 2 || s == 3;
        this._encapsulationKind = s;
        if (bl) {
            this._swapByteOrder = this._encapsulationKind == 1 || this._encapsulationKind == 3;
        }
    }

    public void setEncapsulationOptions(short s) {
        this._encapsulationOptions = s;
    }

    public int readBits(int n) {
        if (this._buffer._bitBufferLength == 0 || n + this._buffer._bitBufferLength > 32) {
            this._buffer._bitBufferLength = 0;
            this._buffer._bitBuffer = this.readInt();
        }
        return this._buffer.getBits(n);
    }

    public void skipBits(int n) {
        if (this._buffer._bitBufferLength == 0 || n + this._buffer._bitBufferLength > 32) {
            this._buffer._bitBufferLength = 0;
        }
        this._buffer.skipBits(n);
    }

    public void resetBitsBuffer() {
        this._buffer.resetBitsBuffer();
    }

    public int resetAlignment() {
        return this._buffer.resetAlignment();
    }

    public int resetAlignmentWithOffset(int n) {
        return this._buffer.resetAlignmentWithOffset(n);
    }

    public void restoreAlignment(int n) {
        this._buffer.restoreAlignment(n);
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirtyBit(boolean bl) {
        this._dirty = bl;
    }

    public void computeMD5(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(this._buffer.getBuffer(), 0, this._buffer.currentPosition());
            byte[] byArray2 = messageDigest.digest();
            System.arraycopy(byArray2, 0, byArray, 0, 16);
        }
        catch (Exception exception) {
            IllegalStateException illegalStateException = new IllegalStateException(exception.getMessage());
            throw illegalStateException;
        }
    }

    public CdrMemberInfo readMemberInfo() {
        this.getBuffer().align(4);
        this._memberInfo_tmp.storeMemberId(this.readShort());
        int n = this.readUnsignedShort();
        this._memberInfo_tmp.length = n;
        if (this._memberInfo_tmp.getMemberId() == 16129) {
            this._memberInfo_tmp.storeMemberId(this.readInt());
            this._memberInfo_tmp.length = this.readUnsignedInt();
            if ((n -= 2 * CdrPrimitiveType.INT.size) > 0) {
                this.skipByteArray(n);
            }
        }
        this.resetAlignment();
        return this._memberInfo_tmp;
    }

    private CharsetDecoder getDecoder() {
        if (this._decoder == null) {
            this._decoder = Charset.forName("ISO-8859-1").newDecoder();
            if (!$assertionsDisabled && this._decoder == null) {
                throw new AssertionError();
            }
        }
        return this._decoder;
    }

    private void readSequence(Externalizable externalizable, int n) {
        try {
            if (n >= 0) {
                int n2 = this._buffer.currentPosition();
                int n3 = this.readInt();
                this._buffer.setCurrentPosition(n2);
                if (n3 > n) {
                    throw new IllegalArgumentException("received sequence size (" + n3 + ") " + "exceeds maximum (" + n + ")");
                }
            }
            externalizable.readExternal(this);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected exception: " + exception.getMessage());
            throw illegalStateException;
        }
    }

    static {
        $assertionsDisabled = !CdrInputStream.class.desiredAssertionStatus();
    }
}

