/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.cdr;

import com.rti.dds.cdr.CdrBuffer;
import com.rti.dds.cdr.CdrEncapsulation;
import com.rti.dds.cdr.CdrHelper;
import com.rti.dds.cdr.CdrObjectOutput;
import com.rti.dds.cdr.CdrPrimitiveType;
import com.rti.dds.infrastructure.BooleanSeq;
import com.rti.dds.infrastructure.ByteSeq;
import com.rti.dds.infrastructure.CharSeq;
import com.rti.dds.infrastructure.DoubleSeq;
import com.rti.dds.infrastructure.FloatSeq;
import com.rti.dds.infrastructure.IntSeq;
import com.rti.dds.infrastructure.LongDoubleSeq;
import com.rti.dds.infrastructure.LongSeq;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.ShortSeq;
import com.rti.dds.infrastructure.StringSeq;
import com.rti.dds.infrastructure.WcharSeq;
import com.rti.dds.infrastructure.WstringSeq;
import com.rti.dds.topic.TypeSupportImpl;
import com.rti.dds.util.NativeInterface;
import java.io.Externalizable;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.security.MessageDigest;
import java.util.List;

public final class CdrOutputStream
extends OutputStream
implements CdrObjectOutput {
    private final CdrBuffer _buffer;
    private boolean _dirty = false;
    private boolean _swapByteOrder;
    private short _encapsulationKind;
    private short _encapsulationOptions;
    private int _minBufferSize;
    private boolean _dynamicStream;
    private boolean _trimToSize;
    public boolean skipListEndId;
    public boolean useExtendedMemberId;

    public CdrOutputStream(int n) {
        this._buffer = new CdrBuffer(n);
        this._swapByteOrder = NativeInterface.getInstance().isNativeByteOrderLittleEndian();
        this._encapsulationKind = this._swapByteOrder ? (short)1 : 0;
        this._encapsulationOptions = 0;
        this._minBufferSize = n;
        this._trimToSize = false;
        this._dynamicStream = false;
        this.skipListEndId = false;
        this.useExtendedMemberId = false;
    }

    public CdrOutputStream(int n, short s) {
        this._buffer = new CdrBuffer(n);
        this._encapsulationKind = s;
        this._encapsulationOptions = 0;
        this._minBufferSize = n;
        this._trimToSize = false;
        this._dynamicStream = false;
        this.skipListEndId = false;
        this.useExtendedMemberId = false;
        if (s == 0 || s == 2) {
            this._swapByteOrder = false;
        } else if (s == 1 || s == 3) {
            this._swapByteOrder = true;
        } else {
            throw new RETCODE_ERROR("Unsupported encapsulation");
        }
    }

    public CdrOutputStream(TypeSupportImpl typeSupportImpl) {
        this(typeSupportImpl.get_serialized_sample_max_sizeI(null, true, CdrEncapsulation.CDR_ENCAPSULATION_ID_CDR_NATIVE, 0));
    }

    public CdrOutputStream(CdrBuffer cdrBuffer) {
        this._buffer = cdrBuffer;
        this._swapByteOrder = NativeInterface.getInstance().isNativeByteOrderLittleEndian();
        this._encapsulationKind = this._swapByteOrder ? (short)1 : 0;
        this._encapsulationOptions = 0;
        this._minBufferSize = cdrBuffer.getSize();
        this._trimToSize = false;
        this._dynamicStream = false;
        this.skipListEndId = false;
        this.useExtendedMemberId = false;
    }

    public CdrOutputStream(int n, boolean bl, boolean bl2) {
        this(n);
        this._minBufferSize = n;
        this._trimToSize = bl2;
        this._dynamicStream = bl;
    }

    public CdrBuffer getBuffer() {
        return this._buffer;
    }

    public void setBuffer(byte[] byArray, int n) {
        this._buffer.setBuffer(byArray, n);
    }

    public void reset() {
        this._buffer.resetToZero();
    }

    public void resetAndSetDirtyBit(boolean bl) {
        this.reset();
        this._dirty = bl;
    }

    public void resetAndSetDirtyBit(boolean bl, int n) {
        this.reset();
        this._dirty = bl;
        if (this._dynamicStream) {
            if (this._trimToSize) {
                int n2 = n = n < this._minBufferSize ? this._minBufferSize : n;
                if (this._buffer.getSize() != n) {
                    this._buffer.resize(n);
                }
            } else if (n > this._buffer.getSize()) {
                this._buffer.resize(n);
            }
        }
    }

    public int flushToNative(long l, int n) {
        return this._buffer.flushToNative(l, n);
    }

    public void writeString(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            throw new RETCODE_ERROR("Unexpected string length: " + n2 + " > " + n);
        }
        this.writeInt(n2 + 1);
        for (int i = 0; i < n2; ++i) {
            this.writeByte((byte)string.charAt(i));
        }
        this.writeByte(0);
    }

    public void writeString(String string) {
        this.writeString(string, Integer.MAX_VALUE);
    }

    public void writeStringArray(String[] stringArray, int n, int n2) {
        try {
            StringSeq.writeStringArray(stringArray, this, n, n2);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            illegalStateException.initCause(iOException);
            throw illegalStateException;
        }
    }

    public void writeStringArray(String[] stringArray, int n) {
        this.writeStringArray(stringArray, n, Integer.MAX_VALUE);
    }

    public void writeStringSeq(StringSeq stringSeq, int n, int n2) {
        CdrHelper.checkSequenceMaximum(stringSeq, n2);
        this.writeSequence(stringSeq);
    }

    public void writeWstring(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            throw new RETCODE_ERROR("Unexpected wide string length: " + n2 + " > " + n);
        }
        this.writeInt(n2 + 1);
        for (int i = 0; i < n2; ++i) {
            this.writeInt(string.charAt(i));
        }
        this.writeInt(0);
    }

    public void writeWstring(String string) {
        this.writeWstring(string, Integer.MAX_VALUE);
    }

    public void writeWstringArray(String[] stringArray, int n, int n2) {
        try {
            WstringSeq.writeWstringArray(stringArray, this, n, n2);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            illegalStateException.initCause(iOException);
            throw illegalStateException;
        }
    }

    public void writeWstringArray(String[] stringArray, int n) {
        this.writeWstringArray(stringArray, n, Integer.MAX_VALUE);
    }

    public void writeWstringSeq(StringSeq stringSeq, int n, int n2) {
        CdrHelper.checkSequenceMaximum(stringSeq, n2);
        this.writeSequence(stringSeq);
    }

    public void write(int n) {
        this.writeByte(n);
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) {
        this._buffer.put(byArray, n, n2);
    }

    public void close() {
        this.flush();
        this.reset();
    }

    public void flush() {
        this.reset();
    }

    public void writeBoolean(boolean bl) {
        this.writeByte(bl ? 1 : 0);
    }

    public void writeByte(int n) {
        this._buffer.checkSize(CdrPrimitiveType.BYTE.size);
        this._buffer.put((byte)n);
    }

    public void writeChar(int n) {
        this.writeByte(n);
    }

    public void writeShort(int n) {
        this._buffer.align(CdrPrimitiveType.SHORT.alignment);
        this._buffer.checkSize(CdrPrimitiveType.SHORT.size);
        if (this._swapByteOrder) {
            this._buffer.put((byte)n);
            this._buffer.put((byte)(n >>> 8));
        } else {
            this._buffer.put((byte)(n >>> 8));
            this._buffer.put((byte)n);
        }
    }

    public void writeShortToBigEndian(int n) {
        this._buffer.checkSize(CdrPrimitiveType.SHORT.size);
        this._buffer.put((byte)(n >>> 8));
        this._buffer.put((byte)n);
    }

    public void writeWchar(int n) {
        this.writeInt(n);
    }

    public void writeInt(int n) {
        this._buffer.align(CdrPrimitiveType.INT.alignment);
        this._buffer.checkSize(CdrPrimitiveType.INT.size);
        if (this._swapByteOrder) {
            this._buffer.put((byte)n);
            this._buffer.put((byte)(n >>> 8));
            this._buffer.put((byte)(n >>> 16));
            this._buffer.put((byte)(n >>> 24));
        } else {
            this._buffer.put((byte)(n >>> 24));
            this._buffer.put((byte)(n >>> 16));
            this._buffer.put((byte)(n >>> 8));
            this._buffer.put((byte)n);
        }
    }

    public void writeUnsignedInt(long l) {
        this._buffer.align(CdrPrimitiveType.INT.alignment);
        this._buffer.checkSize(CdrPrimitiveType.INT.size);
        if (this._swapByteOrder) {
            this._buffer.put((byte)l);
            this._buffer.put((byte)(l >>> 8));
            this._buffer.put((byte)(l >>> 16));
            this._buffer.put((byte)(l >>> 24));
        } else {
            this._buffer.put((byte)(l >>> 24));
            this._buffer.put((byte)(l >>> 16));
            this._buffer.put((byte)(l >>> 8));
            this._buffer.put((byte)l);
        }
    }

    public void writeLong(long l) {
        this._buffer.align(CdrPrimitiveType.LONG.alignment);
        this._buffer.checkSize(CdrPrimitiveType.LONG.size);
        if (this._swapByteOrder) {
            this._buffer.put((byte)l);
            this._buffer.put((byte)(l >>> 8));
            this._buffer.put((byte)(l >>> 16));
            this._buffer.put((byte)(l >>> 24));
            this._buffer.put((byte)(l >>> 32));
            this._buffer.put((byte)(l >>> 40));
            this._buffer.put((byte)(l >>> 48));
            this._buffer.put((byte)(l >>> 56));
        } else {
            this._buffer.put((byte)(l >>> 56));
            this._buffer.put((byte)(l >>> 48));
            this._buffer.put((byte)(l >>> 40));
            this._buffer.put((byte)(l >>> 32));
            this._buffer.put((byte)(l >>> 24));
            this._buffer.put((byte)(l >>> 16));
            this._buffer.put((byte)(l >>> 8));
            this._buffer.put((byte)l);
        }
    }

    public void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeLongDouble(double d) {
        long l = Double.doubleToLongBits(d);
        long l2 = l << 12 >>> 12;
        long l3 = l2 & 0xFL;
        long l4 = l >>> 63;
        long l5 = l << 1 >>> 53;
        long l6 = l4 << 63 | (l5 += 15360L) << 48 | l2 >> 4;
        long l7 = l3 << 60;
        if (this._swapByteOrder) {
            this.writeLong(l7);
            this.writeLong(l6);
        } else {
            this.writeLong(l6);
            this.writeLong(l7);
        }
    }

    public void writeBytes(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeByte(string.charAt(i));
        }
    }

    public void writeChars(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    public void writeWchars(String string) {
        throw new UnsupportedOperationException();
    }

    public void writeUTF(String string) {
        throw new UnsupportedOperationException();
    }

    public void writeObject(Object object) throws IOException {
        if (object == null) {
            throw new IllegalArgumentException("can't write null");
        }
        if (object instanceof Externalizable) {
            ((Externalizable)object).writeExternal(this);
        } else if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            BooleanSeq.writeBooleanArray(blArray, this, blArray.length);
        } else if (object instanceof Byte) {
            this.writeByte(((Byte)object).byteValue());
        } else if (object instanceof byte[]) {
            this.write((byte[])object);
        } else if (object instanceof Character) {
            this.writeChar(((Character)object).charValue());
        } else if (object instanceof char[]) {
            char[] cArray = (char[])object;
            CharSeq.writeCharArray(cArray, this, cArray.length);
        } else if (object instanceof Double) {
            this.writeDouble((Double)object);
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            DoubleSeq.writeDoubleArray(dArray, this, dArray.length);
        } else if (object instanceof Float) {
            this.writeFloat(((Float)object).floatValue());
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            FloatSeq.writeFloatArray(fArray, this, fArray.length);
        } else if (object instanceof Integer) {
            this.writeInt((Integer)object);
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            IntSeq.writeIntArray(nArray, this, nArray.length);
        } else if (object instanceof Long) {
            this.writeLong((Long)object);
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            LongSeq.writeLongArray(lArray, this, lArray.length);
        } else if (object instanceof Short) {
            this.writeShort(((Short)object).shortValue());
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            ShortSeq.writeShortArray(sArray, this, sArray.length);
        } else if (object instanceof String) {
            this.writeString((String)object);
        } else if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            StringSeq.writeStringArray(stringArray, this, stringArray.length, stringArray.length);
        } else if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                this.writeObject(Array.get(object, i));
            }
        } else if (object instanceof List) {
            List list = (List)object;
            int n = list.size();
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeObject(list.get(i));
            }
        } else {
            throw new UnsupportedOperationException("unrecognized type for CDR: " + object.getClass().getName());
        }
    }

    public void writeBooleanArray(boolean[] blArray, int n) {
        try {
            BooleanSeq.writeBooleanArray(blArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            illegalStateException.initCause(iOException);
            throw illegalStateException;
        }
    }

    public void writeBooleanArray(boolean[] blArray) {
        this.writeBooleanArray(blArray, blArray.length);
    }

    public void writeByteArray(byte[] byArray, int n) {
        try {
            ByteSeq.writeByteArray(byArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            illegalStateException.initCause(iOException);
            throw illegalStateException;
        }
    }

    public void writeByteArray(byte[] byArray, int n, int n2) {
        this.write(byArray, n, n2);
    }

    public void writeCharArray(char[] cArray, int n) {
        try {
            CharSeq.writeCharArray(cArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            illegalStateException.initCause(iOException);
            throw illegalStateException;
        }
    }

    public void writeByteArray(byte[] byArray) {
        this.writeByteArray(byArray, byArray.length);
    }

    public void writeCharArray(char[] cArray) {
        this.writeCharArray(cArray, cArray.length);
    }

    public void writeShortArray(short[] sArray, int n) {
        try {
            ShortSeq.writeShortArray(sArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            illegalStateException.initCause(iOException);
            throw illegalStateException;
        }
    }

    public void writeShortArray(short[] sArray) {
        this.writeShortArray(sArray, sArray.length);
    }

    public void writeWcharArray(char[] cArray, int n) {
        try {
            WcharSeq.writeWcharArray(cArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            illegalStateException.initCause(iOException);
            throw illegalStateException;
        }
    }

    public void writeWcharArray(char[] cArray) {
        this.writeWcharArray(cArray, cArray.length);
    }

    public void writeIntArray(int[] nArray, int n) {
        try {
            IntSeq.writeIntArray(nArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            illegalStateException.initCause(iOException);
            throw illegalStateException;
        }
    }

    public void writeIntArray(int[] nArray) {
        this.writeIntArray(nArray, nArray.length);
    }

    public void writeLongArray(long[] lArray, int n) {
        try {
            LongSeq.writeLongArray(lArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            illegalStateException.initCause(iOException);
            throw illegalStateException;
        }
    }

    public void writeLongArray(long[] lArray) {
        this.writeLongArray(lArray, lArray.length);
    }

    public void writeFloatArray(float[] fArray, int n) {
        try {
            FloatSeq.writeFloatArray(fArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            illegalStateException.initCause(iOException);
            throw illegalStateException;
        }
    }

    public void writeFloatArray(float[] fArray) {
        this.writeFloatArray(fArray, fArray.length);
    }

    public void writeDoubleArray(double[] dArray, int n) {
        try {
            DoubleSeq.writeDoubleArray(dArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            illegalStateException.initCause(iOException);
            throw illegalStateException;
        }
    }

    public void writeLongDoubleArray(double[] dArray, int n) {
        try {
            LongDoubleSeq.writeLongDoubleArray(dArray, this, n);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected IO exception: " + iOException.getMessage());
            illegalStateException.initCause(iOException);
            throw illegalStateException;
        }
    }

    public void writeDoubleArray(double[] dArray) {
        this.writeDoubleArray(dArray, dArray.length);
    }

    public void writeBooleanSeq(BooleanSeq booleanSeq, int n) {
        CdrHelper.checkSequenceMaximum(booleanSeq, n);
        this.writeSequence(booleanSeq);
    }

    public void writeByteSeq(ByteSeq byteSeq, int n) {
        CdrHelper.checkSequenceMaximum(byteSeq, n);
        this.writeSequence(byteSeq);
    }

    public void writeCharSeq(CharSeq charSeq, int n) {
        CdrHelper.checkSequenceMaximum(charSeq, n);
        this.writeSequence(charSeq);
    }

    public void writeShortSeq(ShortSeq shortSeq, int n) {
        CdrHelper.checkSequenceMaximum(shortSeq, n);
        this.writeSequence(shortSeq);
    }

    public void writeWcharSeq(CharSeq charSeq, int n) {
        CdrHelper.checkSequenceMaximum(charSeq, n);
        this.writeSequence(charSeq);
    }

    public void writeIntSeq(IntSeq intSeq, int n) {
        CdrHelper.checkSequenceMaximum(intSeq, n);
        this.writeSequence(intSeq);
    }

    public void writeIntSeq(IntSeq intSeq) {
        this.writeSequence(intSeq);
    }

    public void writeLongSeq(LongSeq longSeq, int n) {
        CdrHelper.checkSequenceMaximum(longSeq, n);
        this.writeSequence(longSeq);
    }

    public void writeFloatSeq(FloatSeq floatSeq, int n) {
        CdrHelper.checkSequenceMaximum(floatSeq, n);
        this.writeSequence(floatSeq);
    }

    public void writeDoubleSeq(DoubleSeq doubleSeq, int n) {
        CdrHelper.checkSequenceMaximum(doubleSeq, n);
        this.writeSequence(doubleSeq);
    }

    public void writeLongDoubleSeq(DoubleSeq doubleSeq, int n) {
        CdrHelper.checkSequenceMaximum(doubleSeq, n);
        this.writeSequence(doubleSeq);
    }

    public void serializeCdrEncapsulationDefault() {
        this.writeShortToBigEndian(this._encapsulationKind);
        this.writeShortToBigEndian(this._encapsulationOptions);
    }

    public void serializeAndSetCdrEncapsulation(short s) {
        if (s != 0 && s != 1 && s != 2 && s != 3) {
            throw new RETCODE_ERROR("Unsupported encapsulation " + s);
        }
        this._encapsulationKind = s;
        this._swapByteOrder = this._encapsulationKind == 1 || this._encapsulationKind == 3;
        this.writeShortToBigEndian(this._encapsulationKind);
        this.writeShortToBigEndian(this._encapsulationOptions);
    }

    public void serializeCdrEncapsulation(short s, short s2) {
        this.writeShortToBigEndian(s);
        this.writeShortToBigEndian(s2);
    }

    public short getEncapsulationKind() {
        return this._encapsulationKind;
    }

    public short getEncapsulationOptions() {
        return this._encapsulationOptions;
    }

    public void setEncapsulationKind(short s) {
        boolean bl = s == 0 || s == 1 || s == 2 || s == 3;
        this._encapsulationKind = s;
        if (bl) {
            this._swapByteOrder = this._encapsulationKind == 1 || this._encapsulationKind == 3;
        }
    }

    public void setEncapsulationOptions(short s) {
        this._encapsulationOptions = s;
    }

    public void flushBitsBuffer() {
        this.writeInt(this._buffer._bitBuffer);
        this._buffer._bitBuffer = 0;
        this._buffer._bitBufferLength = 0;
    }

    public void writeBits(int n, int n2) {
        if (n2 + this._buffer._bitBufferLength <= 32) {
            this._buffer.setBits(n, n2);
        } else {
            this.flushBitsBuffer();
            this._buffer.setBits(n, n2);
        }
    }

    public int resetAlignment() {
        return this._buffer.resetAlignment();
    }

    public int resetAlignmentWithOffset(int n) {
        return this._buffer.resetAlignmentWithOffset(n);
    }

    public void restoreAlignment(int n) {
        this._buffer.restoreAlignment(n);
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirtyBit(boolean bl) {
        this._dirty = bl;
    }

    public void computeMD5(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(this._buffer.getBuffer(), 0, this._buffer.currentPosition());
            byte[] byArray2 = messageDigest.digest();
            System.arraycopy(byArray2, 0, byArray, 0, 16);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.getMessage());
        }
    }

    public int writeMemberId(int n) {
        int n2 = 0;
        this.getBuffer().align(4);
        n2 = 16129;
        this.writeShort(n2);
        n2 = 8;
        this.writeShort(n2);
        this.writeInt(n);
        int n3 = this.getBuffer().currentPosition();
        this.writeInt(0);
        this.getBuffer().resetAlignment();
        return n3;
    }

    public int writeMemberId(short s) {
        this.getBuffer().align(4);
        this.writeShort(s);
        int n = this.getBuffer().currentPosition();
        this.writeShort(0);
        this.getBuffer().resetAlignment();
        return n;
    }

    public void writeMemberLength(int n, boolean bl) {
        this.getBuffer().align(4);
        int n2 = this.getBuffer().currentPosition();
        this.getBuffer().setCurrentPosition(n);
        if (!bl) {
            int n3 = n2 - (n + CdrPrimitiveType.SHORT.size);
            this.writeShort(n3);
        } else {
            long l = (long)n2 - (long)(n + CdrPrimitiveType.INT.size);
            this.writeUnsignedInt(l);
        }
        this.getBuffer().setCurrentPosition(n2);
    }

    private void writeSequence(Externalizable externalizable) {
        try {
            externalizable.writeExternal(this);
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("unexpected exception: " + iOException.getMessage());
            illegalStateException.initCause(iOException);
            throw illegalStateException;
        }
    }
}

