/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.cdr;

import com.rti.dds.infrastructure.StringSeq;
import com.rti.dds.infrastructure.WstringSeq;
import com.rti.dds.util.AbstractPrimitiveSequence;
import com.rti.dds.util.Enum;

public final class CdrPrimitiveType
extends Enum {
    public static final CdrPrimitiveType BOOLEAN = new CdrPrimitiveType(7, "boolean", 1, 1);
    public static final CdrPrimitiveType BYTE = new CdrPrimitiveType(1, "byte", 1, 1);
    public static final CdrPrimitiveType CHAR = new CdrPrimitiveType(0, "char", 4, 4);
    public static final CdrPrimitiveType SHORT = new CdrPrimitiveType(2, "short", 2, 2);
    public static final CdrPrimitiveType INT = new CdrPrimitiveType(3, "int", 4, 4);
    public static final CdrPrimitiveType LONG = new CdrPrimitiveType(4, "long", 8, 8);
    public static final CdrPrimitiveType FLOAT = new CdrPrimitiveType(5, "float", 4, 4);
    public static final CdrPrimitiveType DOUBLE = new CdrPrimitiveType(6, "double", 8, 8);
    public static final CdrPrimitiveType LONG_DOUBLE = new CdrPrimitiveType(8, "longdouble", 16, 8);
    public static final int MAX_ALIGNMENT = 8;
    public final int size;
    public final int alignment;

    public static long getStringMaxSizeSerialized(long l, long l2) {
        return INT.getMaxSizeSerialized(l) + (long)CdrPrimitiveType.BYTE.size * l2;
    }

    public static long getStringSerializedSize(long l, String string) {
        return INT.getMaxSizeSerialized(l) + (long)(string.length() + 1);
    }

    public static long getStringSeqMaxSizeSerialized(long l, long l2, long l3) {
        long l4 = INT.getMaxSizeSerialized(l);
        if (l3 > 0L) {
            l4 += CdrPrimitiveType.getStringArrayMaxSizeSerialized(l + l4, l2, l3);
        }
        return l4;
    }

    public static long getStringSeqSerializedSize(long l, StringSeq stringSeq) {
        long l2 = INT.getMaxSizeSerialized(l);
        long l3 = stringSeq.size();
        for (long i = 0L; i < l3; ++i) {
            l2 += CdrPrimitiveType.getStringSerializedSize(l + l2, (String)stringSeq.get((int)i));
        }
        return l2;
    }

    public static long getStringArrayMaxSizeSerialized(long l, long l2, long l3) {
        long l4 = 0L;
        if (l3 > 0L) {
            l4 = CdrPrimitiveType.getStringMaxSizeSerialized(l, l2);
            l4 += CdrPrimitiveType.getStringMaxSizeSerialized(l + l4, l2) * (l3 - 1L);
        }
        return l4;
    }

    public static long getWstringMaxSizeSerialized(long l, long l2) {
        return INT.getMaxSizeSerialized(l) + (long)CdrPrimitiveType.INT.size * l2;
    }

    public static long getWstringSerializedSize(long l, String string) {
        return INT.getMaxSizeSerialized(l) + (long)(string.length() * CdrPrimitiveType.INT.size + CdrPrimitiveType.INT.size);
    }

    public static long getWstringSeqMaxSizeSerialized(long l, long l2, long l3) {
        long l4 = INT.getMaxSizeSerialized(l);
        if (l3 > 0L) {
            l4 += CdrPrimitiveType.getWstringMaxSizeSerialized(l + l4, l2) * l3;
        }
        return l4;
    }

    public static long getWstringSeqSerializedSize(long l, WstringSeq wstringSeq) {
        long l2 = INT.getMaxSizeSerialized(l);
        long l3 = wstringSeq.size();
        for (long i = 0L; i < l3; ++i) {
            l2 += CdrPrimitiveType.getWstringSerializedSize(l + l2, (String)wstringSeq.get((int)i));
        }
        return l2;
    }

    public static long getWstringArrayMaxSizeSerialized(long l, long l2, long l3) {
        long l4 = 0L;
        if (l3 > 0L) {
            l4 = CdrPrimitiveType.getWstringMaxSizeSerialized(l, l2);
            l4 += CdrPrimitiveType.getWstringMaxSizeSerialized(l + l4, l2) * (l3 - 1L);
        }
        return l4;
    }

    public static long getBitsMaxSizeSerialized(long l, int[] nArray, int n) {
        if (n + nArray[0] > 32) {
            nArray[0] = n;
            return INT.getMaxSizeSerialized(l);
        }
        nArray[0] = nArray[0] + n;
        return 0L;
    }

    public static long flushBitsMaxSizeSerialized(long l, int[] nArray) {
        nArray[0] = 0;
        return INT.getMaxSizeSerialized(l);
    }

    public long getMaxSizeSerialized(long l) {
        return this.getArrayMaxSizeSerialized(l, 1L);
    }

    public int getMaxSizeSerialized(int n) {
        return (int)this.getArrayMaxSizeSerialized(n, 1L);
    }

    public long getArrayMaxSizeSerialized(long l, long l2) {
        if (l2 == 0L) {
            return 0L;
        }
        return CdrPrimitiveType.getPadSize(l, this.alignment) + (long)this.size * l2;
    }

    public long getSequenceMaxSizeSerialized(long l, long l2) {
        long l3 = INT.getMaxSizeSerialized(l);
        return l3 + this.getArrayMaxSizeSerialized(l + l3, l2);
    }

    public long getSequenceSerializedSize(long l, AbstractPrimitiveSequence abstractPrimitiveSequence) {
        long l2 = INT.getMaxSizeSerialized(l);
        return l2 + this.getArrayMaxSizeSerialized(l + l2, abstractPrimitiveSequence.size());
    }

    private CdrPrimitiveType(int n, String string, int n2, int n3) {
        super(string, n);
        this.size = n2;
        this.alignment = n3;
    }

    public static long getPadSize(long l, long l2) {
        long l3 = l2 > 8L ? 8L : l2;
        long l4 = l + l3 - 1L & (l3 - 1L ^ 0xFFFFFFFFFFFFFFFFL);
        return l4 - l;
    }
}

