/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.domain;

import com.rti.dds.domain.DomainParticipant;
import com.rti.dds.domain.DomainParticipantFactory;
import com.rti.dds.domain.DomainParticipantFactoryQos;
import com.rti.dds.domain.DomainParticipantImpl;
import com.rti.dds.domain.DomainParticipantListener;
import com.rti.dds.domain.DomainParticipantQos;
import com.rti.dds.domain.ThreadFactory;
import com.rti.dds.infrastructure.AbstractNativeObject;
import com.rti.dds.infrastructure.DomainParticipantConfigParams_t;
import com.rti.dds.infrastructure.Entity;
import com.rti.dds.infrastructure.Listener;
import com.rti.dds.infrastructure.NativeFactoryMixin;
import com.rti.dds.infrastructure.NativeObject;
import com.rti.dds.infrastructure.NativeStructMixin;
import com.rti.dds.infrastructure.PropertyQosPolicyHelper;
import com.rti.dds.infrastructure.Property_t;
import com.rti.dds.infrastructure.RETCODE_BAD_PARAMETER;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.RETCODE_OUT_OF_RESOURCES;
import com.rti.dds.infrastructure.StringSeq;
import com.rti.dds.publication.DataWriterQos;
import com.rti.dds.publication.PublisherQos;
import com.rti.dds.subscription.DataReaderQos;
import com.rti.dds.subscription.SubscriberQos;
import com.rti.dds.topic.TopicQos;
import com.rti.dds.topic.TypeSupport;
import com.rti.dds.type.builtin.BytesTypeSupport;
import com.rti.dds.type.builtin.KeyedBytesTypeSupport;
import com.rti.dds.type.builtin.KeyedStringTypeSupport;
import com.rti.dds.type.builtin.StringTypeSupport;
import com.rti.dds.typecode.TypeCode;
import com.rti.dds.typecode.TypeCodeFactory;
import com.rti.dds.util.Utilities;
import com.rti.ndds.config.Logger;
import com.rti.ndds.config.ModuleLogger;

public final class DomainParticipantFactoryImpl
extends DomainParticipantFactory
implements NativeObject {
    private static long _nativeFactory = 0L;
    private final NativeStructMixin _qosMixin;
    private final NativeFactoryMixin _participantFactory;
    private boolean _isThreadPriorityCached = false;
    private int _cachedEventThreadPriority;
    private int _cachedReceiverPoolThreadPriority;
    private int _cachedDatabaseThreadPriority;
    private Object _cachedPluginData = null;
    private final Object _threadFactoryLock = new Object();
    private static final RuntimeException ERROR_CREATING_OBJECTS_PER_WORKER = new RETCODE_OUT_OF_RESOURCES("error creating objects per worker");
    private static final RuntimeException NULL_PROFILE = new RETCODE_BAD_PARAMETER("null profile");
    private static final RuntimeException NULL_LIBRARY = new RETCODE_BAD_PARAMETER("null library");
    private static final RuntimeException NULL_ARGUMENT = new RETCODE_BAD_PARAMETER("null argument");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_thread_factoriesI(ThreadFactory threadFactory, ThreadFactory threadFactory2, ThreadFactory threadFactory3, ThreadFactory threadFactory4) {
        int n;
        Object object = this._threadFactoryLock;
        synchronized (object) {
            n = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_set_thread_factoriesI(threadFactory, threadFactory2, threadFactory3, threadFactory4);
        }
        RETCODE_ERROR.check_return_codeI(n);
    }

    public long get_native_pointer() {
        return _nativeFactory;
    }

    public void before_delete_native() {
    }

    public void after_delete_native() {
        this.clear_native_pointer();
        this._qosMixin.cleanup();
        this._participantFactory.cleanup();
    }

    public void clear_native_pointer() {
        _nativeFactory = 0L;
    }

    public boolean is_alive() {
        return AbstractNativeObject.is_aliveI(this);
    }

    public static void set_product_JMS() {
        DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_set_product_JMS();
    }

    public DomainParticipant create_participant(int n, DomainParticipantQos domainParticipantQos, DomainParticipantListener domainParticipantListener, int n2) {
        DomainParticipantImpl domainParticipantImpl = null;
        if (!DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_initialize_scratchpadsI()) {
            ModuleLogger.DDS.log(1, this.getClass(), "create_participant", "!initialize shared state");
            return null;
        }
        boolean bl = domainParticipantQos == PARTICIPANT_QOS_DEFAULT;
        domainParticipantImpl = (DomainParticipantImpl)this._participantFactory.create_entityI(domainParticipantQos, bl, domainParticipantListener, n2, new Object[]{new Integer(n), bl ? null : domainParticipantQos.type_support.plugin_data});
        try {
            if (domainParticipantImpl != null) {
                if (bl) {
                    DomainParticipantQos domainParticipantQos2 = new DomainParticipantQos();
                    this.get_default_participant_qos(domainParticipantQos2);
                    domainParticipantImpl.cache_qos(domainParticipantQos2);
                } else {
                    domainParticipantImpl.cache_qos(domainParticipantQos);
                }
            }
        }
        catch (RETCODE_ERROR rETCODE_ERROR) {
            ModuleLogger.DDS.log(1, this.getClass(), "create_participant", "!initialize default QoS");
            this._participantFactory.delete_entityI(domainParticipantImpl);
            domainParticipantImpl = null;
        }
        catch (RuntimeException runtimeException) {
            this._participantFactory.delete_entityI(domainParticipantImpl);
            throw runtimeException;
        }
        if (domainParticipantImpl != null) {
            try {
                this.register_builtin_types(domainParticipantImpl, domainParticipantQos);
            }
            catch (RuntimeException runtimeException) {
                this._participantFactory.delete_entityI(domainParticipantImpl);
                domainParticipantImpl = null;
            }
        }
        return domainParticipantImpl;
    }

    public DomainParticipant create_participant_with_profile(int n, String string, String string2, DomainParticipantListener domainParticipantListener, int n2) {
        DomainParticipant domainParticipant = null;
        DomainParticipantQos domainParticipantQos = new DomainParticipantQos();
        if (!this.is_alive()) {
            return null;
        }
        if (string2 == null) {
            string2 = this.get_default_profile();
            string = this.get_default_profile_library();
        }
        if (string2 == null) {
            Utilities.rethrow(NULL_PROFILE);
            return null;
        }
        if (string == null && (string = this.get_default_library()) == null) {
            Utilities.rethrow(NULL_LIBRARY);
            return null;
        }
        this.get_participant_qos_from_profile(domainParticipantQos, string, string2);
        domainParticipant = this.create_participant(n, domainParticipantQos, domainParticipantListener, n2);
        domainParticipantQos = null;
        return domainParticipant;
    }

    public void unregister_thread() {
        long l = this.get_native_pointer();
        int n = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_unregister_threadI(l);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void delete_participant(DomainParticipant domainParticipant) {
        this._participantFactory.delete_entityI(domainParticipant);
    }

    public void get_default_participant_qos(DomainParticipantQos domainParticipantQos) {
        if (!DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_initialize_scratchpadsI()) {
            Utilities.rethrow(ERROR_CREATING_OBJECTS_PER_WORKER);
        }
        this._participantFactory.get_untypedI(domainParticipantQos);
        if (this._isThreadPriorityCached) {
            domainParticipantQos.event.thread.priority = this._cachedEventThreadPriority;
            domainParticipantQos.receiver_pool.thread.priority = this._cachedReceiverPoolThreadPriority;
            domainParticipantQos.database.thread.priority = this._cachedDatabaseThreadPriority;
        } else {
            this._cachedEventThreadPriority = domainParticipantQos.event.thread.priority;
            this._cachedReceiverPoolThreadPriority = domainParticipantQos.receiver_pool.thread.priority;
            this._cachedDatabaseThreadPriority = domainParticipantQos.database.thread.priority;
            this._isThreadPriorityCached = true;
        }
    }

    public void set_default_participant_qos(DomainParticipantQos domainParticipantQos) {
        if (!DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_initialize_scratchpadsI()) {
            Utilities.rethrow(ERROR_CREATING_OBJECTS_PER_WORKER);
        }
        boolean bl = domainParticipantQos == PARTICIPANT_QOS_DEFAULT;
        this._participantFactory.set_untypedI(domainParticipantQos, bl, false, new Object[]{this._cachedPluginData, bl ? null : domainParticipantQos.type_support.plugin_data});
        if (!bl) {
            this._cachedEventThreadPriority = domainParticipantQos.event.thread.priority;
            this._cachedReceiverPoolThreadPriority = domainParticipantQos.receiver_pool.thread.priority;
            this._cachedDatabaseThreadPriority = domainParticipantQos.database.thread.priority;
            this._isThreadPriorityCached = true;
            this._cachedPluginData = domainParticipantQos.type_support.plugin_data;
        } else {
            this._isThreadPriorityCached = false;
            this._cachedPluginData = null;
        }
    }

    public void set_default_participant_qos_with_profile(String string, String string2) {
        DomainParticipantQos domainParticipantQos = new DomainParticipantQos();
        AbstractNativeObject.check_aliveI(this);
        if (string2 == null) {
            string2 = this.get_default_profile();
            string = this.get_default_profile_library();
        }
        if (string2 == null) {
            Utilities.rethrow(NULL_PROFILE);
            return;
        }
        if (string == null && (string = this.get_default_library()) == null) {
            Utilities.rethrow(NULL_LIBRARY);
            return;
        }
        this.get_participant_qos_from_profile(domainParticipantQos, string, string2);
        this.set_default_participant_qos(domainParticipantQos);
        domainParticipantQos = null;
    }

    public DomainParticipant lookup_participant(int n) {
        if (!this.is_alive()) {
            return null;
        }
        DomainParticipant domainParticipant = null;
        long l = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_lookup_participant(this.get_native_pointer(), n);
        if (l != 0L) {
            domainParticipant = (DomainParticipant)DomainParticipantImpl.get_participantI(l);
        }
        return domainParticipant;
    }

    public void get_qos(DomainParticipantFactoryQos domainParticipantFactoryQos) {
        this._qosMixin.get_untypedI(domainParticipantFactoryQos);
    }

    public void set_qos(DomainParticipantFactoryQos domainParticipantFactoryQos) {
        this._qosMixin.set_untypedI(domainParticipantFactoryQos, false, false, null);
    }

    public void load_profiles() {
        AbstractNativeObject.check_aliveI(this);
        int n = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_load_profiles(this.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void reload_profiles() {
        AbstractNativeObject.check_aliveI(this);
        int n = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_reload_profiles(this.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void unload_profiles() {
        AbstractNativeObject.check_aliveI(this);
        int n = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_unload_profiles(this.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public String get_default_library() {
        if (!this.is_alive()) {
            return null;
        }
        String string = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_get_default_library(this.get_native_pointer());
        return string;
    }

    public void set_default_library(String string) {
        AbstractNativeObject.check_aliveI(this);
        int n = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_set_default_library(this.get_native_pointer(), string);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public String get_default_profile() {
        if (!this.is_alive()) {
            return null;
        }
        String string = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_get_default_profile(this.get_native_pointer());
        return string;
    }

    public void set_default_profile(String string, String string2) {
        AbstractNativeObject.check_aliveI(this);
        int n = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_set_default_profile(this.get_native_pointer(), string, string2);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public String get_default_profile_library() {
        if (!this.is_alive()) {
            return null;
        }
        String string = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_get_default_profile_library(this.get_native_pointer());
        return string;
    }

    public void get_participant_factory_qos_from_profile(DomainParticipantFactoryQos domainParticipantFactoryQos, String string, String string2) {
        AbstractNativeObject.check_aliveI(this);
        this.check_for_null_argumentI(domainParticipantFactoryQos);
        if (!DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_initialize_scratchpadsI()) {
            Utilities.rethrow(ERROR_CREATING_OBJECTS_PER_WORKER);
        }
        long l = DomainParticipantFactoryImpl.get_scratchpad_qosI(this.get_native_pointer());
        int n = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_get_participant_factory_qos_from_profile(this.get_native_pointer(), l, string, string2);
        RETCODE_ERROR.check_return_codeI(n);
        domainParticipantFactoryQos.pull_from_nativeI(l);
    }

    public void get_participant_qos_from_profile(DomainParticipantQos domainParticipantQos, String string, String string2) {
        AbstractNativeObject.check_aliveI(this);
        this.check_for_null_argumentI(domainParticipantQos);
        if (!DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_initialize_scratchpadsI()) {
            Utilities.rethrow(ERROR_CREATING_OBJECTS_PER_WORKER);
        }
        long l = DomainParticipantFactoryImpl.get_scratchpad_participant_qosI(this.get_native_pointer());
        int n = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_get_participant_qos_from_profile(this.get_native_pointer(), l, string, string2);
        RETCODE_ERROR.check_return_codeI(n);
        domainParticipantQos.pull_from_nativeI(l);
    }

    public void get_publisher_qos_from_profile(PublisherQos publisherQos, String string, String string2) {
        AbstractNativeObject.check_aliveI(this);
        this.check_for_null_argumentI(publisherQos);
        if (!DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_initialize_scratchpadsI()) {
            Utilities.rethrow(ERROR_CREATING_OBJECTS_PER_WORKER);
        }
        long l = DomainParticipantFactoryImpl.get_scratchpad_publisher_qosI(this.get_native_pointer());
        int n = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_get_publisher_qos_from_profile(this.get_native_pointer(), l, string, string2);
        RETCODE_ERROR.check_return_codeI(n);
        publisherQos.pull_from_nativeI(l);
    }

    public void get_subscriber_qos_from_profile(SubscriberQos subscriberQos, String string, String string2) {
        AbstractNativeObject.check_aliveI(this);
        this.check_for_null_argumentI(subscriberQos);
        if (!DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_initialize_scratchpadsI()) {
            Utilities.rethrow(ERROR_CREATING_OBJECTS_PER_WORKER);
        }
        long l = DomainParticipantFactoryImpl.get_scratchpad_subscriber_qosI(this.get_native_pointer());
        int n = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_get_subscriber_qos_from_profile(this.get_native_pointer(), l, string, string2);
        RETCODE_ERROR.check_return_codeI(n);
        subscriberQos.pull_from_nativeI(l);
    }

    public void get_datawriter_qos_from_profile(DataWriterQos dataWriterQos, String string, String string2) {
        this.get_datawriter_qos_from_profile_w_topic_name(dataWriterQos, string, string2, null);
    }

    public void get_datawriter_qos_from_profile_w_topic_name(DataWriterQos dataWriterQos, String string, String string2, String string3) {
        AbstractNativeObject.check_aliveI(this);
        this.check_for_null_argumentI(dataWriterQos);
        if (!DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_initialize_scratchpadsI()) {
            Utilities.rethrow(ERROR_CREATING_OBJECTS_PER_WORKER);
        }
        long l = DomainParticipantFactoryImpl.get_scratchpad_datawriter_qosI(this.get_native_pointer());
        int n = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_get_datawriter_qos_from_profile_w_topic_name(this.get_native_pointer(), l, string, string2, string3);
        RETCODE_ERROR.check_return_codeI(n);
        dataWriterQos.pull_from_nativeI(l);
    }

    public void get_datareader_qos_from_profile(DataReaderQos dataReaderQos, String string, String string2) {
        this.get_datareader_qos_from_profile_w_topic_name(dataReaderQos, string, string2, null);
    }

    public void get_datareader_qos_from_profile_w_topic_name(DataReaderQos dataReaderQos, String string, String string2, String string3) {
        AbstractNativeObject.check_aliveI(this);
        this.check_for_null_argumentI(dataReaderQos);
        if (!DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_initialize_scratchpadsI()) {
            Utilities.rethrow(ERROR_CREATING_OBJECTS_PER_WORKER);
        }
        long l = DomainParticipantFactoryImpl.get_scratchpad_datareader_qosI(this.get_native_pointer());
        int n = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_get_datareader_qos_from_profile_w_topic_name(this.get_native_pointer(), l, string, string2, string3);
        RETCODE_ERROR.check_return_codeI(n);
        dataReaderQos.pull_from_nativeI(l);
    }

    public void get_topic_qos_from_profile(TopicQos topicQos, String string, String string2) {
        this.get_topic_qos_from_profile_w_topic_name(topicQos, string, string2, null);
    }

    public void get_topic_qos_from_profile_w_topic_name(TopicQos topicQos, String string, String string2, String string3) {
        AbstractNativeObject.check_aliveI(this);
        this.check_for_null_argumentI(topicQos);
        if (!DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_initialize_scratchpadsI()) {
            Utilities.rethrow(ERROR_CREATING_OBJECTS_PER_WORKER);
        }
        long l = DomainParticipantFactoryImpl.get_scratchpad_topic_qosI(this.get_native_pointer());
        int n = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_get_topic_qos_from_profile_w_topic_name(this.get_native_pointer(), l, string, string2, string3);
        RETCODE_ERROR.check_return_codeI(n);
        topicQos.pull_from_nativeI(l);
    }

    public void get_qos_profile_libraries(StringSeq stringSeq) {
        AbstractNativeObject.check_aliveI(this);
        this.check_for_null_argumentI(stringSeq);
        if (!DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_initialize_scratchpadsI()) {
            ModuleLogger.DDS.log(1, this.getClass(), "get_qos_profile_libraires", "!initialize shared state");
            stringSeq.clear();
            return;
        }
        long l = DomainParticipantFactoryImpl.get_scratchpad_stringseqI(this.get_native_pointer());
        int n = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_get_qos_profile_libraries(this.get_native_pointer(), l);
        RETCODE_ERROR.check_return_codeI(n);
        stringSeq.pull_from_nativeI(l);
        DomainParticipantFactoryImpl.return_scratchpad_stringseqI(this.get_native_pointer(), l);
    }

    public void get_qos_profiles(StringSeq stringSeq, String string) {
        AbstractNativeObject.check_aliveI(this);
        this.check_for_null_argumentI(stringSeq);
        if (!DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_initialize_scratchpadsI()) {
            ModuleLogger.DDS.log(1, this.getClass(), "get_qos_profiles", "!initialize shared state");
            stringSeq.clear();
            return;
        }
        long l = DomainParticipantFactoryImpl.get_scratchpad_stringseqI(this.get_native_pointer());
        int n = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_get_qos_profiles(this.get_native_pointer(), l, string);
        RETCODE_ERROR.check_return_codeI(n);
        stringSeq.pull_from_nativeI(l);
        DomainParticipantFactoryImpl.return_scratchpad_stringseqI(this.get_native_pointer(), l);
    }

    public TypeCode get_typecode_from_type_library(String string, String string2) {
        TypeCode typeCode = null;
        AbstractNativeObject.check_aliveI(this);
        this.check_for_null_argumentI(string2);
        long l = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_get_typecode_from_type_library(this.get_native_pointer(), string, string2);
        if (l != 0L) {
            typeCode = TypeCodeFactory.get_instance().create_tc_from_native(l);
        }
        return typeCode;
    }

    public DomainParticipant create_participant_from_config_w_params(String string, DomainParticipantConfigParams_t domainParticipantConfigParams_t) {
        DomainParticipant domainParticipant = null;
        long l = DomainParticipantFactoryImpl.get_scratchpad_participant_config_paramsI();
        domainParticipantConfigParams_t.push_to_nativeI(l);
        long l2 = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_create_participant_from_config_w_params(this.get_native_pointer(), string, l);
        DomainParticipantFactoryImpl.return_scratchpad_participant_config_paramsI(l);
        if (l2 != 0L) {
            domainParticipant = (DomainParticipant)DomainParticipantImpl.get_participantI(l2);
        }
        return domainParticipant;
    }

    public DomainParticipant create_participant_from_config(String string) {
        DomainParticipant domainParticipant = this.create_participant_from_config_w_params(string, PARTICIPANT_CONFIG_PARAMS_DEFAULT);
        if (domainParticipant == null) {
            ModuleLogger.DDS.log(1, this.getClass(), "create_participant_from_config", "!create_participant_from_config_w_params");
        }
        return domainParticipant;
    }

    public DomainParticipant lookup_participant_by_name(String string) {
        long l = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_lookup_participant_by_name(this.get_native_pointer(), string);
        if (l != 0L) {
            return (DomainParticipant)DomainParticipantImpl.get_participantI(l);
        }
        return null;
    }

    public void register_type_support(TypeSupport typeSupport, String string) {
        int n = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_register_type_support(this.get_native_pointer(), typeSupport, string);
        RETCODE_ERROR.check_return_codeI(n);
    }

    protected void finalize_instanceI() {
        this.before_delete_native();
        int n = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_finalize_instance();
        RETCODE_ERROR.check_return_codeI(n);
        this.after_delete_native();
    }

    protected final void check_for_null_argumentI(Object object) {
        if (object == null) {
            Utilities.rethrow(NULL_ARGUMENT);
        }
    }

    private void register_builtin_types(DomainParticipant domainParticipant, DomainParticipantQos domainParticipantQos) {
        boolean bl = true;
        Property_t property_t = PropertyQosPolicyHelper.lookup_property(domainParticipantQos.property, "dds.builtin_type.auto_register");
        if (property_t != null && (property_t.value.equals("0") || property_t.value.equalsIgnoreCase("false") || property_t.value.equalsIgnoreCase("no"))) {
            bl = false;
        }
        if (bl) {
            StringTypeSupport.register_type(domainParticipant, StringTypeSupport.get_type_name());
            BytesTypeSupport.register_type(domainParticipant, BytesTypeSupport.get_type_name());
            KeyedStringTypeSupport.register_type(domainParticipant, KeyedStringTypeSupport.get_type_name());
            KeyedBytesTypeSupport.register_type(domainParticipant, KeyedBytesTypeSupport.get_type_name());
        }
    }

    DomainParticipantFactoryImpl() {
        _nativeFactory = DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_get_instance();
        AbstractNativeObject.check_for_zeroI(_nativeFactory);
        this._qosMixin = new DomainParticipantFactoryQosMixin();
        this._participantFactory = new DomainParticipantFactoryMixin();
        try {
            Logger.get_instance().initialize_from_system_properties();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ModuleLogger.DDS.log(1, this.getClass(), "<init>", "Incorrectly configured logging: " + illegalArgumentException.getMessage());
        }
    }

    private static native long DDS_DomainParticipantFactory_get_instance();

    private static native int DDS_DomainParticipantFactory_finalize_instance();

    private static native boolean DDS_DomainParticipantFactory_initialize_scratchpadsI();

    private static native void DDS_DomainParticipantFactory_set_product_JMS();

    private static native int DDS_DomainParticipantFactory_set_thread_factoriesI(Object var0, Object var1, Object var2, Object var3);

    private static native long DDS_DomainParticipantFactory_create_participant_disabledI(long var0, boolean[] var2, int var3, long var4, boolean var6, long var7, int var9, Object var10);

    private static native int DDS_DomainParticipantFactory_delete_participant(long var0, long var2);

    private static native int initialize_native_to_java_participant_pointerI(long var0, Object var2);

    private static native int DDS_DomainParticipantFactory_get_default_participant_qos(long var0, long var2);

    private static native int DDS_DomainParticipantFactory_set_default_participant_qos(long var0, long var2, boolean var4, Object var5, Object var6);

    private static native long get_scratchpad_participant_qosI(long var0);

    private static native long get_scratchpad_publisher_qosI(long var0);

    private static native long get_scratchpad_subscriber_qosI(long var0);

    private static native long get_scratchpad_datawriter_qosI(long var0);

    private static native long get_scratchpad_datareader_qosI(long var0);

    private static native long get_scratchpad_topic_qosI(long var0);

    private static native long DDS_DomainParticipantFactory_lookup_participant(long var0, int var2);

    private static native int DDS_DomainParticipantFactory_get_qos(long var0, long var2);

    private static native int DDS_DomainParticipantFactory_set_qos(long var0, long var2);

    private static native int DDS_DomainParticipantFactory_load_profiles(long var0);

    private static native int DDS_DomainParticipantFactory_reload_profiles(long var0);

    private static native int DDS_DomainParticipantFactory_unload_profiles(long var0);

    private static native String DDS_DomainParticipantFactory_get_default_library(long var0);

    private static native int DDS_DomainParticipantFactory_set_default_library(long var0, String var2);

    private static native String DDS_DomainParticipantFactory_get_default_profile(long var0);

    private static native int DDS_DomainParticipantFactory_set_default_profile(long var0, String var2, String var3);

    private static native String DDS_DomainParticipantFactory_get_default_profile_library(long var0);

    private static native int DDS_DomainParticipantFactory_get_participant_factory_qos_from_profile(long var0, long var2, String var4, String var5);

    private static native int DDS_DomainParticipantFactory_get_participant_qos_from_profile(long var0, long var2, String var4, String var5);

    private static native int DDS_DomainParticipantFactory_get_publisher_qos_from_profile(long var0, long var2, String var4, String var5);

    private static native int DDS_DomainParticipantFactory_get_subscriber_qos_from_profile(long var0, long var2, String var4, String var5);

    private static native int DDS_DomainParticipantFactory_get_datawriter_qos_from_profile(long var0, long var2, String var4, String var5);

    private static native int DDS_DomainParticipantFactory_get_datawriter_qos_from_profile_w_topic_name(long var0, long var2, String var4, String var5, String var6);

    private static native int DDS_DomainParticipantFactory_get_datareader_qos_from_profile(long var0, long var2, String var4, String var5);

    private static native int DDS_DomainParticipantFactory_get_datareader_qos_from_profile_w_topic_name(long var0, long var2, String var4, String var5, String var6);

    private static native int DDS_DomainParticipantFactory_get_topic_qos_from_profile(long var0, long var2, String var4, String var5);

    private static native int DDS_DomainParticipantFactory_get_topic_qos_from_profile_w_topic_name(long var0, long var2, String var4, String var5, String var6);

    private static native int DDS_DomainParticipantFactory_get_qos_profile_libraries(long var0, long var2);

    private static native int DDS_DomainParticipantFactory_get_qos_profiles(long var0, long var2, String var4);

    private static native long DDS_DomainParticipantFactory_get_typecode_from_type_library(long var0, String var2, String var3);

    private static native long get_scratchpad_qosI(long var0);

    private static native void return_scratchpad_qosI(long var0, long var2);

    private static native long get_scratchpad_stringseqI(long var0);

    private static native void return_scratchpad_stringseqI(long var0, long var2);

    private static native int DDS_DomainParticipantFactory_unregister_threadI(long var0);

    private static native long DDS_DomainParticipantFactory_create_participant_from_config_w_params(long var0, String var2, long var3);

    private static native long DDS_DomainParticipantFactory_lookup_participant_by_name(long var0, String var2);

    private static native int DDS_DomainParticipantFactory_register_type_support(long var0, TypeSupport var2, String var3);

    private static native long get_scratchpad_participant_config_paramsI();

    private static native void return_scratchpad_participant_config_paramsI(long var0);

    private final class DomainParticipantFactoryMixin
    extends NativeFactoryMixin {
        public DomainParticipantFactoryMixin() {
            super(DomainParticipantFactoryImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DomainParticipantFactoryImpl.get_scratchpad_participant_qosI(l);
        }

        protected Entity create_java_entity(long l, Listener listener, int n, Object[] objectArray) {
            return new DomainParticipantImpl(l, (DomainParticipantListener)listener, n);
        }

        protected long create_native_entity(long l, long l2, boolean bl, long l3, int n, boolean[] blArray, Object[] objectArray) {
            int n2 = (Integer)objectArray[0];
            Object object = objectArray[1];
            return DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_create_participant_disabledI(l, blArray, n2, l2, bl, l3, n, object);
        }

        protected int destroy_native_entity(long l, long l2) {
            return DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_delete_participant(l, l2);
        }

        protected int initialize_native_to_java_pointer(long l, Entity entity) {
            return DomainParticipantFactoryImpl.initialize_native_to_java_participant_pointerI(l, entity);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_get_default_participant_qos(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            Object object = objectArray[0];
            Object object2 = objectArray[1];
            return DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_set_default_participant_qos(l, l2, bl, object, object2);
        }
    }

    private final class DomainParticipantFactoryQosMixin
    extends NativeStructMixin {
        public DomainParticipantFactoryQosMixin() {
            super(DomainParticipantFactoryImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DomainParticipantFactoryImpl.get_scratchpad_qosI(l);
        }

        protected void return_scratchpadI(long l, long l2) {
            DomainParticipantFactoryImpl.return_scratchpad_qosI(l, l2);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_get_qos(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return DomainParticipantFactoryImpl.DDS_DomainParticipantFactory_set_qos(l, l2);
        }
    }
}

