/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.domain;

import com.rti.dds.domain.DomainParticipant;
import com.rti.dds.domain.DomainParticipantFactory;
import com.rti.dds.domain.DomainParticipantListener;
import com.rti.dds.domain.DomainParticipantListenerImpl;
import com.rti.dds.domain.DomainParticipantQos;
import com.rti.dds.domain.builtin.ParticipantBuiltinTopicData;
import com.rti.dds.domain.builtin.ParticipantBuiltinTopicDataTypeSupport;
import com.rti.dds.dynamicdata.DynamicDataTypeSupport;
import com.rti.dds.infrastructure.AbstractNativeObject;
import com.rti.dds.infrastructure.Duration_t;
import com.rti.dds.infrastructure.EndpointGroup_t;
import com.rti.dds.infrastructure.Entity;
import com.rti.dds.infrastructure.EntityImpl;
import com.rti.dds.infrastructure.InstanceHandleSeq;
import com.rti.dds.infrastructure.InstanceHandle_t;
import com.rti.dds.infrastructure.Listener;
import com.rti.dds.infrastructure.NativeFactoryMixin;
import com.rti.dds.infrastructure.NativeObject;
import com.rti.dds.infrastructure.NativeStructMixin;
import com.rti.dds.infrastructure.RETCODE_BAD_PARAMETER;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.RETCODE_IMMUTABLE_POLICY;
import com.rti.dds.infrastructure.RETCODE_OUT_OF_RESOURCES;
import com.rti.dds.infrastructure.RETCODE_PRECONDITION_NOT_MET;
import com.rti.dds.infrastructure.RETCODE_UNSUPPORTED;
import com.rti.dds.infrastructure.StringSeq;
import com.rti.dds.infrastructure.Time_t;
import com.rti.dds.publication.DataWriter;
import com.rti.dds.publication.DataWriterImpl;
import com.rti.dds.publication.DataWriterListener;
import com.rti.dds.publication.DataWriterQos;
import com.rti.dds.publication.FlowController;
import com.rti.dds.publication.FlowControllerImpl;
import com.rti.dds.publication.FlowControllerProperty_t;
import com.rti.dds.publication.Publisher;
import com.rti.dds.publication.PublisherImpl;
import com.rti.dds.publication.PublisherListener;
import com.rti.dds.publication.PublisherQos;
import com.rti.dds.publication.PublisherSeq;
import com.rti.dds.publication.builtin.PublicationBuiltinTopicDataTypeSupport;
import com.rti.dds.subscription.DataReader;
import com.rti.dds.subscription.DataReaderImpl;
import com.rti.dds.subscription.DataReaderListener;
import com.rti.dds.subscription.DataReaderQos;
import com.rti.dds.subscription.Subscriber;
import com.rti.dds.subscription.SubscriberImpl;
import com.rti.dds.subscription.SubscriberListener;
import com.rti.dds.subscription.SubscriberQos;
import com.rti.dds.subscription.SubscriberSeq;
import com.rti.dds.subscription.builtin.SubscriptionBuiltinTopicDataTypeSupport;
import com.rti.dds.topic.AbstractBuiltinTopicData;
import com.rti.dds.topic.ContentFilter;
import com.rti.dds.topic.ContentFilteredTopic;
import com.rti.dds.topic.ContentFilteredTopicImpl;
import com.rti.dds.topic.MultiTopic;
import com.rti.dds.topic.Topic;
import com.rti.dds.topic.TopicDescription;
import com.rti.dds.topic.TopicDescriptionImpl;
import com.rti.dds.topic.TopicImpl;
import com.rti.dds.topic.TopicListener;
import com.rti.dds.topic.TopicQos;
import com.rti.dds.topic.TypeSupport;
import com.rti.dds.topic.TypeSupportImpl;
import com.rti.dds.topic.builtin.TopicBuiltinTopicData;
import com.rti.dds.topic.builtin.TopicBuiltinTopicDataTypeSupport;
import com.rti.dds.typecode.TypeCode;
import com.rti.dds.util.Utilities;
import com.rti.ndds.config.ModuleLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public final class DomainParticipantImpl
extends EntityImpl
implements DomainParticipant {
    private static final RuntimeException OUT_OF_MEMORY = new RETCODE_OUT_OF_RESOURCES("out of memory");
    private static final RuntimeException IMMUTABLE_QOS = new RETCODE_IMMUTABLE_POLICY("immutable qos policy");
    private static final RuntimeException UNSUPPORTED_ERROR = new RETCODE_UNSUPPORTED();
    private static final RuntimeException NULL_PROFILE = new RETCODE_BAD_PARAMETER("null profile");
    private static final RuntimeException NULL_LIBRARY = new RETCODE_BAD_PARAMETER("null library");
    private final TopicFactoryMixin _topicFactory = new TopicFactoryMixin();
    private final PublisherFactoryMixin _publisherFactory = new PublisherFactoryMixin();
    private final SubscriberFactoryMixin _subscriberFactory = new SubscriberFactoryMixin();
    private final NativeStructMixin _dataWriterQos = new DataWriterQosMixin();
    private final NativeStructMixin _dataReaderQos = new DataReaderQosMixin();
    private final Object[] _serializeOption = new Object[1];
    private int _cachedEventThreadPriority;
    private int _cachedReceiverPoolThreadPriority;
    private int _cachedDatabaseThreadPriority;
    private boolean _isPublisherThreadPriorityCached = false;
    private int _cachedAsynchronousPublisherThreadPriority;
    private int _cachedAsynchronousPublisherBatchThreadPriority;
    private boolean[] _needsEnableOut = new boolean[1];
    private Collection _dynamicDataTypeSupportsToPreventGC = null;
    private final Object _dynamicDataTypeSupportLock = new Object();

    public static native Object get_participantI(long var0);

    public void get_default_flowcontroller_property(FlowControllerProperty_t flowControllerProperty_t) {
        this.check_aliveI();
        long l = this.get_native_pointer();
        long l2 = DomainParticipantImpl.get_scratchpad_flowcontroller_propertyI(l);
        int n = DomainParticipantImpl.DDS_DomainParticipant_get_default_flowcontroller_propertyI(l, l2);
        RETCODE_ERROR.check_return_codeI(n);
        flowControllerProperty_t.pull_from_nativeI(l2);
    }

    public void set_default_flowcontroller_property(FlowControllerProperty_t flowControllerProperty_t) {
        this.check_aliveI();
        boolean bl = flowControllerProperty_t == FLOW_CONTROLLER_PROPERTY_DEFAULT;
        long l = this.get_native_pointer();
        long l2 = 0L;
        if (!bl) {
            l2 = DomainParticipantImpl.get_scratchpad_flowcontroller_propertyI(l);
            flowControllerProperty_t.push_to_nativeI(l2);
        }
        int n = DomainParticipantImpl.DDS_DomainParticipant_set_default_flowcontroller_propertyI(l, l2, bl);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void get_default_topic_qos(TopicQos topicQos) {
        this._topicFactory.get_untypedI(topicQos, null);
    }

    public void get_default_topic_qos_w_topic_name(TopicQos topicQos, String string) {
        this._topicFactory.get_untypedI(topicQos, string);
    }

    public void set_default_topic_qos(TopicQos topicQos) {
        boolean bl = topicQos == TOPIC_QOS_DEFAULT;
        this._topicFactory.set_untypedI(topicQos, bl, false, null);
    }

    public void set_default_topic_qos_with_profile(String string, String string2) {
        this.check_aliveI();
        if (string2 == null) {
            string2 = this.get_default_profile();
            string = this.get_default_profile_library();
        }
        if (string2 == null) {
            Utilities.rethrow(NULL_PROFILE);
            return;
        }
        if (string == null && (string = this.get_default_library()) == null) {
            Utilities.rethrow(NULL_LIBRARY);
            return;
        }
        TopicQos topicQos = new TopicQos();
        this._topicFactory.set_untypedI(topicQos, false, true, new Object[]{string, string2});
        topicQos = null;
    }

    public void get_default_publisher_qos(PublisherQos publisherQos) {
        this._publisherFactory.get_untypedI(publisherQos);
        if (this._isPublisherThreadPriorityCached) {
            publisherQos.asynchronous_publisher.thread.priority = this._cachedAsynchronousPublisherThreadPriority;
            publisherQos.asynchronous_publisher.asynchronous_batch_thread.priority = this._cachedAsynchronousPublisherBatchThreadPriority;
        } else {
            this._cachedAsynchronousPublisherThreadPriority = publisherQos.asynchronous_publisher.thread.priority;
            this._cachedAsynchronousPublisherBatchThreadPriority = publisherQos.asynchronous_publisher.asynchronous_batch_thread.priority;
            this._isPublisherThreadPriorityCached = true;
        }
    }

    public void set_default_publisher_qos(PublisherQos publisherQos) {
        boolean bl = publisherQos == PUBLISHER_QOS_DEFAULT;
        this._publisherFactory.set_untypedI(publisherQos, bl, false, null);
        if (!bl) {
            this._cachedAsynchronousPublisherThreadPriority = publisherQos.asynchronous_publisher.thread.priority;
            this._cachedAsynchronousPublisherBatchThreadPriority = publisherQos.asynchronous_publisher.asynchronous_batch_thread.priority;
            this._isPublisherThreadPriorityCached = true;
        } else {
            this._isPublisherThreadPriorityCached = false;
        }
    }

    public void set_default_publisher_qos_with_profile(String string, String string2) {
        this.check_aliveI();
        if (string2 == null) {
            string2 = this.get_default_profile();
            string = this.get_default_profile_library();
        }
        if (string2 == null) {
            Utilities.rethrow(NULL_PROFILE);
            return;
        }
        if (string == null && (string = this.get_default_library()) == null) {
            Utilities.rethrow(NULL_LIBRARY);
            return;
        }
        PublisherQos publisherQos = new PublisherQos();
        DomainParticipantFactory.get_instance().get_publisher_qos_from_profile(publisherQos, string, string2);
        this.set_default_publisher_qos(publisherQos);
        publisherQos = null;
    }

    public void get_default_datawriter_qos(DataWriterQos dataWriterQos) {
        this._dataWriterQos.get_untypedI(dataWriterQos, null);
    }

    public void get_default_datawriter_qos_w_topic_name(DataWriterQos dataWriterQos, String string) {
        this._dataWriterQos.get_untypedI(dataWriterQos, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_default_datawriter_qos(DataWriterQos dataWriterQos) {
        boolean bl = dataWriterQos == Publisher.DATAWRITER_QOS_DEFAULT;
        this.lock();
        try {
            this._serializeOption[0] = bl ? null : dataWriterQos.type_support.plugin_data;
            this._dataWriterQos.set_untypedI(dataWriterQos, bl, false, this._serializeOption);
        }
        finally {
            this.unlock();
        }
    }

    public void set_default_datawriter_qos_with_profile(String string, String string2) {
        this.check_aliveI();
        if (string2 == null) {
            string2 = this.get_default_profile();
            string = this.get_default_profile_library();
        }
        if (string2 == null) {
            Utilities.rethrow(NULL_PROFILE);
            return;
        }
        if (string == null && (string = this.get_default_library()) == null) {
            Utilities.rethrow(NULL_LIBRARY);
            return;
        }
        DataWriterQos dataWriterQos = new DataWriterQos();
        this._dataWriterQos.set_untypedI(dataWriterQos, false, true, new Object[]{string, string2});
        dataWriterQos = null;
    }

    public void get_default_subscriber_qos(SubscriberQos subscriberQos) {
        this._subscriberFactory.get_untypedI(subscriberQos);
    }

    public void set_default_subscriber_qos(SubscriberQos subscriberQos) {
        boolean bl = subscriberQos == SUBSCRIBER_QOS_DEFAULT;
        this._subscriberFactory.set_untypedI(subscriberQos, bl, false, null);
    }

    public void set_default_subscriber_qos_with_profile(String string, String string2) {
        this.check_aliveI();
        if (string2 == null) {
            string2 = this.get_default_profile();
            string = this.get_default_profile_library();
        }
        if (string2 == null) {
            Utilities.rethrow(NULL_PROFILE);
            return;
        }
        if (string == null && (string = this.get_default_library()) == null) {
            Utilities.rethrow(NULL_LIBRARY);
            return;
        }
        SubscriberQos subscriberQos = new SubscriberQos();
        DomainParticipantFactory.get_instance().get_subscriber_qos_from_profile(subscriberQos, string, string2);
        this.set_default_subscriber_qos(subscriberQos);
        subscriberQos = null;
    }

    public void get_default_datareader_qos(DataReaderQos dataReaderQos) {
        this._dataReaderQos.get_untypedI(dataReaderQos, null);
    }

    public void get_default_datareader_qos_w_topic_name(DataReaderQos dataReaderQos, String string) {
        this._dataReaderQos.get_untypedI(dataReaderQos, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_default_datareader_qos(DataReaderQos dataReaderQos) {
        boolean bl = dataReaderQos == Subscriber.DATAREADER_QOS_DEFAULT;
        this.lock();
        try {
            this._serializeOption[0] = bl ? null : dataReaderQos.type_support.plugin_data;
            this._dataReaderQos.set_untypedI(dataReaderQos, bl, false, this._serializeOption);
        }
        finally {
            this.unlock();
        }
    }

    public void set_default_datareader_qos_with_profile(String string, String string2) {
        this.check_aliveI();
        if (string2 == null) {
            string2 = this.get_default_profile();
            string = this.get_default_profile_library();
        }
        if (string2 == null) {
            Utilities.rethrow(NULL_PROFILE);
            return;
        }
        if (string == null && (string = this.get_default_library()) == null) {
            Utilities.rethrow(NULL_LIBRARY);
            return;
        }
        DataReaderQos dataReaderQos = new DataReaderQos();
        this._dataReaderQos.set_untypedI(dataReaderQos, false, true, new Object[]{string, string2});
        dataReaderQos = null;
    }

    public FlowController create_flowcontroller(String string, FlowControllerProperty_t flowControllerProperty_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(string);
        this.check_for_null_argumentI(flowControllerProperty_t);
        long l = this.get_native_pointer();
        long l2 = DomainParticipantImpl.get_scratchpad_flowcontroller_propertyI(l);
        flowControllerProperty_t.push_to_nativeI(l2);
        boolean bl = flowControllerProperty_t == FLOW_CONTROLLER_PROPERTY_DEFAULT;
        long l3 = DomainParticipantImpl.DDS_DomainParticipant_create_flowcontrollerI(l, string, l2, bl);
        if (l3 == 0L) {
            return null;
        }
        FlowControllerImpl flowControllerImpl = null;
        try {
            flowControllerImpl = new FlowControllerImpl(l3);
            int n = DomainParticipantImpl.initialize_native_to_java_flowcontroller_pointerI(l, l3, flowControllerImpl);
            RETCODE_ERROR.check_return_codeI(n);
        }
        catch (Throwable throwable) {
            try {
                DomainParticipantImpl.DDS_DomainParticipant_delete_flowcontrollerI(l, l3);
            }
            catch (Throwable throwable2) {
                ModuleLogger.DDS.log(1, this.getClass(), "create_flowcontroller", "!delete partially created flow controller");
                ModuleLogger.DDS.logStackTrace(this.getClass(), "create_flowcontroller", throwable);
            }
            try {
                throw throwable;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Utilities.rethrow(OUT_OF_MEMORY);
            }
            catch (Error error) {
                throw error;
            }
            catch (Throwable throwable3) {
                throw new IllegalArgumentException("Checked exception when expecting unchecked (" + throwable3.getMessage() + ")");
            }
        }
        if (flowControllerImpl == null) {
            return null;
        }
        return flowControllerImpl;
    }

    public void delete_flowcontroller(FlowController flowController) {
        this.check_aliveI();
        if (flowController == null) {
            return;
        }
        NativeObject nativeObject = (NativeObject)((Object)flowController);
        AbstractNativeObject.check_aliveI(nativeObject);
        nativeObject.before_delete_native();
        int n = DomainParticipantImpl.DDS_DomainParticipant_delete_flowcontrollerI(this.get_native_pointer(), nativeObject.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
        nativeObject.after_delete_native();
    }

    public Publisher create_publisher(PublisherQos publisherQos, PublisherListener publisherListener, int n) {
        boolean bl = publisherQos == PUBLISHER_QOS_DEFAULT;
        PublisherImpl publisherImpl = (PublisherImpl)this._publisherFactory.create_entityI(publisherQos, bl, publisherListener, n, null);
        if (publisherImpl != null) {
            if (bl) {
                PublisherQos publisherQos2 = new PublisherQos();
                this.get_default_publisher_qos(publisherQos2);
                publisherImpl.cache_qos(publisherQos2);
            } else {
                publisherImpl.cache_qos(publisherQos);
            }
        }
        return publisherImpl;
    }

    public Publisher create_publisher_with_profile(String string, String string2, PublisherListener publisherListener, int n) {
        this.check_aliveI();
        PublisherQos publisherQos = new PublisherQos();
        Publisher publisher = null;
        if (string2 == null) {
            string2 = DomainParticipantImpl.DDS_DomainParticipant_get_default_profile(this.get_native_pointer());
            string = DomainParticipantImpl.DDS_DomainParticipant_get_default_profile_library(this.get_native_pointer());
        }
        if (string2 == null) {
            Utilities.rethrow(NULL_PROFILE);
            return null;
        }
        if (string == null && (string = DomainParticipantImpl.DDS_DomainParticipant_get_default_library(this.get_native_pointer())) == null) {
            Utilities.rethrow(NULL_LIBRARY);
            return null;
        }
        DomainParticipantFactory.get_instance().get_publisher_qos_from_profile(publisherQos, string, string2);
        publisher = this.create_publisher(publisherQos, publisherListener, n);
        publisherQos = null;
        return publisher;
    }

    public void delete_publisher(Publisher publisher) {
        this._publisherFactory.delete_entityI(publisher);
    }

    public Subscriber create_subscriber(SubscriberQos subscriberQos, SubscriberListener subscriberListener, int n) {
        boolean bl = subscriberQos == SUBSCRIBER_QOS_DEFAULT;
        return (Subscriber)this._subscriberFactory.create_entityI(subscriberQos, bl, subscriberListener, n, null);
    }

    public Subscriber create_subscriber_with_profile(String string, String string2, SubscriberListener subscriberListener, int n) {
        this.check_aliveI();
        SubscriberQos subscriberQos = new SubscriberQos();
        Subscriber subscriber = null;
        if (string2 == null) {
            string2 = DomainParticipantImpl.DDS_DomainParticipant_get_default_profile(this.get_native_pointer());
            string = DomainParticipantImpl.DDS_DomainParticipant_get_default_profile_library(this.get_native_pointer());
        }
        if (string2 == null) {
            Utilities.rethrow(NULL_PROFILE);
            return null;
        }
        if (string == null && (string = DomainParticipantImpl.DDS_DomainParticipant_get_default_library(this.get_native_pointer())) == null) {
            Utilities.rethrow(NULL_LIBRARY);
            return null;
        }
        DomainParticipantFactory.get_instance().get_subscriber_qos_from_profile(subscriberQos, string, string2);
        subscriber = this.create_subscriber(subscriberQos, subscriberListener, n);
        subscriberQos = null;
        return subscriber;
    }

    public void delete_subscriber(Subscriber subscriber) {
        this._subscriberFactory.delete_entityI(subscriber);
    }

    public DataWriter create_datawriter(Topic topic, DataWriterQos dataWriterQos, DataWriterListener dataWriterListener, int n) {
        PublisherImpl publisherImpl = null;
        publisherImpl = (PublisherImpl)this.get_implicit_publisher();
        if (publisherImpl == null) {
            return null;
        }
        return publisherImpl.create_datawriter(topic, dataWriterQos, dataWriterListener, n);
    }

    public DataWriter create_datawriter_with_profile(Topic topic, String string, String string2, DataWriterListener dataWriterListener, int n) {
        PublisherImpl publisherImpl = null;
        publisherImpl = (PublisherImpl)this.get_implicit_publisher();
        if (publisherImpl == null) {
            return null;
        }
        return publisherImpl.create_datawriter_with_profile(topic, string, string2, dataWriterListener, n);
    }

    public void delete_datawriter(DataWriter dataWriter) {
        PublisherImpl publisherImpl = null;
        publisherImpl = (PublisherImpl)this.get_implicit_publisher();
        if (publisherImpl == null) {
            return;
        }
        publisherImpl.delete_datawriter(dataWriter);
    }

    public DataReader create_datareader(TopicDescription topicDescription, DataReaderQos dataReaderQos, DataReaderListener dataReaderListener, int n) {
        SubscriberImpl subscriberImpl = null;
        subscriberImpl = (SubscriberImpl)this.get_implicit_subscriber();
        if (subscriberImpl == null) {
            return null;
        }
        return subscriberImpl.create_datareader(topicDescription, dataReaderQos, dataReaderListener, n);
    }

    public DataReader create_datareader_with_profile(TopicDescription topicDescription, String string, String string2, DataReaderListener dataReaderListener, int n) {
        SubscriberImpl subscriberImpl = null;
        subscriberImpl = (SubscriberImpl)this.get_implicit_subscriber();
        if (subscriberImpl == null) {
            return null;
        }
        return subscriberImpl.create_datareader_with_profile(topicDescription, string, string2, dataReaderListener, n);
    }

    public void delete_datareader(DataReader dataReader) {
        SubscriberImpl subscriberImpl = null;
        subscriberImpl = (SubscriberImpl)this.get_implicit_subscriber();
        if (subscriberImpl == null) {
            return;
        }
        subscriberImpl.delete_datareader(dataReader);
    }

    public void get_publishers(PublisherSeq publisherSeq) {
        this.check_aliveI();
        this.check_for_null_argumentI(publisherSeq);
        int n = DomainParticipantImpl.DDS_DomainParticipant_get_publishers(this.get_native_pointer(), publisherSeq.getNativeSequence());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void get_subscribers(SubscriberSeq subscriberSeq) {
        this.check_aliveI();
        this.check_for_null_argumentI(subscriberSeq);
        int n = DomainParticipantImpl.DDS_DomainParticipant_get_subscribers(this.get_native_pointer(), subscriberSeq.getNativeSequence());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public Topic create_topic(String string, String string2, TopicQos topicQos, TopicListener topicListener, int n) {
        boolean bl = topicQos == TOPIC_QOS_DEFAULT;
        return (Topic)this._topicFactory.create_entityI(topicQos, bl, topicListener, n, new Object[]{string, string2});
    }

    public Topic create_topic_with_profile(String string, String string2, String string3, String string4, TopicListener topicListener, int n) {
        this.check_aliveI();
        TopicQos topicQos = new TopicQos();
        Topic topic = null;
        if (string4 == null) {
            string4 = DomainParticipantImpl.DDS_DomainParticipant_get_default_profile(this.get_native_pointer());
            string3 = DomainParticipantImpl.DDS_DomainParticipant_get_default_profile_library(this.get_native_pointer());
        }
        if (string4 == null) {
            Utilities.rethrow(NULL_PROFILE);
            return null;
        }
        if (string3 == null && (string3 = DomainParticipantImpl.DDS_DomainParticipant_get_default_library(this.get_native_pointer())) == null) {
            Utilities.rethrow(NULL_LIBRARY);
            return null;
        }
        DomainParticipantFactory.get_instance().get_topic_qos_from_profile_w_topic_name(topicQos, string3, string4, string);
        topic = this.create_topic(string, string2, topicQos, topicListener, n);
        topicQos = null;
        return topic;
    }

    public void delete_topic(Topic topic) {
        this._topicFactory.delete_entityI(topic);
    }

    public ContentFilteredTopic create_contentfilteredtopic(String string, Topic topic, String string2, StringSeq stringSeq) {
        return this.create_contentfilteredtopic_with_filter(string, topic, string2, stringSeq, "DDSSQL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentFilteredTopic create_contentfilteredtopic_with_filter(String string, Topic topic, String string2, StringSeq stringSeq, String string3) {
        this.check_aliveI();
        this.check_for_null_argumentI(string);
        this.check_for_null_argumentI(topic);
        this.check_for_null_argumentI(string2);
        AbstractNativeObject.check_aliveI((NativeObject)((Object)topic));
        if (stringSeq == null) {
            stringSeq = new StringSeq();
        }
        long l = this.get_native_pointer();
        long l2 = ((NativeObject)((Object)topic)).get_native_pointer();
        long l3 = DomainParticipantImpl.get_scratchpad_filter_parametersI(l);
        long l4 = 0L;
        try {
            stringSeq.push_to_nativeI(l3);
            l4 = DomainParticipantImpl.DDS_DomainParticipant_create_contentfilteredtopic_with_filter(l, string, l2, string2, l3, string3);
        }
        catch (Exception exception) {
            ModuleLogger.DDS.log(1, this.getClass(), "create_contentfilteredtopic_with_filter", "!" + exception.getMessage());
        }
        finally {
            DomainParticipantImpl.return_scratchpad_filter_parametersI(l, l3);
        }
        if (l4 == 0L) {
            return null;
        }
        ContentFilteredTopicImpl contentFilteredTopicImpl = null;
        try {
            contentFilteredTopicImpl = new ContentFilteredTopicImpl(l4);
            int n = DomainParticipantImpl.initialize_native_to_java_contentfilteredtopic_pointer(l, l4, contentFilteredTopicImpl);
            RETCODE_ERROR.check_return_codeI(n);
        }
        catch (Throwable throwable) {
            try {
                DomainParticipantImpl.DDS_DomainParticipant_delete_contentfilteredtopic(l, l4);
            }
            catch (Throwable throwable2) {
                ModuleLogger.DDS.log(1, this.getClass(), "create_contentfilteredtopic_with_filter", "!delete partially created content filtered topic");
                ModuleLogger.DDS.logStackTrace(this.getClass(), "create_contentfilteredtopic_with_filter", throwable);
            }
            try {
                throw throwable;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Utilities.rethrow(OUT_OF_MEMORY);
            }
            catch (Error error) {
                throw error;
            }
            catch (Throwable throwable3) {
                throw new IllegalArgumentException("Checked exception when expecting unchecked (" + throwable3.getMessage() + ")");
            }
        }
        return contentFilteredTopicImpl;
    }

    public void delete_contentfilteredtopic(ContentFilteredTopic contentFilteredTopic) {
        this.check_aliveI();
        if (contentFilteredTopic == null) {
            return;
        }
        NativeObject nativeObject = (NativeObject)((Object)contentFilteredTopic);
        AbstractNativeObject.check_aliveI(nativeObject);
        nativeObject.before_delete_native();
        int n = DomainParticipantImpl.DDS_DomainParticipant_delete_contentfilteredtopic(this.get_native_pointer(), nativeObject.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
        nativeObject.after_delete_native();
    }

    public MultiTopic create_multitopic(String string, String string2, String string3, StringSeq stringSeq) {
        this.check_aliveI();
        throw UNSUPPORTED_ERROR;
    }

    public void delete_multitopic(MultiTopic multiTopic) {
        this.check_aliveI();
        throw UNSUPPORTED_ERROR;
    }

    public void get_qos(DomainParticipantQos domainParticipantQos) {
        this.get_untyped_qos(domainParticipantQos);
        domainParticipantQos.event.thread.priority = this._cachedEventThreadPriority;
        domainParticipantQos.receiver_pool.thread.priority = this._cachedReceiverPoolThreadPriority;
        domainParticipantQos.database.thread.priority = this._cachedDatabaseThreadPriority;
    }

    public void set_qos(DomainParticipantQos domainParticipantQos) {
        boolean bl;
        boolean bl2 = bl = domainParticipantQos == DomainParticipantFactory.PARTICIPANT_QOS_DEFAULT;
        if (!bl) {
            if (domainParticipantQos.event.thread.priority != this._cachedEventThreadPriority || domainParticipantQos.receiver_pool.thread.priority != this._cachedReceiverPoolThreadPriority || domainParticipantQos.database.thread.priority != this._cachedDatabaseThreadPriority) {
                Utilities.rethrow(IMMUTABLE_QOS);
            }
        } else {
            DomainParticipantFactory.TheParticipantFactory.get_default_participant_qos(domainParticipantQos);
            bl = false;
        }
        this.set_untyped_qos(domainParticipantQos, bl, new Object[]{domainParticipantQos.type_support.plugin_data});
    }

    public void set_qos_with_profile(String string, String string2) {
        DomainParticipantQos domainParticipantQos = new DomainParticipantQos();
        this.check_aliveI();
        if (string2 == null) {
            string2 = DomainParticipantImpl.DDS_DomainParticipant_get_default_profile(this.get_native_pointer());
            string = DomainParticipantImpl.DDS_DomainParticipant_get_default_profile_library(this.get_native_pointer());
        }
        if (string2 == null) {
            Utilities.rethrow(NULL_PROFILE);
            return;
        }
        if (string == null && (string = DomainParticipantImpl.DDS_DomainParticipant_get_default_library(this.get_native_pointer())) == null) {
            Utilities.rethrow(NULL_LIBRARY);
            return;
        }
        DomainParticipantFactory.get_instance().get_participant_qos_from_profile(domainParticipantQos, string, string2);
        this.set_qos(domainParticipantQos);
        domainParticipantQos = null;
    }

    public String get_default_library() {
        this.check_aliveI();
        String string = DomainParticipantImpl.DDS_DomainParticipant_get_default_library(this.get_native_pointer());
        return string;
    }

    public void set_default_library(String string) {
        this.check_aliveI();
        int n = DomainParticipantImpl.DDS_DomainParticipant_set_default_library(this.get_native_pointer(), string);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public String get_default_profile() {
        this.check_aliveI();
        String string = DomainParticipantImpl.DDS_DomainParticipant_get_default_profile(this.get_native_pointer());
        return string;
    }

    public void set_default_profile(String string, String string2) {
        this.check_aliveI();
        int n = DomainParticipantImpl.DDS_DomainParticipant_set_default_profile(this.get_native_pointer(), string, string2);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public String get_default_profile_library() {
        this.check_aliveI();
        String string = DomainParticipantImpl.DDS_DomainParticipant_get_default_profile_library(this.get_native_pointer());
        return string;
    }

    public void add_peer(String string) {
        this.check_aliveI();
        this.check_for_null_argumentI(string);
        long l = this.get_native_pointer();
        int n = DomainParticipantImpl.DDS_DomainParticipant_add_peer(l, string);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void remove_peer(String string) {
        this.check_aliveI();
        this.check_for_null_argumentI(string);
        long l = this.get_native_pointer();
        int n = DomainParticipantImpl.DDS_DomainParticipant_remove_peer(l, string);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public DomainParticipantListener get_listener() {
        return (DomainParticipantListener)this.get_untyped_listenerI();
    }

    public void set_listener(DomainParticipantListener domainParticipantListener, int n) {
        this.set_untyped_listenerI(domainParticipantListener, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscriber get_builtin_subscriber() {
        if (!this.is_alive()) {
            return null;
        }
        Subscriber subscriber = null;
        this.lock();
        try {
            long l = DomainParticipantImpl.DDS_DomainParticipant_get_builtin_subscriberI(this.get_native_pointer(), this._needsEnableOut, true);
            if (l != 0L && (subscriber = (Subscriber)SubscriberImpl.get_subscriberI(l)) == null) {
                subscriber = (Subscriber)this._subscriberFactory.wrap_with_java_entity(l, null, 0, null);
                if (this._needsEnableOut[0]) {
                    subscriber.enable();
                }
            }
        }
        finally {
            this.unlock();
        }
        return subscriber;
    }

    public FlowController lookup_flowcontroller(String string) {
        this.check_aliveI();
        long l = this.get_native_pointer();
        long l2 = DomainParticipantImpl.DDS_DomainParticipant_lookup_flowcontrollerI(l, string);
        if (l2 == 0L) {
            return null;
        }
        FlowControllerImpl flowControllerImpl = (FlowControllerImpl)DomainParticipantImpl.get_native_to_java_flowcontroller_pointerI(l, l2);
        if (flowControllerImpl == null) {
            try {
                flowControllerImpl = new FlowControllerImpl(l2);
                int n = DomainParticipantImpl.initialize_native_to_java_flowcontroller_pointerI(l, l2, flowControllerImpl);
                RETCODE_ERROR.check_return_codeI(n);
            }
            catch (Throwable throwable) {
                try {
                    DomainParticipantImpl.DDS_DomainParticipant_delete_flowcontrollerI(l, l2);
                }
                catch (Throwable throwable2) {
                    ModuleLogger.DDS.log(1, this.getClass(), "lookup_flowcontroller", "!delete partially created flow controller");
                    ModuleLogger.DDS.logStackTrace(this.getClass(), "lookup_flowcontroller", throwable);
                }
                try {
                    throw throwable;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Utilities.rethrow(OUT_OF_MEMORY);
                }
                catch (Error error) {
                    throw error;
                }
                catch (Throwable throwable3) {
                    throw new IllegalArgumentException("Checked exception when expecting unchecked (" + throwable3.getMessage() + ")");
                }
            }
        }
        return flowControllerImpl;
    }

    public Topic find_topic(String string, Duration_t duration_t) {
        if (!this.is_alive() || duration_t == null || string == null) {
            return null;
        }
        long l = 0L;
        long l2 = DomainParticipantImpl.get_scratchpad_durationI(this.get_native_pointer());
        duration_t.push_to_nativeI(l2);
        l = DomainParticipantImpl.DDS_DomainParticipant_find_topic(this.get_native_pointer(), string, l2);
        Topic topic = l == 0L ? null : (Topic)TopicImpl.get_topicI(l);
        return topic;
    }

    public TopicDescription lookup_topicdescription(String string) {
        if (!this.is_alive() || string == null) {
            return null;
        }
        return this.lookup_topicdescriptionI(string, true);
    }

    public void ignore_participant(InstanceHandle_t instanceHandle_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(instanceHandle_t);
        int n = DomainParticipantImpl.DDS_DomainParticipant_ignore_participant(this.get_native_pointer(), instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void ignore_topic(InstanceHandle_t instanceHandle_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(instanceHandle_t);
        int n = DomainParticipantImpl.DDS_DomainParticipant_ignore_topic(this.get_native_pointer(), instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void ignore_publication(InstanceHandle_t instanceHandle_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(instanceHandle_t);
        int n = DomainParticipantImpl.DDS_DomainParticipant_ignore_publication(this.get_native_pointer(), instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void ignore_subscription(InstanceHandle_t instanceHandle_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(instanceHandle_t);
        int n = DomainParticipantImpl.DDS_DomainParticipant_ignore_subscription(this.get_native_pointer(), instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public int get_domain_id() {
        this.check_aliveI();
        return DomainParticipantImpl.DDS_DomainParticipant_get_domain_id(this.get_native_pointer());
    }

    public void assert_liveliness() {
        this.check_aliveI();
        long l = this.get_native_pointer();
        int n = DomainParticipantImpl.DDS_DomainParticipant_assert_liveliness(l);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void delete_contained_entities() {
        this.check_aliveI();
        int n = DomainParticipantImpl.DDS_DomainParticipant_delete_contained_entities(this.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void start_database_interactive_shellI() {
        this.check_aliveI();
        DomainParticipantImpl.DDS_DomainParticipant_start_database_interactive_shellI(this.get_native_pointer());
    }

    public void get_current_time(Time_t time_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(time_t);
        long l = DomainParticipantImpl.get_scratchpad_timeI(this.get_native_pointer());
        int n = DomainParticipantImpl.DDS_DomainParticipant_get_current_time(this.get_native_pointer(), l);
        RETCODE_ERROR.check_return_codeI(n);
        time_t.pull_from_nativeI(l);
    }

    public void get_discovered_participants(InstanceHandleSeq instanceHandleSeq) {
        this.check_aliveI();
        this.check_for_null_argumentI(instanceHandleSeq);
        long l = this.get_native_pointer();
        long l2 = DomainParticipantImpl.get_scratchpad_handlesI(l);
        int n = DomainParticipantImpl.DDS_DomainParticipant_get_discovered_participants(l, l2);
        RETCODE_ERROR.check_return_codeI(n);
        instanceHandleSeq.pull_from_nativeI(l2);
    }

    public void get_discovered_participant_data(ParticipantBuiltinTopicData participantBuiltinTopicData, InstanceHandle_t instanceHandle_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(participantBuiltinTopicData);
        this.check_for_null_argumentI(instanceHandle_t);
        long l = this.get_native_pointer();
        long l2 = DomainParticipantImpl.get_scratchpad_participant_dataI(l);
        int n = DomainParticipantImpl.DDS_DomainParticipant_get_discovered_participant_data(l, l2, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
        RETCODE_ERROR.check_return_codeI(n);
        participantBuiltinTopicData.pull_from_nativeI(l2);
        DomainParticipantImpl.DDS_ParticipantBuiltinTopicData_finalize(l2);
    }

    public void get_discovered_topics(InstanceHandleSeq instanceHandleSeq) {
        this.check_aliveI();
        this.check_for_null_argumentI(instanceHandleSeq);
        long l = this.get_native_pointer();
        long l2 = DomainParticipantImpl.get_scratchpad_handlesI(l);
        int n = DomainParticipantImpl.DDS_DomainParticipant_get_discovered_topics(l, l2);
        RETCODE_ERROR.check_return_codeI(n);
        instanceHandleSeq.pull_from_nativeI(l2);
    }

    public void get_discovered_topic_data(TopicBuiltinTopicData topicBuiltinTopicData, InstanceHandle_t instanceHandle_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(topicBuiltinTopicData);
        this.check_for_null_argumentI(instanceHandle_t);
        long l = this.get_native_pointer();
        long l2 = DomainParticipantImpl.get_scratchpad_topic_dataI(l);
        int n = DomainParticipantImpl.DDS_DomainParticipant_get_discovered_topic_data(l, l2, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
        RETCODE_ERROR.check_return_codeI(n);
        topicBuiltinTopicData.pull_from_nativeI(l2);
    }

    public boolean contains_entity(InstanceHandle_t instanceHandle_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(instanceHandle_t);
        long l = this.get_native_pointer();
        return DomainParticipantImpl.DDS_DomainParticipant_contains_entity(l, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
    }

    public void register_durable_subscription(EndpointGroup_t endpointGroup_t, String string) {
        this.check_aliveI();
        this.check_for_null_argumentI(endpointGroup_t);
        this.check_for_null_argumentI(string);
        long l = this.get_native_pointer();
        int n = DomainParticipantImpl.DDS_DomainParticipant_register_durable_subscription(l, endpointGroup_t.role_name, endpointGroup_t.quorum_count, string);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void delete_durable_subscription(EndpointGroup_t endpointGroup_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(endpointGroup_t);
        long l = this.get_native_pointer();
        int n = DomainParticipantImpl.DDS_DomainParticipant_delete_durable_subscription(l, endpointGroup_t.role_name, endpointGroup_t.quorum_count);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void register_contentfilter(String string, ContentFilter contentFilter) {
        this.check_aliveI();
        this.check_for_null_argumentI(string);
        this.check_for_null_argumentI(contentFilter);
        int n = DomainParticipantImpl.DDS_DomainParticipant_register_contentfilter(this.get_native_pointer(), string, contentFilter);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void register_type(String string, TypeSupport typeSupport, Object object) {
        this.check_aliveI();
        this.check_for_null_argumentI(string);
        this.check_for_null_argumentI(typeSupport);
        if (typeSupport instanceof DynamicDataTypeSupport) {
            ((DynamicDataTypeSupport)typeSupport).register_type(this, string);
        } else {
            TypeSupportImpl.register_type_globalI((TypeSupportImpl)typeSupport, this, string, object);
        }
    }

    public void unregister_type(String string) {
        this.check_aliveI();
        this.check_for_null_argumentI(string);
        TypeSupportImpl typeSupportImpl = TypeSupportImpl.get_data_typeI(this.get_native_pointer(), string);
        if (typeSupportImpl instanceof DynamicDataTypeSupport) {
            ((DynamicDataTypeSupport)typeSupportImpl).unregister_type(this, string);
        } else {
            TypeSupportImpl.unregister_type_globalI(this, string);
        }
    }

    public TypeCode get_typecode(String string) {
        long l = DomainParticipantImpl.DDS_DomainParticipant_get_typecode(this.get_native_pointer(), string);
        if (l != 0L) {
            return TypeCode.create_from_native(l);
        }
        return null;
    }

    public ContentFilter lookup_contentfilter(String string) {
        this.check_aliveI();
        this.check_for_null_argumentI(string);
        ContentFilter contentFilter = DomainParticipantImpl.DDS_DomainParticipant_lookup_contentfilter(this.get_native_pointer(), string);
        return contentFilter;
    }

    public void unregister_contentfilter(String string) {
        this.check_aliveI();
        this.check_for_null_argumentI(string);
        int n = DomainParticipantImpl.DDS_DomainParticipant_unregister_contentfilter(this.get_native_pointer(), string);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void before_delete_native() {
        int n = DomainParticipantImpl.DDS_DomainParticipant_disableI(this.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
        this.destroy_implicit_entitiesI();
        DomainParticipantImpl.DDS_DomainParticipant_set_implicit_entities_nullI(this.get_native_pointer());
        this.destroy_builtin_entitiesI();
        DomainParticipantImpl.DDS_DomainParticipant_set_builtin_entities_nullI(this.get_native_pointer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after_delete_native() {
        this.clear_native_pointer();
        Object object = this._dynamicDataTypeSupportLock;
        synchronized (object) {
            if (this._dynamicDataTypeSupportsToPreventGC != null) {
                this._dynamicDataTypeSupportsToPreventGC.clear();
                this._dynamicDataTypeSupportsToPreventGC = null;
            }
        }
        this._topicFactory.cleanup();
        this._publisherFactory.cleanup();
        this._subscriberFactory.cleanup();
        this._dataWriterQos.cleanup();
        this._dataReaderQos.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remember_type_support(DynamicDataTypeSupport dynamicDataTypeSupport) {
        Object object = this._dynamicDataTypeSupportLock;
        synchronized (object) {
            if (this._dynamicDataTypeSupportsToPreventGC == null) {
                this._dynamicDataTypeSupportsToPreventGC = new ArrayList();
            }
            this._dynamicDataTypeSupportsToPreventGC.add(dynamicDataTypeSupport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget_type_support(DynamicDataTypeSupport dynamicDataTypeSupport) {
        Object object = this._dynamicDataTypeSupportLock;
        synchronized (object) {
            if (this._dynamicDataTypeSupportsToPreventGC != null) {
                this._dynamicDataTypeSupportsToPreventGC.remove(dynamicDataTypeSupport);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Publisher get_implicit_publisher() {
        if (!this.is_alive()) {
            return null;
        }
        Publisher publisher = null;
        this.lock();
        try {
            long l = DomainParticipantImpl.DDS_DomainParticipant_get_implicit_publisherI(this.get_native_pointer(), this._needsEnableOut, true);
            if (l != 0L && (publisher = (Publisher)PublisherImpl.get_publisherI(l)) == null) {
                publisher = (Publisher)this._publisherFactory.wrap_with_java_entity(l, null, 0, null);
                if (this._needsEnableOut[0]) {
                    publisher.enable();
                }
            }
        }
        catch (RETCODE_ERROR rETCODE_ERROR) {
            ModuleLogger.DDS.logStackTrace(DomainParticipantImpl.class, "get_implicit_publisher", rETCODE_ERROR);
            Publisher publisher2 = null;
            return publisher2;
        }
        finally {
            this.unlock();
        }
        return publisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscriber get_implicit_subscriber() {
        if (!this.is_alive()) {
            return null;
        }
        Subscriber subscriber = null;
        this.lock();
        try {
            long l = DomainParticipantImpl.DDS_DomainParticipant_get_implicit_subscriberI(this.get_native_pointer(), this._needsEnableOut, true);
            if (l != 0L && (subscriber = (Subscriber)SubscriberImpl.get_subscriberI(l)) == null) {
                subscriber = (Subscriber)this._subscriberFactory.wrap_with_java_entity(l, null, 0, null);
                if (this._needsEnableOut[0]) {
                    subscriber.enable();
                }
            }
        }
        catch (RETCODE_ERROR rETCODE_ERROR) {
            ModuleLogger.DDS.logStackTrace(DomainParticipantImpl.class, "get_implicit_subscriber", rETCODE_ERROR);
            Subscriber subscriber2 = null;
            return subscriber2;
        }
        finally {
            this.unlock();
        }
        return subscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topic check_create_and_enable_topic_if_no_existI(String string, String string2) {
        this.check_for_null_argumentI(string);
        this.check_for_null_argumentI(string2);
        if (!this.is_alive()) {
            return null;
        }
        Topic topic = null;
        boolean[] blArray = new boolean[1];
        this.lock();
        try {
            long l = 0L;
            l = DomainParticipantImpl.DDS_DomainParticipant_check_and_create_topic_if_no_existI(this.get_native_pointer(), blArray, this._needsEnableOut, string, string2);
            if (l != 0L) {
                if (blArray[0]) {
                    topic = (Topic)this._topicFactory.wrap_with_java_entity(l, null, 0, null);
                    if (this._needsEnableOut[0]) {
                        topic.enable();
                    }
                } else {
                    topic = (Topic)TopicImpl.get_topicI(l);
                }
            }
        }
        finally {
            this.unlock();
        }
        return topic;
    }

    public Publisher lookup_publisher_by_name(String string) {
        long l = DomainParticipantImpl.DDS_DomainParticipant_lookup_publisher_by_name(this.get_native_pointer(), string);
        if (l != 0L) {
            return (Publisher)PublisherImpl.get_publisherI(l);
        }
        return null;
    }

    public Subscriber lookup_subscriber_by_name(String string) {
        long l = DomainParticipantImpl.DDS_DomainParticipant_lookup_subscriber_by_name(this.get_native_pointer(), string);
        if (l != 0L) {
            return (Subscriber)SubscriberImpl.get_subscriberI(l);
        }
        return null;
    }

    public DataWriter lookup_datawriter_by_name(String string) {
        long l = DomainParticipantImpl.DDS_DomainParticipant_lookup_datawriter_by_name(this.get_native_pointer(), string);
        if (l != 0L) {
            return (DataWriter)DataWriterImpl.get_datawriterI(l);
        }
        return null;
    }

    public DataReader lookup_datareader_by_name(String string) {
        long l = DomainParticipantImpl.DDS_DomainParticipant_lookup_datareader_by_name(this.get_native_pointer(), string);
        if (l != 0L) {
            return (DataReader)DataReaderImpl.get_datareaderI(l);
        }
        return null;
    }

    protected DomainParticipantImpl(long l, DomainParticipantListener domainParticipantListener, int n) {
        super(l, new DomainParticipantListenerImpl(domainParticipantListener, n, l));
        this.initializeQosMixin(new DomainParticipantQosMixin());
        ParticipantBuiltinTopicDataTypeSupport.register_type(this, ParticipantBuiltinTopicDataTypeSupport.get_type_name());
        TopicBuiltinTopicDataTypeSupport.register_type(this, TopicBuiltinTopicDataTypeSupport.get_type_name());
        PublicationBuiltinTopicDataTypeSupport.register_type(this, PublicationBuiltinTopicDataTypeSupport.get_type_name());
        SubscriptionBuiltinTopicDataTypeSupport.register_type(this, SubscriptionBuiltinTopicDataTypeSupport.get_type_name());
    }

    protected void cache_qos(DomainParticipantQos domainParticipantQos) {
        this._cachedEventThreadPriority = domainParticipantQos.event.thread.priority;
        this._cachedReceiverPoolThreadPriority = domainParticipantQos.receiver_pool.thread.priority;
        this._cachedDatabaseThreadPriority = domainParticipantQos.database.thread.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TopicDescription lookup_topicdescriptionI(String string, boolean bl) {
        TopicDescription topicDescription = null;
        this.lock();
        try {
            long l = DomainParticipantImpl.DDS_DomainParticipant_lookup_topicdescriptionI(this.get_native_pointer(), this._needsEnableOut, bl, string);
            if (l == 0L) {
                TopicDescription topicDescription2 = null;
                return topicDescription2;
            }
            topicDescription = (TopicDescription)TopicDescriptionImpl.get_topicdescriptionI(l);
            if (topicDescription == null && bl) {
                long l2 = TopicImpl.DDS_Topic_narrow(l);
                topicDescription = (TopicDescription)((Object)this._topicFactory.wrap_with_java_entity(l2, null, 0, null));
                if (this._needsEnableOut[0]) {
                    ((Topic)topicDescription).enable();
                }
            }
        }
        finally {
            this.unlock();
        }
        return topicDescription;
    }

    private void destroy_builtin_entitiesI() {
        long l = DomainParticipantImpl.DDS_DomainParticipant_get_builtin_subscriberI(this.get_native_pointer(), null, false);
        Subscriber subscriber = null;
        if (l != 0L) {
            subscriber = (Subscriber)SubscriberImpl.get_subscriberI(l);
        }
        Iterator iterator = AbstractBuiltinTopicData.topic_name_iteratorI();
        while (iterator.hasNext()) {
            TopicDescription topicDescription;
            String string = (String)iterator.next();
            if (subscriber != null) {
                ((SubscriberImpl)subscriber).delete_builtin_datareaderI(string);
            }
            if ((topicDescription = this.lookup_topicdescriptionI(string, false)) == null) continue;
            try {
                if (topicDescription instanceof Topic) {
                    this.delete_topic((Topic)topicDescription);
                    continue;
                }
                if (topicDescription instanceof MultiTopic) {
                    this.delete_multitopic((MultiTopic)topicDescription);
                    continue;
                }
                if (topicDescription instanceof ContentFilteredTopic) {
                    this.delete_contentfilteredtopic((ContentFilteredTopic)topicDescription);
                    continue;
                }
                throw new IllegalStateException("Unknown TopicDescription subtype: " + topicDescription.getClass());
            }
            catch (RETCODE_PRECONDITION_NOT_MET rETCODE_PRECONDITION_NOT_MET) {
                ModuleLogger.DDS.log(2, this.getClass(), "destroy_builtin_entitiesI", "Warning: entity still attached to built-in topic");
            }
        }
        this.delete_subscriber(subscriber);
    }

    private void destroy_implicit_entitiesI() {
        long l = DomainParticipantImpl.DDS_DomainParticipant_get_implicit_publisherI(this.get_native_pointer(), null, false);
        Publisher publisher = null;
        if (l != 0L) {
            publisher = (Publisher)PublisherImpl.get_publisherI(l);
            this.delete_publisher(publisher);
        }
        long l2 = DomainParticipantImpl.DDS_DomainParticipant_get_implicit_subscriberI(this.get_native_pointer(), null, false);
        Subscriber subscriber = null;
        if (l2 != 0L) {
            subscriber = (Subscriber)SubscriberImpl.get_subscriberI(l2);
            this.delete_subscriber(subscriber);
        }
    }

    public static native long get_transport_property_holder_udpv4I(long var0);

    public static native long get_transport_property_holder_udpv6I(long var0);

    public static native long get_transport_property_holder_shmemI(long var0);

    private static native long get_scratchpad_flowcontroller_propertyI(long var0);

    private static native int initialize_native_to_java_flowcontroller_pointerI(long var0, long var2, Object var4);

    private static native Object get_native_to_java_flowcontroller_pointerI(long var0, long var2);

    private static native int DDS_DomainParticipant_get_default_flowcontroller_propertyI(long var0, long var2);

    private static native int DDS_DomainParticipant_set_default_flowcontroller_propertyI(long var0, long var2, boolean var4);

    private static native long DDS_DomainParticipant_create_flowcontrollerI(long var0, String var2, long var3, boolean var5);

    private static native int DDS_DomainParticipant_delete_flowcontrollerI(long var0, long var2);

    private static native long DDS_DomainParticipant_lookup_flowcontrollerI(long var0, String var2);

    private static native long DDS_DomainParticipant_create_topic_disabledI(long var0, boolean[] var2, String var3, String var4, long var5, boolean var7, long var8, int var10);

    private static native int DDS_DomainParticipant_delete_topic(long var0, long var2);

    private static native int initialize_native_to_java_topic_pointer(long var0, long var2, Object var4);

    private static native int DDS_DomainParticipant_get_default_topic_qos_w_topic_name(long var0, long var2, String var4);

    private static native int DDS_DomainParticipant_set_default_topic_qos(long var0, long var2, boolean var4);

    private static native int DDS_DomainParticipant_set_default_topic_qos_with_profile(long var0, String var2, String var3);

    private static native long get_scratchpad_topic_qosI(long var0);

    private static native long DDS_DomainParticipant_create_publisher_disabledI(long var0, boolean[] var2, long var3, boolean var5, long var6, int var8);

    private static native int DDS_DomainParticipant_delete_publisher(long var0, long var2);

    private static native int initialize_native_to_java_publisher_pointer(long var0, long var2, Object var4);

    private static native int DDS_DomainParticipant_get_default_publisher_qos(long var0, long var2);

    private static native int DDS_DomainParticipant_set_default_publisher_qos(long var0, long var2, boolean var4);

    private static native long get_scratchpad_publisher_qosI(long var0);

    private static native long DDS_DomainParticipant_create_subscriber_disabledI(long var0, boolean[] var2, long var3, boolean var5, long var6, int var8);

    private static native int DDS_DomainParticipant_delete_subscriber(long var0, long var2);

    private static native int initialize_native_to_java_subscriber_pointer(long var0, long var2, Object var4);

    private static native int DDS_DomainParticipant_get_default_subscriber_qos(long var0, long var2);

    private static native int DDS_DomainParticipant_set_default_subscriber_qos(long var0, long var2, boolean var4);

    private static native long get_scratchpad_subscriber_qosI(long var0);

    private static native int DDS_DomainParticipant_get_default_datawriter_qos_w_topic_name(long var0, long var2, String var4);

    private static native int DDS_DomainParticipant_set_default_datawriter_qos(long var0, long var2, boolean var4, Object var5);

    private static native int DDS_DomainParticipant_set_default_datawriter_qos_with_profile(long var0, String var2, String var3);

    private static native long get_scratchpad_datawriter_qosI(long var0);

    private static native int DDS_DomainParticipant_get_default_datareader_qos_w_topic_name(long var0, long var2, String var4);

    private static native int DDS_DomainParticipant_set_default_datareader_qos(long var0, long var2, boolean var4, Object var5);

    private static native int DDS_DomainParticipant_set_default_datareader_qos_with_profile(long var0, String var2, String var3);

    private static native long get_scratchpad_datareader_qosI(long var0);

    private static native int DDS_DomainParticipant_get_qos(long var0, long var2);

    private static native int DDS_DomainParticipant_set_qos(long var0, long var2, boolean var4, Object var5);

    private static native String DDS_DomainParticipant_get_default_library(long var0);

    private static native int DDS_DomainParticipant_set_default_library(long var0, String var2);

    private static native String DDS_DomainParticipant_get_default_profile(long var0);

    private static native int DDS_DomainParticipant_set_default_profile(long var0, String var2, String var3);

    private static native String DDS_DomainParticipant_get_default_profile_library(long var0);

    private static native long get_scratchpad_participant_qosI(long var0);

    private static native int DDS_DomainParticipant_add_peer(long var0, String var2);

    private static native int DDS_DomainParticipant_remove_peer(long var0, String var2);

    private static native int DDS_DomainParticipant_ignore_participant(long var0, byte[] var2, int var3, boolean var4);

    private static native int DDS_DomainParticipant_ignore_topic(long var0, byte[] var2, int var3, boolean var4);

    private static native int DDS_DomainParticipant_ignore_publication(long var0, byte[] var2, int var3, boolean var4);

    private static native int DDS_DomainParticipant_ignore_subscription(long var0, byte[] var2, int var3, boolean var4);

    private static native long DDS_DomainParticipant_find_topic(long var0, String var2, long var3);

    private static native long get_scratchpad_durationI(long var0);

    private static native long DDS_DomainParticipant_lookup_topicdescriptionI(long var0, boolean[] var2, boolean var3, String var4);

    private static native long DDS_DomainParticipant_get_builtin_subscriberI(long var0, boolean[] var2, boolean var3);

    private static native int DDS_DomainParticipant_get_domain_id(long var0);

    private static native int DDS_DomainParticipant_assert_liveliness(long var0);

    private static native int DDS_DomainParticipant_delete_contained_entities(long var0);

    private static native int DDS_DomainParticipant_disableI(long var0);

    private static native void DDS_DomainParticipant_set_builtin_entities_nullI(long var0);

    private static native void DDS_DomainParticipant_set_implicit_entities_nullI(long var0);

    private static native void DDS_DomainParticipant_start_database_interactive_shellI(long var0);

    private static native long get_scratchpad_timeI(long var0);

    private static native int DDS_DomainParticipant_get_current_time(long var0, long var2);

    private static native long get_scratchpad_handlesI(long var0);

    private static native int DDS_DomainParticipant_get_discovered_participants(long var0, long var2);

    private static native long get_scratchpad_participant_dataI(long var0);

    private static native int DDS_DomainParticipant_get_discovered_participant_data(long var0, long var2, byte[] var4, int var5, boolean var6);

    private static native long DDS_DomainParticipant_lookup_publisher_by_name(long var0, String var2);

    private static native long DDS_DomainParticipant_lookup_subscriber_by_name(long var0, String var2);

    private static native long DDS_DomainParticipant_lookup_datawriter_by_name(long var0, String var2);

    private static native long DDS_DomainParticipant_lookup_datareader_by_name(long var0, String var2);

    private static native long DDS_DomainParticipant_get_typecode(long var0, String var2);

    private static native void DDS_ParticipantBuiltinTopicData_finalize(long var0);

    private static native int DDS_DomainParticipant_get_discovered_topics(long var0, long var2);

    private static native long get_scratchpad_topic_dataI(long var0);

    private static native int DDS_DomainParticipant_get_discovered_topic_data(long var0, long var2, byte[] var4, int var5, boolean var6);

    private static native boolean DDS_DomainParticipant_contains_entity(long var0, byte[] var2, int var3, boolean var4);

    private static native int DDS_DomainParticipant_register_durable_subscription(long var0, String var2, int var3, String var4);

    private static native int DDS_DomainParticipant_delete_durable_subscription(long var0, String var2, int var3);

    private static native long DDS_DomainParticipant_create_contentfilteredtopic_with_filter(long var0, String var2, long var3, String var5, long var6, String var8);

    private static native int DDS_DomainParticipant_delete_contentfilteredtopic(long var0, long var2);

    private static native int DDS_DomainParticipant_register_contentfilter(long var0, String var2, ContentFilter var3);

    private static native int DDS_DomainParticipant_register_dynamicdata_contentfilterI(long var0, String var2);

    private static native ContentFilter DDS_DomainParticipant_lookup_contentfilter(long var0, String var2);

    private static native int DDS_DomainParticipant_unregister_contentfilter(long var0, String var2);

    private static native long get_scratchpad_filter_parametersI(long var0);

    private static native void return_scratchpad_filter_parametersI(long var0, long var2);

    private static native int initialize_native_to_java_contentfilteredtopic_pointer(long var0, long var2, Object var4);

    private static native int DDS_DomainParticipant_get_publishers(long var0, long var2);

    private static native int DDS_DomainParticipant_get_subscribers(long var0, long var2);

    private static native long DDS_DomainParticipant_get_implicit_subscriberI(long var0, boolean[] var2, boolean var3);

    private static native long DDS_DomainParticipant_get_implicit_publisherI(long var0, boolean[] var2, boolean var3);

    private static native long DDS_DomainParticipant_check_and_create_topic_if_no_existI(long var0, boolean[] var2, boolean[] var3, String var4, String var5);

    private final class DataReaderQosMixin
    extends NativeStructMixin {
        public DataReaderQosMixin() {
            super(DomainParticipantImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DomainParticipantImpl.get_scratchpad_datareader_qosI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            String string = (String)object;
            return DomainParticipantImpl.DDS_DomainParticipant_get_default_datareader_qos_w_topic_name(l, l2, string);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            if (bl2) {
                return DomainParticipantImpl.DDS_DomainParticipant_set_default_datareader_qos_with_profile(l, (String)objectArray[0], (String)objectArray[1]);
            }
            return DomainParticipantImpl.DDS_DomainParticipant_set_default_datareader_qos(l, l2, bl, objectArray[0]);
        }
    }

    private final class DataWriterQosMixin
    extends NativeStructMixin {
        public DataWriterQosMixin() {
            super(DomainParticipantImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DomainParticipantImpl.get_scratchpad_datawriter_qosI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            String string = (String)object;
            return DomainParticipantImpl.DDS_DomainParticipant_get_default_datawriter_qos_w_topic_name(l, l2, string);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            if (bl2) {
                return DomainParticipantImpl.DDS_DomainParticipant_set_default_datawriter_qos_with_profile(l, (String)objectArray[0], (String)objectArray[1]);
            }
            return DomainParticipantImpl.DDS_DomainParticipant_set_default_datawriter_qos(l, l2, bl, objectArray[0]);
        }
    }

    private final class SubscriberFactoryMixin
    extends NativeFactoryMixin {
        public SubscriberFactoryMixin() {
            super(DomainParticipantImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DomainParticipantImpl.get_scratchpad_subscriber_qosI(l);
        }

        protected Entity wrap_with_java_entity(long l, Listener listener, int n, Object[] objectArray) {
            return super.wrap_with_java_entity(l, listener, n, objectArray);
        }

        protected long create_native_entity(long l, long l2, boolean bl, long l3, int n, boolean[] blArray, Object[] objectArray) {
            return DomainParticipantImpl.DDS_DomainParticipant_create_subscriber_disabledI(l, blArray, l2, bl, l3, n);
        }

        protected Entity create_java_entity(long l, Listener listener, int n, Object[] objectArray) {
            return new SubscriberImpl(l, (SubscriberListener)listener, n);
        }

        protected int initialize_native_to_java_pointer(long l, Entity entity) {
            return DomainParticipantImpl.initialize_native_to_java_subscriber_pointer(DomainParticipantImpl.this.get_native_pointer(), l, entity);
        }

        protected int destroy_native_entity(long l, long l2) {
            return DomainParticipantImpl.DDS_DomainParticipant_delete_subscriber(l, l2);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DomainParticipantImpl.DDS_DomainParticipant_get_default_subscriber_qos(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return DomainParticipantImpl.DDS_DomainParticipant_set_default_subscriber_qos(l, l2, bl);
        }
    }

    private final class PublisherFactoryMixin
    extends NativeFactoryMixin {
        public PublisherFactoryMixin() {
            super(DomainParticipantImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DomainParticipantImpl.get_scratchpad_publisher_qosI(l);
        }

        protected Entity wrap_with_java_entity(long l, Listener listener, int n, Object[] objectArray) {
            return super.wrap_with_java_entity(l, listener, n, objectArray);
        }

        protected long create_native_entity(long l, long l2, boolean bl, long l3, int n, boolean[] blArray, Object[] objectArray) {
            return DomainParticipantImpl.DDS_DomainParticipant_create_publisher_disabledI(l, blArray, l2, bl, l3, n);
        }

        protected Entity create_java_entity(long l, Listener listener, int n, Object[] objectArray) {
            return new PublisherImpl(l, (PublisherListener)listener, n);
        }

        protected int initialize_native_to_java_pointer(long l, Entity entity) {
            return DomainParticipantImpl.initialize_native_to_java_publisher_pointer(DomainParticipantImpl.this.get_native_pointer(), l, entity);
        }

        protected int destroy_native_entity(long l, long l2) {
            return DomainParticipantImpl.DDS_DomainParticipant_delete_publisher(l, l2);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DomainParticipantImpl.DDS_DomainParticipant_get_default_publisher_qos(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return DomainParticipantImpl.DDS_DomainParticipant_set_default_publisher_qos(l, l2, bl);
        }
    }

    private final class TopicFactoryMixin
    extends NativeFactoryMixin {
        public TopicFactoryMixin() {
            super(DomainParticipantImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DomainParticipantImpl.get_scratchpad_topic_qosI(l);
        }

        protected Entity wrap_with_java_entity(long l, Listener listener, int n, Object[] objectArray) {
            return super.wrap_with_java_entity(l, listener, n, objectArray);
        }

        protected long create_native_entity(long l, long l2, boolean bl, long l3, int n, boolean[] blArray, Object[] objectArray) {
            String string = (String)objectArray[0];
            String string2 = (String)objectArray[1];
            return DomainParticipantImpl.DDS_DomainParticipant_create_topic_disabledI(l, blArray, string, string2, l2, bl, l3, n);
        }

        protected Entity create_java_entity(long l, Listener listener, int n, Object[] objectArray) {
            return new TopicImpl(l, (TopicListener)listener, n);
        }

        protected int initialize_native_to_java_pointer(long l, Entity entity) {
            return DomainParticipantImpl.initialize_native_to_java_topic_pointer(DomainParticipantImpl.this.get_native_pointer(), l, entity);
        }

        protected int destroy_native_entity(long l, long l2) {
            return DomainParticipantImpl.DDS_DomainParticipant_delete_topic(l, l2);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            String string = (String)object;
            return DomainParticipantImpl.DDS_DomainParticipant_get_default_topic_qos_w_topic_name(l, l2, string);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            if (bl2) {
                return DomainParticipantImpl.DDS_DomainParticipant_set_default_topic_qos_with_profile(l, (String)objectArray[0], (String)objectArray[1]);
            }
            return DomainParticipantImpl.DDS_DomainParticipant_set_default_topic_qos(l, l2, bl);
        }
    }

    private final class DomainParticipantQosMixin
    extends NativeStructMixin {
        public DomainParticipantQosMixin() {
            super(DomainParticipantImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DomainParticipantImpl.get_scratchpad_participant_qosI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DomainParticipantImpl.DDS_DomainParticipant_get_qos(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            Object object = objectArray[0];
            return DomainParticipantImpl.DDS_DomainParticipant_set_qos(l, l2, bl, object);
        }
    }
}

