/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.dynamicdata;

import com.rti.dds.cdr.CdrBuffer;
import com.rti.dds.cdr.CdrInputStream;
import com.rti.dds.cdr.CdrOutputStream;
import com.rti.dds.domain.DomainParticipant;
import com.rti.dds.domain.DomainParticipantImpl;
import com.rti.dds.dynamicdata.DynamicData;
import com.rti.dds.dynamicdata.DynamicDataReader;
import com.rti.dds.dynamicdata.DynamicDataTypeProperty_t;
import com.rti.dds.dynamicdata.DynamicDataWriter;
import com.rti.dds.infrastructure.BadKind;
import com.rti.dds.infrastructure.NativeObject;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.publication.DataWriter;
import com.rti.dds.publication.DataWriterListener;
import com.rti.dds.subscription.DataReader;
import com.rti.dds.subscription.DataReaderListener;
import com.rti.dds.topic.AbstractDataReaderDelegate;
import com.rti.dds.topic.DataReaderDelegate;
import com.rti.dds.topic.TypeSupport;
import com.rti.dds.topic.TypeSupportImpl;
import com.rti.dds.topic.TypeSupportType;
import com.rti.dds.typecode.TCKind;
import com.rti.dds.typecode.TypeCode;
import com.rti.dds.util.Utilities;

public final class DynamicDataTypeSupport
extends TypeSupportImpl
implements TypeSupport {
    private TypeCode _typeCode;
    private long native_type_support;
    private DataReaderDelegate _cachedDelegate;
    protected static final RuntimeException DYNAMICDATA_TYPE_NOT_SUPPORTED = new RETCODE_ERROR("not a top-level type");
    public static final DynamicDataTypeProperty_t TYPE_PROPERTY_DEFAULT = new DynamicDataTypeProperty_t();

    public final DataReaderDelegate create_delegateI() {
        if (this._cachedDelegate == null) {
            throw new IllegalStateException("constructor failed to call initialize_delegateI");
        }
        return this._cachedDelegate;
    }

    public final long create_native_bufferI() {
        throw new UnsupportedOperationException("Can't create native buffer for dynamic type");
    }

    public final void destroy_native_bufferI(long l) {
        throw new UnsupportedOperationException("Can't destroy native buffer for dynamic type");
    }

    public long create_native_objectI() {
        long l = DynamicDataTypeSupport.DDS_DynamicDataTypeSupport_create_data(this.native_type_support);
        if (l == 0L) {
            Utilities.rethrow(CANT_CREATE_NATIVE_TYPE_PLUGIN);
        }
        return l;
    }

    public void destroy_native_objectI(long l) {
        DynamicDataTypeSupport.DDS_DynamicDataTypeSupport_delete_data(this.native_type_support, l);
    }

    public final CdrBuffer create_cdr_bufferI() {
        throw new UnsupportedOperationException("Can't create CDR buffer for dynamic type");
    }

    public final Object copy_data(Object object, Object object2) {
        return ((DynamicData)object).copy_from((DynamicData)object2);
    }

    public final long get_serialized_sample_max_size(Object object, boolean bl, short s, long l) {
        throw new IllegalStateException("(de)serialization of dynamic types should take place in native code");
    }

    public final long get_serialized_sample_min_size(Object object, boolean bl, short s, long l) {
        throw new IllegalStateException("(de)serialization of dynamic types should take place in native code");
    }

    public final void serialize(Object object, Object object2, CdrOutputStream cdrOutputStream, boolean bl, short s, boolean bl2, Object object3) {
        throw new IllegalStateException("serialization of dynamic types should take place in native code");
    }

    public final Object deserialize_sample(Object object, Object object2, CdrInputStream cdrInputStream, boolean bl, boolean bl2, Object object3) {
        throw new IllegalStateException("deserialization of dynamic types should take place in native code");
    }

    public final void skip(Object object, CdrInputStream cdrInputStream, boolean bl, boolean bl2, Object object2) {
        throw new IllegalStateException("skip of dynamic types should take place in native code");
    }

    public final void register_type(DomainParticipant domainParticipant, String string) {
        DynamicDataTypeSupport.DDS_DynamicDataTypeSupport_register_type(this.native_type_support, ((NativeObject)((Object)domainParticipant)).get_native_pointer(), string);
        DomainParticipantImpl domainParticipantImpl = (DomainParticipantImpl)domainParticipant;
        long l = DynamicDataTypeSupport.DDS_DomainParticipant_get_type_plugin(domainParticipantImpl.get_native_pointer(), string);
        super.set_type_pluginI(l);
        domainParticipantImpl.remember_type_support(this);
    }

    public void register_typeI(DomainParticipant domainParticipant, String string) {
        this.register_type(domainParticipant, string);
    }

    public final void unregister_type(DomainParticipant domainParticipant, String string) {
        DomainParticipantImpl domainParticipantImpl = (DomainParticipantImpl)domainParticipant;
        int n = DynamicDataTypeSupport.DDS_DynamicDataTypeSupport_unregister_type(this.native_type_support, domainParticipantImpl.get_native_pointer(), string);
        RETCODE_ERROR.check_return_codeI(n);
        domainParticipantImpl.forget_type_support(this);
    }

    public final String get_type_name() {
        return super.get_type_nameI();
    }

    public final TypeCode get_data_type() {
        return this._typeCode;
    }

    public Object create_data() {
        long l = DynamicDataTypeSupport.DDS_DynamicDataTypeSupport_create_data(this.native_type_support);
        try {
            return new DynamicData(l);
        }
        catch (RuntimeException runtimeException) {
            DynamicDataTypeSupport.DDS_DynamicDataTypeSupport_delete_data(this.native_type_support, l);
            throw runtimeException;
        }
    }

    public Class get_type() {
        return DynamicData.class;
    }

    public void destroy_data(Object object) {
        DynamicData dynamicData = (DynamicData)object;
        long l = dynamicData.get_native_pointer();
        if (l != 0L) {
            dynamicData.clear_native_pointer();
            DynamicDataTypeSupport.DDS_DynamicDataTypeSupport_delete_data(this.native_type_support, l);
        }
        dynamicData.delete();
    }

    public void print_data(DynamicData dynamicData) {
        DynamicDataTypeSupport.DDS_DynamicDataTypeSupport_print_data(this.native_type_support, dynamicData.get_native_pointer());
    }

    public void copy_data(DynamicData dynamicData, DynamicData dynamicData2) {
        DynamicDataTypeSupport.DDS_DynamicDataTypeSupport_copy_data(this.native_type_support, dynamicData.get_native_pointer(), dynamicData2.get_native_pointer());
    }

    public void delete() {
        this._typeCode = null;
        if (this.native_type_support != 0L) {
            DynamicDataTypeSupport.DDS_DynamicDataTypeSupport_delete(this.native_type_support);
            this.native_type_support = 0L;
        }
    }

    private static String getTypeName(TypeCode typeCode) {
        String string = null;
        try {
            string = typeCode.name();
        }
        catch (BadKind badKind) {
            Utilities.rethrow(DYNAMICDATA_TYPE_NOT_SUPPORTED);
        }
        return string;
    }

    private static TypeSupportType getTypeSupportType(TypeCode typeCode) {
        if (typeCode.kind().equals(TCKind.TK_ENUM)) {
            return TypeSupportType.TST_ENUM;
        }
        if (typeCode.kind().equals(TCKind.TK_UNION)) {
            return TypeSupportType.TST_UNION;
        }
        return TypeSupportType.TST_STRUCT;
    }

    public DynamicDataTypeSupport(TypeCode typeCode, DynamicDataTypeProperty_t dynamicDataTypeProperty_t) {
        super(DynamicDataTypeSupport.getTypeName(typeCode), false, typeCode, DynamicData.class, DynamicDataTypeSupport.getTypeSupportType(typeCode), PLUGIN_VERSION_2_0);
        this._typeCode = typeCode;
        int n = -1;
        CdrBuffer cdrBuffer = null;
        CdrOutputStream cdrOutputStream = null;
        if (typeCode != null) {
            n = typeCode.get_serialized_size(0);
            cdrBuffer = new CdrBuffer(n);
            cdrOutputStream = new CdrOutputStream(cdrBuffer);
            typeCode.serialize(cdrOutputStream);
            this.native_type_support = DynamicDataTypeSupport.DDS_DynamicDataTypeSupport_new(cdrBuffer.getBuffer(), n, dynamicDataTypeProperty_t.data.buffer_initial_size, dynamicDataTypeProperty_t.data.buffer_max_size, dynamicDataTypeProperty_t.data.buffer_max_size_increment, dynamicDataTypeProperty_t.serialization.use_42e_compatible_alignment, dynamicDataTypeProperty_t.serialization.max_size_serialized);
            if (this.native_type_support == 0L) {
                throw new RETCODE_ERROR("unable to create native type support object");
            }
            this.initialize_delegateI(new DynamicDataReaderDelegate());
        }
    }

    protected final void initialize_delegateI(DataReaderDelegate dataReaderDelegate) {
        if (dataReaderDelegate == null) {
            throw new NullPointerException("null reader delegate");
        }
        this._cachedDelegate = dataReaderDelegate;
    }

    protected long create_native_data_typeI(String string, boolean bl, TypeCode typeCode) {
        return 0L;
    }

    protected void destroy_native_data_typeI(long l) {
    }

    protected final DataReader create_datareader(long l, DataReaderListener dataReaderListener, int n) {
        return new DynamicDataReader(l, dataReaderListener, n, this);
    }

    protected final DataWriter create_datawriter(long l, DataWriterListener dataWriterListener, int n) {
        return new DynamicDataWriter(l, dataWriterListener, n, this);
    }

    protected void finalize() throws Throwable {
        this.delete();
        super.finalize();
    }

    private static native long DDS_DynamicDataTypeSupport_new(byte[] var0, int var1, int var2, int var3, int var4, boolean var5, int var6);

    private static native void DDS_DynamicDataTypeSupport_delete(long var0);

    private static native void DDS_DynamicDataTypeSupport_register_type(long var0, long var2, String var4);

    private static native int DDS_DynamicDataTypeSupport_unregister_type(long var0, long var2, String var4);

    private static native long DDS_DynamicDataTypeSupport_create_data(long var0);

    private static native void DDS_DynamicDataTypeSupport_delete_data(long var0, long var2);

    private static native void DDS_DynamicDataTypeSupport_print_data(long var0, long var2);

    private static native void DDS_DynamicDataTypeSupport_copy_data(long var0, long var2, long var4);

    private static native long DDS_DomainParticipant_get_type_plugin(long var0, String var2);

    private final class DynamicDataReaderDelegate
    extends AbstractDataReaderDelegate {
        public DynamicDataReaderDelegate() {
            super(DynamicDataTypeSupport.this);
        }

        public void pull_data_sample_from_native(Object object, long l) {
            ((DynamicData)object).pull_from_nativeI(l);
        }

        public void push_data_sample_to_native(Object object, long l) {
            ((DynamicData)object).push_to_nativeI(l);
        }
    }
}

