/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.Duration_t;
import com.rti.dds.infrastructure.EndpointGroupSeq;
import com.rti.dds.infrastructure.QosPolicy;
import com.rti.dds.infrastructure.QosPolicyId_t;
import com.rti.dds.util.Utilities;
import java.util.Collection;

public final class AvailabilityQosPolicy
extends QosPolicy {
    public boolean enable_required_subscriptions;
    public final Duration_t max_data_availability_waiting_time = new Duration_t(-1, 0);
    public final Duration_t max_endpoint_availability_waiting_time = new Duration_t(-1, 0);
    public final EndpointGroupSeq required_matched_endpoint_groups = new EndpointGroupSeq();

    public void copy_from(AvailabilityQosPolicy availabilityQosPolicy) {
        this.enable_required_subscriptions = availabilityQosPolicy.enable_required_subscriptions;
        this.max_endpoint_availability_waiting_time.copy_from(availabilityQosPolicy.max_endpoint_availability_waiting_time);
        this.max_data_availability_waiting_time.copy_from(availabilityQosPolicy.max_data_availability_waiting_time);
        this.required_matched_endpoint_groups.clear();
        this.required_matched_endpoint_groups.addAll((Collection)availabilityQosPolicy.required_matched_endpoint_groups);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            return true;
        }
        if (object instanceof AvailabilityQosPolicy) {
            AvailabilityQosPolicy availabilityQosPolicy = (AvailabilityQosPolicy)object;
            if (this.enable_required_subscriptions != availabilityQosPolicy.enable_required_subscriptions) {
                return false;
            }
            if (!this.required_matched_endpoint_groups.equals(availabilityQosPolicy.required_matched_endpoint_groups)) {
                return false;
            }
            if (!Utilities.equalsNullSafe(this.max_endpoint_availability_waiting_time, availabilityQosPolicy.max_endpoint_availability_waiting_time)) {
                return false;
            }
            if (!Utilities.equalsNullSafe(this.max_data_availability_waiting_time, availabilityQosPolicy.max_data_availability_waiting_time)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this.required_matched_endpoint_groups.hashCode() + this.required_matched_endpoint_groups.size() + Utilities.hashCodeNullSafe(this.max_endpoint_availability_waiting_time) + Utilities.hashCodeNullSafe(this.max_data_availability_waiting_time);
    }

    public void pull_from_nativeI(long l) {
        int n = AvailabilityQosPolicy.get_native_enable_required_subscriptionsI(l);
        this.enable_required_subscriptions = n != 0;
        long l2 = AvailabilityQosPolicy.get_native_max_endpoint_availability_waiting_timeI(l);
        this.max_endpoint_availability_waiting_time.pull_from_nativeI(l2);
        long l3 = AvailabilityQosPolicy.get_native_max_data_availability_waiting_timeI(l);
        this.max_data_availability_waiting_time.pull_from_nativeI(l3);
        this.required_matched_endpoint_groups.pull_from_nativeI(AvailabilityQosPolicy.get_native_required_matched_endpoint_groupsI(l));
    }

    public void push_to_nativeI(long l) {
        AvailabilityQosPolicy.set_native_enable_required_subscriptionsI(l, this.enable_required_subscriptions);
        long l2 = AvailabilityQosPolicy.get_native_max_endpoint_availability_waiting_timeI(l);
        this.max_endpoint_availability_waiting_time.push_to_nativeI(l2);
        long l3 = AvailabilityQosPolicy.get_native_max_data_availability_waiting_timeI(l);
        this.max_data_availability_waiting_time.push_to_nativeI(l3);
        this.required_matched_endpoint_groups.push_to_nativeI(AvailabilityQosPolicy.get_native_required_matched_endpoint_groupsI(l));
    }

    AvailabilityQosPolicy() {
        super(QosPolicyId_t.PROPERTY_QOS_POLICY_ID);
    }

    private static native long get_native_max_data_availability_waiting_timeI(long var0);

    private static native long get_native_max_endpoint_availability_waiting_timeI(long var0);

    private static native long get_native_required_matched_endpoint_groupsI(long var0);

    private static native int get_native_enable_required_subscriptionsI(long var0);

    private static native void set_native_enable_required_subscriptionsI(long var0, boolean var2);
}

