/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.Duration_t;
import com.rti.dds.infrastructure.QosPolicy;
import com.rti.dds.infrastructure.QosPolicyId_t;

public final class BatchQosPolicy
extends QosPolicy {
    public boolean enable = false;
    public int max_data_bytes = -1;
    public int max_meta_data_bytes = -1;
    public int max_samples = 1024;
    public final Duration_t max_flush_delay = new Duration_t(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public final Duration_t source_timestamp_resolution = new Duration_t(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public boolean thread_safe_write = true;

    public void copy_from(BatchQosPolicy batchQosPolicy) {
        this.enable = batchQosPolicy.enable;
        this.max_data_bytes = batchQosPolicy.max_data_bytes;
        this.max_meta_data_bytes = batchQosPolicy.max_meta_data_bytes;
        this.max_samples = batchQosPolicy.max_samples;
        this.max_flush_delay.copy_from(batchQosPolicy.max_flush_delay);
        this.source_timestamp_resolution.copy_from(batchQosPolicy.source_timestamp_resolution);
        this.thread_safe_write = batchQosPolicy.thread_safe_write;
    }

    public void pull_from_nativeI(long l) {
        int n = BatchQosPolicy.get_native_enableI(l);
        this.enable = n != 0;
        this.max_data_bytes = BatchQosPolicy.get_native_max_data_bytesI(l);
        this.max_meta_data_bytes = BatchQosPolicy.get_native_max_meta_data_bytesI(l);
        this.max_samples = BatchQosPolicy.get_native_max_samplesI(l);
        long l2 = BatchQosPolicy.get_native_max_flush_delayI(l);
        this.max_flush_delay.pull_from_nativeI(l2);
        long l3 = BatchQosPolicy.get_native_source_timestamp_resolutionI(l);
        this.source_timestamp_resolution.pull_from_nativeI(l3);
        int n2 = BatchQosPolicy.get_native_thread_safe_writeI(l);
        this.thread_safe_write = n2 != 0;
    }

    public void push_to_nativeI(long l) {
        BatchQosPolicy.set_native_enableI(l, this.enable);
        BatchQosPolicy.set_native_max_data_bytesI(l, this.max_data_bytes);
        BatchQosPolicy.set_native_max_meta_data_bytesI(l, this.max_meta_data_bytes);
        BatchQosPolicy.set_native_max_samplesI(l, this.max_samples);
        long l2 = BatchQosPolicy.get_native_max_flush_delayI(l);
        this.max_flush_delay.push_to_nativeI(l2);
        long l3 = BatchQosPolicy.get_native_source_timestamp_resolutionI(l);
        this.source_timestamp_resolution.push_to_nativeI(l3);
        BatchQosPolicy.set_native_thread_safe_writeI(l, this.thread_safe_write);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BatchQosPolicy) {
            BatchQosPolicy batchQosPolicy = (BatchQosPolicy)object;
            if (this.enable != batchQosPolicy.enable) {
                return false;
            }
            if (this.max_data_bytes != batchQosPolicy.max_data_bytes) {
                return false;
            }
            if (this.max_meta_data_bytes != batchQosPolicy.max_meta_data_bytes) {
                return false;
            }
            if (this.max_samples != batchQosPolicy.max_samples) {
                return false;
            }
            if (!this.max_flush_delay.equals(batchQosPolicy.max_flush_delay)) {
                return false;
            }
            if (!this.source_timestamp_resolution.equals(batchQosPolicy.source_timestamp_resolution)) {
                return false;
            }
            return this.thread_safe_write == batchQosPolicy.thread_safe_write;
        }
        return false;
    }

    public int hashCode() {
        return this.max_data_bytes + this.max_samples + this.max_meta_data_bytes;
    }

    BatchQosPolicy() {
        super(QosPolicyId_t.BATCH_QOS_POLICY_ID);
    }

    private static native int get_native_enableI(long var0);

    private static native int get_native_max_data_bytesI(long var0);

    private static native int get_native_max_meta_data_bytesI(long var0);

    private static native int get_native_max_samplesI(long var0);

    private static native long get_native_max_flush_delayI(long var0);

    private static native long get_native_source_timestamp_resolutionI(long var0);

    private static native int get_native_thread_safe_writeI(long var0);

    private static native void set_native_enableI(long var0, boolean var2);

    private static native void set_native_max_data_bytesI(long var0, int var2);

    private static native void set_native_max_meta_data_bytesI(long var0, int var2);

    private static native void set_native_max_samplesI(long var0, int var2);

    private static native void set_native_thread_safe_writeI(long var0, boolean var2);
}

