/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.util.AbstractPrimitiveSequence;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class BooleanSeq
extends AbstractPrimitiveSequence {
    private static final long serialVersionUID = 8482952605492216987L;
    private boolean[] _array;

    public BooleanSeq() {
        this(0);
    }

    public BooleanSeq(int n) {
        super(Boolean.class, Boolean.TYPE, n);
    }

    public BooleanSeq(boolean[] blArray) {
        this(blArray.length);
        this.addAllBoolean(blArray);
    }

    public boolean addAllBoolean(boolean[] blArray, int n, int n2) {
        return this.addAllPrimitive(blArray, n, n2);
    }

    public boolean addAllBoolean(boolean[] blArray) {
        int n = blArray.length;
        return this.addAllBoolean(blArray, 0, n);
    }

    public void addBoolean(boolean bl) {
        this.ensureSpaceForAdditionalElements(1);
        this._array[this._size++] = bl;
    }

    public void addBoolean(int n, boolean bl) {
        this.shiftAndEnlarge(n);
        this._array[n] = bl;
    }

    public boolean getBoolean(int n) {
        this.checkIndexUpperBound(n, false);
        return this._array[n];
    }

    public boolean setBoolean(int n, boolean bl) {
        this.checkIndexUpperBound(n, false);
        boolean bl2 = this._array[n];
        this._array[n] = bl;
        return bl2;
    }

    public void setBoolean(int n, boolean[] blArray, int n2, int n3) {
        this.setPrimitive(n, blArray, n2, n3);
    }

    public boolean[] toArrayBoolean(boolean[] blArray) {
        int n = blArray == null ? 0 : blArray.length;
        return (boolean[])this.toArrayPrimitive(blArray, n);
    }

    public static void readBooleanArray(boolean[] blArray, DataInput dataInput, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            blArray[i] = dataInput.readBoolean();
        }
    }

    public static void writeBooleanArray(boolean[] blArray, DataOutput dataOutput, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            dataOutput.writeBoolean(blArray[i]);
        }
    }

    public int getMaximum() {
        return this._array == null ? 0 : this._array.length;
    }

    public Object get(int n) {
        boolean bl = this.getBoolean(n);
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object getPrimitiveArray() {
        return this._array;
    }

    public void setPrimitiveArray(Object object, int n) {
        this._array = (boolean[])object;
        this._size = n;
    }

    public Object set(int n, Object object) {
        boolean bl = this.setBoolean(n, (Boolean)object);
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void add(int n, Object object) {
        this.addBoolean(n, (Boolean)object);
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this._size; ++i) {
            n += this._array[i] ? 1 : 0;
        }
        return n;
    }

    protected Object createArray(int n) {
        return new boolean[n];
    }

    protected void setPrimitiveArray(Object object) {
        this._array = (boolean[])object;
    }

    protected void readElements(ObjectInput objectInput, int n) throws IOException {
        BooleanSeq.readBooleanArray(this._array, objectInput, n);
    }

    protected void writeElements(ObjectOutput objectOutput, int n) throws IOException {
        if (this._array != null) {
            BooleanSeq.writeBooleanArray(this._array, objectOutput, n);
        }
    }
}

