/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.Condition;
import com.rti.dds.infrastructure.NativeCondition;
import com.rti.dds.util.AbstractNativeSequence;
import com.rti.dds.util.Utilities;
import java.util.Collection;

public final class ConditionSeq
extends AbstractNativeSequence {
    public ConditionSeq(Collection collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public ConditionSeq() {
        this(0);
    }

    public ConditionSeq(int n) {
        super(NativeCondition.class, ConditionSeq.createNativeSequence(), n);
    }

    public int getMaximum() {
        return ConditionSeq.DDS_ConditionSeq_get_maximum(this.getNativeSequence());
    }

    public Object get(int n) {
        this.checkBounds(n, false);
        Condition condition = null;
        long l = ConditionSeq.DDS_ConditionSeq_get(this.getNativeSequence(), n);
        if (l != 0L) {
            condition = (Condition)ConditionSeq.get_condition(l);
        }
        return condition;
    }

    public Object set(int n, Object object) {
        Object object2 = this.get(n);
        long l = ((NativeCondition)object).get_native_pointer();
        long l2 = ConditionSeq.DDS_ConditionSeq_get_reference(this.getNativeSequence(), n);
        if (l2 == 0L) {
            Utilities.rethrow(INCONSISTENT_STATE);
        }
        ConditionSeq.DDS_ConditionSeq_set(l2, l);
        return object2;
    }

    public void clear() {
        this.setSize(0);
    }

    public int size() {
        return ConditionSeq.DDS_ConditionSeq_get_length(this.getNativeSequence());
    }

    protected long getNativeSequence() {
        return super.getNativeSequence();
    }

    protected native void destroyNativeSequence(long var1);

    protected void incrementSize() {
        this.setSize(this.size() + 1);
    }

    protected void decrementSize() {
        this.setSize(this.size() - 1);
    }

    protected void reallocate(int n) {
        int n2 = ConditionSeq.DDS_ConditionSeq_set_maximum(this.getNativeSequence(), n);
        if (n2 == 0) {
            Utilities.rethrow(FAILED_ALLOCATION);
        }
    }

    private static long createNativeSequence() {
        long l = ConditionSeq.DDS_new_empty_sequence();
        if (l == 0L) {
            Utilities.rethrow(FAILED_ALLOCATION);
        }
        return l;
    }

    private void setSize(int n) {
        int n2 = ConditionSeq.DDS_ConditionSeq_set_length(this.getNativeSequence(), n);
        if ((long)n2 == 0L) {
            Utilities.rethrow(INCONSISTENT_STATE);
        }
    }

    private static native long DDS_new_empty_sequence();

    private static native int DDS_ConditionSeq_get_maximum(long var0);

    private static native int DDS_ConditionSeq_set_maximum(long var0, int var2);

    private static native int DDS_ConditionSeq_get_length(long var0);

    private static native int DDS_ConditionSeq_set_length(long var0, int var2);

    private static native long DDS_ConditionSeq_get_reference(long var0, int var2);

    private static native long DDS_ConditionSeq_get(long var0, int var2);

    private static native void DDS_ConditionSeq_set(long var0, long var2);

    private static native Object get_condition(long var0);
}

