/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.GUID_t;
import com.rti.dds.infrastructure.QosPolicy;
import com.rti.dds.infrastructure.QosPolicyId_t;
import com.rti.dds.infrastructure.RtpsReliableReaderProtocol_t;

public final class DataReaderProtocolQosPolicy
extends QosPolicy {
    public GUID_t virtual_guid = new GUID_t(GUID_t.GUID_AUTO);
    public int rtps_object_id = 0;
    public boolean expects_inline_qos = false;
    public boolean disable_positive_acks = false;
    public boolean propagate_dispose_of_unregistered_instances = false;
    public final RtpsReliableReaderProtocol_t rtps_reliable_reader = new RtpsReliableReaderProtocol_t();

    public void copy_from(DataReaderProtocolQosPolicy dataReaderProtocolQosPolicy) {
        this.rtps_object_id = dataReaderProtocolQosPolicy.rtps_object_id;
        this.expects_inline_qos = dataReaderProtocolQosPolicy.expects_inline_qos;
        this.disable_positive_acks = dataReaderProtocolQosPolicy.disable_positive_acks;
        this.propagate_dispose_of_unregistered_instances = dataReaderProtocolQosPolicy.propagate_dispose_of_unregistered_instances;
        this.rtps_reliable_reader.copy_from(dataReaderProtocolQosPolicy.rtps_reliable_reader);
        this.virtual_guid.copy_from(dataReaderProtocolQosPolicy.virtual_guid);
    }

    public void pull_from_nativeI(long l) {
        this.rtps_object_id = DataReaderProtocolQosPolicy.get_native_rtps_object_idI(l);
        int n = DataReaderProtocolQosPolicy.get_native_expects_inline_qosI(l);
        this.expects_inline_qos = n != 0;
        long l2 = DataReaderProtocolQosPolicy.get_native_rtps_reliable_readerI(l);
        long l3 = DataReaderProtocolQosPolicy.get_native_virtual_guidI(l);
        this.rtps_reliable_reader.pull_from_nativeI(l2);
        this.virtual_guid.pull_from_nativeI(l3);
        this.disable_positive_acks = DataReaderProtocolQosPolicy.get_native_disable_positive_acksI(l);
        this.propagate_dispose_of_unregistered_instances = DataReaderProtocolQosPolicy.get_native_propagate_dispose_of_unregistered_instancesI(l);
    }

    public void push_to_nativeI(long l) {
        DataReaderProtocolQosPolicy.set_native_rtps_object_idI(l, this.rtps_object_id);
        DataReaderProtocolQosPolicy.set_native_expects_inline_qosI(l, this.expects_inline_qos);
        DataReaderProtocolQosPolicy.set_native_disable_positive_acksI(l, this.disable_positive_acks);
        long l2 = DataReaderProtocolQosPolicy.get_native_rtps_reliable_readerI(l);
        long l3 = DataReaderProtocolQosPolicy.get_native_virtual_guidI(l);
        this.rtps_reliable_reader.push_to_nativeI(l2);
        this.virtual_guid.push_to_nativeI(l3);
        DataReaderProtocolQosPolicy.set_native_propagate_dispose_of_unregistered_instancesI(l, this.propagate_dispose_of_unregistered_instances);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof DataReaderProtocolQosPolicy && (bl = this.rtps_reliable_reader.equals(((DataReaderProtocolQosPolicy)object).rtps_reliable_reader)) && (bl = this.virtual_guid.equals(((DataReaderProtocolQosPolicy)object).virtual_guid))) {
            boolean bl2 = bl = this.rtps_object_id == ((DataReaderProtocolQosPolicy)object).rtps_object_id;
            if (bl) {
                bl = this.expects_inline_qos == ((DataReaderProtocolQosPolicy)object).expects_inline_qos && this.disable_positive_acks == ((DataReaderProtocolQosPolicy)object).disable_positive_acks && this.propagate_dispose_of_unregistered_instances == ((DataReaderProtocolQosPolicy)object).propagate_dispose_of_unregistered_instances;
            }
        }
        return bl;
    }

    public int hashCode() {
        return this.virtual_guid.hashCode() + this.rtps_reliable_reader.hashCode() + (this.expects_inline_qos ? 1 : 0) + (this.propagate_dispose_of_unregistered_instances ? 1 : 0);
    }

    DataReaderProtocolQosPolicy() {
        super(QosPolicyId_t.DATAREADERPROTOCOL_QOS_POLICY_ID);
    }

    private static native int get_native_rtps_object_idI(long var0);

    private static native void set_native_rtps_object_idI(long var0, int var2);

    private static native long get_native_rtps_reliable_readerI(long var0);

    private static native int get_native_expects_inline_qosI(long var0);

    private static native void set_native_expects_inline_qosI(long var0, boolean var2);

    private static native long get_native_virtual_guidI(long var0);

    private static native void set_native_disable_positive_acksI(long var0, boolean var2);

    private static native boolean get_native_disable_positive_acksI(long var0);

    private static native void set_native_propagate_dispose_of_unregistered_instancesI(long var0, boolean var2);

    private static native boolean get_native_propagate_dispose_of_unregistered_instancesI(long var0);
}

