/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.util.AbstractPrimitiveSequence;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DoubleSeq
extends AbstractPrimitiveSequence {
    private static final long serialVersionUID = 223791703485712340L;
    protected double[] _array;

    public DoubleSeq() {
        this(0);
    }

    public DoubleSeq(int n) {
        super(Double.class, Double.TYPE, n);
    }

    public DoubleSeq(double[] dArray) {
        this(dArray.length);
        this.addAllDouble(dArray);
    }

    public final boolean addAllDouble(double[] dArray, int n, int n2) {
        return this.addAllPrimitive(dArray, n, n2);
    }

    public final boolean addAllDouble(double[] dArray) {
        int n = dArray.length;
        return this.addAllDouble(dArray, 0, n);
    }

    public final void addDouble(double d) {
        this.ensureSpaceForAdditionalElements(1);
        this._array[this._size++] = d;
    }

    public final void addDouble(int n, double d) {
        this.shiftAndEnlarge(n);
        this._array[n] = d;
    }

    public final double getDouble(int n) {
        this.checkIndexUpperBound(n, false);
        return this._array[n];
    }

    public final double setDouble(int n, double d) {
        this.checkIndexUpperBound(n, false);
        double d2 = this._array[n];
        this._array[n] = d;
        return d2;
    }

    public final void setDouble(int n, double[] dArray, int n2, int n3) {
        this.setPrimitive(n, dArray, n2, n3);
    }

    public final double[] toArrayDouble(double[] dArray) {
        int n = dArray == null ? 0 : dArray.length;
        return (double[])this.toArrayPrimitive(dArray, n);
    }

    public static void readDoubleArray(double[] dArray, DataInput dataInput, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            dArray[i] = dataInput.readDouble();
        }
    }

    public static void writeDoubleArray(double[] dArray, DataOutput dataOutput, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            dataOutput.writeDouble(dArray[i]);
        }
    }

    public final int getMaximum() {
        return this._array == null ? 0 : this._array.length;
    }

    public final Object get(int n) {
        double d = this.getDouble(n);
        return new Double(d);
    }

    public final Object getPrimitiveArray() {
        return this._array;
    }

    public final void setPrimitiveArray(Object object, int n) {
        this._array = (double[])object;
        this._size = n;
    }

    public final Object set(int n, Object object) {
        double d = this.setDouble(n, (Double)object);
        return new Double(d);
    }

    public final void add(int n, Object object) {
        this.addDouble(n, (Double)object);
    }

    protected final Object createArray(int n) {
        return new double[n];
    }

    protected final void setPrimitiveArray(Object object) {
        this._array = (double[])object;
    }

    protected void readElements(ObjectInput objectInput, int n) throws IOException {
        DoubleSeq.readDoubleArray(this._array, objectInput, n);
    }

    protected void writeElements(ObjectOutput objectOutput, int n) throws IOException {
        if (this._array != null) {
            DoubleSeq.writeDoubleArray(this._array, objectOutput, n);
        }
    }
}

