/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.Duration_t;
import com.rti.dds.infrastructure.HistoryQosPolicyKind;
import com.rti.dds.infrastructure.QosPolicy;
import com.rti.dds.infrastructure.QosPolicyId_t;
import com.rti.dds.util.Utilities;

public final class DurabilityServiceQosPolicy
extends QosPolicy {
    public final Duration_t service_cleanup_delay = new Duration_t(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public HistoryQosPolicyKind history_kind = HistoryQosPolicyKind.KEEP_LAST_HISTORY_QOS;
    public int history_depth = 1;
    public int max_samples = 1;
    public int max_instances = 1;
    public int max_samples_per_instance = 1;

    public void copy_from(DurabilityServiceQosPolicy durabilityServiceQosPolicy) {
        this.service_cleanup_delay.copy_from(durabilityServiceQosPolicy.service_cleanup_delay);
        this.history_kind = durabilityServiceQosPolicy.history_kind;
        this.history_depth = durabilityServiceQosPolicy.history_depth;
        this.max_samples = durabilityServiceQosPolicy.max_samples;
        this.max_instances = durabilityServiceQosPolicy.max_instances;
        this.max_samples_per_instance = durabilityServiceQosPolicy.max_samples_per_instance;
    }

    public void pull_from_nativeI(long l) {
        HistoryQosPolicyKind historyQosPolicyKind;
        long l2 = DurabilityServiceQosPolicy.get_native_service_cleanup_delayI(l);
        this.service_cleanup_delay.pull_from_nativeI(l2);
        int n = DurabilityServiceQosPolicy.get_native_history_kindI(l);
        this.history_kind = historyQosPolicyKind = HistoryQosPolicyKind.valueOf(n);
        this.history_depth = DurabilityServiceQosPolicy.get_native_history_depthI(l);
        this.max_samples = DurabilityServiceQosPolicy.get_native_max_samplesI(l);
        this.max_instances = DurabilityServiceQosPolicy.get_native_max_instancesI(l);
        this.max_samples_per_instance = DurabilityServiceQosPolicy.get_native_max_samples_per_instanceI(l);
    }

    public void push_to_nativeI(long l) {
        if (this.history_kind == null) {
            this.throw_cant_push_nullI();
        }
        long l2 = DurabilityServiceQosPolicy.get_native_service_cleanup_delayI(l);
        this.service_cleanup_delay.push_to_nativeI(l2);
        DurabilityServiceQosPolicy.set_native_history_kindI(l, this.history_kind.ordinal());
        DurabilityServiceQosPolicy.set_native_history_depthI(l, this.history_depth);
        DurabilityServiceQosPolicy.set_native_max_samplesI(l, this.max_samples);
        DurabilityServiceQosPolicy.set_native_max_instancesI(l, this.max_instances);
        DurabilityServiceQosPolicy.set_native_max_samples_per_instanceI(l, this.max_samples_per_instance);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof DurabilityServiceQosPolicy) {
            DurabilityServiceQosPolicy durabilityServiceQosPolicy = (DurabilityServiceQosPolicy)object;
            bl = Utilities.equalsNullSafe(this.service_cleanup_delay, durabilityServiceQosPolicy.service_cleanup_delay) && this.history_kind == durabilityServiceQosPolicy.history_kind && this.history_depth == durabilityServiceQosPolicy.history_depth && this.max_samples == durabilityServiceQosPolicy.max_samples && this.max_instances == durabilityServiceQosPolicy.max_instances && this.max_samples_per_instance == durabilityServiceQosPolicy.max_samples_per_instance;
        }
        return bl;
    }

    public int hashCode() {
        return Utilities.hashCodeNullSafe(this.service_cleanup_delay) + Utilities.hashCodeNullSafe(this.history_kind) + this.history_depth + this.max_samples + this.max_instances + this.max_samples_per_instance;
    }

    DurabilityServiceQosPolicy() {
        super(QosPolicyId_t.DURABILITY_SERVICE_QOS_POLICY_ID);
    }

    private static native long get_native_service_cleanup_delayI(long var0);

    private static native int get_native_history_kindI(long var0);

    private static native void set_native_history_kindI(long var0, int var2);

    private static native int get_native_history_depthI(long var0);

    private static native void set_native_history_depthI(long var0, int var2);

    private static native int get_native_max_samplesI(long var0);

    private static native void set_native_max_samplesI(long var0, int var2);

    private static native int get_native_max_instancesI(long var0);

    private static native void set_native_max_instancesI(long var0, int var2);

    private static native int get_native_max_samples_per_instanceI(long var0);

    private static native void set_native_max_samples_per_instanceI(long var0, int var2);
}

