/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.util.AbstractPrimitiveSequence;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class FloatSeq
extends AbstractPrimitiveSequence {
    private static final long serialVersionUID = -970880199161881871L;
    private float[] _array;

    public FloatSeq() {
        this(0);
    }

    public FloatSeq(int n) {
        super(Float.class, Float.TYPE, n);
    }

    public FloatSeq(float[] fArray) {
        this(fArray.length);
        this.addAllFloat(fArray);
    }

    public boolean addAllFloat(float[] fArray, int n, int n2) {
        return this.addAllPrimitive(fArray, n, n2);
    }

    public boolean addAllFloat(float[] fArray) {
        int n = fArray.length;
        return this.addAllFloat(fArray, 0, n);
    }

    public void addFloat(float f) {
        this.ensureSpaceForAdditionalElements(1);
        this._array[this._size++] = f;
    }

    public void addFloat(int n, float f) {
        this.shiftAndEnlarge(n);
        this._array[n] = f;
    }

    public float getFloat(int n) {
        this.checkIndexUpperBound(n, false);
        return this._array[n];
    }

    public float setFloat(int n, float f) {
        this.checkIndexUpperBound(n, false);
        float f2 = this._array[n];
        this._array[n] = f;
        return f2;
    }

    public void setFloat(int n, float[] fArray, int n2, int n3) {
        this.setPrimitive(n, fArray, n2, n3);
    }

    public float[] toArrayFloat(float[] fArray) {
        int n = fArray == null ? 0 : fArray.length;
        return (float[])this.toArrayPrimitive(fArray, n);
    }

    public static void readFloatArray(float[] fArray, DataInput dataInput, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            fArray[i] = dataInput.readFloat();
        }
    }

    public static void writeFloatArray(float[] fArray, DataOutput dataOutput, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            dataOutput.writeFloat(fArray[i]);
        }
    }

    public int getMaximum() {
        return this._array == null ? 0 : this._array.length;
    }

    public Object get(int n) {
        float f = this.getFloat(n);
        return new Float(f);
    }

    public Object getPrimitiveArray() {
        return this._array;
    }

    public void setPrimitiveArray(Object object, int n) {
        this._array = (float[])object;
        this._size = n;
    }

    public Object set(int n, Object object) {
        float f = this.setFloat(n, ((Float)object).floatValue());
        return new Float(f);
    }

    public void add(int n, Object object) {
        this.addFloat(n, ((Float)object).floatValue());
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this._size; ++i) {
            n += (int)this._array[i];
        }
        return n;
    }

    protected Object createArray(int n) {
        return new float[n];
    }

    protected void setPrimitiveArray(Object object) {
        this._array = (float[])object;
    }

    protected void readElements(ObjectInput objectInput, int n) throws IOException {
        FloatSeq.readFloatArray(this._array, objectInput, n);
    }

    protected void writeElements(ObjectOutput objectOutput, int n) throws IOException {
        if (this._array != null) {
            FloatSeq.writeFloatArray(this._array, objectOutput, n);
        }
    }
}

