/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.util.AbstractPrimitiveSequence;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class IntSeq
extends AbstractPrimitiveSequence {
    private static final long serialVersionUID = 7474765038470066615L;
    private int[] _array;

    public IntSeq() {
        this(0);
    }

    public IntSeq(int n) {
        super(Integer.class, Integer.TYPE, n);
    }

    public IntSeq(int[] nArray) {
        this(nArray.length);
        this.addAllInt(nArray);
    }

    public boolean addAllInt(int[] nArray, int n, int n2) {
        return this.addAllPrimitive(nArray, n, n2);
    }

    public boolean addAllInt(int[] nArray) {
        int n = nArray.length;
        return this.addAllInt(nArray, 0, n);
    }

    public void addInt(int n) {
        this.ensureSpaceForAdditionalElements(1);
        this._array[this._size++] = n;
    }

    public void addInt(int n, int n2) {
        this.shiftAndEnlarge(n);
        this._array[n] = n2;
    }

    public int getInt(int n) {
        this.checkIndexUpperBound(n, false);
        return this._array[n];
    }

    public int setInt(int n, int n2) {
        this.checkIndexUpperBound(n, false);
        int n3 = this._array[n];
        this._array[n] = n2;
        return n3;
    }

    public void setInt(int n, int[] nArray, int n2, int n3) {
        this.setPrimitive(n, nArray, n2, n3);
    }

    public int[] toArrayInt(int[] nArray) {
        int n = nArray == null ? 0 : nArray.length;
        return (int[])this.toArrayPrimitive(nArray, n);
    }

    public static void readIntArray(int[] nArray, DataInput dataInput, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            nArray[i] = dataInput.readInt();
        }
    }

    public static void writeIntArray(int[] nArray, DataOutput dataOutput, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            dataOutput.writeInt(nArray[i]);
        }
    }

    public int getMaximum() {
        return this._array == null ? 0 : this._array.length;
    }

    public Object get(int n) {
        int n2 = this.getInt(n);
        return new Integer(n2);
    }

    public Object getPrimitiveArray() {
        return this._array;
    }

    public void setPrimitiveArray(Object object, int n) {
        this._array = (int[])object;
        this._size = n;
    }

    public Object set(int n, Object object) {
        int n2 = this.setInt(n, (Integer)object);
        return new Integer(n2);
    }

    public void add(int n, Object object) {
        this.addInt(n, (Integer)object);
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this._size; ++i) {
            n += this._array[i];
        }
        return n;
    }

    protected Object createArray(int n) {
        return new int[n];
    }

    protected void setPrimitiveArray(Object object) {
        this._array = (int[])object;
    }

    protected void readElements(ObjectInput objectInput, int n) throws IOException {
        IntSeq.readIntArray(this._array, objectInput, n);
    }

    protected void writeElements(ObjectOutput objectOutput, int n) throws IOException {
        if (this._array != null) {
            IntSeq.writeIntArray(this._array, objectOutput, n);
        }
    }
}

