/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.ShortSeq;
import com.rti.dds.infrastructure.Struct;
import java.util.Arrays;

public final class Locator_t
extends Struct {
    public static final int KIND_INVALID = -1;
    public static final int PORT_INVALID = 0;
    public static final byte[] ADDRESS_INVALID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final Locator_t INVALID = new Locator_t(-1, 0, ADDRESS_INVALID);
    public static final int KIND_UDPv4 = 1;
    public static final int KIND_SHMEM = 2;
    public static final int KIND_INTRA = 3;
    public static final int KIND_UDPv6 = 5;
    public static final int KIND_DTLS = 6;
    public static final int KIND_WAN = 7;
    public static final int KIND_TCPV4_LAN = 8;
    public static final int KIND_TCPV4_WAN = 9;
    public static final int KIND_TLSV4_LAN = 10;
    public static final int KIND_TLSV4_WAN = 11;
    public static final int KIND_RESERVED = 1000;
    public static final int ADDRESS_LENGTH_MAX = 16;
    public int kind;
    public int port;
    public final byte[] address = new byte[16];
    public final ShortSeq encapsulations = new ShortSeq();

    public Locator_t() {
    }

    Locator_t(int n, int n2, byte[] byArray) {
        this.kind = n;
        this.port = n2;
        System.arraycopy(byArray, 0, this.address, 0, 16);
    }

    Locator_t(int n, int n2, byte[] byArray, ShortSeq shortSeq) {
        this.kind = n;
        this.port = n2;
        System.arraycopy(byArray, 0, this.address, 0, 16);
        this.encapsulations.addAll(shortSeq);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof Locator_t && ((Locator_t)object).kind == this.kind && ((Locator_t)object).port == this.port && Arrays.equals(((Locator_t)object).address, this.address) && ((Locator_t)object).encapsulations.equals(this.encapsulations);
    }

    public int hashCode() {
        return this.kind + this.port + this.address[0] + this.address[1] + this.address[2] + this.address[3] + this.address[4] + this.address[5] + this.address[6] + this.address[7] + this.address[8] + this.address[9] + this.address[10] + this.address[11] + this.address[12] + this.address[13] + this.address[14] + this.address[15] + this.encapsulations.hashCode();
    }

    public void pull_from_nativeI(long l) {
        int n;
        this.kind = Locator_t.get_native_kindI(l);
        this.port = Locator_t.get_native_portI(l);
        Locator_t.pull_address_from_nativeI(l, this.address);
        long l2 = Locator_t.get_native_encapsulationsPtrI(l);
        int n2 = Locator_t.get_native_encapsulations_lengthI(l2);
        int n3 = this.encapsulations.getMaximum();
        if (n2 < n3) {
            for (n = n2; n < n3; ++n) {
                this.encapsulations.remove(n);
            }
        } else if (n2 > n3) {
            for (n = n3; n < n2; ++n) {
                this.encapsulations.add((Object)null);
            }
        }
        for (n = 0; n < n2; ++n) {
            short s = Locator_t.get_native_encapsulations_elementI(l2, n);
            this.encapsulations.setShort(n, s);
        }
    }

    public void push_to_nativeI(long l) {
        Locator_t.set_native_kindI(l, this.kind);
        Locator_t.set_native_portI(l, this.port);
        Locator_t.push_address_to_nativeI(l, this.address);
        long l2 = Locator_t.get_native_encapsulationsPtrI(l);
        int n = this.encapsulations.size();
        int n2 = Locator_t.set_native_encapsulations_lengthI(l2, n);
        RETCODE_ERROR.check_return_codeI(n2);
        int n3 = Locator_t.get_native_encapsulations_lengthI(l2);
        for (int i = 0; i < n && i < n3; ++i) {
            short s = this.encapsulations.getShort(i);
            Locator_t.set_native_encapsulations_elementI(l2, i, s);
        }
    }

    private static native int get_native_kindI(long var0);

    private static native void set_native_kindI(long var0, int var2);

    private static native int get_native_portI(long var0);

    private static native void set_native_portI(long var0, int var2);

    private static native void pull_address_from_nativeI(long var0, byte[] var2);

    private static native void push_address_to_nativeI(long var0, byte[] var2);

    private static native long get_native_encapsulationsPtrI(long var0);

    private static native int get_native_encapsulations_lengthI(long var0);

    private static native int set_native_encapsulations_lengthI(long var0, int var2);

    private static native short get_native_encapsulations_elementI(long var0, int var2);

    private static native void set_native_encapsulations_elementI(long var0, int var2, short var3);
}

