/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.QosPolicy;
import com.rti.dds.infrastructure.QosPolicyId_t;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.StringHelper;
import com.rti.dds.util.Utilities;
import com.rti.ndds.config.LogCategory;
import com.rti.ndds.config.LogPrintFormat;
import com.rti.ndds.config.LogVerbosity;

public final class LoggingQosPolicy
extends QosPolicy {
    public LogVerbosity verbosity = LogVerbosity.NDDS_CONFIG_LOG_VERBOSITY_ERROR;
    public LogCategory category = LogCategory.NDDS_CONFIG_LOG_CATEGORY_ENTITIES;
    public LogPrintFormat print_format = LogPrintFormat.NDDS_CONFIG_LOG_PRINT_FORMAT_DEFAULT;
    public String output_file = null;

    public void pull_from_nativeI(long l) {
        this.output_file = StringHelper.dup_native_stringI(LoggingQosPolicy.get_native_output_file_ptrI(l));
        this.verbosity = LogVerbosity.valueOf(LoggingQosPolicy.get_native_verbosityI(l));
        this.category = LogCategory.valueOf(LoggingQosPolicy.get_native_categoryI(l));
        this.print_format = LogPrintFormat.valueOf(LoggingQosPolicy.get_native_print_formatI(l));
    }

    public void push_to_nativeI(long l) {
        if (this.output_file != null) {
            int n = StringHelper.replace_native_stringI(LoggingQosPolicy.get_native_output_file_ptrI(l), this.output_file);
            RETCODE_ERROR.check_return_codeI(n);
        }
        LoggingQosPolicy.set_native_verbosityI(l, this.verbosity.ordinal());
        LoggingQosPolicy.set_native_categoryI(l, this.category.ordinal());
        LoggingQosPolicy.set_native_print_formatI(l, this.print_format.ordinal());
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof LoggingQosPolicy) {
            LoggingQosPolicy loggingQosPolicy = (LoggingQosPolicy)object;
            bl = Utilities.equalsNullSafe(this.output_file, loggingQosPolicy.output_file) && this.verbosity.equals(loggingQosPolicy.verbosity) && this.category.equals(loggingQosPolicy.category) && this.print_format.equals(loggingQosPolicy.print_format);
        }
        return bl;
    }

    public int hashCode() {
        return Utilities.hashCodeNullSafe(this.output_file) + this.verbosity.hashCode() + this.category.hashCode() + this.print_format.hashCode();
    }

    LoggingQosPolicy() {
        super(QosPolicyId_t.LOGGING_QOS_POLICY_ID);
    }

    private static native long get_native_output_file_ptrI(long var0);

    private static native int get_native_verbosityI(long var0);

    private static native int get_native_categoryI(long var0);

    private static native int get_native_print_formatI(long var0);

    private static native void set_native_verbosityI(long var0, int var2);

    private static native void set_native_categoryI(long var0, int var2);

    private static native void set_native_print_formatI(long var0, int var2);
}

