/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.util.AbstractPrimitiveSequence;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class LongSeq
extends AbstractPrimitiveSequence {
    private static final long serialVersionUID = 6756796864301723163L;
    private long[] _array;

    public LongSeq() {
        this(0);
    }

    public LongSeq(int n) {
        super(Long.class, Long.TYPE, n);
    }

    public LongSeq(long[] lArray) {
        this(lArray.length);
        this.addAllLong(lArray);
    }

    public boolean addAllLong(long[] lArray, int n, int n2) {
        return this.addAllPrimitive(lArray, n, n2);
    }

    public boolean addAllLong(long[] lArray) {
        int n = lArray.length;
        return this.addAllLong(lArray, 0, n);
    }

    public void addLong(long l) {
        this.ensureSpaceForAdditionalElements(1);
        this._array[this._size++] = l;
    }

    public void addLong(int n, long l) {
        this.shiftAndEnlarge(n);
        this._array[n] = l;
    }

    public long getLong(int n) {
        this.checkIndexUpperBound(n, false);
        return this._array[n];
    }

    public long setLong(int n, long l) {
        this.checkIndexUpperBound(n, false);
        long l2 = this._array[n];
        this._array[n] = l;
        return l2;
    }

    public void setLong(int n, long[] lArray, int n2, int n3) {
        this.setPrimitive(n, lArray, n2, n3);
    }

    public long[] toArrayLong(long[] lArray) {
        int n = lArray == null ? 0 : lArray.length;
        return (long[])this.toArrayPrimitive(lArray, n);
    }

    public static void readLongArray(long[] lArray, DataInput dataInput, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            lArray[i] = dataInput.readLong();
        }
    }

    public static void writeLongArray(long[] lArray, DataOutput dataOutput, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            dataOutput.writeLong(lArray[i]);
        }
    }

    public int getMaximum() {
        return this._array == null ? 0 : this._array.length;
    }

    public Object get(int n) {
        long l = this.getLong(n);
        return new Long(l);
    }

    public Object getPrimitiveArray() {
        return this._array;
    }

    public void setPrimitiveArray(Object object, int n) {
        this._array = (long[])object;
        this._size = n;
    }

    public Object set(int n, Object object) {
        long l = this.setLong(n, (Long)object);
        return new Long(l);
    }

    public void add(int n, Object object) {
        this.addLong(n, (Long)object);
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this._size; ++i) {
            n += (int)this._array[i];
        }
        return n;
    }

    protected Object createArray(int n) {
        return new long[n];
    }

    protected void setPrimitiveArray(Object object) {
        this._array = (long[])object;
    }

    protected void readElements(ObjectInput objectInput, int n) throws IOException {
        LongSeq.readLongArray(this._array, objectInput, n);
    }

    protected void writeElements(ObjectOutput objectOutput, int n) throws IOException {
        if (this._array != null) {
            LongSeq.writeLongArray(this._array, objectOutput, n);
        }
    }
}

