/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.AbstractNativeObject;
import com.rti.dds.infrastructure.Entity;
import com.rti.dds.infrastructure.Listener;
import com.rti.dds.infrastructure.NativeObject;
import com.rti.dds.infrastructure.NativeStructMixin;
import com.rti.dds.infrastructure.Qos;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.RETCODE_OUT_OF_RESOURCES;
import com.rti.dds.util.Utilities;
import com.rti.ndds.config.ModuleLogger;

public abstract class NativeFactoryMixin
extends NativeStructMixin {
    private static final RuntimeException OUT_OF_MEMORY = new RETCODE_OUT_OF_RESOURCES("out of memory");
    private static final RuntimeException ERROR_CREATING_ENTITY = new RETCODE_ERROR("error creating entity");

    public final Entity create_entityI(Qos qos, boolean bl, Listener listener, int n, Object[] objectArray) {
        this.check_entity_aliveI();
        if (!bl) {
            this.check_for_null_argumentI(qos);
            qos.check_consistentI();
        }
        long l = this.get_native_entity();
        long l2 = 0L;
        long l3 = this.get_scratchpadI(l);
        int n2 = this.get_native_structI(l, l3, null);
        RETCODE_ERROR.check_return_codeI(n2);
        if (!bl) {
            qos.push_to_nativeI(l3);
        }
        boolean[] blArray = new boolean[1];
        l2 = this.create_native_entity(l, l3, bl, 0L, 0, blArray, objectArray);
        this.return_scratchpadI(l, l3);
        if (l2 == 0L) {
            Utilities.rethrow(ERROR_CREATING_ENTITY);
        }
        Entity entity = null;
        try {
            entity = this.wrap_with_java_entity(l2, listener, n, objectArray);
        }
        catch (Throwable throwable) {
            try {
                this.destroy_native_entity(l, l2);
            }
            catch (Throwable throwable2) {
                ModuleLogger.DDS.log(1, this.getClass(), "create_entityI", "!delete partially created entity");
                ModuleLogger.DDS.logStackTrace(this.getClass(), "create_entityI", throwable);
            }
            NativeFactoryMixin.throwFactoryException(throwable);
        }
        if (entity == null) {
            Utilities.rethrow(ERROR_CREATING_ENTITY);
            throw new IllegalStateException("unreachable");
        }
        boolean bl2 = blArray[0];
        if (bl2) {
            try {
                entity.enable();
            }
            catch (Throwable throwable) {
                try {
                    this.delete_entityI(entity);
                }
                catch (Throwable throwable3) {
                    ModuleLogger.DDS.log(1, this.getClass(), "create_entityI", "!delete entity after enable failure");
                    ModuleLogger.DDS.logStackTrace(this.getClass(), "create_entityI", throwable3);
                }
                if (throwable instanceof RETCODE_ERROR) {
                    return null;
                }
                NativeFactoryMixin.throwFactoryException(throwable);
            }
        }
        return entity;
    }

    public final void delete_entityI(Entity entity) {
        this.check_entity_aliveI();
        if (entity == null) {
            return;
        }
        NativeObject nativeObject = (NativeObject)((Object)entity);
        AbstractNativeObject.check_aliveI(nativeObject);
        nativeObject.before_delete_native();
        int n = this.destroy_native_entity(this.get_native_entity(), nativeObject.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
        nativeObject.after_delete_native();
    }

    protected NativeFactoryMixin(NativeObject nativeObject) {
        super(nativeObject);
    }

    protected Entity wrap_with_java_entity(long l, Listener listener, int n, Object[] objectArray) {
        Entity entity = this.create_java_entity(l, listener, n, objectArray);
        int n2 = this.initialize_native_to_java_pointer(l, entity);
        RETCODE_ERROR.check_return_codeI(n2);
        return entity;
    }

    protected abstract long create_native_entity(long var1, long var3, boolean var5, long var6, int var8, boolean[] var9, Object[] var10);

    protected abstract Entity create_java_entity(long var1, Listener var3, int var4, Object[] var5);

    protected abstract int initialize_native_to_java_pointer(long var1, Entity var3);

    protected abstract int destroy_native_entity(long var1, long var3);

    private static void throwFactoryException(Throwable throwable) {
        try {
            throw throwable;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Utilities.rethrow(OUT_OF_MEMORY);
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable2) {
            throw new IllegalArgumentException("Checked exception when expecting unchecked (" + throwable2.getMessage() + ")");
        }
    }
}

