/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.PropertyQosPolicy;
import com.rti.dds.infrastructure.PropertySeq;
import com.rti.dds.infrastructure.Property_t;
import com.rti.dds.infrastructure.RETCODE_BAD_PARAMETER;
import com.rti.dds.infrastructure.RETCODE_PRECONDITION_NOT_MET;

public final class PropertyQosPolicyHelper {
    public static int get_number_of_properties(PropertyQosPolicy propertyQosPolicy) {
        if (propertyQosPolicy == null) {
            throw new RETCODE_BAD_PARAMETER("policy");
        }
        return propertyQosPolicy.value.size();
    }

    public static void assert_property(PropertyQosPolicy propertyQosPolicy, String string, String string2, boolean bl) {
        if (propertyQosPolicy == null) {
            throw new RETCODE_BAD_PARAMETER("policy");
        }
        if (string == null) {
            throw new RETCODE_BAD_PARAMETER("name");
        }
        if (string2 == null) {
            throw new RETCODE_BAD_PARAMETER("value");
        }
        Property_t property_t = PropertyQosPolicyHelper.lookup_property(propertyQosPolicy, string);
        if (property_t == null) {
            property_t = new Property_t(string, string2, bl);
            propertyQosPolicy.value.add(property_t);
        } else {
            property_t.value = string2;
            property_t.propagate = bl;
        }
    }

    public static void add_property(PropertyQosPolicy propertyQosPolicy, String string, String string2, boolean bl) {
        if (propertyQosPolicy == null) {
            throw new RETCODE_BAD_PARAMETER("policy");
        }
        if (string == null) {
            throw new RETCODE_BAD_PARAMETER("name");
        }
        if (string2 == null) {
            throw new RETCODE_BAD_PARAMETER("value");
        }
        Property_t property_t = PropertyQosPolicyHelper.lookup_property(propertyQosPolicy, string);
        if (property_t != null) {
            throw new RETCODE_PRECONDITION_NOT_MET("property already exists");
        }
        property_t = new Property_t(string, string2, bl);
        propertyQosPolicy.value.add(property_t);
    }

    public static Property_t lookup_property(PropertyQosPolicy propertyQosPolicy, String string) {
        if (propertyQosPolicy == null) {
            throw new RETCODE_BAD_PARAMETER("policy");
        }
        if (string == null) {
            throw new RETCODE_BAD_PARAMETER("name");
        }
        for (int i = 0; i < propertyQosPolicy.value.size(); ++i) {
            Property_t property_t = (Property_t)propertyQosPolicy.value.get(i);
            if (!property_t.name.equals(string)) continue;
            return property_t;
        }
        return null;
    }

    public static void remove_property(PropertyQosPolicy propertyQosPolicy, String string) {
        if (propertyQosPolicy == null) {
            throw new RETCODE_BAD_PARAMETER("policy");
        }
        if (string == null) {
            throw new RETCODE_BAD_PARAMETER("name");
        }
        Property_t property_t = PropertyQosPolicyHelper.lookup_property(propertyQosPolicy, string);
        if (property_t == null) {
            throw new RETCODE_PRECONDITION_NOT_MET("property does not exist");
        }
        propertyQosPolicy.value.remove(property_t);
    }

    public static void get_properties(PropertyQosPolicy propertyQosPolicy, PropertySeq propertySeq, String string) {
        if (propertyQosPolicy == null) {
            throw new RETCODE_BAD_PARAMETER("policy");
        }
        if (propertySeq == null) {
            throw new RETCODE_BAD_PARAMETER("properties");
        }
        if (string == null) {
            throw new RETCODE_BAD_PARAMETER("name_prefix");
        }
        propertySeq.clear();
        for (int i = 0; i < propertyQosPolicy.value.size(); ++i) {
            Property_t property_t = (Property_t)propertyQosPolicy.value.get(i);
            if (property_t.name.indexOf(string) != 0) continue;
            Property_t property_t2 = new Property_t(property_t.name, property_t.value, property_t.propagate);
            propertySeq.add(property_t2);
        }
    }
}

