/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.QosPolicy;
import com.rti.dds.infrastructure.QosPolicyId_t;
import com.rti.dds.infrastructure.ThreadSettings_t;
import com.rti.dds.util.Utilities;

public final class ReceiverPoolQosPolicy
extends QosPolicy {
    public static final int LENGTH_AUTO = -2;
    public final ThreadSettings_t thread = new ThreadSettings_t();
    public int initial_receive_threads = 4;
    public int max_receive_threads = 32;
    public int buffer_size = -2;
    public int buffer_alignment = 16;
    public boolean is_timestamp_enabled = true;

    public void pull_from_nativeI(long l) {
        this.initial_receive_threads = ReceiverPoolQosPolicy.get_native_initial_receive_threadsI(l);
        this.max_receive_threads = ReceiverPoolQosPolicy.get_native_max_receive_threadsI(l);
        this.buffer_size = ReceiverPoolQosPolicy.get_native_buffer_sizeI(l);
        this.buffer_alignment = ReceiverPoolQosPolicy.get_native_buffer_alignmentI(l);
        int n = ReceiverPoolQosPolicy.get_native_is_timestamp_enabledI(l);
        this.is_timestamp_enabled = n != 0;
        long l2 = ReceiverPoolQosPolicy.get_native_threadI(l);
        this.thread.pull_from_nativeI(l2);
    }

    public void push_to_nativeI(long l) {
        long l2 = ReceiverPoolQosPolicy.get_native_threadI(l);
        this.thread.push_to_nativeI(l2);
        ReceiverPoolQosPolicy.push_to_nativeI(l, this.initial_receive_threads, this.max_receive_threads, this.buffer_size, this.buffer_alignment, this.is_timestamp_enabled);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof ReceiverPoolQosPolicy) {
            ReceiverPoolQosPolicy receiverPoolQosPolicy = (ReceiverPoolQosPolicy)object;
            bl = Utilities.equalsNullSafe(this.thread, receiverPoolQosPolicy.thread) && this.initial_receive_threads == receiverPoolQosPolicy.initial_receive_threads && this.max_receive_threads == receiverPoolQosPolicy.max_receive_threads && this.buffer_size == receiverPoolQosPolicy.buffer_size && this.buffer_alignment == receiverPoolQosPolicy.buffer_alignment && this.is_timestamp_enabled == receiverPoolQosPolicy.is_timestamp_enabled;
        }
        return bl;
    }

    public int hashCode() {
        return Utilities.hashCodeNullSafe(this.thread) + this.initial_receive_threads + this.max_receive_threads + this.buffer_size + this.buffer_alignment + (this.is_timestamp_enabled ? 1 : 0);
    }

    protected void check_consistentI() {
        super.check_consistentI();
        this.thread.check_consistentI();
    }

    ReceiverPoolQosPolicy() {
        super(QosPolicyId_t.RECEIVERPOOL_QOS_POLICY_ID);
    }

    private static native long get_native_threadI(long var0);

    private static native int get_native_initial_receive_threadsI(long var0);

    private static native int get_native_max_receive_threadsI(long var0);

    private static native int get_native_buffer_sizeI(long var0);

    private static native int get_native_buffer_alignmentI(long var0);

    private static native int get_native_is_timestamp_enabledI(long var0);

    private static native void push_to_nativeI(long var0, int var2, int var3, int var4, int var5, boolean var6);
}

