/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.Duration_t;
import com.rti.dds.infrastructure.QosPolicy;
import com.rti.dds.infrastructure.QosPolicyId_t;
import com.rti.dds.infrastructure.ReliabilityQosPolicyAcknowledgmentModeKind;
import com.rti.dds.infrastructure.ReliabilityQosPolicyKind;
import com.rti.dds.util.Utilities;

public final class ReliabilityQosPolicy
extends QosPolicy {
    public ReliabilityQosPolicyKind kind = ReliabilityQosPolicyKind.BEST_EFFORT_RELIABILITY_QOS;
    public final Duration_t max_blocking_time = new Duration_t(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public ReliabilityQosPolicyAcknowledgmentModeKind acknowledgment_kind = ReliabilityQosPolicyAcknowledgmentModeKind.PROTOCOL_ACKNOWLEDGMENT_MODE;

    public void copy_from(ReliabilityQosPolicy reliabilityQosPolicy) {
        this.kind = reliabilityQosPolicy.kind;
        this.max_blocking_time.copy_from(reliabilityQosPolicy.max_blocking_time);
        this.acknowledgment_kind = reliabilityQosPolicy.acknowledgment_kind;
    }

    public void pull_from_nativeI(long l) {
        ReliabilityQosPolicyAcknowledgmentModeKind reliabilityQosPolicyAcknowledgmentModeKind;
        ReliabilityQosPolicyKind reliabilityQosPolicyKind;
        int n = ReliabilityQosPolicy.get_native_kindI(l);
        this.kind = reliabilityQosPolicyKind = ReliabilityQosPolicyKind.valueOf(n);
        long l2 = ReliabilityQosPolicy.get_native_max_blocking_timeI(l);
        this.max_blocking_time.pull_from_nativeI(l2);
        n = ReliabilityQosPolicy.get_native_acknowledgment_kindI(l);
        this.acknowledgment_kind = reliabilityQosPolicyAcknowledgmentModeKind = ReliabilityQosPolicyAcknowledgmentModeKind.valueOf(n);
    }

    public void push_to_nativeI(long l) {
        if (this.kind == null) {
            this.throw_cant_push_nullI();
        }
        ReliabilityQosPolicy.set_native_kindI(l, this.kind.ordinal());
        long l2 = ReliabilityQosPolicy.get_native_max_blocking_timeI(l);
        this.max_blocking_time.push_to_nativeI(l2);
        ReliabilityQosPolicy.set_native_acknowledgment_kindI(l, this.acknowledgment_kind.ordinal());
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof ReliabilityQosPolicy) {
            bl = this.kind == ((ReliabilityQosPolicy)object).kind && Utilities.equalsNullSafe(this.max_blocking_time, ((ReliabilityQosPolicy)object).max_blocking_time) && this.acknowledgment_kind == ((ReliabilityQosPolicy)object).acknowledgment_kind;
        }
        return bl;
    }

    public int hashCode() {
        return Utilities.hashCodeNullSafe(this.kind) + Utilities.hashCodeNullSafe(this.max_blocking_time);
    }

    ReliabilityQosPolicy() {
        super(QosPolicyId_t.RELIABILITY_QOS_POLICY_ID);
    }

    private static native int get_native_kindI(long var0);

    private static native void set_native_kindI(long var0, int var2);

    private static native long get_native_max_blocking_timeI(long var0);

    private static native int get_native_acknowledgment_kindI(long var0);

    private static native void set_native_acknowledgment_kindI(long var0, int var2);
}

