/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.QosPolicy;
import com.rti.dds.infrastructure.QosPolicyId_t;

public final class ResourceLimitsQosPolicy
extends QosPolicy {
    public static final int LENGTH_UNLIMITED = -1;
    public int max_samples = 1;
    public int max_instances = 1;
    public int max_samples_per_instance = 1;
    public int initial_samples = 1;
    public int initial_instances = 1;
    public int instance_hash_buckets = 1;

    public void copy_from(ResourceLimitsQosPolicy resourceLimitsQosPolicy) {
        this.initial_instances = resourceLimitsQosPolicy.initial_instances;
        this.initial_samples = resourceLimitsQosPolicy.initial_samples;
        this.max_instances = resourceLimitsQosPolicy.max_instances;
        this.max_samples = resourceLimitsQosPolicy.max_samples;
        this.max_samples_per_instance = resourceLimitsQosPolicy.max_samples_per_instance;
        this.instance_hash_buckets = resourceLimitsQosPolicy.instance_hash_buckets;
    }

    public void pull_from_nativeI(long l) {
        this.max_samples = ResourceLimitsQosPolicy.get_native_max_samplesI(l);
        this.max_instances = ResourceLimitsQosPolicy.get_native_max_instancesI(l);
        this.max_samples_per_instance = ResourceLimitsQosPolicy.get_native_max_samples_per_instanceI(l);
        this.initial_samples = ResourceLimitsQosPolicy.get_native_initial_samplesI(l);
        this.initial_instances = ResourceLimitsQosPolicy.get_native_initial_instancesI(l);
        this.instance_hash_buckets = ResourceLimitsQosPolicy.get_native_instance_hash_bucketsI(l);
    }

    public void push_to_nativeI(long l) {
        ResourceLimitsQosPolicy.push_to_nativeI(l, this.max_samples, this.max_instances, this.max_samples_per_instance, this.initial_samples, this.initial_instances, this.instance_hash_buckets);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof ResourceLimitsQosPolicy) {
            ResourceLimitsQosPolicy resourceLimitsQosPolicy = (ResourceLimitsQosPolicy)object;
            bl = this.max_instances == resourceLimitsQosPolicy.max_instances && this.max_samples == resourceLimitsQosPolicy.max_samples && this.max_samples_per_instance == resourceLimitsQosPolicy.max_samples_per_instance && this.initial_samples == resourceLimitsQosPolicy.initial_samples && this.initial_instances == resourceLimitsQosPolicy.initial_instances && this.instance_hash_buckets == resourceLimitsQosPolicy.instance_hash_buckets;
        }
        return bl;
    }

    public int hashCode() {
        return this.max_instances + this.max_samples + this.max_samples_per_instance + this.initial_samples + this.initial_instances + this.instance_hash_buckets;
    }

    ResourceLimitsQosPolicy() {
        super(QosPolicyId_t.RESOURCELIMITS_QOS_POLICY_ID);
    }

    private static native int get_native_max_samplesI(long var0);

    private static native int get_native_max_instancesI(long var0);

    private static native int get_native_max_samples_per_instanceI(long var0);

    private static native int get_native_initial_samplesI(long var0);

    private static native int get_native_initial_instancesI(long var0);

    private static native int get_native_instance_hash_bucketsI(long var0);

    private static native void push_to_nativeI(long var0, int var2, int var3, int var4, int var5, int var6, int var7);
}

