/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.StringHelper;
import com.rti.dds.infrastructure.StringSeq;
import com.rti.dds.infrastructure.Struct;
import com.rti.dds.util.Utilities;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;

public final class TransportMulticastSettings_t
extends Struct {
    public final StringSeq transports = new StringSeq();
    public InetAddress receive_address;
    public int receive_port;

    public TransportMulticastSettings_t() {
    }

    public TransportMulticastSettings_t(TransportMulticastSettings_t transportMulticastSettings_t) {
        this(transportMulticastSettings_t.transports, transportMulticastSettings_t.receive_address, transportMulticastSettings_t.receive_port);
    }

    public TransportMulticastSettings_t(StringSeq stringSeq, InetAddress inetAddress, int n) {
        this.transports.addAll((Collection)stringSeq);
        this.receive_address = inetAddress;
        this.receive_port = n;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof TransportMulticastSettings_t && ((TransportMulticastSettings_t)object).transports.equals(this.transports) && Utilities.equalsNullSafe(((TransportMulticastSettings_t)object).receive_address, this.receive_address) && ((TransportMulticastSettings_t)object).receive_port == this.receive_port;
    }

    public int hashCode() {
        return this.transports.hashCode() + this.receive_port + Utilities.hashCodeNullSafe(this.receive_address);
    }

    protected void pull_from_nativeI(long l) {
        long l2 = TransportMulticastSettings_t.get_native_transportsI(l);
        this.transports.pull_from_nativeI(l2);
        String string = StringHelper.dup_native_stringI(TransportMulticastSettings_t.get_native_receive_address_ptrI(l));
        if (string.equals("AUTOMATIC")) {
            this.receive_address = null;
        } else {
            try {
                this.receive_address = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalStateException("Unknown host: " + string);
            }
        }
        this.receive_port = TransportMulticastSettings_t.get_native_receive_portI(l);
    }

    protected void push_to_nativeI(long l) {
        long l2 = TransportMulticastSettings_t.get_native_transportsI(l);
        this.transports.push_to_nativeI(l2);
        int n = this.receive_address != null ? StringHelper.replace_native_stringI(TransportMulticastSettings_t.get_native_receive_address_ptrI(l), this.receive_address.getHostAddress()) : StringHelper.replace_native_stringI(TransportMulticastSettings_t.get_native_receive_address_ptrI(l), "AUTOMATIC");
        TransportMulticastSettings_t.set_native_receive_portI(l, this.receive_port);
        RETCODE_ERROR.check_return_codeI(n);
    }

    private static native long get_native_transportsI(long var0);

    private static native long get_native_receive_address_ptrI(long var0);

    private static native int get_native_receive_portI(long var0);

    private static native void set_native_receive_portI(long var0, int var2);
}

