/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.cdr.CdrObjectInput;
import com.rti.dds.cdr.CdrObjectOutput;
import com.rti.dds.infrastructure.StringSeq;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

public final class WstringSeq
extends StringSeq {
    private static final long serialVersionUID = 547789875300181993L;

    public WstringSeq() {
    }

    public WstringSeq(int n) {
        super(n);
    }

    public WstringSeq(Collection collection) {
        super(collection);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        if (objectInput instanceof CdrObjectInput) {
            CdrObjectInput cdrObjectInput = (CdrObjectInput)objectInput;
            this.clear();
            int n = objectInput.readInt();
            for (int i = 0; i < n; ++i) {
                this.add(cdrObjectInput.readWstring());
            }
        } else {
            super.readExternal(objectInput);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (objectOutput instanceof CdrObjectOutput) {
            CdrObjectOutput cdrObjectOutput = (CdrObjectOutput)objectOutput;
            int n = this.size();
            objectOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                cdrObjectOutput.writeWstring((String)this.get(i));
            }
        } else {
            super.writeExternal(objectOutput);
        }
    }

    public static void readWstringArray(String[] stringArray, CdrObjectInput cdrObjectInput, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            stringArray[i] = cdrObjectInput.readWstring();
        }
    }

    public static void writeWstringArray(String[] stringArray, CdrObjectOutput cdrObjectOutput, int n, int n2) throws IOException {
        for (int i = 0; i < n; ++i) {
            cdrObjectOutput.writeWstring(stringArray[i], n2);
        }
    }
}

