/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.publication;

import com.rti.dds.domain.DomainParticipantFactory;
import com.rti.dds.domain.builtin.ParticipantBuiltinTopicData;
import com.rti.dds.infrastructure.Duration_t;
import com.rti.dds.infrastructure.EntityImpl;
import com.rti.dds.infrastructure.InstanceHandleSeq;
import com.rti.dds.infrastructure.InstanceHandle_t;
import com.rti.dds.infrastructure.LocatorSeq;
import com.rti.dds.infrastructure.Locator_t;
import com.rti.dds.infrastructure.NativeStructMixin;
import com.rti.dds.infrastructure.RETCODE_BAD_PARAMETER;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.Time_t;
import com.rti.dds.infrastructure.WriteParams_t;
import com.rti.dds.publication.DataWriter;
import com.rti.dds.publication.DataWriterCacheStatus;
import com.rti.dds.publication.DataWriterListener;
import com.rti.dds.publication.DataWriterListenerImpl;
import com.rti.dds.publication.DataWriterProtocolStatus;
import com.rti.dds.publication.DataWriterQos;
import com.rti.dds.publication.LivelinessLostStatus;
import com.rti.dds.publication.OfferedDeadlineMissedStatus;
import com.rti.dds.publication.OfferedIncompatibleQosStatus;
import com.rti.dds.publication.PublicationMatchedStatus;
import com.rti.dds.publication.Publisher;
import com.rti.dds.publication.PublisherImpl;
import com.rti.dds.publication.ReliableReaderActivityChangedStatus;
import com.rti.dds.publication.ReliableWriterCacheChangedStatus;
import com.rti.dds.subscription.builtin.SubscriptionBuiltinTopicData;
import com.rti.dds.topic.KeyHash_t;
import com.rti.dds.topic.Topic;
import com.rti.dds.topic.TopicImpl;
import com.rti.dds.topic.TypeSupportImpl;
import com.rti.dds.util.Utilities;

public abstract class DataWriterImpl
extends EntityImpl
implements DataWriter {
    private final NativeStructMixin _livelinessLostStatus = new LivelinessLostStatusMixin();
    private final NativeStructMixin _offeredDeadlineMissesStatus = new OfferedDeadlineMissedStatusMixin();
    private final NativeStructMixin _offeredIncompatibleQosStatus = new OfferedIncompatibleQosStatusMixin();
    private final NativeStructMixin _publicationMatchedStatus = new PublicationMatchedStatusMixin();
    private final NativeStructMixin _reliableWriterCacheChangedStatus = new ReliableWriterCacheChangedStatusMixin();
    private final NativeStructMixin _reliableReaderActivityChangedStatus = new ReliableReaderActivityChangedStatusMixin();
    private final NativeStructMixin _dataWriterCacheStatus = new DataWriterCacheStatusMixin();
    private final NativeStructMixin _dataWriterProtocolStatus = new DataWriterProtocolStatusMixin();
    private final NativeStructMixin _matchedSubscriptionDataWriterProtocolStatus = new MatchedSubscriptionDataWriterProtocolStatusMixin();
    private final NativeStructMixin _matchedSubscriptionDataWriterProtocolStatusByLocator = new MatchedSubscriptionDataWriterProtocolStatusByLocatorMixin();
    private static final RuntimeException NULL_PROFILE = new RETCODE_BAD_PARAMETER("null profile");
    private static final RuntimeException NULL_LIBRARY = new RETCODE_BAD_PARAMETER("null library");
    private final KeyHash_t _keyHash = new KeyHash_t();
    private final Object[] _serializeOption = new Object[1];

    public void get_qos(DataWriterQos dataWriterQos) {
        this.get_untyped_qos(dataWriterQos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_qos(DataWriterQos dataWriterQos) {
        boolean bl = dataWriterQos == Publisher.DATAWRITER_QOS_DEFAULT;
        EntityImpl.lock_native_entityI(((EntityImpl)((Object)this.get_publisher().get_participant())).get_native_pointer());
        try {
            this.lock();
            try {
                this._serializeOption[0] = bl ? null : dataWriterQos.type_support.plugin_data;
                this.set_untyped_qos(dataWriterQos, bl, this._serializeOption);
            }
            finally {
                this.unlock();
            }
        }
        finally {
            EntityImpl.unlock_native_entityI(((EntityImpl)((Object)this.get_publisher().get_participant())).get_native_pointer());
        }
    }

    public void set_qos_with_profile(String string, String string2) {
        this.check_aliveI();
        DataWriterQos dataWriterQos = new DataWriterQos();
        if (string2 == null) {
            string2 = this.get_publisher().get_default_library();
            string = this.get_publisher().get_default_profile_library();
        }
        if (string2 == null) {
            Utilities.rethrow(NULL_PROFILE);
        }
        if (string == null) {
            string = this.get_publisher().get_default_library();
        }
        if (string == null) {
            Utilities.rethrow(NULL_LIBRARY);
        }
        DomainParticipantFactory.get_instance().get_datawriter_qos_from_profile(dataWriterQos, string, string2);
        this.set_qos(dataWriterQos);
    }

    public DataWriterListener get_listener() {
        return (DataWriterListener)this.get_untyped_listenerI();
    }

    public void set_listener(DataWriterListener dataWriterListener, int n) {
        this.set_untyped_listenerI(dataWriterListener, n);
    }

    public void call_listenerT(int n) {
        this.check_aliveI();
        DataWriterImpl.DDS_DataWriter_call_listener(this.get_native_pointer(), n);
    }

    public void get_liveliness_lost_status(LivelinessLostStatus livelinessLostStatus) {
        this._livelinessLostStatus.get_untypedI(livelinessLostStatus);
    }

    public void set_liveliness_lost_statusT(LivelinessLostStatus livelinessLostStatus) {
        this._livelinessLostStatus.set_untypedI(livelinessLostStatus, false, false, null);
    }

    public void get_offered_deadline_missed_status(OfferedDeadlineMissedStatus offeredDeadlineMissedStatus) {
        this._offeredDeadlineMissesStatus.get_untypedI(offeredDeadlineMissedStatus);
    }

    public void set_offered_deadline_missed_statusT(OfferedDeadlineMissedStatus offeredDeadlineMissedStatus) {
        this._offeredDeadlineMissesStatus.set_untypedI(offeredDeadlineMissedStatus, false, false, null);
    }

    public void get_offered_incompatible_qos_status(OfferedIncompatibleQosStatus offeredIncompatibleQosStatus) {
        this._offeredIncompatibleQosStatus.get_untypedI(offeredIncompatibleQosStatus);
    }

    public void set_offered_incompatible_qos_statusT(OfferedIncompatibleQosStatus offeredIncompatibleQosStatus) {
        this._offeredIncompatibleQosStatus.set_untypedI(offeredIncompatibleQosStatus, false, false, null);
    }

    public void get_publication_matched_status(PublicationMatchedStatus publicationMatchedStatus) {
        this._publicationMatchedStatus.get_untypedI(publicationMatchedStatus);
    }

    public void set_publication_matched_statusT(PublicationMatchedStatus publicationMatchedStatus) {
        this._publicationMatchedStatus.set_untypedI(publicationMatchedStatus, false, false, null);
    }

    public void get_reliable_writer_cache_changed_status(ReliableWriterCacheChangedStatus reliableWriterCacheChangedStatus) {
        this._reliableWriterCacheChangedStatus.get_untypedI(reliableWriterCacheChangedStatus);
    }

    public void set_reliable_writer_cache_changed_statusT(ReliableWriterCacheChangedStatus reliableWriterCacheChangedStatus) {
        this._reliableWriterCacheChangedStatus.set_untypedI(reliableWriterCacheChangedStatus, false, false, null);
    }

    public void get_reliable_reader_activity_changed_status(ReliableReaderActivityChangedStatus reliableReaderActivityChangedStatus) {
        this._reliableReaderActivityChangedStatus.get_untypedI(reliableReaderActivityChangedStatus);
    }

    public void set_reliable_reader_activity_changed_statusT(ReliableReaderActivityChangedStatus reliableReaderActivityChangedStatus) {
        this._reliableReaderActivityChangedStatus.set_untypedI(reliableReaderActivityChangedStatus, false, false, null);
    }

    public void get_datawriter_cache_status(DataWriterCacheStatus dataWriterCacheStatus) {
        this._dataWriterCacheStatus.get_untypedI(dataWriterCacheStatus);
    }

    public void set_datawriter_cache_statusT(DataWriterCacheStatus dataWriterCacheStatus) {
        this._dataWriterCacheStatus.set_untypedI(dataWriterCacheStatus, false, false, null);
    }

    public void get_datawriter_protocol_status(DataWriterProtocolStatus dataWriterProtocolStatus) {
        this._dataWriterProtocolStatus.get_untypedI(dataWriterProtocolStatus);
    }

    public void set_datawriter_protocol_statusT(DataWriterProtocolStatus dataWriterProtocolStatus) {
        this._dataWriterProtocolStatus.set_untypedI(dataWriterProtocolStatus, false, false, null);
    }

    public void get_matched_subscription_datawriter_protocol_status(DataWriterProtocolStatus dataWriterProtocolStatus, InstanceHandle_t instanceHandle_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(dataWriterProtocolStatus);
        this.check_for_null_argumentI(instanceHandle_t);
        long l = this.get_native_pointer();
        long l2 = DataWriterImpl.get_scratchpad_matched_subscription_datawriter_protocol_statusI(l);
        int n = DataWriterImpl.DDS_DataWriter_get_matched_subscription_datawriter_protocol_status(l, l2, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
        RETCODE_ERROR.check_return_codeI(n);
        dataWriterProtocolStatus.pull_from_nativeI(l2);
    }

    public void set_matched_subscription_datawriter_protocol_statusT(DataWriterProtocolStatus dataWriterProtocolStatus, InstanceHandle_t instanceHandle_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(dataWriterProtocolStatus);
        this.check_for_null_argumentI(instanceHandle_t);
        long l = this.get_native_pointer();
        long l2 = DataWriterImpl.get_scratchpad_matched_subscription_datawriter_protocol_statusI(l);
        dataWriterProtocolStatus.push_to_nativeI(l2);
        int n = DataWriterImpl.DDS_DataWriter_set_matched_subscription_datawriter_protocol_statusT(l, l2, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void get_matched_subscription_datawriter_protocol_status_by_locator(DataWriterProtocolStatus dataWriterProtocolStatus, Locator_t locator_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(dataWriterProtocolStatus);
        this.check_for_null_argumentI(locator_t);
        long l = this.get_native_pointer();
        long l2 = DataWriterImpl.get_scratchpad_matched_subscription_datawriter_protocol_status_by_locatorI(l);
        int n = DataWriterImpl.DDS_DataWriter_get_matched_subscription_datawriter_protocol_status_by_locator(l, l2, locator_t.kind, locator_t.port, locator_t.address);
        RETCODE_ERROR.check_return_codeI(n);
        dataWriterProtocolStatus.pull_from_nativeI(l2);
    }

    public void set_matched_subscription_datawriter_protocol_status_by_locatorT(DataWriterProtocolStatus dataWriterProtocolStatus, Locator_t locator_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(dataWriterProtocolStatus);
        this.check_for_null_argumentI(locator_t);
        long l = this.get_native_pointer();
        long l2 = DataWriterImpl.get_scratchpad_matched_subscription_datawriter_protocol_status_by_locatorI(l);
        dataWriterProtocolStatus.push_to_nativeI(l2);
        int n = DataWriterImpl.DDS_DataWriter_set_matched_subscription_datawriter_protocol_status_by_locatorT(l, l2, locator_t.kind, locator_t.port, locator_t.address);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void get_matched_subscription_locators(LocatorSeq locatorSeq) {
        this.check_aliveI();
        this.check_for_null_argumentI(locatorSeq);
        long l = this.get_native_pointer();
        long l2 = DataWriterImpl.get_scratchpad_matched_subscription_locatorsI(l);
        int n = DataWriterImpl.DDS_DataWriter_get_matched_subscription_locators(l, l2);
        RETCODE_ERROR.check_return_codeI(n);
        locatorSeq.pull_from_nativeI(l2);
    }

    public void get_matched_subscriptions(InstanceHandleSeq instanceHandleSeq) {
        this.check_aliveI();
        this.check_for_null_argumentI(instanceHandleSeq);
        long l = this.get_native_pointer();
        long l2 = DataWriterImpl.get_scratchpad_matched_subscriptionsI(l);
        int n = DataWriterImpl.DDS_DataWriter_get_matched_subscriptions(l, l2);
        RETCODE_ERROR.check_return_codeI(n);
        instanceHandleSeq.pull_from_nativeI(l2);
    }

    public void get_matched_subscription_data(SubscriptionBuiltinTopicData subscriptionBuiltinTopicData, InstanceHandle_t instanceHandle_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(subscriptionBuiltinTopicData);
        this.check_for_null_argumentI(instanceHandle_t);
        long l = this.get_native_pointer();
        long l2 = DataWriterImpl.get_scratchpad_subscription_dataI(l);
        int n = DataWriterImpl.DDS_DataWriter_get_matched_subscription_data(l, l2, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
        RETCODE_ERROR.check_return_codeI(n);
        subscriptionBuiltinTopicData.pull_from_nativeI(l2);
        DataWriterImpl.DDS_SubscriptionBuiltinTopicData_finalize(l2);
    }

    public void get_matched_subscription_participant_data(ParticipantBuiltinTopicData participantBuiltinTopicData, InstanceHandle_t instanceHandle_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(participantBuiltinTopicData);
        this.check_for_null_argumentI(instanceHandle_t);
        long l = this.get_native_pointer();
        long l2 = DataWriterImpl.get_scratchpad_participant_dataI(l);
        int n = DataWriterImpl.DDS_DataWriter_get_matched_subscription_participant_data(l, l2, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
        RETCODE_ERROR.check_return_codeI(n);
        participantBuiltinTopicData.pull_from_nativeI(l2);
        DataWriterImpl.DDS_ParticipantBuiltinTopicData_finalize(l2);
    }

    public Publisher get_publisher() {
        if (!this.is_alive()) {
            return null;
        }
        Publisher publisher = null;
        long l = DataWriterImpl.DDS_DataWriter_get_publisher(this.get_native_pointer());
        if (l != 0L) {
            publisher = (Publisher)PublisherImpl.get_publisherI(l);
        }
        return publisher;
    }

    public Topic get_topic() {
        if (!this.is_alive()) {
            return null;
        }
        Topic topic = null;
        long l = DataWriterImpl.DDS_DataWriter_get_topic(this.get_native_pointer());
        if (l != 0L) {
            topic = (Topic)TopicImpl.get_topicI(l);
        }
        return topic;
    }

    public void wait_for_acknowledgments(Duration_t duration_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(duration_t);
        long l = DataWriterImpl.get_scratchpad_timeoutI(this.get_native_pointer());
        duration_t.push_to_nativeI(l);
        int n = DataWriterImpl.DDS_DataWriter_wait_for_acknowledgments(this.get_native_pointer(), l);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void wait_for_asynchronous_publishing(Duration_t duration_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(duration_t);
        long l = DataWriterImpl.get_scratchpad_timeoutI(this.get_native_pointer());
        duration_t.push_to_nativeI(l);
        int n = DataWriterImpl.DDS_DataWriter_wait_for_asynchronous_publishing(this.get_native_pointer(), l);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void assert_liveliness() {
        this.check_aliveI();
        long l = this.get_native_pointer();
        int n = DataWriterImpl.DDS_DataWriter_assert_liveliness(l);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void flush() {
        this.check_aliveI();
        long l = this.get_native_pointer();
        int n = DataWriterImpl.DDS_DataWriter_flush(l);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void on_native_entity_finalized() {
        super.cleanup();
        this._livelinessLostStatus.cleanup();
        this._offeredDeadlineMissesStatus.cleanup();
        this._offeredIncompatibleQosStatus.cleanup();
        this._publicationMatchedStatus.cleanup();
        this._reliableWriterCacheChangedStatus.cleanup();
        this._reliableReaderActivityChangedStatus.cleanup();
        this._dataWriterCacheStatus.cleanup();
        this._dataWriterProtocolStatus.cleanup();
        this._matchedSubscriptionDataWriterProtocolStatus.cleanup();
        this._matchedSubscriptionDataWriterProtocolStatusByLocator.cleanup();
    }

    public KeyHash_t get_key_hash() {
        return this._keyHash;
    }

    public void unregister_instance_untyped(Object object, InstanceHandle_t instanceHandle_t) {
        this.check_unregister_dispose_preconditionsI(object, instanceHandle_t);
        if (instanceHandle_t == null) {
            instanceHandle_t = InstanceHandle_t.HANDLE_NIL;
        }
        int n = DataWriterImpl.DDS_DataWriter_unregister_instance_untypedI(this.get_native_pointer(), object, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public final void unregister_instance_w_timestamp_untyped(Object object, InstanceHandle_t instanceHandle_t, Time_t time_t) {
        this.check_unregister_dispose_preconditionsI(object, instanceHandle_t);
        this.check_for_null_argumentI(time_t);
        if (instanceHandle_t == null) {
            instanceHandle_t = InstanceHandle_t.HANDLE_NIL;
        }
        int n = DataWriterImpl.DDS_DataWriter_unregister_instance_w_timestamp_untypedI(this.get_native_pointer(), object, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil(), time_t.sec, time_t.nanosec);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public final void unregister_instance_w_params_untyped(Object object, WriteParams_t writeParams_t) {
        this.check_unregister_dispose_preconditionsI(object, writeParams_t.handle);
        this.check_for_null_argumentI(writeParams_t.source_timestamp);
        if (writeParams_t.handle == null) {
            writeParams_t.handle.copy_from(InstanceHandle_t.HANDLE_NIL);
        }
        long l = DataWriterImpl.get_scratchpad_writeParamsI(this.get_native_pointer());
        writeParams_t.push_to_nativeI(l);
        int n = DataWriterImpl.DDS_DataWriter_unregister_instance_w_params_untypedI(this.get_native_pointer(), object, l);
        RETCODE_ERROR.check_return_codeI(n);
        if (writeParams_t.replace_auto) {
            writeParams_t.pull_from_nativeI(l);
        }
    }

    public void write_untyped(Object object, InstanceHandle_t instanceHandle_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(object);
        if (instanceHandle_t == null) {
            instanceHandle_t = InstanceHandle_t.HANDLE_NIL;
        }
        int n = DataWriterImpl.DDS_DataWriter_write_untypedI(this.get_native_pointer(), object, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public final void write_w_timestamp_untyped(Object object, InstanceHandle_t instanceHandle_t, Time_t time_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(object);
        this.check_for_null_argumentI(time_t);
        if (instanceHandle_t == null) {
            instanceHandle_t = InstanceHandle_t.HANDLE_NIL;
        }
        int n = DataWriterImpl.DDS_DataWriter_write_w_timestamp_untypedI(this.get_native_pointer(), object, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil(), time_t.sec, time_t.nanosec);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void write_w_params_untyped(Object object, WriteParams_t writeParams_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(object);
        this.check_for_null_argumentI(writeParams_t.source_timestamp);
        if (writeParams_t.handle == null) {
            writeParams_t.handle.copy_from(InstanceHandle_t.HANDLE_NIL);
        }
        long l = DataWriterImpl.get_scratchpad_writeParamsI(this.get_native_pointer());
        writeParams_t.push_to_nativeI(l);
        int n = DataWriterImpl.DDS_DataWriter_write_w_params_untypedI(this.get_native_pointer(), object, l);
        RETCODE_ERROR.check_return_codeI(n);
        if (writeParams_t.replace_auto) {
            writeParams_t.pull_from_nativeI(l);
        }
    }

    public final void dispose_untyped(Object object, InstanceHandle_t instanceHandle_t) {
        this.check_unregister_dispose_preconditionsI(object, instanceHandle_t);
        if (instanceHandle_t == null) {
            instanceHandle_t = InstanceHandle_t.HANDLE_NIL;
        }
        int n = DataWriterImpl.DDS_DataWriter_dispose_untypedI(this.get_native_pointer(), object, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void dispose_w_timestamp_untyped(Object object, InstanceHandle_t instanceHandle_t, Time_t time_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(object);
        this.check_for_null_argumentI(time_t);
        if (instanceHandle_t == null) {
            instanceHandle_t = InstanceHandle_t.HANDLE_NIL;
        }
        int n = DataWriterImpl.DDS_DataWriter_dispose_w_timestamp_untypedI(this.get_native_pointer(), object, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil(), time_t.sec, time_t.nanosec);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void dispose_w_params_untyped(Object object, WriteParams_t writeParams_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(object);
        this.check_for_null_argumentI(writeParams_t.source_timestamp);
        if (writeParams_t.handle == null) {
            writeParams_t.handle.copy_from(InstanceHandle_t.HANDLE_NIL);
        }
        long l = DataWriterImpl.get_scratchpad_writeParamsI(this.get_native_pointer());
        writeParams_t.push_to_nativeI(l);
        int n = DataWriterImpl.DDS_DataWriter_dispose_w_params_untypedI(this.get_native_pointer(), object, l);
        RETCODE_ERROR.check_return_codeI(n);
        if (writeParams_t.replace_auto) {
            writeParams_t.pull_from_nativeI(l);
        }
    }

    public final void get_key_value_untyped(Object object, InstanceHandle_t instanceHandle_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(object);
        this.check_for_null_argumentI(instanceHandle_t);
        int n = DataWriterImpl.DDS_DataWriter_get_key_value_untypedI(this.get_native_pointer(), object, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public InstanceHandle_t register_instance_untyped(Object object) {
        long l;
        InstanceHandle_t instanceHandle_t = InstanceHandle_t.HANDLE_NIL;
        if (object == null || !this.is_alive()) {
            return instanceHandle_t;
        }
        long l2 = this.get_native_pointer();
        boolean bl = DataWriterImpl.DDS_DataWriter_register_instance_untypedI(l2, object, l = DataWriterImpl.get_scratchpad_instancehandleI(l2));
        if (bl) {
            instanceHandle_t = new InstanceHandle_t(instanceHandle_t);
            instanceHandle_t.pull_from_nativeI(l);
        }
        return instanceHandle_t;
    }

    public final InstanceHandle_t register_instance_w_timestamp_untyped(Object object, Time_t time_t) {
        long l;
        InstanceHandle_t instanceHandle_t = InstanceHandle_t.HANDLE_NIL;
        if (object == null || !this.is_alive() || time_t == null || time_t.is_invalid()) {
            return instanceHandle_t;
        }
        long l2 = this.get_native_pointer();
        boolean bl = DataWriterImpl.DDS_DataWriter_register_instance_w_timestamp_untypedI(l2, object, l = DataWriterImpl.get_scratchpad_instancehandleI(l2), time_t.sec, time_t.nanosec);
        if (bl) {
            instanceHandle_t = new InstanceHandle_t(instanceHandle_t);
            instanceHandle_t.pull_from_nativeI(l);
        }
        return instanceHandle_t;
    }

    public InstanceHandle_t register_instance_w_params_untyped(Object object, WriteParams_t writeParams_t) {
        InstanceHandle_t instanceHandle_t = InstanceHandle_t.HANDLE_NIL;
        if (object == null || !this.is_alive() || writeParams_t.source_timestamp == null || writeParams_t.source_timestamp.is_invalid()) {
            return instanceHandle_t;
        }
        long l = this.get_native_pointer();
        long l2 = DataWriterImpl.get_scratchpad_instancehandleI(l);
        long l3 = DataWriterImpl.get_scratchpad_writeParamsI(this.get_native_pointer());
        writeParams_t.push_to_nativeI(l3);
        boolean bl = DataWriterImpl.DDS_DataWriter_register_instance_w_params_untypedI(l, object, l2, l3);
        if (bl) {
            instanceHandle_t = new InstanceHandle_t(instanceHandle_t);
            instanceHandle_t.pull_from_nativeI(l2);
        }
        return instanceHandle_t;
    }

    public final InstanceHandle_t lookup_instance_untyped(Object object) {
        long l;
        InstanceHandle_t instanceHandle_t = InstanceHandle_t.HANDLE_NIL;
        if (object == null || !this.is_alive()) {
            return instanceHandle_t;
        }
        long l2 = this.get_native_pointer();
        boolean bl = DataWriterImpl.DDS_DataWriter_lookup_instance_untypedI(l2, object, l = DataWriterImpl.get_scratchpad_instancehandleI(l2));
        if (bl) {
            instanceHandle_t = new InstanceHandle_t(instanceHandle_t);
            instanceHandle_t.pull_from_nativeI(l);
        }
        return instanceHandle_t;
    }

    public static native Object get_datawriterI(long var0);

    protected DataWriterImpl(long l, DataWriterListener dataWriterListener, int n, TypeSupportImpl typeSupportImpl) {
        super(l, new DataWriterListenerImpl(dataWriterListener, n, l));
        this.initializeQosMixin(new DataWriterQosMixin());
    }

    protected final void unregister_instance_untypedX(Object object, InstanceHandle_t instanceHandle_t) {
        this.unregister_instance_untyped(object, instanceHandle_t);
    }

    protected final void unregister_instance_w_timestamp_untypedX(Object object, InstanceHandle_t instanceHandle_t, Time_t time_t) {
        this.unregister_instance_w_timestamp_untyped(object, instanceHandle_t, time_t);
    }

    protected final void write_untypedX(Object object, InstanceHandle_t instanceHandle_t) {
        this.write_untyped(object, instanceHandle_t);
    }

    protected final void write_w_timestamp_untypedX(Object object, InstanceHandle_t instanceHandle_t, Time_t time_t) {
        this.write_w_timestamp_untyped(object, instanceHandle_t, time_t);
    }

    protected final void dispose_untypedX(Object object, InstanceHandle_t instanceHandle_t) {
        this.dispose_untyped(object, instanceHandle_t);
    }

    protected final void dispose_w_timestamp_untypedX(Object object, InstanceHandle_t instanceHandle_t, Time_t time_t) {
        this.dispose_w_timestamp_untyped(object, instanceHandle_t, time_t);
    }

    protected final void get_key_value_untypedX(Object object, InstanceHandle_t instanceHandle_t) {
        this.get_key_value_untyped(object, instanceHandle_t);
    }

    protected final InstanceHandle_t register_instance_untypedX(Object object) {
        return this.register_instance_untyped(object);
    }

    protected final InstanceHandle_t register_instance_w_timestamp_untypedX(Object object, Time_t time_t) {
        return this.register_instance_w_timestamp_untyped(object, time_t);
    }

    protected final InstanceHandle_t lookup_instance_untypedX(Object object) {
        return this.lookup_instance_untyped(object);
    }

    private void check_unregister_dispose_preconditionsI(Object object, InstanceHandle_t instanceHandle_t) {
        this.check_aliveI();
        if (instanceHandle_t == null || instanceHandle_t.is_nil()) {
            this.check_for_null_argumentI(object);
        }
    }

    private static native int DDS_DataWriter_get_qos(long var0, long var2);

    private static native int DDS_DataWriter_set_qos(long var0, long var2, boolean var4, Object var5);

    private static native long get_scratchpad_datawriter_qosI(long var0);

    private static native int DDS_DataWriter_get_liveliness_lost_status(long var0, long var2);

    private static native int DDS_DataWriter_set_liveliness_lost_status(long var0, long var2);

    private static native long get_scratchpad_liveliness_lost_statusI(long var0);

    private static native int DDS_DataWriter_get_offered_deadline_missed_status(long var0, long var2);

    private static native int DDS_DataWriter_set_offered_deadline_missed_status(long var0, long var2);

    private static native long get_scratchpad_offered_deadline_missed_statusI(long var0);

    private static native int DDS_DataWriter_get_offered_incompatible_qos_status(long var0, long var2);

    private static native int DDS_DataWriter_set_offered_incompatible_qos_status(long var0, long var2);

    private static native long get_scratchpad_offered_incompatible_qos_statusI(long var0);

    private static native long get_scratchpad_publication_matched_statusI(long var0);

    private static native int DDS_DataWriter_get_publication_matched_status(long var0, long var2);

    private static native int DDS_DataWriter_set_publication_matched_statusT(long var0, long var2);

    private static native long get_scratchpad_reliable_writer_cache_changed_statusI(long var0);

    private static native int DDS_DataWriter_get_reliable_writer_cache_changed_status(long var0, long var2);

    private static native int DDS_DataWriter_set_reliable_writer_cache_changed_statusT(long var0, long var2);

    private static native long get_scratchpad_reliable_reader_activity_changed_statusI(long var0);

    private static native int DDS_DataWriter_get_reliable_reader_activity_changed_status(long var0, long var2);

    private static native int DDS_DataWriter_set_reliable_reader_activity_changed_statusT(long var0, long var2);

    private static native long get_scratchpad_datawriter_cache_statusI(long var0);

    private static native int DDS_DataWriter_get_datawriter_cache_status(long var0, long var2);

    private static native int DDS_DataWriter_set_datawriter_cache_statusT(long var0, long var2);

    private static native long get_scratchpad_datawriter_protocol_statusI(long var0);

    private static native int DDS_DataWriter_get_datawriter_protocol_status(long var0, long var2);

    private static native int DDS_DataWriter_set_datawriter_protocol_statusT(long var0, long var2);

    private static native long get_scratchpad_matched_subscription_datawriter_protocol_statusI(long var0);

    private static native int DDS_DataWriter_get_matched_subscription_datawriter_protocol_status(long var0, long var2, byte[] var4, int var5, boolean var6);

    private static native int DDS_DataWriter_set_matched_subscription_datawriter_protocol_statusT(long var0, long var2, byte[] var4, int var5, boolean var6);

    private static native long get_scratchpad_matched_subscription_datawriter_protocol_status_by_locatorI(long var0);

    private static native int DDS_DataWriter_get_matched_subscription_datawriter_protocol_status_by_locator(long var0, long var2, int var4, int var5, byte[] var6);

    private static native int DDS_DataWriter_set_matched_subscription_datawriter_protocol_status_by_locatorT(long var0, long var2, int var4, int var5, byte[] var6);

    private static native long get_scratchpad_matched_subscription_locatorsI(long var0);

    private static native int DDS_DataWriter_get_matched_subscription_locators(long var0, long var2);

    protected static native long get_scratchpad_writeParamsI(long var0);

    private static native boolean DDS_DataWriter_register_instance_untypedI(long var0, Object var2, long var3);

    private static native boolean DDS_DataWriter_register_instance_w_timestamp_untypedI(long var0, Object var2, long var3, int var5, int var6);

    private static native boolean DDS_DataWriter_register_instance_w_params_untypedI(long var0, Object var2, long var3, long var5);

    private static native int DDS_DataWriter_unregister_instance_untypedI(long var0, Object var2, byte[] var3, int var4, boolean var5);

    private static native int DDS_DataWriter_unregister_instance_w_timestamp_untypedI(long var0, Object var2, byte[] var3, int var4, boolean var5, int var6, int var7);

    private static native int DDS_DataWriter_unregister_instance_w_params_untypedI(long var0, Object var2, long var3);

    private static native int DDS_DataWriter_dispose_untypedI(long var0, Object var2, byte[] var3, int var4, boolean var5);

    private static native int DDS_DataWriter_dispose_w_timestamp_untypedI(long var0, Object var2, byte[] var3, int var4, boolean var5, int var6, int var7);

    private static native int DDS_DataWriter_dispose_w_params_untypedI(long var0, Object var2, long var3);

    private static native int DDS_DataWriter_write_untypedI(long var0, Object var2, byte[] var3, int var4, boolean var5);

    private static native int DDS_DataWriter_write_w_timestamp_untypedI(long var0, Object var2, byte[] var3, int var4, boolean var5, int var6, int var7);

    private static native int DDS_DataWriter_write_w_params_untypedI(long var0, Object var2, long var3);

    private static native int DDS_DataWriter_call_listener(long var0, int var2);

    private static native long DDS_DataWriter_get_topic(long var0);

    private static native long DDS_DataWriter_get_publisher(long var0);

    private static native int DDS_DataWriter_wait_for_acknowledgments(long var0, long var2);

    private static native int DDS_DataWriter_wait_for_asynchronous_publishing(long var0, long var2);

    private static native long get_scratchpad_timeoutI(long var0);

    private static native int DDS_DataWriter_assert_liveliness(long var0);

    private static native int DDS_DataWriter_flush(long var0);

    private static native long get_scratchpad_matched_subscriptionsI(long var0);

    private static native int DDS_DataWriter_get_matched_subscriptions(long var0, long var2);

    private static native long get_scratchpad_subscription_dataI(long var0);

    private static native long get_scratchpad_participant_dataI(long var0);

    private static native int DDS_DataWriter_get_matched_subscription_data(long var0, long var2, byte[] var4, int var5, boolean var6);

    private static native int DDS_DataWriter_get_matched_subscription_participant_data(long var0, long var2, byte[] var4, int var5, boolean var6);

    private static native void DDS_SubscriptionBuiltinTopicData_finalize(long var0);

    private static native void DDS_ParticipantBuiltinTopicData_finalize(long var0);

    private static native long get_scratchpad_instancehandleI(long var0);

    private static native boolean DDS_DataWriter_lookup_instance_untypedI(long var0, Object var2, long var3);

    private static native int DDS_DataWriter_get_key_value_untypedI(long var0, Object var2, byte[] var3, int var4, boolean var5);

    private final class MatchedSubscriptionDataWriterProtocolStatusByLocatorMixin
    extends NativeStructMixin {
        public MatchedSubscriptionDataWriterProtocolStatusByLocatorMixin() {
            super(DataWriterImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataWriterImpl.get_scratchpad_matched_subscription_datawriter_protocol_status_by_locatorI(DataWriterImpl.this.get_native_pointer());
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return 0;
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return 0;
        }
    }

    private final class MatchedSubscriptionDataWriterProtocolStatusMixin
    extends NativeStructMixin {
        public MatchedSubscriptionDataWriterProtocolStatusMixin() {
            super(DataWriterImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataWriterImpl.get_scratchpad_matched_subscription_datawriter_protocol_statusI(DataWriterImpl.this.get_native_pointer());
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return 0;
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return 0;
        }
    }

    private final class DataWriterProtocolStatusMixin
    extends NativeStructMixin {
        public DataWriterProtocolStatusMixin() {
            super(DataWriterImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataWriterImpl.get_scratchpad_datawriter_protocol_statusI(DataWriterImpl.this.get_native_pointer());
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DataWriterImpl.DDS_DataWriter_get_datawriter_protocol_status(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return DataWriterImpl.DDS_DataWriter_set_datawriter_protocol_statusT(l, l2);
        }
    }

    private final class DataWriterCacheStatusMixin
    extends NativeStructMixin {
        public DataWriterCacheStatusMixin() {
            super(DataWriterImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataWriterImpl.get_scratchpad_datawriter_cache_statusI(DataWriterImpl.this.get_native_pointer());
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DataWriterImpl.DDS_DataWriter_get_datawriter_cache_status(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return DataWriterImpl.DDS_DataWriter_set_datawriter_cache_statusT(l, l2);
        }
    }

    private final class ReliableReaderActivityChangedStatusMixin
    extends NativeStructMixin {
        public ReliableReaderActivityChangedStatusMixin() {
            super(DataWriterImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataWriterImpl.get_scratchpad_reliable_reader_activity_changed_statusI(DataWriterImpl.this.get_native_pointer());
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DataWriterImpl.DDS_DataWriter_get_reliable_reader_activity_changed_status(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return DataWriterImpl.DDS_DataWriter_set_reliable_reader_activity_changed_statusT(l, l2);
        }
    }

    private final class ReliableWriterCacheChangedStatusMixin
    extends NativeStructMixin {
        public ReliableWriterCacheChangedStatusMixin() {
            super(DataWriterImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataWriterImpl.get_scratchpad_reliable_writer_cache_changed_statusI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DataWriterImpl.DDS_DataWriter_get_reliable_writer_cache_changed_status(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return DataWriterImpl.DDS_DataWriter_set_reliable_writer_cache_changed_statusT(l, l2);
        }
    }

    private final class PublicationMatchedStatusMixin
    extends NativeStructMixin {
        public PublicationMatchedStatusMixin() {
            super(DataWriterImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataWriterImpl.get_scratchpad_publication_matched_statusI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DataWriterImpl.DDS_DataWriter_get_publication_matched_status(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return DataWriterImpl.DDS_DataWriter_set_publication_matched_statusT(l, l2);
        }
    }

    private final class OfferedIncompatibleQosStatusMixin
    extends NativeStructMixin {
        public OfferedIncompatibleQosStatusMixin() {
            super(DataWriterImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataWriterImpl.get_scratchpad_offered_incompatible_qos_statusI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DataWriterImpl.DDS_DataWriter_get_offered_incompatible_qos_status(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return DataWriterImpl.DDS_DataWriter_set_offered_incompatible_qos_status(l, l2);
        }
    }

    private final class OfferedDeadlineMissedStatusMixin
    extends NativeStructMixin {
        public OfferedDeadlineMissedStatusMixin() {
            super(DataWriterImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataWriterImpl.get_scratchpad_offered_deadline_missed_statusI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DataWriterImpl.DDS_DataWriter_get_offered_deadline_missed_status(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return DataWriterImpl.DDS_DataWriter_set_offered_deadline_missed_status(l, l2);
        }
    }

    private final class LivelinessLostStatusMixin
    extends NativeStructMixin {
        public LivelinessLostStatusMixin() {
            super(DataWriterImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataWriterImpl.get_scratchpad_liveliness_lost_statusI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DataWriterImpl.DDS_DataWriter_get_liveliness_lost_status(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return DataWriterImpl.DDS_DataWriter_set_liveliness_lost_status(l, l2);
        }
    }

    private final class DataWriterQosMixin
    extends NativeStructMixin {
        public DataWriterQosMixin() {
            super(DataWriterImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataWriterImpl.get_scratchpad_datawriter_qosI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DataWriterImpl.DDS_DataWriter_get_qos(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            Object object = objectArray[0];
            return DataWriterImpl.DDS_DataWriter_set_qos(l, l2, bl, object);
        }
    }
}

