/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.sqlfilter;

import com.rti.dds.sqlfilter.BoolExpression;
import com.rti.dds.sqlfilter.EvaluatorBoolean;
import com.rti.dds.sqlfilter.EvaluatorCorbaEnum;
import com.rti.dds.sqlfilter.EvaluatorDouble;
import com.rti.dds.sqlfilter.EvaluatorEnum;
import com.rti.dds.sqlfilter.EvaluatorLong;
import com.rti.dds.sqlfilter.EvaluatorString;
import com.rti.dds.sqlfilter.ObjectValue;
import com.rti.dds.sqlfilter.ParseException;
import com.rti.dds.sqlfilter.RelationalOperator;
import com.rti.dds.sqlfilter.SpecialParseExceptions;

public abstract class BoolExpressionRELOP
implements BoolExpression {
    protected final ObjectValue _leftObjectValue;
    protected final ObjectValue _rightObjectValue;
    protected final int _relOp;
    protected final boolean _leftIsVariable;
    protected final boolean _rightIsVariable;

    protected BoolExpressionRELOP(ObjectValue objectValue, int n, ObjectValue objectValue2) {
        this._leftObjectValue = objectValue;
        this._relOp = n;
        this._rightObjectValue = objectValue2;
        this._leftIsVariable = this._leftObjectValue.isVariable();
        this._rightIsVariable = this._rightObjectValue.isVariable();
    }

    public static BoolExpression create(ObjectValue objectValue, int n, ObjectValue objectValue2) throws ParseException {
        if (objectValue.isLong() && objectValue2.isLong()) {
            return new EvaluatorLong(objectValue, n, objectValue2);
        }
        if (objectValue.isDouble() && objectValue2.isDouble() || objectValue.isDouble() && objectValue2.isLong() || objectValue.isLong() && objectValue2.isDouble()) {
            return new EvaluatorDouble(objectValue, n, objectValue2);
        }
        if (objectValue.isBoolean() && objectValue2.isBoolean()) {
            return new EvaluatorBoolean(objectValue, n, objectValue2);
        }
        if (objectValue.isString() && objectValue2.isString()) {
            return new EvaluatorString(objectValue, n, objectValue2);
        }
        if (objectValue.isEnum() && (objectValue2.isString() || objectValue2.isLong() || objectValue2.isEnum()) || objectValue2.isEnum() && (objectValue.isString() || objectValue.isLong() || objectValue.isEnum())) {
            return new EvaluatorEnum(objectValue, n, objectValue2);
        }
        if (objectValue.isCorbaEnum() && (objectValue2.isString() || objectValue2.isLong() || objectValue2.isCorbaEnum()) || objectValue2.isCorbaEnum() && (objectValue.isString() || objectValue.isLong() || objectValue.isCorbaEnum())) {
            return new EvaluatorCorbaEnum(objectValue, n, objectValue2);
        }
        throw SpecialParseExceptions.TYPE_COMB_NOT_ALLOWED;
    }

    public abstract boolean evaluate(Object var1);

    public String toString() {
        return "(" + this._leftObjectValue.toString() + RelationalOperator.getRelationalOperatorSymbol(this._relOp) + this._rightObjectValue.toString() + ")";
    }
}

