/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.sqlfilter;

import com.rti.dds.infrastructure.RETCODE_BAD_PARAMETER;
import com.rti.dds.sqlfilter.BoolExpressionRELOP;
import com.rti.dds.sqlfilter.CorbaUtilities;
import com.rti.dds.sqlfilter.ObjectValue;
import com.rti.dds.sqlfilter.ObjectValueGetValueException;
import com.rti.dds.sqlfilter.ParseException;
import com.rti.dds.sqlfilter.SpecialParseExceptions;

public class EvaluatorCorbaEnum
extends BoolExpressionRELOP {
    private long _leftLong = -1L;
    private long _rightLong = -1L;
    private final Class _enumClass;
    private final boolean _leftObjectValueIsEnum;
    private final boolean _rightObjectValueIsEnum;

    public EvaluatorCorbaEnum(ObjectValue objectValue, int n, ObjectValue objectValue2) throws ParseException {
        super(objectValue, n, objectValue2);
        this._leftObjectValueIsEnum = objectValue.isCorbaEnum();
        this._rightObjectValueIsEnum = objectValue2.isCorbaEnum();
        this._enumClass = this._leftObjectValueIsEnum ? objectValue.getValueClass() : objectValue2.getValueClass();
        if (this._leftObjectValueIsEnum && this._rightObjectValueIsEnum && !this._enumClass.equals(objectValue2.getValueClass())) {
            throw SpecialParseExceptions.ENUM_TYPE_COMB_NOT_ALLOWED;
        }
        if (objectValue.isString() && this._leftIsVariable || objectValue2.isString() && this._rightIsVariable) {
            throw SpecialParseExceptions.ENUM_TYPE_COMB_NOT_ALLOWED;
        }
        if (this._relOp == 6) {
            throw SpecialParseExceptions.MATCH_OPERATOR_ONLY_SUPPORTED_FOR_STRINGS;
        }
        if (!this._leftIsVariable) {
            if (this._leftObjectValueIsEnum) {
                this._leftLong = CorbaUtilities.corbaEnumValueOf(this._enumClass, this._leftObjectValue.getValue());
            } else if (objectValue.isString()) {
                try {
                    this._leftLong = CorbaUtilities.corbaEnumValueOf(this._enumClass, this._leftObjectValue.getValue().toString());
                }
                catch (RETCODE_BAD_PARAMETER rETCODE_BAD_PARAMETER) {
                    throw SpecialParseExceptions.ENUM_TYPE_COMB_NOT_ALLOWED;
                }
            } else {
                this._leftLong = ((Number)objectValue.getValue()).longValue();
            }
        }
        if (!this._rightIsVariable) {
            if (this._rightObjectValueIsEnum) {
                this._rightLong = CorbaUtilities.corbaEnumValueOf(this._enumClass, this._rightObjectValue.getValue());
            } else if (this._rightObjectValue.isString()) {
                try {
                    this._rightLong = CorbaUtilities.corbaEnumValueOf(this._enumClass, this._rightObjectValue.getValue().toString());
                }
                catch (RETCODE_BAD_PARAMETER rETCODE_BAD_PARAMETER) {
                    throw SpecialParseExceptions.ENUM_TYPE_COMB_NOT_ALLOWED;
                }
            } else {
                this._rightLong = ((Number)objectValue2.getValue()).longValue();
            }
        }
    }

    public boolean evaluate(Object object) {
        try {
            if (this._leftIsVariable) {
                this._leftLong = this._leftObjectValueIsEnum ? (long)CorbaUtilities.corbaEnumValueOf(this._enumClass, this._leftObjectValue.getValue(object)) : ((Number)this._leftObjectValue.getValue(object)).longValue();
            }
            if (this._rightIsVariable) {
                this._rightLong = this._rightObjectValueIsEnum ? (long)CorbaUtilities.corbaEnumValueOf(this._enumClass, this._rightObjectValue.getValue(object)) : ((Number)this._rightObjectValue.getValue(object)).longValue();
            }
        }
        catch (ObjectValueGetValueException objectValueGetValueException) {
            return false;
        }
        switch (this._relOp) {
            case 0: {
                return this._leftLong == this._rightLong;
            }
            case 1: {
                return this._leftLong > this._rightLong;
            }
            case 2: {
                return this._leftLong >= this._rightLong;
            }
            case 3: {
                return this._leftLong < this._rightLong;
            }
            case 4: {
                return this._leftLong <= this._rightLong;
            }
            case 5: {
                return this._leftLong != this._rightLong;
            }
        }
        throw new RuntimeException("INVALID OPERATOR");
    }
}

