/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.sqlfilter;

import com.rti.dds.infrastructure.StringSeq;
import com.rti.dds.sqlfilter.ObjectValue;
import com.rti.dds.sqlfilter.Parameter;
import com.rti.dds.sqlfilter.ParseException;
import com.rti.dds.sqlfilter.SpecialParseExceptions;
import com.rti.dds.sqlfilter.SqlWhereParser;
import com.rti.dds.sqlfilter.Token;
import java.io.StringReader;
import java.util.ArrayList;

public class ParameterList {
    private ArrayList _parameterArrayList = null;
    private final int MAX_PARAM_COUNT = 100;

    public ParameterList(StringSeq stringSeq) throws ParseException {
        SqlWhereParser sqlWhereParser = null;
        if (stringSeq == null) {
            return;
        }
        if (stringSeq.size() == 0) {
            return;
        }
        if (stringSeq.size() > 100) {
            throw SpecialParseExceptions.PARAMETER_COUNT_OUT_OF_BOUNDS;
        }
        this._parameterArrayList = new ArrayList(stringSeq.size());
        for (int i = 0; i < stringSeq.size(); ++i) {
            ObjectValue objectValue = null;
            Token token = null;
            Parameter parameter = null;
            if (sqlWhereParser == null) {
                sqlWhereParser = new SqlWhereParser(new StringReader((String)stringSeq.get(0)));
            } else {
                sqlWhereParser.ReInit(new StringReader((String)stringSeq.get(i)));
            }
            try {
                objectValue = sqlWhereParser.VALUE();
                token = null;
                token = sqlWhereParser.getNextToken();
                if (token == null) {
                    throw SpecialParseExceptions.MULTIPLE_TOKENS_IN_PARAMETER;
                }
                if (token.kind != 0) {
                    throw SpecialParseExceptions.MULTIPLE_TOKENS_IN_PARAMETER;
                }
                parameter = new Parameter(objectValue, i);
                this._parameterArrayList.add(parameter);
                continue;
            }
            catch (ParseException parseException) {
                throw SpecialParseExceptions.PARAMETER_PARSE_ERROR;
            }
        }
    }

    public Parameter getParameter(int n) throws ParseException {
        if (this._parameterArrayList == null) {
            throw SpecialParseExceptions.NO_SUCH_PARAMETER;
        }
        if (this._parameterArrayList.size() == 0) {
            throw SpecialParseExceptions.NO_SUCH_PARAMETER;
        }
        Parameter parameter = null;
        try {
            parameter = (Parameter)this._parameterArrayList.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SpecialParseExceptions.NO_SUCH_PARAMETER;
        }
        if (parameter == null) {
            throw SpecialParseExceptions.NO_SUCH_PARAMETER;
        }
        return parameter;
    }
}

