/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.subscription;

import com.rti.dds.domain.DomainParticipantFactory;
import com.rti.dds.domain.builtin.ParticipantBuiltinTopicData;
import com.rti.dds.infrastructure.AbstractNativeObject;
import com.rti.dds.infrastructure.AckResponseData_t;
import com.rti.dds.infrastructure.Duration_t;
import com.rti.dds.infrastructure.EntityImpl;
import com.rti.dds.infrastructure.InstanceHandleSeq;
import com.rti.dds.infrastructure.InstanceHandle_t;
import com.rti.dds.infrastructure.NativeCondition;
import com.rti.dds.infrastructure.NativeObject;
import com.rti.dds.infrastructure.NativeStructMixin;
import com.rti.dds.infrastructure.RETCODE_BAD_PARAMETER;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.RETCODE_NO_DATA;
import com.rti.dds.infrastructure.RETCODE_PRECONDITION_NOT_MET;
import com.rti.dds.infrastructure.RETCODE_UNSUPPORTED;
import com.rti.dds.infrastructure.SequenceNumber_t;
import com.rti.dds.infrastructure.StringSeq;
import com.rti.dds.publication.builtin.PublicationBuiltinTopicData;
import com.rti.dds.subscription.DataReaderCacheStatus;
import com.rti.dds.subscription.DataReaderListener;
import com.rti.dds.subscription.DataReaderListenerImpl;
import com.rti.dds.subscription.DataReaderProtocolStatus;
import com.rti.dds.subscription.DataReaderQos;
import com.rti.dds.subscription.IndexCondition;
import com.rti.dds.subscription.IndexConditionImpl;
import com.rti.dds.subscription.LivelinessChangedStatus;
import com.rti.dds.subscription.NativeDataReader;
import com.rti.dds.subscription.QueryCondition;
import com.rti.dds.subscription.QueryConditionImpl;
import com.rti.dds.subscription.ReadCondition;
import com.rti.dds.subscription.ReadConditionImpl;
import com.rti.dds.subscription.RequestedDeadlineMissedStatus;
import com.rti.dds.subscription.RequestedIncompatibleQosStatus;
import com.rti.dds.subscription.SampleInfo;
import com.rti.dds.subscription.SampleInfoSeq;
import com.rti.dds.subscription.SampleLostStatus;
import com.rti.dds.subscription.SampleRejectedStatus;
import com.rti.dds.subscription.Subscriber;
import com.rti.dds.subscription.SubscriberImpl;
import com.rti.dds.subscription.SubscriptionMatchedStatus;
import com.rti.dds.topic.DataReaderDelegate;
import com.rti.dds.topic.KeyHash_t;
import com.rti.dds.topic.TopicDescription;
import com.rti.dds.topic.TopicDescriptionImpl;
import com.rti.dds.topic.TypeSupportImpl;
import com.rti.dds.util.LoanableSequence;
import com.rti.dds.util.Utilities;
import java.util.List;

public abstract class DataReaderImpl
extends EntityImpl
implements NativeDataReader {
    private static final RuntimeException UNSUPPORTED = new RETCODE_UNSUPPORTED();
    private static final RuntimeException INCONSISTENT_LOAN = new RETCODE_PRECONDITION_NOT_MET("sequences have inconsistent loan states");
    private static final RuntimeException SEQUENCE_MISMATCH = new RETCODE_PRECONDITION_NOT_MET("data and info sequences weren't read together");
    private static final RuntimeException SEQUENCE_LENGTH_MISMATCH = new RETCODE_PRECONDITION_NOT_MET("data or info sequence size incorrect");
    private static final RuntimeException NULL_PROFILE = new RETCODE_BAD_PARAMETER("null profile");
    private static final RuntimeException NULL_LIBRARY = new RETCODE_BAD_PARAMETER("null library");
    private static final int READ_RESULTS_LENGTH = 4;
    private final long[] _readResults = new long[4];
    private static final int READ_RESULTS_DATA_PTR_INDEX = 0;
    private static final int READ_RESULTS_DATA_COUNT_INDEX = 1;
    private static final int READ_RESULTS_INFO_INDEX = 2;
    private static final int READ_RESULTS_INFO_BUFFER_INDEX = 3;
    private final NativeStructMixin _livelinessChangedStatus = new LivelinessChangedStatusMixin();
    private final NativeStructMixin _requestedDeadlineMissedStatus = new RequestedDeadlineMissedStatusMixin();
    private final NativeStructMixin _requestedIncompatibleQosStatusMixin = new RequestedIncompatibleQosStatusMixin();
    private final NativeStructMixin _sampleRejectedStatusMixin = new SampleRejectedStatusMixin();
    private final NativeStructMixin _sampleLostStatus = new SampleLostStatusMixin();
    private final NativeStructMixin _subscriptionMatchedStatus = new SubscriptionMatchedStatusMixin();
    private final NativeStructMixin _dataReaderCacheStatus = new DataReaderCacheStatusMixin();
    private final NativeStructMixin _dataReaderProtocolStatus = new DataReaderProtocolStatusMixin();
    private final NativeStructMixin _matchedPublicationDataReaderProtocolStatus = new MatchedPublicationDataReaderProtocolStatusMixin();
    private final TypeSupportImpl _dataType;
    private final DataReaderDelegate _delegate;
    private long _scratchpadData;
    private final KeyHash_t _keyHash = new KeyHash_t();
    private final Object[] _serializeOption = new Object[1];

    public void on_native_entity_finalized() {
        super.cleanup();
        this._livelinessChangedStatus.cleanup();
        this._requestedDeadlineMissedStatus.cleanup();
        this._requestedIncompatibleQosStatusMixin.cleanup();
        this._sampleRejectedStatusMixin.cleanup();
        this._sampleLostStatus.cleanup();
        this._subscriptionMatchedStatus.cleanup();
        this._dataReaderCacheStatus.cleanup();
        this._dataReaderProtocolStatus.cleanup();
        this._matchedPublicationDataReaderProtocolStatus.cleanup();
        if (this._scratchpadData != 0L) {
            this._dataType.destroy_native_objectI(this._scratchpadData);
            this._scratchpadData = 0L;
        }
    }

    public ReadCondition create_readcondition(int n, int n2, int n3) {
        this.check_aliveI();
        return new ReadConditionImpl(DataReaderImpl.DDS_DataReader_create_readcondition(this.get_native_pointer(), n, n2, n3));
    }

    public QueryCondition create_querycondition(int n, int n2, int n3, String string, StringSeq stringSeq) {
        this.check_aliveI();
        long l = DataReaderImpl.get_scratchpad_query_parametersI(this.get_native_pointer());
        stringSeq.push_to_nativeI(l);
        long l2 = DataReaderImpl.DDS_DataReader_create_querycondition(this.get_native_pointer(), n, n2, n3, string, l);
        DataReaderImpl.return_scratchpad_query_parametersI(this.get_native_pointer(), l);
        return new QueryConditionImpl(l2);
    }

    public IndexCondition create_indexcondition(int n, int n2, int n3, String string, SampleInfo sampleInfo) {
        this.check_aliveI();
        long l = DataReaderImpl.get_scratchpad_sample_infoI(this.get_native_pointer());
        sampleInfo.push_to_nativeI(l);
        long l2 = DataReaderImpl.DDS_DataReader_create_indexcondition(this.get_native_pointer(), n, n2, n3, string, l);
        return new IndexConditionImpl(l2);
    }

    public void create_corelation_index(String string) {
        this.check_aliveI();
        int n = DataReaderImpl.DDS_DataReader_create_corelation_index(this.get_native_pointer(), string);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void delete_index(String string) {
        this.check_aliveI();
        int n = DataReaderImpl.DDS_DataReader_delete_index(this.get_native_pointer(), string);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void delete_readcondition(ReadCondition readCondition) {
        this.check_aliveI();
        if (!NativeCondition.class.isAssignableFrom(readCondition.getClass())) {
            Utilities.rethrow(UNSUPPORTED);
        }
        AbstractNativeObject.check_aliveI((NativeObject)((Object)readCondition));
        ((NativeCondition)((Object)readCondition)).before_delete_native();
        int n = DataReaderImpl.DDS_DataReader_delete_readcondition(this.get_native_pointer(), ((NativeCondition)((Object)readCondition)).get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
        ((NativeCondition)((Object)readCondition)).after_delete_native();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_qos(DataReaderQos dataReaderQos) {
        boolean bl = dataReaderQos == Subscriber.DATAREADER_QOS_DEFAULT;
        EntityImpl.lock_native_entityI(((EntityImpl)((Object)this.get_subscriber().get_participant())).get_native_pointer());
        try {
            this.lock();
            try {
                this._serializeOption[0] = bl ? null : dataReaderQos.type_support.plugin_data;
                this.set_untyped_qos(dataReaderQos, bl, this._serializeOption);
            }
            finally {
                this.unlock();
            }
        }
        finally {
            EntityImpl.unlock_native_entityI(((EntityImpl)((Object)this.get_subscriber().get_participant())).get_native_pointer());
        }
    }

    public void set_qos_with_profile(String string, String string2) {
        DataReaderQos dataReaderQos = new DataReaderQos();
        this.check_aliveI();
        if (string2 == null) {
            string2 = this.get_subscriber().get_default_profile();
            string = this.get_subscriber().get_default_profile_library();
        }
        if (string2 == null) {
            Utilities.rethrow(NULL_PROFILE);
        }
        if (string == null) {
            string = this.get_subscriber().get_default_library();
        }
        if (string == null) {
            Utilities.rethrow(NULL_LIBRARY);
        }
        DomainParticipantFactory.get_instance().get_datareader_qos_from_profile(dataReaderQos, string, string2);
        this.set_qos(dataReaderQos);
        dataReaderQos = null;
    }

    public void get_qos(DataReaderQos dataReaderQos) {
        this.get_untyped_qos(dataReaderQos);
    }

    public void set_listener(DataReaderListener dataReaderListener, int n) {
        this.set_untyped_listenerI(dataReaderListener, n);
    }

    public DataReaderListener get_listener() {
        return (DataReaderListener)this.get_untyped_listenerI();
    }

    public void call_listenerT(int n) {
        this.check_aliveI();
        DataReaderImpl.DDS_DataReader_call_listener(this.get_native_pointer(), n);
    }

    public void get_liveliness_changed_status(LivelinessChangedStatus livelinessChangedStatus) {
        this._livelinessChangedStatus.get_untypedI(livelinessChangedStatus);
    }

    public void get_requested_deadline_missed_status(RequestedDeadlineMissedStatus requestedDeadlineMissedStatus) {
        this._requestedDeadlineMissedStatus.get_untypedI(requestedDeadlineMissedStatus);
    }

    public void get_requested_incompatible_qos_status(RequestedIncompatibleQosStatus requestedIncompatibleQosStatus) {
        this._requestedIncompatibleQosStatusMixin.get_untypedI(requestedIncompatibleQosStatus);
    }

    public void get_sample_rejected_status(SampleRejectedStatus sampleRejectedStatus) {
        this._sampleRejectedStatusMixin.get_untypedI(sampleRejectedStatus);
    }

    public void get_subscription_matched_status(SubscriptionMatchedStatus subscriptionMatchedStatus) {
        this._subscriptionMatchedStatus.get_untypedI(subscriptionMatchedStatus);
    }

    public void set_subscription_matched_statusT(SubscriptionMatchedStatus subscriptionMatchedStatus) {
        this._subscriptionMatchedStatus.set_untypedI(subscriptionMatchedStatus, false, false, null);
    }

    public void set_liveliness_changed_statusT(LivelinessChangedStatus livelinessChangedStatus) {
        this._livelinessChangedStatus.set_untypedI(livelinessChangedStatus, false, false, null);
    }

    public void set_requested_deadline_missed_statusT(RequestedDeadlineMissedStatus requestedDeadlineMissedStatus) {
        this._requestedDeadlineMissedStatus.set_untypedI(requestedDeadlineMissedStatus, false, false, null);
    }

    public void set_requested_incompatible_qos_statusT(RequestedIncompatibleQosStatus requestedIncompatibleQosStatus) {
        this._requestedIncompatibleQosStatusMixin.set_untypedI(requestedIncompatibleQosStatus, false, false, null);
    }

    public void set_sample_rejected_statusT(SampleRejectedStatus sampleRejectedStatus) {
        this._sampleRejectedStatusMixin.set_untypedI(sampleRejectedStatus, false, false, null);
    }

    public void get_sample_lost_status(SampleLostStatus sampleLostStatus) {
        this._sampleLostStatus.get_untypedI(sampleLostStatus);
    }

    public void set_sample_lost_statusT(SampleLostStatus sampleLostStatus) {
        this._sampleLostStatus.set_untypedI(sampleLostStatus, false, false, null);
    }

    public void get_datareader_cache_status(DataReaderCacheStatus dataReaderCacheStatus) {
        this._dataReaderCacheStatus.get_untypedI(dataReaderCacheStatus);
    }

    public void set_datareader_cache_statusT(DataReaderCacheStatus dataReaderCacheStatus) {
        this._dataReaderCacheStatus.set_untypedI(dataReaderCacheStatus, false, false, null);
    }

    public void get_datareader_protocol_status(DataReaderProtocolStatus dataReaderProtocolStatus) {
        this._dataReaderProtocolStatus.get_untypedI(dataReaderProtocolStatus);
    }

    public void set_datareader_protocol_statusT(DataReaderProtocolStatus dataReaderProtocolStatus) {
        this._dataReaderProtocolStatus.set_untypedI(dataReaderProtocolStatus, false, false, null);
    }

    public void get_matched_publication_datareader_protocol_status(DataReaderProtocolStatus dataReaderProtocolStatus, InstanceHandle_t instanceHandle_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(dataReaderProtocolStatus);
        this.check_for_null_argumentI(instanceHandle_t);
        long l = this.get_native_pointer();
        long l2 = DataReaderImpl.get_scratchpad_matched_publication_datareader_protocol_statusI(l);
        int n = DataReaderImpl.DDS_DataReader_get_matched_publication_datareader_protocol_status(l, l2, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
        RETCODE_ERROR.check_return_codeI(n);
        dataReaderProtocolStatus.pull_from_nativeI(l2);
    }

    public void set_matched_publication_datareader_protocol_statusT(DataReaderProtocolStatus dataReaderProtocolStatus, InstanceHandle_t instanceHandle_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(dataReaderProtocolStatus);
        this.check_for_null_argumentI(instanceHandle_t);
        long l = this.get_native_pointer();
        long l2 = DataReaderImpl.get_scratchpad_matched_publication_datareader_protocol_statusI(l);
        dataReaderProtocolStatus.push_to_nativeI(l2);
        int n = DataReaderImpl.DDS_DataReader_set_matched_publication_datareader_protocol_statusT(l, l2, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void delete_contained_entities() {
        this.check_aliveI();
        int n = DataReaderImpl.DDS_DataReader_delete_contained_entities(this.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void get_matched_publications(InstanceHandleSeq instanceHandleSeq) {
        this.check_aliveI();
        this.check_for_null_argumentI(instanceHandleSeq);
        long l = this.get_native_pointer();
        long l2 = DataReaderImpl.get_scratchpad_matched_publicationsI(l);
        int n = DataReaderImpl.DDS_DataReader_get_matched_publications(l, l2);
        RETCODE_ERROR.check_return_codeI(n);
        instanceHandleSeq.pull_from_nativeI(l2);
    }

    public void get_matched_publication_data(PublicationBuiltinTopicData publicationBuiltinTopicData, InstanceHandle_t instanceHandle_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(publicationBuiltinTopicData);
        this.check_for_null_argumentI(instanceHandle_t);
        long l = this.get_native_pointer();
        long l2 = DataReaderImpl.get_scratchpad_publication_dataI(l);
        int n = DataReaderImpl.DDS_DataReader_get_matched_publication_data(l, l2, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
        RETCODE_ERROR.check_return_codeI(n);
        publicationBuiltinTopicData.pull_from_nativeI(l2);
        DataReaderImpl.DDS_PublicationBuiltinTopicData_finalize(l2);
    }

    public void get_matched_publication_participant_data(ParticipantBuiltinTopicData participantBuiltinTopicData, InstanceHandle_t instanceHandle_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(participantBuiltinTopicData);
        this.check_for_null_argumentI(instanceHandle_t);
        long l = this.get_native_pointer();
        long l2 = DataReaderImpl.get_scratchpad_participant_dataI(l);
        int n = DataReaderImpl.DDS_DataReader_get_matched_publication_participant_data(l, l2, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
        RETCODE_ERROR.check_return_codeI(n);
        participantBuiltinTopicData.pull_from_nativeI(l2);
        DataReaderImpl.DDS_ParticipantBuiltinTopicData_finalize(l2);
    }

    public Subscriber get_subscriber() {
        if (!this.is_alive()) {
            return null;
        }
        Subscriber subscriber = null;
        long l = DataReaderImpl.DDS_DataReader_get_subscriber(this.get_native_pointer());
        if (l != 0L) {
            subscriber = (Subscriber)SubscriberImpl.get_subscriberI(l);
        }
        return subscriber;
    }

    public TopicDescription get_topicdescription() {
        if (!this.is_alive()) {
            return null;
        }
        TopicDescription topicDescription = null;
        long l = DataReaderImpl.DDS_DataReader_get_topicdescription(this.get_native_pointer());
        if (l != 0L) {
            topicDescription = (TopicDescription)TopicDescriptionImpl.get_topicdescriptionI(l);
        }
        return topicDescription;
    }

    public void wait_for_historical_data(Duration_t duration_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(duration_t);
        int n = DataReaderImpl.DDS_DataReader_wait_for_historical_data(this.get_native_pointer(), duration_t.sec, duration_t.nanosec);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void acknowledge_sample(SampleInfo sampleInfo) {
        this.check_aliveI();
        this.check_for_null_argumentI(sampleInfo);
        long l = DataReaderImpl.get_scratchpad_sample_infoI(this.get_native_pointer());
        sampleInfo.push_to_nativeI(l);
        int n = DataReaderImpl.DDS_DataReader_acknowledge_sample(this.get_native_pointer(), l, 0L);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void acknowledge_sample(SampleInfo sampleInfo, AckResponseData_t ackResponseData_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(sampleInfo);
        this.check_for_null_argumentI(ackResponseData_t);
        long l = DataReaderImpl.get_scratchpad_sample_infoI(this.get_native_pointer());
        long l2 = DataReaderImpl.get_scratchpad_ack_responseI(this.get_native_pointer());
        sampleInfo.push_to_nativeI(l);
        ackResponseData_t.push_to_nativeI(l2);
        int n = DataReaderImpl.DDS_DataReader_acknowledge_sample(this.get_native_pointer(), l, l2);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void acknowledge_all() {
        this.check_aliveI();
        int n = DataReaderImpl.DDS_DataReader_acknowledge_all(this.get_native_pointer(), 0L);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void acknowledge_all(AckResponseData_t ackResponseData_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(ackResponseData_t);
        long l = DataReaderImpl.get_scratchpad_ack_responseI(this.get_native_pointer());
        ackResponseData_t.push_to_nativeI(l);
        int n = DataReaderImpl.DDS_DataReader_acknowledge_all(this.get_native_pointer(), l);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void set_last_publication_sequence_number(InstanceHandle_t instanceHandle_t, int n, SequenceNumber_t sequenceNumber_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(instanceHandle_t);
        this.check_for_null_argumentI(sequenceNumber_t);
        int n2 = DataReaderImpl.DDS_DataReader_set_last_publication_sequence_number(this.get_native_pointer(), instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil(), n, sequenceNumber_t.high, sequenceNumber_t.low);
        RETCODE_ERROR.check_return_codeI(n2);
    }

    public DataReaderDelegate get_delegate() {
        return this._delegate;
    }

    public KeyHash_t get_key_hash() {
        return this._keyHash;
    }

    public final void read_untyped(List list, SampleInfoSeq sampleInfoSeq, int n, int n2, int n3, int n4) {
        this.read_or_take_untypedI(list, sampleInfoSeq, n, n2, n3, n4, false);
    }

    public final void take_untyped(List list, SampleInfoSeq sampleInfoSeq, int n, int n2, int n3, int n4) {
        this.read_or_take_untypedI(list, sampleInfoSeq, n, n2, n3, n4, true);
    }

    public final void read_w_condition_untyped(List list, SampleInfoSeq sampleInfoSeq, int n, ReadCondition readCondition) {
        this.read_or_take_w_condition_untypedI(list, sampleInfoSeq, n, readCondition, false);
    }

    public final void take_w_condition_untyped(List list, SampleInfoSeq sampleInfoSeq, int n, ReadCondition readCondition) {
        this.read_or_take_w_condition_untypedI(list, sampleInfoSeq, n, readCondition, true);
    }

    public final void read_next_sample_untyped(Object object, SampleInfo sampleInfo) {
        this.read_or_take_next_sample_untypedI(object, sampleInfo, false);
    }

    public final void take_next_sample_untyped(Object object, SampleInfo sampleInfo) {
        this.read_or_take_next_sample_untypedI(object, sampleInfo, true);
    }

    public final void read_instance_untyped(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, int n2, int n3, int n4) {
        this.read_or_take_instance_untypedI(list, sampleInfoSeq, n, instanceHandle_t, n2, n3, n4, false, false);
    }

    public final void take_instance_untyped(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, int n2, int n3, int n4) {
        this.read_or_take_instance_untypedI(list, sampleInfoSeq, n, instanceHandle_t, n2, n3, n4, false, true);
    }

    public final void read_instance_w_condition_untyped(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, ReadCondition readCondition) {
        this.read_or_take_instance_w_condition_untypedI(list, sampleInfoSeq, n, instanceHandle_t, readCondition, false);
    }

    public final void take_instance_w_condition_untyped(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, ReadCondition readCondition) {
        this.read_or_take_instance_w_condition_untypedI(list, sampleInfoSeq, n, instanceHandle_t, readCondition, true);
    }

    public final void read_next_instance_untyped(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, int n2, int n3, int n4) {
        this.read_or_take_instance_untypedI(list, sampleInfoSeq, n, instanceHandle_t, n2, n3, n4, true, false);
    }

    public final void take_next_instance_untyped(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, int n2, int n3, int n4) {
        this.read_or_take_instance_untypedI(list, sampleInfoSeq, n, instanceHandle_t, n2, n3, n4, true, true);
    }

    public final void read_next_instance_w_condition_untyped(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, ReadCondition readCondition) {
        this.read_or_take_next_instance_w_condition_untypedI(list, sampleInfoSeq, n, instanceHandle_t, readCondition, false);
    }

    public final void take_next_instance_w_condition_untyped(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, ReadCondition readCondition) {
        this.read_or_take_next_instance_w_condition_untypedI(list, sampleInfoSeq, n, instanceHandle_t, readCondition, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void return_loan_untyped(List list, SampleInfoSeq sampleInfoSeq) {
        this.check_aliveI();
        this.check_for_null_argumentI(list);
        this.check_for_null_argumentI(sampleInfoSeq);
        this.lock();
        try {
            long l = sampleInfoSeq.getNativeElements();
            long l2 = sampleInfoSeq.get_loaned_native_data_buffer();
            long l3 = sampleInfoSeq.get_loaned_native_data_size();
            if (sampleInfoSeq.hasOwnership()) {
                return;
            }
            if (!sampleInfoSeq.was_loaned_with(list)) {
                Utilities.rethrow(SEQUENCE_MISMATCH);
            }
            int n = DataReaderImpl.DDS_DataReader_return_loan_untypedI(this.get_native_pointer(), l2, l3, l);
            RETCODE_ERROR.check_return_codeI(n);
            sampleInfoSeq.unloan();
            if (list instanceof LoanableSequence) {
                ((LoanableSequence)list).unloan();
            } else {
                list.clear();
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void get_key_value_untyped(Object object, InstanceHandle_t instanceHandle_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(object);
        this.check_for_null_argumentI(instanceHandle_t);
        boolean bl = this._delegate.is_sample_native();
        this.lock();
        try {
            int n = DataReaderImpl.DDS_DataReader_get_key_value_untypedI(this.get_native_pointer(), object, bl, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
            RETCODE_ERROR.check_return_codeI(n);
            if (bl) {
                this._delegate.pull_data_sample_from_native(object, this._scratchpadData);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InstanceHandle_t lookup_instance_untyped(Object object) {
        InstanceHandle_t instanceHandle_t = InstanceHandle_t.HANDLE_NIL;
        this.check_aliveI();
        if (object == null || !this.is_alive()) {
            return instanceHandle_t;
        }
        boolean bl = this._delegate.is_sample_native();
        long l = this.get_native_pointer();
        long l2 = DataReaderImpl.get_scratchpad_instancehandleI(l);
        this.lock();
        try {
            boolean bl2;
            if (bl) {
                this._delegate.push_data_sample_to_native(object, this._scratchpadData);
            }
            if (bl2 = DataReaderImpl.DDS_DataReader_lookup_instance_untypedI(l, object, bl, l2)) {
                instanceHandle_t = new InstanceHandle_t(instanceHandle_t);
                instanceHandle_t.pull_from_nativeI(l2);
            }
        }
        finally {
            this.unlock();
        }
        return instanceHandle_t;
    }

    public static native Object get_datareaderI(long var0);

    protected DataReaderImpl(long l, DataReaderListener dataReaderListener, int n, TypeSupportImpl typeSupportImpl) {
        super(l, new DataReaderListenerImpl(dataReaderListener, n, l));
        this.initializeQosMixin(new DataReaderQosMixin());
        this._dataType = typeSupportImpl;
        this._delegate = typeSupportImpl.create_delegateI();
        if (this._delegate.is_sample_native()) {
            this._scratchpadData = typeSupportImpl.create_native_objectI();
            DataReaderImpl.initialize_scratchpad_data(l, this._scratchpadData);
        }
    }

    protected final void read_untypedX(List list, SampleInfoSeq sampleInfoSeq, int n, int n2, int n3, int n4) {
        this.read_untyped(list, sampleInfoSeq, n, n2, n3, n4);
    }

    protected final void take_untypedX(List list, SampleInfoSeq sampleInfoSeq, int n, int n2, int n3, int n4) {
        this.take_untyped(list, sampleInfoSeq, n, n2, n3, n4);
    }

    protected final void read_w_condition_untypedX(List list, SampleInfoSeq sampleInfoSeq, int n, ReadCondition readCondition) {
        this.read_w_condition_untyped(list, sampleInfoSeq, n, readCondition);
    }

    protected final void take_w_condition_untypedX(List list, SampleInfoSeq sampleInfoSeq, int n, ReadCondition readCondition) {
        this.take_w_condition_untyped(list, sampleInfoSeq, n, readCondition);
    }

    protected final void read_next_sample_untypedX(Object object, SampleInfo sampleInfo) {
        this.read_next_sample_untyped(object, sampleInfo);
    }

    protected final void take_next_sample_untypedX(Object object, SampleInfo sampleInfo) {
        this.take_next_sample_untyped(object, sampleInfo);
    }

    protected final void read_instance_untypedX(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, int n2, int n3, int n4) {
        this.read_instance_untyped(list, sampleInfoSeq, n, instanceHandle_t, n2, n3, n4);
    }

    protected final void take_instance_untypedX(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, int n2, int n3, int n4) {
        this.take_instance_untyped(list, sampleInfoSeq, n, instanceHandle_t, n2, n3, n4);
    }

    protected final void read_instance_w_condition_untypedX(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, ReadCondition readCondition) {
        this.read_instance_w_condition_untyped(list, sampleInfoSeq, n, instanceHandle_t, readCondition);
    }

    protected final void take_instance_w_condition_untypedX(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, ReadCondition readCondition) {
        this.take_instance_w_condition_untyped(list, sampleInfoSeq, n, instanceHandle_t, readCondition);
    }

    protected final void read_next_instance_untypedX(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, int n2, int n3, int n4) {
        this.read_next_instance_untyped(list, sampleInfoSeq, n, instanceHandle_t, n2, n3, n4);
    }

    protected final void take_next_instance_untypedX(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, int n2, int n3, int n4) {
        this.take_next_instance_untyped(list, sampleInfoSeq, n, instanceHandle_t, n2, n3, n4);
    }

    protected final void read_next_instance_w_condition_untypedX(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, ReadCondition readCondition) {
        this.read_next_instance_w_condition_untyped(list, sampleInfoSeq, n, instanceHandle_t, readCondition);
    }

    protected final void take_next_instance_w_condition_untypedX(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, ReadCondition readCondition) {
        this.take_next_instance_w_condition_untyped(list, sampleInfoSeq, n, instanceHandle_t, readCondition);
    }

    protected final void return_loan_untypedX(List list, SampleInfoSeq sampleInfoSeq) {
        this.return_loan_untyped(list, sampleInfoSeq);
    }

    protected final void get_key_value_untypedX(Object object, InstanceHandle_t instanceHandle_t) {
        this.get_key_value_untyped(object, instanceHandle_t);
    }

    protected final InstanceHandle_t lookup_instance_untypedX(Object object) {
        return this.lookup_instance_untyped(object);
    }

    private void read_or_take_untypedI(List list, SampleInfoSeq sampleInfoSeq, int n, int n2, int n3, int n4, boolean bl) {
        this.read_or_take_untypedI(list, sampleInfoSeq, n, null, n2, n3, n4, null, false, bl);
    }

    private void read_or_take_w_condition_untypedI(List list, SampleInfoSeq sampleInfoSeq, int n, ReadCondition readCondition, boolean bl) {
        this.check_for_null_argumentI(readCondition);
        this.read_or_take_untypedI(list, sampleInfoSeq, n, null, 0, 0, 0, readCondition, false, bl);
    }

    private void read_or_take_instance_untypedI(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, int n2, int n3, int n4, boolean bl, boolean bl2) {
        this.check_for_null_argumentI(instanceHandle_t);
        this.read_or_take_untypedI(list, sampleInfoSeq, n, instanceHandle_t, n2, n3, n4, null, bl, bl2);
    }

    private void read_or_take_instance_w_condition_untypedI(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, ReadCondition readCondition, boolean bl) {
        this.check_for_null_argumentI(instanceHandle_t);
        this.check_for_null_argumentI(readCondition);
        this.read_or_take_untypedI(list, sampleInfoSeq, n, instanceHandle_t, 0, 0, 0, readCondition, false, bl);
    }

    private void read_or_take_next_instance_w_condition_untypedI(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, ReadCondition readCondition, boolean bl) {
        this.check_for_null_argumentI(instanceHandle_t);
        this.check_for_null_argumentI(readCondition);
        this.read_or_take_untypedI(list, sampleInfoSeq, n, instanceHandle_t, 0, 0, 0, readCondition, true, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read_or_take_next_sample_untypedI(Object object, SampleInfo sampleInfo, boolean bl) {
        this.check_aliveI();
        this.check_for_null_argumentI(object);
        this.check_for_null_argumentI(sampleInfo);
        this.lock();
        try {
            boolean bl2 = this._delegate.is_sample_native();
            int n = DataReaderImpl.DDS_DataReader_read_or_take_next_sample_untypedI(this.get_native_pointer(), this._readResults, object, bl2, bl ? 1 : 0);
            RETCODE_ERROR.check_return_codeI(n);
            long l = this._readResults[3];
            sampleInfo.pull_from_nativeI(l);
            if (sampleInfo.valid_data && bl2) {
                long l2 = this._readResults[0];
                this._delegate.pull_data_sample_from_native(object, l2);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read_or_take_untypedI(List list, SampleInfoSeq sampleInfoSeq, int n, InstanceHandle_t instanceHandle_t, int n2, int n3, int n4, ReadCondition readCondition, boolean bl, boolean bl2) {
        boolean bl3;
        this.check_aliveI();
        this.check_for_null_argumentI(list);
        this.check_for_null_argumentI(sampleInfoSeq);
        int n5 = list.size();
        if (n5 != sampleInfoSeq.size()) {
            Utilities.rethrow(SEQUENCE_LENGTH_MISMATCH);
        }
        boolean bl4 = bl3 = !(list instanceof LoanableSequence) || ((LoanableSequence)list).hasOwnership();
        if (bl3 != sampleInfoSeq.hasOwnership()) {
            Utilities.rethrow(INCONSISTENT_LOAN);
        }
        if (!(list.isEmpty() || n != -1 && n <= n5)) {
            Utilities.rethrow(SEQUENCE_LENGTH_MISMATCH);
        }
        boolean bl5 = list.isEmpty();
        this.lock();
        try {
            int n6;
            long l = this.get_native_pointer();
            if (readCondition == null) {
                n6 = instanceHandle_t == null ? DataReaderImpl.DDS_DataReader_read_or_take_untypedI(l, this._readResults, n, n2, n3, n4, bl2 ? 1 : 0) : (bl ? DataReaderImpl.DDS_DataReader_read_or_take_next_instance_untypedI(l, this._readResults, n, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil(), n2, n3, n4, bl2 ? 1 : 0) : DataReaderImpl.DDS_DataReader_read_or_take_instance_untypedI(l, this._readResults, n, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil(), n2, n3, n4, bl2 ? 1 : 0));
            } else if (readCondition instanceof NativeCondition) {
                NativeCondition nativeCondition = (NativeCondition)((Object)readCondition);
                AbstractNativeObject.check_aliveI(nativeCondition);
                long l2 = nativeCondition.get_native_pointer();
                n6 = instanceHandle_t == null ? DataReaderImpl.DDS_DataReader_read_or_take_w_condition_untypedI(l, this._readResults, n, l2, bl2 ? 1 : 0) : (bl ? DataReaderImpl.DDS_DataReader_read_or_take_next_instance_w_condition_untypedI(l, this._readResults, n, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil(), l2, bl2 ? 1 : 0) : DataReaderImpl.DDS_DataReader_read_or_take_instance_w_condition_untypedI(l, this._readResults, n, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil(), l2, bl2 ? 1 : 0));
            } else {
                Utilities.rethrow(UNSUPPORTED);
                throw new Error("unreachable");
            }
            try {
                RETCODE_ERROR.check_return_codeI(n6);
            }
            catch (RETCODE_NO_DATA rETCODE_NO_DATA) {
                list.clear();
                sampleInfoSeq.clear();
                throw rETCODE_NO_DATA;
            }
            long l3 = this._readResults[2];
            long l4 = this._readResults[0];
            int n7 = (int)this._readResults[1];
            long l5 = this._readResults[3];
            if (bl5) {
                sampleInfoSeq.loan(l5, n7);
                sampleInfoSeq.remember_loaned_data_sequenceI(list);
                sampleInfoSeq.remember_loaned_native_data_buffer(l4, n7);
            }
            sampleInfoSeq.pull_from_nativeI(l3, bl5);
            this._delegate.pull_data_sequence_from_native(list, sampleInfoSeq, l4, n7, bl5);
            if (bl5) {
                SampleInfoSeq.unloanNativeSequence(l3);
            } else {
                n6 = DataReaderImpl.DDS_DataReader_return_loan_untypedI(l, l4, n7, l5);
                RETCODE_ERROR.check_return_codeI(n6);
            }
        }
        finally {
            this.unlock();
        }
    }

    private static native void initialize_scratchpad_data(long var0, long var2);

    private static native int DDS_DataReader_get_qos(long var0, long var2);

    private static native int DDS_DataReader_set_qos(long var0, long var2, boolean var4, Object var5);

    private static native long get_scratchpad_datareader_qosI(long var0);

    private static native int DDS_DataReader_get_liveliness_changed_status(long var0, long var2);

    private static native int DDS_DataReader_set_liveliness_changed_status(long var0, long var2);

    private static native long get_scratchpad_liveliness_changed_statusI(long var0);

    private static native int DDS_DataReader_get_sample_lost_status(long var0, long var2);

    private static native int DDS_DataReader_set_sample_lost_statusT(long var0, long var2);

    private static native long get_scratchpad_sample_lost_statusI(long var0);

    private static native int DDS_DataReader_get_subscription_matched_status(long var0, long var2);

    private static native int DDS_DataReader_set_subscription_matched_statusT(long var0, long var2);

    private static native long get_scratchpad_subscription_matched_statusI(long var0);

    private static native int DDS_DataReader_get_requested_deadline_missed_status(long var0, long var2);

    private static native int DDS_DataReader_set_requested_deadline_missed_status(long var0, long var2);

    private static native long get_scratchpad_requested_deadline_missed_statusI(long var0);

    private static native int DDS_DataReader_get_requested_incompatible_qos_status(long var0, long var2);

    private static native int DDS_DataReader_set_requested_incompatible_qos_status(long var0, long var2);

    private static native long get_scratchpad_requested_incompatible_qos_statusI(long var0);

    private static native int DDS_DataReader_get_sample_rejected_status(long var0, long var2);

    private static native int DDS_DataReader_set_sample_rejected_status(long var0, long var2);

    private static native long get_scratchpad_sample_rejected_statusI(long var0);

    private static native long get_scratchpad_datareader_cache_statusI(long var0);

    private static native int DDS_DataReader_get_datareader_cache_status(long var0, long var2);

    private static native int DDS_DataReader_set_datareader_cache_statusT(long var0, long var2);

    private static native long get_scratchpad_datareader_protocol_statusI(long var0);

    private static native int DDS_DataReader_get_datareader_protocol_status(long var0, long var2);

    private static native int DDS_DataReader_set_datareader_protocol_statusT(long var0, long var2);

    private static native long get_scratchpad_matched_publication_datareader_protocol_statusI(long var0);

    private static native int DDS_DataReader_get_matched_publication_datareader_protocol_status(long var0, long var2, byte[] var4, int var5, boolean var6);

    private static native int DDS_DataReader_set_matched_publication_datareader_protocol_statusT(long var0, long var2, byte[] var4, int var5, boolean var6);

    private static native long get_scratchpad_matched_publicationsI(long var0);

    private static native int DDS_DataReader_get_matched_publications(long var0, long var2);

    private static native long get_scratchpad_publication_dataI(long var0);

    private static native long get_scratchpad_participant_dataI(long var0);

    private static native int DDS_DataReader_get_matched_publication_data(long var0, long var2, byte[] var4, int var5, boolean var6);

    private static native int DDS_DataReader_get_matched_publication_participant_data(long var0, long var2, byte[] var4, int var5, boolean var6);

    private static native void DDS_PublicationBuiltinTopicData_finalize(long var0);

    private static native void DDS_ParticipantBuiltinTopicData_finalize(long var0);

    private static native int DDS_DataReader_call_listener(long var0, int var2);

    private static native long get_scratchpad_query_parametersI(long var0);

    private static native void return_scratchpad_query_parametersI(long var0, long var2);

    private static native int DDS_DataReader_read_or_take_untypedI(long var0, long[] var2, int var3, int var4, int var5, int var6, int var7);

    private static native int DDS_DataReader_read_or_take_w_condition_untypedI(long var0, long[] var2, int var3, long var4, int var6);

    private static native int DDS_DataReader_read_or_take_next_sample_untypedI(long var0, long[] var2, Object var3, boolean var4, int var5);

    private static native int DDS_DataReader_read_or_take_instance_untypedI(long var0, long[] var2, int var3, byte[] var4, int var5, boolean var6, int var7, int var8, int var9, int var10);

    private static native int DDS_DataReader_read_or_take_instance_w_condition_untypedI(long var0, long[] var2, int var3, byte[] var4, int var5, boolean var6, long var7, int var9);

    private static native int DDS_DataReader_read_or_take_next_instance_untypedI(long var0, long[] var2, int var3, byte[] var4, int var5, boolean var6, int var7, int var8, int var9, int var10);

    private static native int DDS_DataReader_read_or_take_next_instance_w_condition_untypedI(long var0, long[] var2, int var3, byte[] var4, int var5, boolean var6, long var7, int var9);

    private static native int DDS_DataReader_return_loan_untypedI(long var0, long var2, long var4, long var6);

    private static native int DDS_DataReader_get_key_value_untypedI(long var0, Object var2, boolean var3, byte[] var4, int var5, boolean var6);

    private static native long DDS_DataReader_get_topicdescription(long var0);

    private static native long DDS_DataReader_get_subscriber(long var0);

    private static native long get_scratchpad_instancehandleI(long var0);

    private static native long get_scratchpad_ack_responseI(long var0);

    private static native long get_scratchpad_sample_infoI(long var0);

    private static native boolean DDS_DataReader_lookup_instance_untypedI(long var0, Object var2, boolean var3, long var4);

    private static native long DDS_DataReader_create_readcondition(long var0, int var2, int var3, int var4);

    private static native long DDS_DataReader_create_querycondition(long var0, int var2, int var3, int var4, String var5, long var6);

    private static native long DDS_DataReader_create_indexcondition(long var0, int var2, int var3, int var4, String var5, long var6);

    private static native int DDS_DataReader_create_corelation_index(long var0, String var2);

    private static native int DDS_DataReader_delete_index(long var0, String var2);

    private static native int DDS_DataReader_delete_readcondition(long var0, long var2);

    private static native int DDS_DataReader_delete_contained_entities(long var0);

    private static native int DDS_DataReader_wait_for_historical_data(long var0, int var2, int var3);

    private static native int DDS_DataReader_acknowledge_sample(long var0, long var2, long var4);

    private static native int DDS_DataReader_acknowledge_all(long var0, long var2);

    private static native int DDS_DataReader_set_last_publication_sequence_number(long var0, byte[] var2, int var3, boolean var4, int var5, int var6, long var7);

    private final class MatchedPublicationDataReaderProtocolStatusMixin
    extends NativeStructMixin {
        public MatchedPublicationDataReaderProtocolStatusMixin() {
            super(DataReaderImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataReaderImpl.get_scratchpad_matched_publication_datareader_protocol_statusI(DataReaderImpl.this.get_native_pointer());
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return 0;
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return 0;
        }
    }

    private final class DataReaderProtocolStatusMixin
    extends NativeStructMixin {
        public DataReaderProtocolStatusMixin() {
            super(DataReaderImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataReaderImpl.get_scratchpad_datareader_protocol_statusI(DataReaderImpl.this.get_native_pointer());
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DataReaderImpl.DDS_DataReader_get_datareader_protocol_status(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return DataReaderImpl.DDS_DataReader_set_datareader_protocol_statusT(l, l2);
        }
    }

    private final class DataReaderCacheStatusMixin
    extends NativeStructMixin {
        public DataReaderCacheStatusMixin() {
            super(DataReaderImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataReaderImpl.get_scratchpad_datareader_cache_statusI(DataReaderImpl.this.get_native_pointer());
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DataReaderImpl.DDS_DataReader_get_datareader_cache_status(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return DataReaderImpl.DDS_DataReader_set_datareader_cache_statusT(l, l2);
        }
    }

    private final class SubscriptionMatchedStatusMixin
    extends NativeStructMixin {
        public SubscriptionMatchedStatusMixin() {
            super(DataReaderImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataReaderImpl.get_scratchpad_subscription_matched_statusI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DataReaderImpl.DDS_DataReader_get_subscription_matched_status(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return DataReaderImpl.DDS_DataReader_set_subscription_matched_statusT(l, l2);
        }
    }

    private final class SampleLostStatusMixin
    extends NativeStructMixin {
        public SampleLostStatusMixin() {
            super(DataReaderImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataReaderImpl.get_scratchpad_sample_lost_statusI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DataReaderImpl.DDS_DataReader_get_sample_lost_status(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return DataReaderImpl.DDS_DataReader_set_sample_lost_statusT(l, l2);
        }
    }

    private final class SampleRejectedStatusMixin
    extends NativeStructMixin {
        public SampleRejectedStatusMixin() {
            super(DataReaderImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataReaderImpl.get_scratchpad_sample_rejected_statusI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DataReaderImpl.DDS_DataReader_get_sample_rejected_status(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return DataReaderImpl.DDS_DataReader_set_sample_rejected_status(l, l2);
        }
    }

    private final class RequestedIncompatibleQosStatusMixin
    extends NativeStructMixin {
        public RequestedIncompatibleQosStatusMixin() {
            super(DataReaderImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataReaderImpl.get_scratchpad_requested_incompatible_qos_statusI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DataReaderImpl.DDS_DataReader_get_requested_incompatible_qos_status(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return DataReaderImpl.DDS_DataReader_set_requested_incompatible_qos_status(l, l2);
        }
    }

    private final class RequestedDeadlineMissedStatusMixin
    extends NativeStructMixin {
        public RequestedDeadlineMissedStatusMixin() {
            super(DataReaderImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataReaderImpl.get_scratchpad_requested_deadline_missed_statusI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DataReaderImpl.DDS_DataReader_get_requested_deadline_missed_status(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return DataReaderImpl.DDS_DataReader_set_requested_deadline_missed_status(l, l2);
        }
    }

    private final class LivelinessChangedStatusMixin
    extends NativeStructMixin {
        public LivelinessChangedStatusMixin() {
            super(DataReaderImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataReaderImpl.get_scratchpad_liveliness_changed_statusI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DataReaderImpl.DDS_DataReader_get_liveliness_changed_status(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return DataReaderImpl.DDS_DataReader_set_liveliness_changed_status(l, l2);
        }
    }

    private final class DataReaderQosMixin
    extends NativeStructMixin {
        public DataReaderQosMixin() {
            super(DataReaderImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return DataReaderImpl.get_scratchpad_datareader_qosI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return DataReaderImpl.DDS_DataReader_get_qos(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            Object object = objectArray[0];
            return DataReaderImpl.DDS_DataReader_set_qos(l, l2, bl, object);
        }
    }
}

