/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.subscription;

import com.rti.dds.subscription.DataReader;
import com.rti.dds.subscription.NativeDataReader;
import com.rti.dds.util.AbstractNativeSequence;
import com.rti.dds.util.Utilities;
import java.util.Collection;

public final class DataReaderSeq
extends AbstractNativeSequence {
    public DataReaderSeq() {
        this(0);
    }

    public DataReaderSeq(Collection collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public DataReaderSeq(int n) {
        super(NativeDataReader.class, DataReaderSeq.createNativeSequence(), n);
    }

    public int getMaximum() {
        return DataReaderSeq.DDS_DataReaderSeq_get_maximum(this.getNativeSequence());
    }

    public Object get(int n) {
        this.checkBounds(n, false);
        DataReader dataReader = null;
        long l = DataReaderSeq.DDS_DataReaderSeq_get(this.getNativeSequence(), n);
        if (l != 0L) {
            dataReader = (DataReader)DataReaderSeq.get_datareader(l);
        }
        return dataReader;
    }

    public Object set(int n, Object object) {
        Object object2 = this.get(n);
        long l = ((NativeDataReader)object).get_native_pointer();
        long l2 = DataReaderSeq.DDS_DataReaderSeq_get_reference(this.getNativeSequence(), n);
        if (l2 == 0L) {
            Utilities.rethrow(INCONSISTENT_STATE);
        }
        DataReaderSeq.DDS_DataReaderSeq_set(l2, l);
        return object2;
    }

    public void clear() {
        this.setSize(0);
    }

    public int size() {
        return DataReaderSeq.DDS_DataReaderSeq_get_length(this.getNativeSequence());
    }

    protected long getNativeSequence() {
        return super.getNativeSequence();
    }

    protected native void destroyNativeSequence(long var1);

    protected void incrementSize() {
        this.setSize(this.size() + 1);
    }

    protected void decrementSize() {
        this.setSize(this.size() - 1);
    }

    protected void reallocate(int n) {
        int n2 = DataReaderSeq.DDS_DataReaderSeq_set_maximum(this.getNativeSequence(), n);
        if (n2 == 0) {
            Utilities.rethrow(FAILED_ALLOCATION);
        }
    }

    private static long createNativeSequence() {
        long l = DataReaderSeq.DDS_new_empty_sequence();
        if (l == 0L) {
            Utilities.rethrow(FAILED_ALLOCATION);
        }
        return l;
    }

    private void setSize(int n) {
        int n2 = DataReaderSeq.DDS_DataReaderSeq_set_length(this.getNativeSequence(), n);
        if ((long)n2 == 0L) {
            Utilities.rethrow(INCONSISTENT_STATE);
        }
    }

    private static native long DDS_new_empty_sequence();

    private static native int DDS_DataReaderSeq_get_maximum(long var0);

    private static native int DDS_DataReaderSeq_set_maximum(long var0, int var2);

    private static native int DDS_DataReaderSeq_get_length(long var0);

    private static native int DDS_DataReaderSeq_set_length(long var0, int var2);

    private static native long DDS_DataReaderSeq_get_reference(long var0, int var2);

    private static native long DDS_DataReaderSeq_get(long var0, int var2);

    private static native void DDS_DataReaderSeq_set(long var0, long var2);

    private static native Object get_datareader(long var0);
}

