/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.subscription;

import com.rti.dds.subscription.SampleInfo;
import com.rti.dds.util.LoanableSequence;
import com.rti.dds.util.Sequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public final class SampleInfoSeq
extends LoanableSequence
implements Serializable,
Sequence {
    private transient List _loanedDataSequence = null;
    private transient long _nativeDataBuffer = 0L;
    private transient int _nativeDataSize = -1;

    public SampleInfoSeq() {
        super(SampleInfo.class);
    }

    public SampleInfoSeq(int n) {
        super(SampleInfo.class, n);
    }

    public SampleInfoSeq(Collection collection) {
        super(SampleInfo.class, collection);
    }

    public void unloan() {
        super.unloan();
        this._loanedDataSequence = null;
        this._nativeDataBuffer = 0L;
        this._nativeDataSize = -1;
    }

    public void remember_loaned_data_sequenceI(List list) {
        if (list == null) {
            throw new NullPointerException("null data sequence");
        }
        this._loanedDataSequence = list;
    }

    protected Object getNative(long l, int n) {
        long l2 = SampleInfoSeq.get_reference_from_array(l, n);
        return SampleInfo.get_from_native(l2);
    }

    boolean was_loaned_with(List list) {
        return this._loanedDataSequence == list;
    }

    long get_loaned_native_data_buffer() {
        return this._nativeDataBuffer;
    }

    int get_loaned_native_data_size() {
        return this._nativeDataSize;
    }

    void remember_loaned_native_data_buffer(long l, int n) {
        this._nativeDataBuffer = l;
        this._nativeDataSize = n;
    }

    static void unloanNativeSequence(long l) {
        boolean bl = SampleInfoSeq.DDS_SampleInfoSeq_unloan(l);
        if (!bl) {
            throw new IllegalStateException("unloan failed");
        }
    }

    void pull_from_nativeI(long l, boolean bl) {
        int n;
        int n2 = this.size();
        int n3 = SampleInfoSeq.DDS_SampleInfoSeq_get_length(l);
        SampleInfo sampleInfo = null;
        while (n2 > n3) {
            this.remove(--n2);
        }
        for (n = 0; n < n2; ++n) {
            sampleInfo = SampleInfoSeq.pull_info_from_native(l, n);
            if (bl) {
                if (sampleInfo == this.get(n)) continue;
                this.set(n, sampleInfo);
                continue;
            }
            SampleInfo sampleInfo2 = (SampleInfo)this.get(n);
            sampleInfo2.copy_from(sampleInfo);
        }
        for (n = n2; n < n3; ++n) {
            sampleInfo = SampleInfoSeq.pull_info_from_native(l, n);
            if (!bl) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
            }
            this.add(sampleInfo);
        }
    }

    private static SampleInfo pull_info_from_native(long l, int n) {
        if (l == 0L) {
            throw new IllegalArgumentException("NULL native sequence");
        }
        long l2 = SampleInfoSeq.DDS_SampleInfoSeq_get_reference(l, n);
        if (l2 == 0L) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + SampleInfoSeq.DDS_SampleInfoSeq_get_length(l));
        }
        SampleInfo sampleInfo = SampleInfo.get_from_native(l2);
        if (sampleInfo == null) {
            throw new NullPointerException("null sample info");
        }
        sampleInfo.pull_from_nativeI(l2);
        return sampleInfo;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._nativeDataSize = -1;
    }

    private static native int DDS_SampleInfoSeq_get_length(long var0);

    private static native long DDS_SampleInfoSeq_get_reference(long var0, int var2);

    private static native long get_reference_from_array(long var0, int var2);

    public static native boolean DDS_SampleInfoSeq_unloan(long var0);
}

